/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.gamerule.rule;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.mixin.gamerule.IntRuleAccessor;
import net.minecraft.class_1928;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BoundedIntRule
extends class_1928.class_4312 {
    private static final Logger LOGGER = LogManager.getLogger(GameRuleRegistry.class);
    private final int minimumValue;
    private final int maximumValue;

    public BoundedIntRule(class_1928.class_4314<class_1928.class_4312> type, int initialValue, int minimumValue, int maximumValue) {
        super(type, initialValue);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
    }

    protected void method_20777(String value) {
        int i = BoundedIntRule.parseInt(value);
        if (this.minimumValue > i || this.maximumValue < i) {
            LOGGER.warn("Failed to parse integer {}. Was out of bounds {} - {}", (Object)value, (Object)this.minimumValue, (Object)this.maximumValue);
            return;
        }
        ((IntRuleAccessor)((Object)this)).setValue(i);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_27332(String input) {
        try {
            int value = Integer.parseInt(input);
            if (this.minimumValue > value || this.maximumValue < value) {
                return false;
            }
            ((IntRuleAccessor)((Object)this)).setValue(value);
            return true;
        }
        catch (NumberFormatException var3) {
            return false;
        }
    }

    protected class_1928.class_4312 method_27333() {
        return new BoundedIntRule((class_1928.class_4314<class_1928.class_4312>)this.field_19417, ((IntRuleAccessor)((Object)this)).getValue(), this.minimumValue, this.maximumValue);
    }

    private static int parseInt(String input) {
        if (!input.isEmpty()) {
            try {
                return Integer.parseInt(input);
            }
            catch (NumberFormatException var2) {
                LOGGER.warn("Failed to parse integer {}", (Object)input);
            }
        }
        return 0;
    }
}

