/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.Hashtable;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.world.level.ColorResolver;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeBlendCalculator;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.MapBiomeColorResolverDetector;

public class BlockStateColorTypeCache {
    public final BiomeKey PLACEHOLDER_BIOME;
    public final BiomeKey UNKNOWN_BIOME;
    private Hashtable<class_2680, Integer> colorTypes = new Hashtable();
    private Hashtable<class_2680, ColorResolver> colorResolvers = new Hashtable();
    private int grassColor;
    private int foliageColor;
    private class_2680 grassState;
    private class_2680 oakLeavesState;
    private class_2680 waterState;
    private BiomeKeyManager biomeKeyManager;
    private ColorResolver DEFAULT_GRASS_RESOLVER;
    private ColorResolver DEFAULT_FOLIAGE_RESOLVER;
    private ColorResolver DEFAULT_WATER_RESOLVER;
    private MapBiomeColorResolverDetector colorResolverDetector;
    private BiomeBlendCalculator biomeBlendCalculator;

    public BlockStateColorTypeCache(BiomeKeyManager biomeKeyManager) {
        this.biomeKeyManager = biomeKeyManager;
        this.grassState = class_2246.field_10219.method_9564();
        this.oakLeavesState = class_2246.field_10503.method_9564();
        this.waterState = class_2246.field_10382.method_9564();
        this.UNKNOWN_BIOME = biomeKeyManager.get("xaeroworldmap:unknown_biome");
        this.PLACEHOLDER_BIOME = biomeKeyManager.get("xaeroworldmap:placeholder_biome");
        this.colorResolverDetector = new MapBiomeColorResolverDetector();
        this.biomeBlendCalculator = new BiomeBlendCalculator();
    }

    public BiomeKey getBlockBiomeColour(class_1937 world, class_2680 state, class_2338 pos, int[] dest, BiomeKey biomeId, class_2378<class_1959> biomeRegistry) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        BiomeKey blockBiome = null;
        Integer cachedColorType = this.colorTypes.get(state);
        int colorType = cachedColorType != null ? cachedColorType : -1;
        int customColour = -1;
        boolean gotFullCC = false;
        boolean isRenderThread = class_310.method_1551().method_18854();
        if (colorType == -1 && isRenderThread) {
            ColorResolver detectedColorResolver = this.colorResolverDetector.detectColorResolver(state, (class_1920)world, pos);
            if (detectedColorResolver == null) {
                if (state.method_26204() == class_2246.field_10382) {
                    detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                } else {
                    try {
                        customColour = class_310.method_1551().method_1505().method_1697(state, null, null, 0);
                    }
                    catch (Throwable t) {
                        customColour = 0;
                    }
                    if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor) {
                        class_3614 material = state.method_26207();
                        if (material != null && (material.method_15803() == class_3620.field_15999 || material.method_15803() == class_3620.field_16004 || material.method_15803() == class_3620.field_16019)) {
                            customColour = this.tryGettingColor(state, world, pos, 0);
                            gotFullCC = true;
                            if (material.method_15803() == class_3620.field_15999 && customColour == this.tryGettingColor(this.grassState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                            } else if (material.method_15803() == class_3620.field_16004 && customColour == this.tryGettingColor(this.oakLeavesState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                            } else if (material.method_15803() == class_3620.field_16019 && customColour == this.tryGettingColor(this.waterState, world, pos, 0)) {
                                detectedColorResolver = this.DEFAULT_WATER_RESOLVER;
                            }
                        }
                    } else if (customColour == this.grassColor) {
                        detectedColorResolver = this.DEFAULT_GRASS_RESOLVER;
                    } else if (customColour == this.foliageColor) {
                        detectedColorResolver = this.DEFAULT_FOLIAGE_RESOLVER;
                    }
                }
            }
            if (detectedColorResolver != null) {
                colorType = 1;
                if (detectedColorResolver == this.DEFAULT_FOLIAGE_RESOLVER) {
                    colorType = 2;
                }
                this.colorResolvers.put(state, detectedColorResolver);
            } else {
                if (!gotFullCC) {
                    customColour = this.tryGettingColor(state, world, pos, 0);
                    gotFullCC = true;
                }
                colorType = customColour != 0xFFFFFF && customColour != -1 ? 3 : 0;
            }
            this.colorTypes.put(state, colorType);
        } else if (colorType == 3 && !isRenderThread) {
            colorType = -1;
        }
        if ((colorType == 1 || colorType == 2) && biomeId == null) {
            if (isRenderThread) {
                biomeId = this.getBiome(world, pos, biomeRegistry);
            } else {
                colorType = -1;
            }
        }
        dest[0] = colorType;
        if (colorType == -1) {
            blockBiome = biomeId;
        } else if (colorType == 1 || colorType == 2) {
            blockBiome = biomeId;
        } else if (colorType == 3) {
            if (!gotFullCC) {
                customColour = this.tryGettingColor(state, world, pos, 0);
            }
            dest[2] = customColour;
        }
        return blockBiome;
    }

    public void updateGrassColor() {
        this.grassColor = this.tryGettingColor(this.grassState, null, null, 0);
        this.foliageColor = this.tryGettingColor(this.oakLeavesState, null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }

    public void updateDefaultResolvers(class_1937 world) {
        if (world == null) {
            return;
        }
        this.DEFAULT_GRASS_RESOLVER = this.colorResolverDetector.detectColorResolver(class_2246.field_10479.method_9564(), (class_1920)world, new class_2338(0, 0, 0));
        if (this.DEFAULT_GRASS_RESOLVER == null) {
            this.DEFAULT_GRASS_RESOLVER = class_1163.field_5665;
        }
        this.DEFAULT_FOLIAGE_RESOLVER = this.colorResolverDetector.detectColorResolver(class_2246.field_10503.method_9564(), (class_1920)world, new class_2338(0, 0, 0));
        if (this.DEFAULT_FOLIAGE_RESOLVER == null) {
            this.DEFAULT_FOLIAGE_RESOLVER = class_1163.field_5664;
        }
        this.DEFAULT_WATER_RESOLVER = this.colorResolverDetector.detectColorResolver(class_2246.field_10382.method_9564(), (class_1920)world, new class_2338(0, 0, 0));
        if (this.DEFAULT_WATER_RESOLVER == null) {
            this.DEFAULT_WATER_RESOLVER = class_1163.field_5666;
        }
    }

    private BiomeKey getBiome(class_1937 world, class_2338 pos, class_2378<class_1959> biomeRegistry) {
        class_1959 biome = world.method_23753(pos);
        class_2960 biomeIdentifier = biomeRegistry.method_10221((Object)biome);
        return biomeIdentifier == null ? this.UNKNOWN_BIOME : this.biomeKeyManager.get(biomeIdentifier.toString());
    }

    private int tryGettingColor(class_2680 state, class_1937 world, class_2338 pos, int tint) {
        this.biomeBlendCalculator.setWorld(world);
        try {
            return class_310.method_1551().method_1505().method_1697(state, (class_1920)(world == null ? null : this.biomeBlendCalculator), pos, tint);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    public ColorResolver getColorResolver(class_2680 state) {
        return this.colorResolvers.get(state);
    }
}

