/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.class_1257;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_156;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2170;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2966;
import net.minecraft.class_2981;
import net.minecraft.class_31;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3312;
import net.minecraft.class_3532;
import net.minecraft.class_3551;
import net.minecraft.class_3806;
import net.minecraft.class_3807;
import net.minecraft.class_3951;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5350;
import net.minecraft.class_5352;
import net.minecraft.class_5359;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger field_24625 = LogManager.getLogger();

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u26038 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u26039 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260314 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260315 = optionParser.nonOptions();
        try {
            Object \u260337;
            Object \u260335;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26039)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            class_128.method_24305();
            class_2966.method_12851();
            class_2966.method_17598();
            class_156.method_29476();
            class_5455.class_5457 \u260316 = class_5455.method_30528();
            Path \u260317 = Paths.get("server.properties", new String[0]);
            class_3807 \u260318 = new class_3807(\u260316, \u260317);
            \u260318.method_16719();
            Path \u260319 = Paths.get("eula.txt", new String[0]);
            class_2981 \u260320 = new class_2981(\u260319);
            if (optionSet.has((OptionSpec)\u26033)) {
                field_24625.info("Initialized '{}' and '{}'", (Object)\u260317.toAbsolutePath(), (Object)\u260319.toAbsolutePath());
                return;
            }
            if (!\u260320.method_12866()) {
                field_24625.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u260321 = new File((String)optionSet.valueOf((OptionSpec)\u260311));
            YggdrasilAuthenticationService \u260322 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService \u260323 = \u260322.createMinecraftSessionService();
            GameProfileRepository \u260324 = \u260322.createProfileRepository();
            class_3312 \u260325 = new class_3312(\u260324, new File(\u260321, MinecraftServer.field_4588.getName()));
            String \u260326 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260312)).orElse(\u260318.method_16717().field_16820);
            class_32 \u260327 = class_32.method_26999(\u260321.toPath());
            class_32.class_5143 \u260328 = \u260327.method_27002(\u260326);
            MinecraftServer.method_27725(\u260328);
            class_5359 \u260329 = \u260328.method_29585();
            boolean \u260330 = optionSet.has((OptionSpec)\u26038);
            if (\u260330) {
                field_24625.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            class_3283 \u260331 = new class_3283(new class_3286(), new class_3279(\u260328.method_27010(class_5218.field_24186).toFile(), class_5352.field_25349));
            class_5359 \u260332 = MinecraftServer.method_29736(\u260331, \u260329 == null ? class_5359.field_25393 : \u260329, \u260330);
            CompletableFuture<class_5350> \u260333 = class_5350.method_29466(\u260331.method_29211(), class_2170.class_5364.field_25420, \u260318.method_16717().field_20324, class_156.method_18349(), Runnable::run);
            try {
                class_5350 class_53502 = \u260333.get();
            }
            catch (Exception exception) {
                field_24625.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u260331.close();
                return;
            }
            class_53502.method_29475();
            class_5382<class_2520> class_53822 = class_5382.method_29753(class_2509.field_11560, class_53502.method_29474(), \u260316);
            class_5219 \u260334 = \u260328.method_27013(class_53822, \u260332);
            if (\u260334 == null) {
                if (optionSet.has((OptionSpec)\u26034)) {
                    \u260335 = MinecraftServer.field_17704;
                    \u260336 = class_5285.method_31112(\u260316);
                } else {
                    \u260337 = \u260318.method_16717();
                    \u260335 = new class_1940(((class_3806)\u260337).field_16820, ((class_3806)\u260337).field_16841, ((class_3806)\u260337).field_16838, ((class_3806)\u260337).field_16840, false, new class_1928(), \u260332);
                    \u260336 = optionSet.has((OptionSpec)\u26035) ? ((class_3806)\u260337).field_24623.method_28036() : ((class_3806)\u260337).field_24623;
                }
                \u260334 = new class_31((class_1940)\u260335, (class_5285)\u260336, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u26036)) {
                Main.method_29173(\u260328, class_3551.method_15450(), optionSet.has((OptionSpec)\u26037), () -> true, \u260334.method_28057().method_29575());
            }
            \u260328.method_27425(\u260316, \u260334);
            \u260335 = \u260334;
            Object \u260336 = MinecraftServer.method_29740(arg_0 -> Main.method_29734(\u260316, \u260328, \u260331, class_53502, (class_5219)\u260335, \u260318, \u260323, \u260324, \u260325, optionSet, (OptionSpec)\u260310, (OptionSpec)\u260313, (OptionSpec)\u26034, (OptionSpec)\u260314, (OptionSpec)\u26032, (OptionSpec)\u260315, arg_0));
            \u260337 = new Thread("Server Shutdown Thread", (class_3176)\u260336){
                final /* synthetic */ class_3176 field_4611;
                {
                    this.field_4611 = class_31762;
                    super(string);
                }

                @Override
                public void run() {
                    this.field_4611.method_3747(true);
                }
            };
            ((Thread)\u260337).setUncaughtExceptionHandler(new class_140(field_24625));
            Runtime.getRuntime().addShutdownHook((Thread)\u260337);
        }
        catch (Exception exception) {
            field_24625.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void method_29173(class_32.class_5143 class_51432, DataFixer dataFixer, boolean bl, BooleanSupplier booleanSupplier2, ImmutableSet<class_5321<class_1937>> immutableSet) {
        field_24625.info("Forcing world upgrade!");
        class_1257 class_12572 = new class_1257(class_51432, dataFixer, immutableSet, bl);
        class_2561 \u26032 = null;
        while (!class_12572.method_5403()) {
            BooleanSupplier booleanSupplier2;
            class_2561 class_25612 = class_12572.method_5394();
            if (\u26032 != class_25612) {
                \u26032 = class_25612;
                field_24625.info(class_12572.method_5394().getString());
            }
            if ((\u2603 = class_12572.method_5397()) > 0) {
                int n = class_12572.method_5400() + class_12572.method_5399();
                field_24625.info("{}% completed ({} / {} chunks)...", (Object)class_3532.method_15375((float)n / (float)\u2603 * 100.0f), (Object)n, (Object)\u2603);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                class_12572.method_5402();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ class_3176 method_29734(class_5455.class_5457 class_54572, class_32.class_5143 class_51432, class_3283 class_32832, class_5350 class_53502, class_5219 class_52192, class_3807 class_38072, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, class_3312 class_33122, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        class_3176 class_31762 = new class_3176(thread, class_54572, class_51432, class_32832, class_53502, class_52192, class_38072, class_3551.method_15450(), minecraftSessionService, gameProfileRepository, class_33122, class_3951::new);
        class_31762.method_3849((String)optionSet.valueOf(optionSpec));
        class_31762.method_3779((Integer)optionSet.valueOf(optionSpec2));
        class_31762.method_3730(optionSet.has(optionSpec3));
        class_31762.method_17819((String)optionSet.valueOf(optionSpec4));
        boolean bl = \u2603 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u2603 && !GraphicsEnvironment.isHeadless()) {
            class_31762.method_13948();
        }
        return class_31762;
    }
}

