/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3312 {
    private static final Logger field_25805 = LogManager.getLogger();
    private static boolean field_14313;
    private final Map<String, class_3313> field_14312 = Maps.newConcurrentMap();
    private final Map<UUID, class_3313> field_14310 = Maps.newConcurrentMap();
    private final GameProfileRepository field_14315;
    private final Gson field_14318 = new GsonBuilder().create();
    private final File field_14314;
    private final AtomicLong field_25724 = new AtomicLong();

    public class_3312(GameProfileRepository gameProfileRepository, File file) {
        this.field_14315 = gameProfileRepository;
        this.field_14314 = file;
        Lists.reverse(this.method_14517()).forEach(this::method_30164);
    }

    private void method_30164(class_3313 class_33132) {
        GameProfile gameProfile = class_33132.method_14519();
        class_33132.method_30171(this.method_30169());
        String \u26032 = gameProfile.getName();
        if (\u26032 != null) {
            this.field_14312.put(\u26032.toLowerCase(Locale.ROOT), class_33132);
        }
        if ((\u2603 = gameProfile.getId()) != null) {
            this.field_14310.put(\u2603, class_33132);
        }
    }

    @Nullable
    private static GameProfile method_14509(GameProfileRepository gameProfileRepository, String string) {
        final AtomicReference atomicReference = new AtomicReference();
        ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                atomicReference.set(gameProfile);
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                atomicReference.set(null);
            }
        };
        gameProfileRepository.findProfilesByNames(new String[]{string}, Agent.MINECRAFT, \u26032);
        GameProfile \u26033 = (GameProfile)atomicReference.get();
        if (!class_3312.method_14514() && \u26033 == null) {
            UUID uUID = class_1657.method_7271(new GameProfile(null, string));
            \u26033 = new GameProfile(uUID, string);
        }
        return \u26033;
    }

    public static void method_14510(boolean bl) {
        field_14313 = bl;
    }

    private static boolean method_14514() {
        return field_14313;
    }

    public void method_14508(GameProfile gameProfile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date \u26032 = calendar.getTime();
        class_3313 \u26033 = new class_3313(gameProfile, \u26032);
        this.method_30164(\u26033);
        this.method_14518();
    }

    private long method_30169() {
        return this.field_25724.incrementAndGet();
    }

    @Nullable
    public GameProfile method_14515(String string) {
        GameProfile \u26033;
        string2 = string.toLowerCase(Locale.ROOT);
        class_3313 class_33132 = this.field_14312.get(string2);
        boolean \u26032 = false;
        if (class_33132 != null && new Date().getTime() >= class_33132.field_14319.getTime()) {
            this.field_14310.remove(class_33132.method_14519().getId());
            this.field_14312.remove(class_33132.method_14519().getName().toLowerCase(Locale.ROOT));
            \u26032 = true;
            class_33132 = null;
        }
        if (class_33132 != null) {
            class_33132.method_30171(this.method_30169());
            \u26033 = class_33132.method_14519();
        } else {
            String string2;
            \u26033 = class_3312.method_14509(this.field_14315, string2);
            if (\u26033 != null) {
                this.method_14508(\u26033);
                \u26032 = false;
            }
        }
        if (\u26032) {
            this.method_14518();
        }
        return \u26033;
    }

    @Nullable
    public GameProfile method_14512(UUID uUID) {
        class_3313 class_33132 = this.field_14310.get(uUID);
        if (class_33132 == null) {
            return null;
        }
        class_33132.method_30171(this.method_30169());
        return class_33132.method_14519();
    }

    private static DateFormat method_30170() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<class_3313> method_14517() {
        ArrayList arrayList = Lists.newArrayList();
        try (BufferedReader bufferedReader2 = Files.newReader((File)this.field_14314, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.field_14318.fromJson((Reader)bufferedReader2, JsonArray.class);
            if (jsonArray == null) {
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            DateFormat \u26032 = class_3312.method_30170();
            jsonArray.forEach(jsonElement -> {
                class_3313 class_33132 = class_3312.method_30167(jsonElement, \u26032);
                if (class_33132 != null) {
                    arrayList.add(class_33132);
                }
            });
            return arrayList;
        }
        catch (FileNotFoundException bufferedReader2) {
            return arrayList;
        }
        catch (JsonParseException | IOException throwable) {
            field_25805.warn("Failed to load profile cache {}", (Object)this.field_14314, (Object)throwable);
        }
        return arrayList;
    }

    public void method_14518() {
        JsonArray jsonArray = new JsonArray();
        DateFormat \u26032 = class_3312.method_30170();
        this.method_14516(1000).forEach(class_33132 -> jsonArray.add(class_3312.method_30165(class_33132, \u26032)));
        String \u26033 = this.field_14318.toJson((JsonElement)jsonArray);
        try (BufferedWriter bufferedWriter = Files.newWriter((File)this.field_14314, (Charset)StandardCharsets.UTF_8);){
            bufferedWriter.write(\u26033);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<class_3313> method_14516(int n) {
        return ImmutableList.copyOf(this.field_14310.values()).stream().sorted(Comparator.comparing(class_3313::method_30172).reversed()).limit(n);
    }

    private static JsonElement method_30165(class_3313 class_33132, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", class_33132.method_14519().getName());
        UUID \u26032 = class_33132.method_14519().getId();
        jsonObject.addProperty("uuid", \u26032 == null ? "" : \u26032.toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(class_33132.method_14520()));
        return jsonObject;
    }

    @Nullable
    private static class_3313 method_30167(JsonElement jsonElement, DateFormat dateFormat) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement \u26032 = jsonObject.get("name");
            JsonElement \u26033 = jsonObject.get("uuid");
            JsonElement \u26034 = jsonObject.get("expiresOn");
            if (\u26032 == null || \u26033 == null) {
                return null;
            }
            String \u26035 = \u26033.getAsString();
            String \u26036 = \u26032.getAsString();
            Date \u26037 = null;
            if (\u26034 != null) {
                try {
                    \u26037 = dateFormat.parse(\u26034.getAsString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (\u26036 == null || \u26035 == null || \u26037 == null) {
                return null;
            }
            try {
                UUID uUID = UUID.fromString(\u26035);
            }
            catch (Throwable throwable) {
                return null;
            }
            return new class_3313(new GameProfile(uUID, \u26036), \u26037);
        }
        return null;
    }

    static class class_3313 {
        private final GameProfile field_14321;
        private final Date field_14319;
        private volatile long field_25726;

        private class_3313(GameProfile gameProfile, Date date) {
            this.field_14321 = gameProfile;
            this.field_14319 = date;
        }

        public GameProfile method_14519() {
            return this.field_14321;
        }

        public Date method_14520() {
            return this.field_14319;
        }

        public void method_30171(long l) {
            this.field_25726 = l;
        }

        public long method_30172() {
            return this.field_25726;
        }
    }
}

