/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2378;
import net.minecraft.class_24;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2588;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_31;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_3536;
import net.minecraft.class_3551;
import net.minecraft.class_4239;
import net.minecraft.class_4284;
import net.minecraft.class_5125;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5285;
import net.minecraft.class_5315;
import net.minecraft.class_5321;
import net.minecraft.class_5359;
import net.minecraft.class_5455;
import net.minecraft.class_5505;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_32 {
    private static final Logger field_17665 = LogManager.getLogger();
    private static final DateTimeFormatter field_200 = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> field_25020 = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private final Path field_17666;
    private final Path field_17667;
    private final DataFixer field_17668;

    public class_32(Path path, Path path2, DataFixer dataFixer) {
        this.field_17668 = dataFixer;
        try {
            Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.field_17666 = path;
        this.field_17667 = path2;
    }

    public static class_32 method_26999(Path path) {
        return new class_32(path, path.resolve("../backups"), class_3551.method_15450());
    }

    private static <T> Pair<class_5285, Lifecycle> method_29010(Dynamic<T> dynamic, DataFixer dataFixer, int n) {
        String \u260332;
        Dynamic \u26032 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        for (String \u260332 : field_25020) {
            Optional optional = dynamic.get(\u260332).result();
            if (!optional.isPresent()) continue;
            \u26032 = \u26032.set(\u260332, (Dynamic)optional.get());
        }
        Dynamic dynamic2 = dataFixer.update(class_1208.field_23067, \u26032, n, class_155.method_16673().getWorldVersion());
        \u260332 = class_5285.field_24826.parse(dynamic2);
        return Pair.of((Object)\u260332.resultOrPartial(class_156.method_29188("WorldGenSettings: ", arg_0 -> ((Logger)field_17665).error(arg_0))).orElseGet(() -> {
            class_2378 class_23782 = (class_2378)class_5505.method_31148(class_2378.field_25095).codec().parse(dynamic2).resultOrPartial(class_156.method_29188("Dimension type registry: ", arg_0 -> ((Logger)field_17665).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get dimension registry"));
            \u2603 = (class_2378)class_5505.method_31148(class_2378.field_25114).codec().parse(dynamic2).resultOrPartial(class_156.method_29188("Biome registry: ", arg_0 -> ((Logger)field_17665).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get biome registry"));
            \u2603 = (class_2378)class_5505.method_31148(class_2378.field_26374).codec().parse(dynamic2).resultOrPartial(class_156.method_29188("Noise settings registry: ", arg_0 -> ((Logger)field_17665).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get noise settings registry"));
            return class_5285.method_28009(class_23782, \u2603, \u2603);
        }), (Object)\u260332.lifecycle());
    }

    private static class_5359 method_29580(Dynamic<?> dynamic) {
        return class_5359.field_25394.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)field_17665).error(arg_0)).orElse(class_5359.field_25393);
    }

    public List<class_34> method_235() throws class_33 {
        if (!Files.isDirectory(this.field_17666, new LinkOption[0])) {
            throw new class_33(new class_2588("selectWorld.load_folder_access").getString());
        }
        ArrayList arrayList = Lists.newArrayList();
        for (File file : \u2603 = this.field_17666.toFile().listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                boolean bl = class_5125.method_26804(file.toPath());
            }
            catch (Exception exception) {
                field_17665.warn("Failed to read {} lock", (Object)file, (Object)exception);
                continue;
            }
            class_34 class_343 = this.method_26998(file, this.method_29014(file, bl));
            if (class_343 == null) continue;
            arrayList.add(class_343);
        }
        return arrayList;
    }

    private int method_17931() {
        return 19133;
    }

    @Nullable
    private <T> T method_26998(File file, BiFunction<File, DataFixer, T> biFunction) {
        if (!file.exists()) {
            return null;
        }
        File file2 = new File(file, "level.dat");
        if (file2.exists() && (\u2603 = biFunction.apply(file2, this.field_17668)) != null) {
            return \u2603;
        }
        file2 = new File(file, "level.dat_old");
        if (file2.exists()) {
            return biFunction.apply(file2, this.field_17668);
        }
        return null;
    }

    @Nullable
    private static class_5359 method_29583(File file, DataFixer dataFixer) {
        try {
            class_2487 class_24872 = class_2507.method_30613(file);
            \u2603 = class_24872.method_10562("Data");
            \u2603.method_10551("Player");
            int \u26032 = \u2603.method_10573("DataVersion", 99) ? \u2603.method_10550("DataVersion") : -1;
            Dynamic \u26033 = dataFixer.update(class_4284.field_19212.method_20329(), new Dynamic((DynamicOps)class_2509.field_11560, (Object)\u2603), \u26032, class_155.method_16673().getWorldVersion());
            return \u26033.get("DataPacks").result().map(class_32::method_29580).orElse(class_5359.field_25393);
        }
        catch (Exception exception) {
            field_17665.error("Exception reading {}", (Object)file, (Object)exception);
            return null;
        }
    }

    private static BiFunction<File, DataFixer, class_31> method_17926(DynamicOps<class_2520> dynamicOps, class_5359 class_53592) {
        return (file, dataFixer) -> {
            try {
                class_2487 class_24872 = class_2507.method_30613(file);
                \u2603 = class_24872.method_10562("Data");
                \u2603 = \u2603.method_10573("Player", 10) ? \u2603.method_10562("Player") : null;
                \u2603.method_10551("Player");
                int \u26032 = \u2603.method_10573("DataVersion", 99) ? \u2603.method_10550("DataVersion") : -1;
                Dynamic \u26033 = dataFixer.update(class_4284.field_19212.method_20329(), new Dynamic(dynamicOps, (Object)\u2603), \u26032, class_155.method_16673().getWorldVersion());
                Pair<class_5285, Lifecycle> \u26034 = class_32.method_29010(\u26033, dataFixer, \u26032);
                class_5315 \u26035 = class_5315.method_29023(\u26033);
                class_1940 \u26036 = class_1940.method_28383(\u26033, class_53592);
                return class_31.method_29029((Dynamic<class_2520>)\u26033, dataFixer, \u26032, \u2603, \u26036, \u26035, (class_5285)\u26034.getFirst(), (Lifecycle)\u26034.getSecond());
            }
            catch (Exception exception) {
                field_17665.error("Exception reading {}", file, (Object)exception);
                return null;
            }
        };
    }

    private BiFunction<File, DataFixer, class_34> method_29014(File file, boolean bl) {
        return (file2, dataFixer) -> {
            try {
                class_2487 class_24872 = class_2507.method_30613(file2);
                \u2603 = class_24872.method_10562("Data");
                \u2603.method_10551("Player");
                int \u26032 = \u2603.method_10573("DataVersion", 99) ? \u2603.method_10550("DataVersion") : -1;
                Dynamic \u26033 = dataFixer.update(class_4284.field_19212.method_20329(), new Dynamic((DynamicOps)class_2509.field_11560, (Object)\u2603), \u26032, class_155.method_16673().getWorldVersion());
                class_5315 \u26034 = class_5315.method_29023(\u26033);
                int \u26035 = \u26034.method_29022();
                if (\u26035 == 19132 || \u26035 == 19133) {
                    boolean bl2 = \u26035 != this.method_17931();
                    File \u26036 = new File(file, "icon.png");
                    class_5359 \u26037 = \u26033.get("DataPacks").result().map(class_32::method_29580).orElse(class_5359.field_25393);
                    class_1940 \u26038 = class_1940.method_28383(\u26033, \u26037);
                    return new class_34(\u26038, \u26034, file.getName(), bl2, bl, \u26036);
                }
                return null;
            }
            catch (Exception exception) {
                field_17665.error("Exception reading {}", file2, (Object)exception);
                return null;
            }
        };
    }

    public boolean method_240(String string) {
        try {
            Path path = this.field_17666.resolve(string);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean method_230(String string) {
        return Files.isDirectory(this.field_17666.resolve(string), new LinkOption[0]);
    }

    public Path method_19636() {
        return this.field_17666;
    }

    public Path method_236() {
        return this.field_17667;
    }

    public class_5143 method_27002(String string) throws IOException {
        return new class_5143(string);
    }

    public class class_5143
    implements AutoCloseable {
        private final class_5125 field_23767;
        private final Path field_23768;
        private final String field_23769;
        private final Map<class_5218, Path> field_24190 = Maps.newHashMap();

        public class_5143(String string) throws IOException {
            this.field_23769 = string;
            this.field_23768 = class_32.this.field_17666.resolve(string);
            this.field_23767 = class_5125.method_26803(this.field_23768);
        }

        public String method_27005() {
            return this.field_23769;
        }

        public Path method_27010(class_5218 class_52183) {
            return this.field_24190.computeIfAbsent(class_52183, class_52182 -> this.field_23768.resolve(class_52182.method_27423()));
        }

        public File method_27424(class_5321<class_1937> class_53212) {
            return class_2874.method_12488(class_53212, this.field_23768.toFile());
        }

        private void method_27017() {
            if (!this.field_23767.method_26802()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public class_29 method_27427() {
            this.method_27017();
            return new class_29(this, class_32.this.field_17668);
        }

        public boolean method_27012() {
            class_34 class_343 = this.method_29584();
            return class_343 != null && class_343.method_29586().method_29022() != class_32.this.method_17931();
        }

        public boolean method_27006(class_3536 class_35362) {
            this.method_27017();
            return class_24.method_234(this, class_35362);
        }

        @Nullable
        public class_34 method_29584() {
            this.method_27017();
            return (class_34)class_32.this.method_26998(this.field_23768.toFile(), class_32.this.method_29014(this.field_23768.toFile(), false));
        }

        @Nullable
        public class_5219 method_27013(DynamicOps<class_2520> dynamicOps, class_5359 class_53592) {
            this.method_27017();
            return (class_5219)class_32.this.method_26998(this.field_23768.toFile(), class_32.method_17926((DynamicOps<class_2520>)dynamicOps, class_53592));
        }

        @Nullable
        public class_5359 method_29585() {
            this.method_27017();
            return (class_5359)class_32.this.method_26998(this.field_23768.toFile(), (file, dataFixer) -> class_32.method_29583(file, dataFixer));
        }

        public void method_27425(class_5455 class_54552, class_5219 class_52192) {
            this.method_27426(class_54552, class_52192, null);
        }

        public void method_27426(class_5455 class_54552, class_5219 class_52192, @Nullable class_2487 class_24872) {
            File file = this.field_23768.toFile();
            class_2487 \u26032 = class_52192.method_163(class_54552, class_24872);
            class_2487 \u26033 = new class_2487();
            \u26033.method_10566("Data", \u26032);
            try {
                \u2603 = File.createTempFile("level", ".dat", file);
                class_2507.method_30614(\u26033, \u2603);
                \u2603 = new File(file, "level.dat_old");
                \u2603 = new File(file, "level.dat");
                class_156.method_27760(\u2603, \u2603, \u2603);
            }
            catch (Exception \u26034) {
                field_17665.error("Failed to save level {}", (Object)file, (Object)\u26034);
            }
        }

        public File method_27014() {
            this.method_27017();
            return this.field_23768.resolve("icon.png").toFile();
        }

        public void method_27015() throws IOException {
            this.method_27017();
            final Path path = this.field_23768.resolve("session.lock");
            for (int i = 1; i <= 5; ++i) {
                field_17665.info("Attempt {}...", (Object)i);
                try {
                    Files.walkFileTree(this.field_23768, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult method_27019(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                            if (!path2.equals(path)) {
                                field_17665.debug("Deleting {}", (Object)path2);
                                Files.delete(path2);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult method_27018(Path path2, IOException iOException) throws IOException {
                            if (iOException != null) {
                                throw iOException;
                            }
                            if (path2.equals(class_5143.this.field_23768)) {
                                class_5143.this.field_23767.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path2);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                            return this.method_27018((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.method_27019((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException iOException) {
                    if (i < 5) {
                        field_17665.warn("Failed to delete {}", (Object)this.field_23768, (Object)iOException);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw iOException;
                }
            }
        }

        public void method_27008(String string) throws IOException {
            this.method_27017();
            File file = new File(class_32.this.field_17666.toFile(), this.field_23769);
            if (!file.exists()) {
                return;
            }
            \u2603 = new File(file, "level.dat");
            if (\u2603.exists()) {
                class_2487 class_24872 = class_2507.method_30613(\u2603);
                \u2603 = class_24872.method_10562("Data");
                \u2603.method_10582("LevelName", string);
                class_2507.method_30614(class_24872, \u2603);
            }
        }

        public long method_27016() throws IOException {
            this.method_27017();
            String string = LocalDateTime.now().format(field_200) + "_" + this.field_23769;
            Path \u26032 = class_32.this.method_236();
            try {
                Files.createDirectories(Files.exists(\u26032, new LinkOption[0]) ? \u26032.toRealPath(new LinkOption[0]) : \u26032, new FileAttribute[0]);
            }
            catch (IOException \u26033) {
                throw new RuntimeException(\u26033);
            }
            Path \u26034 = \u26032.resolve(class_4239.method_19773(\u26032, string, ".zip"));
            try (final ZipOutputStream \u26035 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(\u26034, new OpenOption[0])));){
                final Path path = Paths.get(this.field_23769, new String[0]);
                Files.walkFileTree(this.field_23768, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult method_246(Path path2, BasicFileAttributes basicFileAttributes) throws IOException {
                        if (path2.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String string = path.resolve(class_5143.this.field_23768.relativize(path2)).toString().replace('\\', '/');
                        ZipEntry \u26032 = new ZipEntry(string);
                        \u26035.putNextEntry(\u26032);
                        com.google.common.io.Files.asByteSource((File)path2.toFile()).copyTo((OutputStream)\u26035);
                        \u26035.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.method_246((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size(\u26034);
        }

        @Override
        public void close() throws IOException {
            this.field_23767.close();
        }
    }
}

