/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_3696;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3032 {
    private static final Logger field_20283 = LogManager.getLogger();
    private static final SimpleCommandExceptionType field_13597 = new SimpleCommandExceptionType((Message)new class_2588("commands.debug.notRunning"));
    private static final SimpleCommandExceptionType field_13596 = new SimpleCommandExceptionType((Message)new class_2588("commands.debug.alreadyRunning"));
    @Nullable
    private static final FileSystemProvider field_20310 = FileSystemProvider.installedProviders().stream().filter(fileSystemProvider -> fileSystemProvider.getScheme().equalsIgnoreCase("jar")).findFirst().orElse(null);

    public static void method_13156(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247("debug").requires(class_21682 -> class_21682.method_9259(3))).then(class_2170.method_9247("start").executes(commandContext -> class_3032.method_13159((class_2168)commandContext.getSource())))).then(class_2170.method_9247("stop").executes(commandContext -> class_3032.method_13158((class_2168)commandContext.getSource())))).then(class_2170.method_9247("report").executes(commandContext -> class_3032.method_21618((class_2168)commandContext.getSource()))));
    }

    private static int method_13159(class_2168 class_21682) throws CommandSyntaxException {
        MinecraftServer minecraftServer = class_21682.method_9211();
        if (minecraftServer.method_24488()) {
            throw field_13596.create();
        }
        minecraftServer.method_3832();
        class_21682.method_9226(new class_2588("commands.debug.started", "Started the debug profiler. Type '/debug stop' to stop it."), true);
        return 0;
    }

    private static int method_13158(class_2168 class_21682) throws CommandSyntaxException {
        MinecraftServer minecraftServer = class_21682.method_9211();
        if (!minecraftServer.method_24488()) {
            throw field_13597.create();
        }
        class_3696 \u26032 = minecraftServer.method_24489();
        File \u26033 = new File(minecraftServer.method_3758("debug"), "profile-results-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".txt");
        \u26032.method_16069(\u26033);
        float \u26034 = (float)\u26032.method_16071() / 1.0E9f;
        float \u26035 = (float)\u26032.method_16074() / \u26034;
        class_21682.method_9226(new class_2588("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", Float.valueOf(\u26034)), \u26032.method_16074(), String.format("%.2f", Float.valueOf(\u26035))), true);
        return class_3532.method_15375(\u26035);
    }

    private static int method_21618(class_2168 class_216822) {
        MinecraftServer minecraftServer = class_216822.method_9211();
        String \u26032 = "debug-report-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        try {
            class_2168 class_216822;
            Path path = minecraftServer.method_3758("debug").toPath();
            Files.createDirectories(path, new FileAttribute[0]);
            if (class_155.field_1125 || field_20310 == null) {
                \u2603 = path.resolve(\u26032);
                minecraftServer.method_21613(\u2603);
            } else {
                \u2603 = path.resolve(\u26032 + ".zip");
                try (FileSystem fileSystem = field_20310.newFileSystem(\u2603, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));){
                    minecraftServer.method_21613(fileSystem.getPath("/", new String[0]));
                }
            }
            class_216822.method_9226(new class_2588("commands.debug.reportSaved", \u26032), false);
            return 1;
        }
        catch (IOException iOException) {
            field_20283.error("Failed to save debug dump", (Throwable)iOException);
            class_216822.method_9213(new class_2588("commands.debug.reportFailed"));
            return 0;
        }
    }
}

