/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1276;
import net.minecraft.class_128;
import net.minecraft.class_140;
import net.minecraft.class_143;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2631;
import net.minecraft.class_2976;
import net.minecraft.class_2994;
import net.minecraft.class_3174;
import net.minecraft.class_3178;
import net.minecraft.class_3182;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_3312;
import net.minecraft.class_3321;
import net.minecraft.class_3324;
import net.minecraft.class_3350;
import net.minecraft.class_3364;
import net.minecraft.class_3408;
import net.minecraft.class_3515;
import net.minecraft.class_3532;
import net.minecraft.class_3806;
import net.minecraft.class_3807;
import net.minecraft.class_3950;
import net.minecraft.class_5169;
import net.minecraft.class_5219;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3176
extends MinecraftServer
implements class_2994 {
    private static final Logger field_13814 = LogManager.getLogger();
    private static final Pattern field_13810 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final List<class_2976> field_13815 = Collections.synchronizedList(Lists.newArrayList());
    private class_3364 field_13816;
    private final class_3350 field_13811;
    private class_3408 field_13819;
    private final class_3807 field_16799;
    @Nullable
    private class_3182 field_16800;

    public class_3176(Thread thread, class_5455.class_5457 class_54572, class_32.class_5143 class_51432, class_3283 class_32832, class_5350 class_53502, class_5219 class_52192, class_3807 class_38072, DataFixer dataFixer, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, class_3312 class_33122, class_3950 class_39502) {
        super(thread, class_54572, class_51432, class_52192, class_32832, Proxy.NO_PROXY, dataFixer, class_53502, minecraftSessionService, gameProfileRepository, class_33122, class_39502);
        this.field_16799 = class_38072;
        this.field_13811 = new class_3350(this);
    }

    @Override
    public boolean method_3823() throws IOException {
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    while (!class_3176.this.method_3750() && class_3176.this.method_3806() && (\u2603 = bufferedReader.readLine()) != null) {
                        class_3176.this.method_13947(\u2603, class_3176.this.method_3739());
                    }
                }
                catch (IOException \u26032) {
                    field_13814.error("Exception handling console input", (Throwable)\u26032);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new class_140(field_13814));
        thread.start();
        field_13814.info("Starting minecraft server version " + class_155.method_16673().getName());
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_13814.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        field_13814.info("Loading properties");
        class_3806 \u26032 = this.field_16799.method_16717();
        if (this.method_3724()) {
            this.method_3842("127.0.0.1");
        } else {
            this.method_3864(\u26032.field_16813);
            this.method_3764(\u26032.field_16839);
            this.method_3842(\u26032.field_16829);
        }
        this.method_3815(\u26032.field_16833);
        this.method_3745(\u26032.field_16807);
        this.method_3843(\u26032.field_16801, this.method_13950());
        this.method_3834(\u26032.field_16825);
        this.method_3794(\u26032.field_16827);
        super.method_3803(\u26032.field_16817.get());
        this.method_3731(\u26032.field_16805);
        this.field_24372.method_193(\u26032.field_16841);
        field_13814.info("Default game type: {}", (Object)\u26032.field_16841);
        InetAddress \u26033 = null;
        if (!this.method_3819().isEmpty()) {
            \u26033 = InetAddress.getByName(this.method_3819());
        }
        if (this.method_3756() < 0) {
            this.method_3779(\u26032.field_16837);
        }
        field_13814.info("Generating keypair");
        this.method_3853(class_3515.method_15237());
        field_13814.info("Starting Minecraft server on {}:{}", (Object)(this.method_3819().isEmpty() ? "*" : this.method_3819()), (Object)this.method_3756());
        try {
            this.method_3787().method_14354(\u26033, this.method_3756());
        }
        catch (IOException \u26034) {
            field_13814.warn("**** FAILED TO BIND TO PORT!");
            field_13814.warn("The exception was: {}", (Object)\u26034.toString());
            field_13814.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.method_3828()) {
            field_13814.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            field_13814.warn("The server will make no attempt to authenticate usernames. Beware.");
            field_13814.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            field_13814.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.method_13951()) {
            this.method_3793().method_14518();
        }
        if (!class_3321.method_14540(this)) {
            return false;
        }
        this.method_3846(new class_3174(this, this.field_25132, this.field_24371));
        long \u26035 = class_156.method_648();
        this.method_3850(\u26032.field_16810);
        class_2631.method_11337(this.method_3793());
        class_2631.method_11336(this.method_3844());
        class_3312.method_14510(this.method_3828());
        field_13814.info("Preparing level \"{}\"", (Object)this.method_3865());
        this.method_3735();
        long \u26036 = class_156.method_648() - \u26035;
        String \u26037 = String.format(Locale.ROOT, "%.3fs", (double)\u26036 / 1.0E9);
        field_13814.info("Done ({})! For help, type \"help\"", (Object)\u26037);
        if (\u26032.field_16830 != null) {
            this.method_3767().method_20746(class_1928.field_19409).method_20758(\u26032.field_16830, this);
        }
        if (\u26032.field_16819) {
            field_13814.info("Starting GS4 status listener");
            this.field_13816 = class_3364.method_30737(this);
        }
        if (\u26032.field_16818) {
            field_13814.info("Starting remote control listener");
            this.field_13819 = class_3408.method_30738(this);
        }
        if (this.method_13944() > 0L) {
            \u2603 = new Thread(new class_3178(this));
            \u2603.setUncaughtExceptionHandler(new class_143(field_13814));
            \u2603.setName("Server Watchdog");
            \u2603.setDaemon(true);
            \u2603.start();
        }
        class_1802.field_8162.method_7850(class_1761.field_7915, class_2371.method_10211());
        if (\u26032.field_24056) {
            class_5169.method_27181(this);
        }
        return true;
    }

    @Override
    public boolean method_3796() {
        return this.method_16705().field_16836 && super.method_3796();
    }

    @Override
    public boolean method_3783() {
        return this.field_16799.method_16717().field_16835 && super.method_3783();
    }

    @Override
    public boolean method_3736() {
        return this.field_16799.method_16717().field_16809 && super.method_3736();
    }

    public String method_13950() {
        String string;
        class_3806 class_38062 = this.field_16799.method_16717();
        if (!class_38062.field_16821.isEmpty()) {
            string = class_38062.field_16821;
            if (!Strings.isNullOrEmpty((String)class_38062.field_16834)) {
                field_13814.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)class_38062.field_16834)) {
            field_13814.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            string = class_38062.field_16834;
        } else {
            string = "";
        }
        if (!string.isEmpty() && !field_13810.matcher(string).matches()) {
            field_13814.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!class_38062.field_16801.isEmpty() && string.isEmpty()) {
            field_13814.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return string;
    }

    @Override
    public class_3806 method_16705() {
        return this.field_16799.method_16717();
    }

    @Override
    public void method_27731() {
        this.method_3776(this.method_16705().field_16840, true);
    }

    @Override
    public boolean method_3754() {
        return this.method_16705().field_16838;
    }

    @Override
    public class_128 method_3859(class_128 class_12810) {
        class_12810 = super.method_3859(class_12810);
        class_12810.method_567().method_577("Is Modded", () -> this.method_24307().orElse("Unknown (can't tell)"));
        class_12810.method_567().method_577("Type", () -> "Dedicated Server (map_server.txt)");
        return class_12810;
    }

    @Override
    public Optional<String> method_24307() {
        String string = this.getServerModName();
        if (!"vanilla".equals(string)) {
            return Optional.of("Definitely; Server brand changed to '" + string + "'");
        }
        return Optional.empty();
    }

    @Override
    public void method_3821() {
        if (this.field_16800 != null) {
            this.field_16800.method_16750();
        }
        if (this.field_13819 != null) {
            this.field_13819.method_18050();
        }
        if (this.field_13816 != null) {
            this.field_13816.method_18050();
        }
    }

    @Override
    public void method_3813(BooleanSupplier booleanSupplier) {
        super.method_3813(booleanSupplier);
        this.method_13941();
    }

    @Override
    public boolean method_3839() {
        return this.method_16705().field_16811;
    }

    @Override
    public void method_5495(class_1276 class_12762) {
        class_12762.method_5481("whitelist_enabled", this.method_13949().method_14614());
        class_12762.method_5481("whitelist_count", this.method_13949().method_14560().length);
        super.method_5495(class_12762);
    }

    public void method_13947(String string, class_2168 class_21682) {
        this.field_13815.add(new class_2976(string, class_21682));
    }

    public void method_13941() {
        while (!this.field_13815.isEmpty()) {
            class_2976 class_29762 = this.field_13815.remove(0);
            this.method_3734().method_9249(class_29762.field_13378, class_29762.field_13377);
        }
    }

    @Override
    public boolean method_3816() {
        return true;
    }

    @Override
    public int method_30612() {
        return this.method_16705().field_25802;
    }

    @Override
    public boolean method_3759() {
        return this.method_16705().field_16832;
    }

    public class_3174 method_13949() {
        return (class_3174)super.method_3760();
    }

    @Override
    public boolean method_3860() {
        return true;
    }

    @Override
    public String method_12929() {
        return this.method_3819();
    }

    @Override
    public int method_12918() {
        return this.method_3756();
    }

    @Override
    public String method_12930() {
        return this.method_3818();
    }

    public void method_13948() {
        if (this.field_16800 == null) {
            this.field_16800 = class_3182.method_13969(this);
        }
    }

    @Override
    public boolean method_3727() {
        return this.field_16800 != null;
    }

    @Override
    public boolean method_3763(class_1934 class_19342, boolean bl, int n) {
        return false;
    }

    @Override
    public boolean method_3812() {
        return this.method_16705().field_16806;
    }

    @Override
    public int method_3841() {
        return this.method_16705().field_16816;
    }

    @Override
    public boolean method_3785(class_3218 class_32182, class_2338 class_23382, class_1657 class_16572) {
        if (class_32182.method_27983() != class_1937.field_25179) {
            return false;
        }
        if (this.method_13949().method_14603().method_14641()) {
            return false;
        }
        if (this.method_13949().method_14569(class_16572.method_7334())) {
            return false;
        }
        if (this.method_3841() <= 0) {
            return false;
        }
        class_2338 class_23383 = class_32182.method_27911();
        int \u26032 = class_3532.method_15382(class_23382.method_10263() - class_23383.method_10263());
        int \u26033 = Math.max(\u26032, \u2603 = class_3532.method_15382(class_23382.method_10260() - class_23383.method_10260()));
        return \u26033 <= this.method_3841();
    }

    @Override
    public boolean method_27902() {
        return this.method_16705().field_24453;
    }

    @Override
    public int method_3798() {
        return this.method_16705().field_16845;
    }

    @Override
    public int method_21714() {
        return this.method_16705().field_20324;
    }

    @Override
    public void method_3803(int n) {
        super.method_3803(n);
        this.field_16799.method_16718(class_38062 -> (class_3806)class_38062.field_16817.method_16745(this.method_30611(), n));
    }

    @Override
    public boolean method_3732() {
        return this.method_16705().field_16824;
    }

    @Override
    public boolean method_9201() {
        return this.method_16705().field_16802;
    }

    @Override
    public int method_3749() {
        return this.method_16705().field_16812;
    }

    @Override
    public int method_3773() {
        return this.method_16705().field_16842;
    }

    protected boolean method_13951() {
        int n;
        boolean bl = false;
        for (n = 0; !bl && n <= 2; ++n) {
            if (n > 0) {
                field_13814.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.method_13942();
            }
            bl = class_3321.method_14547(this);
        }
        boolean bl2 = false;
        for (n = 0; !bl2 && n <= 2; ++n) {
            if (n > 0) {
                field_13814.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.method_13942();
            }
            bl2 = class_3321.method_14545(this);
        }
        boolean bl3 = false;
        for (n = 0; !bl3 && n <= 2; ++n) {
            if (n > 0) {
                field_13814.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.method_13942();
            }
            bl3 = class_3321.method_14539(this);
        }
        boolean bl4 = false;
        for (n = 0; !bl4 && n <= 2; ++n) {
            if (n > 0) {
                field_13814.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.method_13942();
            }
            bl4 = class_3321.method_14533(this);
        }
        boolean bl5 = false;
        for (n = 0; !bl5 && n <= 2; ++n) {
            if (n > 0) {
                field_13814.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.method_13942();
            }
            bl5 = class_3321.method_14550(this);
        }
        return bl || bl2 || bl3 || bl4 || bl5;
    }

    private void method_13942() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public long method_13944() {
        return this.method_16705().field_16815;
    }

    @Override
    public String method_12916() {
        return "";
    }

    @Override
    public String method_12934(String string) {
        this.field_13811.method_14702();
        this.method_19537(() -> this.method_3734().method_9249(this.field_13811.method_14700(), string));
        return this.field_13811.method_14701();
    }

    public void method_16712(boolean bl) {
        this.field_16799.method_16718(class_38062 -> (class_3806)class_38062.field_16804.method_16745(this.method_30611(), bl));
    }

    @Override
    public void method_3782() {
        super.method_3782();
        class_156.method_18350();
    }

    @Override
    public boolean method_19466(GameProfile gameProfile) {
        return false;
    }

    @Override
    public int method_27903(int n) {
        return this.method_16705().field_24454 * n / 100;
    }

    @Override
    public String method_3865() {
        return this.field_23784.method_27005();
    }

    @Override
    public boolean method_27051() {
        return this.field_16799.method_16717().field_23785;
    }

    @Override
    public /* synthetic */ class_3324 method_3760() {
        return this.method_13949();
    }
}

