/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4493;
import net.minecraft.class_4573;
import net.minecraft.class_5365;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

public class RenderSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<class_4573> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final class_289 RENDER_THREAD_TESSELATOR = new class_289();
    public static final float DEFAULTALPHACUTOFF = 0.1f;
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    private static Thread gameThread;
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean bl) {
        boolean bl2 = \u2603 = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || \u2603 == bl) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> supplier) {
        if (!supplier.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(class_4573 class_45732) {
        recordingQueue.add(class_45732);
    }

    public static void flipFrame(long l) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        class_289.method_1348().method_1349().method_1343();
        GLFW.glfwSwapBuffers((long)l);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            class_4573 class_45732 = recordingQueue.poll();
            class_45732.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int n) {
        double d = lastDrawTime + 1.0 / (double)n;
        \u2603 = GLFW.glfwGetTime();
        while (\u2603 < d) {
            GLFW.glfwWaitEventsTimeout((double)(d - \u2603));
            \u2603 = GLFW.glfwGetTime();
        }
        lastDrawTime = \u2603;
    }

    @Deprecated
    public static void pushLightingAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21935();
    }

    @Deprecated
    public static void pushTextureAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21976();
    }

    @Deprecated
    public static void popAttributes() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21997();
    }

    @Deprecated
    public static void disableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22012();
    }

    @Deprecated
    public static void enableAlphaTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22021();
    }

    @Deprecated
    public static void alphaFunc(int n, float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21945(n, f);
    }

    @Deprecated
    public static void enableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22028();
    }

    @Deprecated
    public static void disableLighting() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22034();
    }

    @Deprecated
    public static void enableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22040();
    }

    @Deprecated
    public static void disableColorMaterial() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22044();
    }

    @Deprecated
    public static void colorMaterial(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21947(n, n2);
    }

    @Deprecated
    public static void normal3f(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21942(f, f2, f3);
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22047();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_22050();
    }

    public static void depthFunc(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22001(n);
    }

    public static void depthMask(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21974(bl);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22056();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22053();
    }

    public static void blendFunc(class_4493.class_4535 class_45352, class_4493.class_4534 class_45342) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21984(class_45352.field_22545, class_45342.field_22528);
    }

    public static void blendFunc(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21984(n, n2);
    }

    public static void blendFuncSeparate(class_4493.class_4535 class_45352, class_4493.class_4534 class_45342, class_4493.class_4535 class_45353, class_4493.class_4534 class_45343) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21950(class_45352.field_22545, class_45342.field_22528, class_45353.field_22545, class_45343.field_22528);
    }

    public static void blendFuncSeparate(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21950(n, n2, n3, n4);
    }

    public static void blendEquation(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22015(n);
    }

    public static void blendColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22883(f, f2, f3, f4);
    }

    @Deprecated
    public static void enableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22072();
    }

    @Deprecated
    public static void disableFog() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22074();
    }

    @Deprecated
    public static void fogMode(class_4493.class_1028 class_10282) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22071(class_10282.field_5093);
    }

    @Deprecated
    public static void fogMode(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22071(n);
    }

    @Deprecated
    public static void fogDensity(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21940(f);
    }

    @Deprecated
    public static void fogStart(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21978(f);
    }

    @Deprecated
    public static void fogEnd(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21998(f);
    }

    @Deprecated
    public static void fog(int n, float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22033(n, new float[]{f, f2, f3, f4});
    }

    @Deprecated
    public static void fogi(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22055(n, n2);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22076();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22078();
    }

    public static void polygonMode(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22058(n, n2);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22080();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22082();
    }

    public static void enableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22084();
    }

    public static void disableLineOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22086();
    }

    public static void polygonOffset(float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21941(f, f2);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21906();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21908();
    }

    public static void logicOp(class_4493.class_1030 class_10302) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22075(class_10302.field_5108);
    }

    public static void activeTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22077(n);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21910();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21912();
    }

    public static void texParameter(int n, int n2, int n3) {
        class_4493.method_21986(n, n2, n3);
    }

    public static void deleteTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_22079(n);
    }

    public static void bindTexture(int n) {
        class_4493.method_22081(n);
    }

    @Deprecated
    public static void shadeModel(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22083(n);
    }

    @Deprecated
    public static void enableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21920();
    }

    @Deprecated
    public static void disableRescaleNormal() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21922();
    }

    public static void viewport(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_22025(n, n2, n3, n4);
    }

    public static void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21975(bl, bl2, bl3, bl4);
    }

    public static void stencilFunc(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22017(n, n2, n3);
    }

    public static void stencilMask(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22085(n);
    }

    public static void stencilOp(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22024(n, n2, n3);
    }

    public static void clearDepth(double d) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_21936(d);
    }

    public static void clearColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_21943(f, f2, f3, f4);
    }

    public static void clearStencil(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22087(n);
    }

    public static void clear(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_21965(n, bl);
    }

    @Deprecated
    public static void matrixMode(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21907(n);
    }

    @Deprecated
    public static void loadIdentity() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21924();
    }

    @Deprecated
    public static void pushMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21926();
    }

    @Deprecated
    public static void popMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21928();
    }

    @Deprecated
    public static void ortho(double d, double d2, double d3, double d4, double d5, double d6) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21939(d, d2, d3, d4, d5, d6);
    }

    @Deprecated
    public static void rotatef(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21981(f, f2, f3, f4);
    }

    @Deprecated
    public static void scalef(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21980(f, f2, f3);
    }

    @Deprecated
    public static void scaled(double d, double d2, double d3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21937(d, d2, d3);
    }

    @Deprecated
    public static void translatef(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21999(f, f2, f3);
    }

    @Deprecated
    public static void translated(double d, double d2, double d3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21938(d, d2, d3);
    }

    @Deprecated
    public static void multMatrix(class_1159 class_11592) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21971(class_11592);
    }

    @Deprecated
    public static void color4f(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22000(f, f2, f3, f4);
    }

    @Deprecated
    public static void color3f(float f, float f2, float f3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22000(f, f2, f3, 1.0f);
    }

    @Deprecated
    public static void clearCurrentColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21930();
    }

    public static void drawArrays(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22037(n, n2, n3);
    }

    public static void lineWidth(float f) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22013(f);
    }

    public static void pixelStore(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        class_4493.method_22067(n, n2);
    }

    public static void pixelTransfer(int n, float f) {
        class_4493.method_21983(n, f);
    }

    public static void readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21956(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    public static void getString(int n, Consumer<String> consumer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumer.accept(class_4493.method_21921(n));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(n, bl);
    }

    public static void setErrorCallback(GLFWErrorCallbackI gLFWErrorCallbackI) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(gLFWErrorCallbackI);
    }

    public static void renderCrosshair(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(n, true, true, true);
    }

    public static void setupNvFogDistance() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._setupNvFogDistance();
    }

    @Deprecated
    public static void glMultiTexCoord2f(int n, float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21946(n, f, f2);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return GLX._getCapsString();
    }

    public static void setupDefaultState(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        class_4493.method_21910();
        class_4493.method_22083(7425);
        class_4493.method_21936(1.0);
        class_4493.method_22050();
        class_4493.method_22001(515);
        class_4493.method_22021();
        class_4493.method_21945(516, 0.1f);
        class_4493.method_21907(5889);
        class_4493.method_21924();
        class_4493.method_21907(5888);
        class_4493.method_22025(n, n2, n3, n4);
    }

    public static int maxSupportedTextureSize() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            int n = class_4493.method_21923(3379);
            for (\u2603 = Math.max(32768, n); \u2603 >= 1024; \u2603 >>= 1) {
                class_4493.method_21954(32868, 0, 6408, \u2603, \u2603, 0, 6408, 5121, null);
                \u2603 = class_4493.method_22003(32868, 0, 4096);
                if (\u2603 == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = \u2603;
                return \u2603;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(n, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int n, Supplier<Integer> supplier) {
        class_4493.method_22036(n, supplier.get());
    }

    public static void glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        class_4493.method_21962(n, byteBuffer, n2);
    }

    public static void glDeleteBuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22054(n);
    }

    public static void glUniform1i(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22030(n, n2);
    }

    public static void glUniform1(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21964(n, intBuffer);
    }

    public static void glUniform2(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21992(n, intBuffer);
    }

    public static void glUniform3(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22008(n, intBuffer);
    }

    public static void glUniform4(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22020(n, intBuffer);
    }

    public static void glUniform1(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21991(n, floatBuffer);
    }

    public static void glUniform2(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22007(n, floatBuffer);
    }

    public static void glUniform3(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22019(n, floatBuffer);
    }

    public static void glUniform4(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22026(n, floatBuffer);
    }

    public static void glUniformMatrix2(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21966(n, bl, floatBuffer);
    }

    public static void glUniformMatrix3(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_21993(n, bl, floatBuffer);
    }

    public static void glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22009(n, bl, floatBuffer);
    }

    public static void setupOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_23282();
    }

    public static void teardownOutline() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_23283();
    }

    public static void setupOverlayColor(IntSupplier intSupplier, int n) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22610(intSupplier.getAsInt(), n);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22618();
    }

    public static void setupLevelDiffuseLighting(class_1160 class_11602, class_1160 class_11603, class_1159 class_11592) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22616(class_11602, class_11603, class_11592);
    }

    public static void setupGuiFlatDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_24221(class_11602, class_11603);
    }

    public static void setupGui3DDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_24222(class_11602, class_11603);
    }

    public static void mulTextureByProjModelView() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22889();
    }

    public static void setupEndPortalTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22887();
    }

    public static void clearTexGen() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        class_4493.method_22888();
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumer.accept(class_4493.method_22065()));
        } else {
            consumer.accept(class_4493.method_22065());
        }
    }

    public static class_289 renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(class_4493.class_4535.field_22541, class_4493.class_4534.field_22523, class_4493.class_4535.field_22534, class_4493.class_4534.field_22527);
    }

    public static void defaultAlphaFunc() {
        RenderSystem.alphaFunc(516, 0.1f);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnable) {
        boolean bl = class_310.method_29611();
        if (!bl) {
            runnable.run();
            return;
        }
        class_315 \u26032 = class_310.method_1551().field_1690;
        class_5365 \u26033 = \u26032.field_25444;
        \u26032.field_25444 = class_5365.field_25428;
        runnable.run();
        \u26032.field_25444 = \u26033;
    }

    private static /* synthetic */ void lambda$setupGui3DDiffuseLighting$70(class_1160 class_11602, class_1160 class_11603) {
        class_4493.method_24222(class_11602, class_11603);
    }

    private static /* synthetic */ void lambda$setupGuiFlatDiffuseLighting$69(class_1160 class_11602, class_1160 class_11603) {
        class_4493.method_24221(class_11602, class_11603);
    }

    private static /* synthetic */ void lambda$setupLevelDiffuseLighting$68(class_1160 class_11602, class_1160 class_11603, class_1159 class_11592) {
        class_4493.method_22616(class_11602, class_11603, class_11592);
    }

    private static /* synthetic */ void lambda$setupOverlayColor$67(IntSupplier intSupplier, int n) {
        class_4493.method_22610(intSupplier.getAsInt(), n);
    }

    private static /* synthetic */ void lambda$glUniformMatrix4$66(int n, boolean bl, FloatBuffer floatBuffer) {
        class_4493.method_22009(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix3$65(int n, boolean bl, FloatBuffer floatBuffer) {
        class_4493.method_21993(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniformMatrix2$64(int n, boolean bl, FloatBuffer floatBuffer) {
        class_4493.method_21966(n, bl, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$63(int n, FloatBuffer floatBuffer) {
        class_4493.method_22026(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$62(int n, FloatBuffer floatBuffer) {
        class_4493.method_22019(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$61(int n, FloatBuffer floatBuffer) {
        class_4493.method_22007(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$60(int n, FloatBuffer floatBuffer) {
        class_4493.method_21991(n, floatBuffer);
    }

    private static /* synthetic */ void lambda$glUniform4$59(int n, IntBuffer intBuffer) {
        class_4493.method_22020(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform3$58(int n, IntBuffer intBuffer) {
        class_4493.method_22008(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform2$57(int n, IntBuffer intBuffer) {
        class_4493.method_21992(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1$56(int n, IntBuffer intBuffer) {
        class_4493.method_21964(n, intBuffer);
    }

    private static /* synthetic */ void lambda$glUniform1i$55(int n, int n2) {
        class_4493.method_22030(n, n2);
    }

    private static /* synthetic */ void lambda$glDeleteBuffers$54(int n) {
        class_4493.method_22054(n);
    }

    private static /* synthetic */ void lambda$glBindBuffer$53(int n, Supplier supplier) {
        class_4493.method_22036(n, (Integer)supplier.get());
    }

    private static /* synthetic */ void lambda$glMultiTexCoord2f$52(int n, float f, float f2) {
        class_4493.method_21946(n, f, f2);
    }

    private static /* synthetic */ void lambda$renderCrosshair$51(int n) {
        GLX._renderCrosshair(n, true, true, true);
    }

    private static /* synthetic */ void lambda$getString$50(int n, Consumer consumer) {
        String string = class_4493.method_21921(n);
        consumer.accept(string);
    }

    private static /* synthetic */ void lambda$readPixels$49(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        class_4493.method_21956(n, n2, n3, n4, n5, n6, byteBuffer);
    }

    private static /* synthetic */ void lambda$pixelTransfer$48(int n, float f) {
        class_4493.method_21983(n, f);
    }

    private static /* synthetic */ void lambda$pixelStore$47(int n, int n2) {
        class_4493.method_22067(n, n2);
    }

    private static /* synthetic */ void lambda$lineWidth$46(float f) {
        class_4493.method_22013(f);
    }

    private static /* synthetic */ void lambda$drawArrays$45(int n, int n2, int n3) {
        class_4493.method_22037(n, n2, n3);
    }

    private static /* synthetic */ void lambda$color3f$44(float f, float f2, float f3) {
        class_4493.method_22000(f, f2, f3, 1.0f);
    }

    private static /* synthetic */ void lambda$color4f$43(float f, float f2, float f3, float f4) {
        class_4493.method_22000(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$multMatrix$42(class_1159 class_11592) {
        class_4493.method_21971(class_11592);
    }

    private static /* synthetic */ void lambda$translated$41(double d, double d2, double d3) {
        class_4493.method_21938(d, d2, d3);
    }

    private static /* synthetic */ void lambda$translatef$40(float f, float f2, float f3) {
        class_4493.method_21999(f, f2, f3);
    }

    private static /* synthetic */ void lambda$scaled$39(double d, double d2, double d3) {
        class_4493.method_21937(d, d2, d3);
    }

    private static /* synthetic */ void lambda$scalef$38(float f, float f2, float f3) {
        class_4493.method_21980(f, f2, f3);
    }

    private static /* synthetic */ void lambda$rotatef$37(float f, float f2, float f3, float f4) {
        class_4493.method_21981(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$ortho$36(double d, double d2, double d3, double d4, double d5, double d6) {
        class_4493.method_21939(d, d2, d3, d4, d5, d6);
    }

    private static /* synthetic */ void lambda$matrixMode$35(int n) {
        class_4493.method_21907(n);
    }

    private static /* synthetic */ void lambda$clear$34(int n, boolean bl) {
        class_4493.method_21965(n, bl);
    }

    private static /* synthetic */ void lambda$clearStencil$33(int n) {
        class_4493.method_22087(n);
    }

    private static /* synthetic */ void lambda$clearColor$32(float f, float f2, float f3, float f4) {
        class_4493.method_21943(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$clearDepth$31(double d) {
        class_4493.method_21936(d);
    }

    private static /* synthetic */ void lambda$stencilOp$30(int n, int n2, int n3) {
        class_4493.method_22024(n, n2, n3);
    }

    private static /* synthetic */ void lambda$stencilMask$29(int n) {
        class_4493.method_22085(n);
    }

    private static /* synthetic */ void lambda$stencilFunc$28(int n, int n2, int n3) {
        class_4493.method_22017(n, n2, n3);
    }

    private static /* synthetic */ void lambda$colorMask$27(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        class_4493.method_21975(bl, bl2, bl3, bl4);
    }

    private static /* synthetic */ void lambda$viewport$26(int n, int n2, int n3, int n4) {
        class_4493.method_22025(n, n2, n3, n4);
    }

    private static /* synthetic */ void lambda$shadeModel$25(int n) {
        class_4493.method_22083(n);
    }

    private static /* synthetic */ void lambda$bindTexture$24(int n) {
        class_4493.method_22081(n);
    }

    private static /* synthetic */ void lambda$deleteTexture$23(int n) {
        class_4493.method_22079(n);
    }

    private static /* synthetic */ void lambda$texParameter$22(int n, int n2, int n3) {
        class_4493.method_21986(n, n2, n3);
    }

    private static /* synthetic */ void lambda$activeTexture$21(int n) {
        class_4493.method_22077(n);
    }

    private static /* synthetic */ void lambda$logicOp$20(class_4493.class_1030 class_10302) {
        class_4493.method_22075(class_10302.field_5108);
    }

    private static /* synthetic */ void lambda$polygonOffset$19(float f, float f2) {
        class_4493.method_21941(f, f2);
    }

    private static /* synthetic */ void lambda$polygonMode$18(int n, int n2) {
        class_4493.method_22058(n, n2);
    }

    private static /* synthetic */ void lambda$fogi$17(int n, int n2) {
        class_4493.method_22055(n, n2);
    }

    private static /* synthetic */ void lambda$fog$16(int n, float f, float f2, float f3, float f4) {
        class_4493.method_22033(n, new float[]{f, f2, f3, f4});
    }

    private static /* synthetic */ void lambda$fogEnd$15(float f) {
        class_4493.method_21998(f);
    }

    private static /* synthetic */ void lambda$fogStart$14(float f) {
        class_4493.method_21978(f);
    }

    private static /* synthetic */ void lambda$fogDensity$13(float f) {
        class_4493.method_21940(f);
    }

    private static /* synthetic */ void lambda$fogMode$12(int n) {
        class_4493.method_22071(n);
    }

    private static /* synthetic */ void lambda$fogMode$11(class_4493.class_1028 class_10282) {
        class_4493.method_22071(class_10282.field_5093);
    }

    private static /* synthetic */ void lambda$blendColor$10(float f, float f2, float f3, float f4) {
        class_4493.method_22883(f, f2, f3, f4);
    }

    private static /* synthetic */ void lambda$blendEquation$9(int n) {
        class_4493.method_22015(n);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$8(int n, int n2, int n3, int n4) {
        class_4493.method_21950(n, n2, n3, n4);
    }

    private static /* synthetic */ void lambda$blendFuncSeparate$7(class_4493.class_4535 class_45352, class_4493.class_4534 class_45342, class_4493.class_4535 class_45353, class_4493.class_4534 class_45343) {
        class_4493.method_21950(class_45352.field_22545, class_45342.field_22528, class_45353.field_22545, class_45343.field_22528);
    }

    private static /* synthetic */ void lambda$blendFunc$6(int n, int n2) {
        class_4493.method_21984(n, n2);
    }

    private static /* synthetic */ void lambda$blendFunc$5(class_4493.class_4535 class_45352, class_4493.class_4534 class_45342) {
        class_4493.method_21984(class_45352.field_22545, class_45342.field_22528);
    }

    private static /* synthetic */ void lambda$depthMask$4(boolean bl) {
        class_4493.method_21974(bl);
    }

    private static /* synthetic */ void lambda$depthFunc$3(int n) {
        class_4493.method_22001(n);
    }

    private static /* synthetic */ void lambda$normal3f$2(float f, float f2, float f3) {
        class_4493.method_21942(f, f2, f3);
    }

    private static /* synthetic */ void lambda$colorMaterial$1(int n, int n2) {
        class_4493.method_21947(n, n2);
    }

    private static /* synthetic */ void lambda$alphaFunc$0(int n, float f) {
        class_4493.method_21945(n, f);
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
    }
}

