/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_4587;

class GuiSlotMobs
extends GuiSlotMinimap<MobItem> {
    private ArrayList<MobItem> mobs;
    private ArrayList<MobItem> mobsFiltered;
    private RadarSettingsManager options;
    final GuiMobs parentGui;
    final class_2588 ENABLE = new class_2588("options.minimap.mobs.enable");
    final class_2588 DISABLE = new class_2588("options.minimap.mobs.disable");
    final class_2588 ENABLED = new class_2588("options.minimap.mobs.enabled");
    final class_2588 DISABLED = new class_2588("options.minimap.mobs.disabled");

    public GuiSlotMobs(GuiMobs par1GuiMobs) {
        super(par1GuiMobs.options.game, par1GuiMobs.getWidth(), par1GuiMobs.getHeight(), 32, par1GuiMobs.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiMobs;
        this.options = this.parentGui.options;
        this.mobs = new ArrayList();
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.isTopLevelUnit || (!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if ((!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobs.add(new MobItem(this.parentGui, mob.id));
        }
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.mobs, new Comparator<MobItem>(){

            @Override
            public int compare(MobItem mob1, MobItem mob2) {
                return collator.compare(mob1.name, mob2.name);
            }
        });
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        this.mobsFiltered.forEach(arg_0 -> ((GuiSlotMobs)this).method_25321(arg_0));
    }

    private static String getTranslatedName(String name) {
        if (name.indexOf(".") == -1) {
            name = "entity.minecraft." + name.toLowerCase();
        }
        name = I18nUtils.getString(name, new Object[0]);
        name = name.replaceAll("^entity.minecraft.", "");
        name = name.replace("_", " ");
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        name = TextUtils.scrubCodes(name);
        return name;
    }

    public void setSelected(MobItem item) {
        super.method_25313((class_350.class_351)item);
        if (this.method_25334() instanceof MobItem) {
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{((MobItem)this.method_25334()).name}).getString());
        }
        this.parentGui.setSelectedMob(item.id);
    }

    protected boolean method_25332(int par1) {
        return this.mobsFiltered.get(par1).id.equals(this.parentGui.selectedMobId);
    }

    protected int method_25317() {
        return this.method_25340() * this.field_22741;
    }

    public void method_25325(class_4587 matrixStack) {
        this.parentGui.method_25420(matrixStack);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.mobsFiltered = new ArrayList<MobItem>(this.mobs);
        Iterator<MobItem> iterator = this.mobsFiltered.iterator();
        while (iterator.hasNext()) {
            String mobName = iterator.next().name;
            if (mobName.toLowerCase().contains(filterString)) continue;
            if (mobName == this.parentGui.selectedMobId) {
                this.parentGui.setSelectedMob(null);
            }
            iterator.remove();
        }
        this.mobsFiltered.forEach(arg_0 -> ((GuiSlotMobs)this).method_25321(arg_0));
    }

    public class MobItem
    extends class_350.class_351<MobItem> {
        private final GuiMobs parentGui;
        private final String id;
        private final String name;

        protected MobItem(GuiMobs mobsScreen, String id) {
            this.parentGui = mobsScreen;
            this.id = id;
            this.name = GuiSlotMobs.getTranslatedName(id);
        }

        public void method_25343(class_4587 matrixStack, int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            boolean isHostile = false;
            boolean isNeutral = false;
            boolean isEnabled = true;
            EnumMobs mob = EnumMobs.getMobByName(this.id);
            if (mob != null) {
                isHostile = mob.isHostile;
                isNeutral = mob.isNeutral;
                isEnabled = mob.enabled;
            } else {
                CustomMob customMob = CustomMobsManager.getCustomMobByType(this.id);
                if (customMob != null) {
                    isHostile = customMob.isHostile;
                    isNeutral = customMob.isNeutral;
                    isEnabled = customMob.enabled;
                }
            }
            int red = isHostile ? 255 : 0;
            int green = isNeutral ? 255 : 0;
            int color = -16777216 + (red << 16) + (green << 8) + 0;
            GuiMobs.method_25300((class_4587)matrixStack, (class_327)this.parentGui.getFontRenderer(), (String)this.name, (int)(this.parentGui.getWidth() / 2), (int)(slotYPos + 3), (int)color);
            int padding = 3;
            if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + GuiSlotMobs.this.field_22741) {
                class_2588 tooltip = mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding ? (isEnabled ? GuiSlotMobs.this.DISABLE : GuiSlotMobs.this.ENABLE) : (isEnabled ? GuiSlotMobs.this.ENABLED : GuiSlotMobs.this.DISABLED);
                GuiMobs.setTooltip(this.parentGui, (class_2561)tooltip);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img("textures/mob_effect/" + (isEnabled ? "night_vision.png" : "blindness.png"));
            class_332.method_25291((class_4587)matrixStack, (int)(leftEdge + 198), (int)(slotYPos - 2), (int)GuiSlotMobs.this.method_25305(), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        }

        public boolean method_25402(double mouseX, double mouseY, int mouseEvent) {
            GuiSlotMobs.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleMobVisibility();
            } else if (GuiSlotMobs.this.doubleclick) {
                this.parentGui.toggleMobVisibility();
            }
            return true;
        }
    }
}

