#version 330 compatibility



/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/

/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////ADJUSTABLE VARIABLES//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



//#define HALF_RES_TRACE

/////////INTERNAL VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////INTERNAL VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Do not change the name of these variables or their type. The Shaders Mod reads these lines and determines values to send to the inner-workings
//of the shaders mod. The shaders mod only reads these lines and doesn't actually know the real value assigned to these variables in GLSL.
//Some of these variables are critical for proper operation. Change at your own risk.

//END OF INTERNAL VARIABLES//




in vec4 texcoord;

in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorSkyUp;
in vec3 colorTorchlight;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;


in vec3 worldLightVector;
in vec3 worldSunVector;


in mat4 gbufferPreviousModelViewInverse;
in mat4 gbufferPreviousProjectionInverse;


#include "lib/Uniforms.inc"
#include "lib/Common.inc"

#include "lib/Materials.inc"


/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////






// vec4 GetViewPosition(in vec2 coord, in float depth) 
// {	
// 	vec2 tcoord = coord;
// 	TemporalJitterProjPosInv01(tcoord);

// 	vec4 fragposition = gbufferProjectionInverse * vec4(tcoord.s * 2.0f - 1.0f, tcoord.t * 2.0f - 1.0f, 2.0f * depth - 1.0f, 1.0f);
// 		 fragposition /= fragposition.w;

	
// 	return fragposition;
// }













#include "lib/GBufferData.inc"
 int f(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int d(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int d()
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int y=v.x*v.y;
   return f(FloorToInt(floor(pow(float(y),.333333))));
 }
 int f()
 {
   ivec2 v=ivec2(2048,2048);
   int y=v.x*v.y;
   return d(FloorToInt(floor(pow(float(y),.333333))));
 }
 vec3 v(vec2 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int x=m.x*m.y,y=d();
   ivec2 f=ivec2(v.x*m.x,v.y*m.y);
   float z=float(f.y/y),i=float(int(f.x+mod(m.x*z,y))/y);
   i+=floor(m.x*z/y);
   vec3 t=vec3(0.,0.,i);
   t.x=mod(f.x+mod(m.x*z,y),y);
   t.y=mod(f.y,y);
   t.xyz=floor(t.xyz);
   t/=y;
   t.xyz=t.xzy;
   return t;
 }
 vec2 t(vec3 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int x=d();
   vec3 f=v.xzy*x;
   f=floor(f+1e-05);
   float y=f.z;
   vec2 i;
   i.x=mod(f.x+y*x,m.x);
   float s=f.x+y*x;
   i.y=f.y+floor(s/m.x)*x;
   i+=.5;
   i/=m;
   return i;
 }
 vec3 x(vec2 v)
 {
   vec2 i=v;
   i.xy/=.5;
   ivec2 m=ivec2(2048,2048);
   int x=m.x*m.y,y=f();
   ivec2 t=ivec2(i.x*m.x,i.y*m.y);
   float z=float(t.y/y),r=float(int(t.x+mod(m.x*z,y))/y);
   r+=floor(m.x*z/y);
   vec3 s=vec3(0.,0.,r);
   s.x=mod(t.x+mod(m.x*z,y),y);
   s.y=mod(t.y,y);
   s.xyz=floor(s.xyz);
   s/=y;
   s.xyz=s.xzy;
   return s;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec2 m=vec2(2048,2048);
   vec3 f=v.xzy*y;
   f=floor(f+1e-05);
   float x=f.z;
   vec2 i;
   i.x=mod(f.x+x*y,m.x);
   float s=f.x+x*y;
   i.y=f.y+floor(s/m.x)*y;
   i+=.5;
   i/=m;
   i.xy*=.5;
   return i;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 t(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 s(vec3 v)
 {
   int m=f();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 n(vec3 v)
 {
   int x=d();
   v*=1./x;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 m(vec3 v)
 {
   int m=d();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 m()
 {
   vec3 v=cameraPosition.xyz+.5,y=previousCameraPosition.xyz+.5,x=floor(v-.0001),z=floor(y-.0001);
   return x-z;
 }
 vec3 e(vec3 v)
 {
   vec4 f=vec4(v,1.);
   f=shadowModelView*f;
   f=shadowProjection*f;
   f/=f.w;
   float x=sqrt(f.x*f.x+f.y*f.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   f.xy*=.95f/y;
   f.z=mix(f.z,.5,.8);
   f=f*.5f+.5f;
   f.xy*=.5;
   f.xy+=.5;
   return f.xyz;
 }
 vec3 d(vec3 v,vec3 f,vec2 m,vec2 x,vec4 s,vec4 t,inout float y,out vec2 i)
 {
   bool r=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   r=!r;
   if(t.x==8||t.x==9||t.x==79||t.x<1.||!r||t.x==20.||t.x==171.||min(abs(f.x),abs(f.z))>.2)
     y=1.;
   if(t.x==50.||t.x==52.||t.x==76.)
     {
       y=0.;
       if(f.y<.5)
         y=1.;
     }
   if(t.x==51||t.x==53)
     y=0.;
   if(t.x>255)
     y=0.;
   vec3 z,c;
   if(f.x>.5)
     z=vec3(0.,0.,-1.),c=vec3(0.,-1.,0.);
   else
      if(f.x<-.5)
       z=vec3(0.,0.,1.),c=vec3(0.,-1.,0.);
     else
        if(f.y>.5)
         z=vec3(1.,0.,0.),c=vec3(0.,0.,1.);
       else
          if(f.y<-.5)
           z=vec3(1.,0.,0.),c=vec3(0.,0.,-1.);
         else
            if(f.z>.5)
             z=vec3(1.,0.,0.),c=vec3(0.,-1.,0.);
           else
              if(f.z<-.5)
               z=vec3(-1.,0.,0.),c=vec3(0.,-1.,0.);
   i=clamp((m.xy-x.xy)*100000.,vec2(0.),vec2(1.));
   float h=.15,w=.15;
   if(t.x==10.||t.x==11.)
     {
       if(abs(f.y)<.01&&r||f.y>.99)
         h=.1,w=.1,y=0.;
       else
          y=1.;
     }
   if(t.x==51||t.x==53)
     h=.5,w=.1;
   if(t.x==76)
     h=.2,w=.2;
   if(t.x-255.+39.>=103.&&t.x-255.+39.<=113.)
     w=.025,h=.025;
   z=normalize(s.xyz);
   c=normalize(cross(z,f.xyz)*sign(s.w));
   vec3 n=v.xyz+mix(z*h,-z*h,vec3(i.x));
   n.xyz+=mix(c*h,-c*h,vec3(i.y));
   n.xyz-=f.xyz*w;
   return n;
 }struct rXuEJcsNQI{vec3 QbpObHBdUl;vec3 QbpObHBdUlOrigin;vec3 ZRrfSsHfvT;vec3 fgCeZiNBHZ;vec3 ZKdJsVHIyK;vec3 frnQIYJjVJ;};
 rXuEJcsNQI r(Ray v)
 {
   rXuEJcsNQI f;
   f.QbpObHBdUl=floor(v.origin);
   f.QbpObHBdUlOrigin=f.QbpObHBdUl;
   f.ZRrfSsHfvT=abs(vec3(length(v.direction))/(v.direction+1e-07));
   f.fgCeZiNBHZ=sign(v.direction);
   f.ZKdJsVHIyK=(sign(v.direction)*(f.QbpObHBdUl-v.origin)+sign(v.direction)*.5+.5)*f.ZRrfSsHfvT;
   f.frnQIYJjVJ=vec3(0.);
   return f;
 }
 void i(inout rXuEJcsNQI v)
 {
   v.frnQIYJjVJ=step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.yzx)*step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.zxy),v.ZKdJsVHIyK+=v.frnQIYJjVJ*v.ZRrfSsHfvT,v.QbpObHBdUl+=v.frnQIYJjVJ*v.fgCeZiNBHZ;
 }
 void d(in Ray v,in vec3 f[2],out float i,out float y)
 {
   float x,z,r,w;
   i=(f[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   y=(f[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   x=(f[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   z=(f[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   r=(f[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   w=(f[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   i=max(max(i,x),r);
   y=min(min(y,z),w);
 }
 vec3 d(const vec3 v,const vec3 f,vec3 y)
 {
   const float x=1e-05;
   vec3 z=(f+v)*.5,t=(f-v)*.5,i=y-z,r=vec3(0.);
   r+=vec3(sign(i.x),0.,0.)*step(abs(abs(i.x)-t.x),x);
   r+=vec3(0.,sign(i.y),0.)*step(abs(abs(i.y)-t.y),x);
   r+=vec3(0.,0.,sign(i.z))*step(abs(abs(i.z)-t.z),x);
   return normalize(r);
 }
 bool e(const vec3 v,const vec3 f,Ray m,out vec2 i)
 {
   vec3 y=m.inv_direction*(v-m.origin),x=m.inv_direction*(f-m.origin),t=min(x,y),s=max(x,y);
   vec2 r=max(t.xx,t.yz);
   float z=max(r.x,r.y);
   r=min(s.xx,s.yz);
   float c=min(r.x,r.y);
   i.x=z;
   i.y=c;
   return c>max(z,0.);
 }
 bool d(const vec3 v,const vec3 f,Ray m,inout float x,inout vec3 y)
 {
   vec3 z=m.inv_direction*(v-1e-05-m.origin),t=m.inv_direction*(f+1e-05-m.origin),i=min(t,z),s=max(t,z);
   vec2 r=max(i.xx,i.yz);
   float c=max(r.x,r.y);
   r=min(s.xx,s.yz);
   float n=min(r.x,r.y);
   bool w=n>max(c,0.)&&max(c,0.)<x;
   if(w)
     y=d(v-1e-05,f+1e-05,m.origin+m.direction*c),x=c;
   return w;
 }
 vec3 e(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 t=e(v);
   float w=.5;
   vec3 i=vec3(1.)*shadow2DLod(shadowtex0,vec3(t.xy,t.z-.0006*w),2).x;
   i*=saturate(dot(f,y));
   {
     vec4 m=texture2DLod(shadowcolor1,t.xy-vec2(0.,.5),4);
     float c=abs(m.x*256.-(v.y+cameraPosition.y)),r=GetCausticsComposite(v,f,c),s=shadow2DLod(shadowtex0,vec3(t.xy-vec2(0.,.5),t.z+1e-06),4).x;
     i=mix(i,i*r,1.-s);
   }
   i=TintUnderwaterDepth(i);
   return i*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 i=s(v);
   i+=1.;
   i-=Fract01(cameraPosition+.5);
   vec3 t=e(i+y*.99);
   float w=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(t.xy,t.z-.0006*w),3).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float m=shadow2DLod(shadowtex0,vec3(t.xy-vec2(.5,0.),t.z-.0006*w),3).x;
   vec3 c=texture2DLod(shadowcolor,vec2(t.xy-vec2(.5,0.)),3).xyz;
   c*=c;
   r=mix(r,r*c,vec3(1.-m));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 i(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 t=e(v);
   float w=.5;
   vec3 i=vec3(1.)*shadow2DLod(shadowtex0,vec3(t.xy,t.z-.0006*w),2).x;
   i*=saturate(dot(f,y));
   i=TintUnderwaterDepth(i);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float m=shadow2DLod(shadowtex0,vec3(t.xy-vec2(.5,0.),t.z-.0006*w),3).x;
   vec3 r=texture2DLod(shadowcolor,vec2(t.xy-vec2(.5,0.)),3).xyz;
   r*=r;
   i=mix(i,i*r,vec3(1.-m));
   #endif
   return i*(1.-rainStrength);
 }struct awIafiSlNY{float mwtAZpOIMX;float KZGLOOTLva;float yDFXZDbcEk;float cvVAxIXMRt;vec3 jbwXZaPXmq;};
 vec4 p(awIafiSlNY v)
 {
   vec4 f;
   v.jbwXZaPXmq=max(vec3(0.),v.jbwXZaPXmq);
   f.x=v.mwtAZpOIMX;
   v.jbwXZaPXmq=pow(v.jbwXZaPXmq,vec3(.125));
   f.y=PackTwo16BitTo32Bit(v.jbwXZaPXmq.x,v.yDFXZDbcEk);
   f.z=PackTwo16BitTo32Bit(v.jbwXZaPXmq.y,v.cvVAxIXMRt);
   f.w=PackTwo16BitTo32Bit(v.jbwXZaPXmq.z,v.KZGLOOTLva/255.);
   return f;
 }
 awIafiSlNY h(vec4 v)
 {
   awIafiSlNY f;
   vec2 t=UnpackTwo16BitFrom32Bit(v.y),m=UnpackTwo16BitFrom32Bit(v.z),i=UnpackTwo16BitFrom32Bit(v.w);
   f.mwtAZpOIMX=v.x;
   f.yDFXZDbcEk=t.y;
   f.cvVAxIXMRt=m.y;
   f.KZGLOOTLva=i.y*255.;
   f.jbwXZaPXmq=pow(vec3(t.x,m.x,i.x),vec3(8.));
   return f;
 }
 awIafiSlNY c(vec2 v)
 {
   vec2 x=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*x;
   return h(texture2DLod(colortex5,v,0));
 }
 float c(float v,float y)
 {
   float x=1.;
   #ifdef FULL_RT_REFLECTIONS
   x=clamp(pow(v,.125)+y,0.,1.);
   #else
   x=clamp(v*10.-7.,0.,1.);
   #endif
   return x;
 }
 bool c(vec3 v,float y,Ray x,bool f,inout float z,inout vec3 i)
 {
   bool m=false,r=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(f)
     return false;
   if(y>=67.)
     return false;
   r=d(v,v+vec3(1.,1.,1.),x,z,i);
   m=r;
   #else
   if(y<40.)
     return r=d(v,v+vec3(1.,1.,1.),x,z,i),r;
   if(y==40.||y==41.||y>=43.&&y<=54.)
     {
       float t=.5;
       if(y==41.)
         t=.9375;
       r=d(v+vec3(0.,0.,0.),v+vec3(1.,t,1.),x,z,i);
       m=m||r;
     }
   if(y==42.||y>=55.&&y<=66.)
     r=d(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),x,z,i),m=m||r;
   if(y==43.||y==46.||y==47.||y==52.||y==53.||y==54.||y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
     {
       float t=.5;
       if(y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
         t=0.;
       r=d(v+vec3(0.,t,0.),v+vec3(.5,.5+t,.5),x,z,i);
       m=m||r;
     }
   if(y==43.||y==45.||y==48.||y==51.||y==53.||y==54.||y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
     {
       float t=.5;
       if(y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
         t=0.;
       r=d(v+vec3(.5,t,0.),v+vec3(1.,.5+t,.5),x,z,i);
       m=m||r;
     }
   if(y==44.||y==45.||y==49.||y==51.||y==52.||y==54.||y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
     {
       float t=.5;
       if(y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
         t=0.;
       r=d(v+vec3(.5,t,.5),v+vec3(1.,.5+t,1.),x,z,i);
       m=m||r;
     }
   if(y==44.||y==46.||y==50.||y==51.||y==52.||y==53.||y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
     {
       float t=.5;
       if(y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
         t=0.;
       r=d(v+vec3(0.,t,.5),v+vec3(.5,.5+t,1.),x,z,i);
       m=m||r;
     }
   if(y>=67.&&y<=82.)
     r=d(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,x,z,i),m=m||r;
   if(y==68.||y==69.||y==70.||y==72.||y==73.||y==74.||y==76.||y==77.||y==78.||y==80.||y==81.||y==82.)
     {
       float t=8.,s=8.;
       if(y==68.||y==70.||y==72.||y==74.||y==76.||y==78.||y==80.||y==82.)
         t=0.;
       if(y==69.||y==70.||y==73.||y==74.||y==77.||y==78.||y==81.||y==82.)
         s=16.;
       r=d(v+vec3(t,6.,7.)/16.,v+vec3(s,9.,9.)/16.,x,z,i);
       m=m||r;
       r=d(v+vec3(t,12.,7.)/16.,v+vec3(s,15.,9.)/16.,x,z,i);
       m=m||r;
     }
   if(y>=71.&&y<=82.)
     {
       float t=8.,w=8.;
       if(y>=71.&&y<=74.||y>=79.&&y<=82.)
         w=16.;
       if(y>=75.&&y<=82.)
         t=0.;
       r=d(v+vec3(7.,6.,t)/16.,v+vec3(9.,9.,w)/16.,x,z,i);
       m=m||r;
       r=d(v+vec3(7.,12.,t)/16.,v+vec3(9.,15.,w)/16.,x,z,i);
       m=m||r;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(y>=83.&&y<=86.)
     {
       vec3 t=vec3(0),w=vec3(0);
       if(y==83.)
         t=vec3(0,0,0),w=vec3(16,16,3);
       if(y==84.)
         t=vec3(0,0,13),w=vec3(16,16,16);
       if(y==86.)
         t=vec3(0,0,0),w=vec3(3,16,16);
       if(y==85.)
         t=vec3(13,0,0),w=vec3(16,16,16);
       r=d(v+t/16.,v+w/16.,x,z,i);
       m=m||r;
     }
   if(y>=87.&&y<=102.)
     {
       vec3 t=vec3(0.),w=vec3(1.);
       if(y>=87.&&y<=94.)
         {
           float c=0.;
           if(y>=91.&&y<=94.)
             c=13.;
           t=vec3(0.,c,0.)/16.;
           w=vec3(16.,c+3.,16.)/16.;
         }
       if(y>=95.&&y<=98.)
         {
           float c=13.;
           if(y==97.||y==98.)
             c=0.;
           t=vec3(0.,0.,c)/16.;
           w=vec3(16.,16.,c+3.)/16.;
         }
       if(y>=99.&&y<=102.)
         {
           float s=13.;
           if(y==99.||y==100.)
             s=0.;
           t=vec3(s,0.,0.)/16.;
           w=vec3(s+3.,16.,16.)/16.;
         }
       r=d(v+t,v+w,x,z,i);
       m=m||r;
     }
   if(y>=103.&&y<=113.)
     {
       vec3 t=vec3(0.),w=vec3(1.);
       if(y>=103.&&y<=110.)
         {
           float c=float(y)-float(103.)+1.;
           w.y=c*2./16.;
         }
       if(y==111.)
         w.y=.0625;
       if(y==112.)
         t=vec3(1.,0.,1.)/16.,w=vec3(15.,1.,15.)/16.;
       if(y==113.)
         t=vec3(1.,0.,1.)/16.,w=vec3(15.,.5,15.)/16.;
       r=d(v+t,v+w,x,z,i);
       m=m||r;
     }
   #endif
   #endif
   return m;
 }
 vec3 D(vec2 v)
 {
   vec2 y=vec2(v.xy*vec2(viewWidth,viewHeight));
   y*=1./64.;
   const vec2 f[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   y=(floor(y*64.)+.5)/64.;
   vec3 i=texture2D(noisetex,y).xyz,x=vec3(sqrt(.2),sqrt(2.),1.61803);
   i=mod(i+float(frameCounter%64)*x,vec3(1.));
   return i;
 }
 vec2 D(vec2 v,float y,out float i)
 {
   vec2 x=1./vec2(viewWidth,viewHeight);
   vec4 f;
   f.x=texture2D(depthtex1,v+x*vec2(1.,1.)).x;
   f.y=texture2D(depthtex1,v+x*vec2(1.,-1.)).x;
   f.z=texture2D(depthtex1,v+x*vec2(-1.,1.)).x;
   f.w=texture2D(depthtex1,v+x*vec2(-1.,-1.)).x;
   vec2 t=vec2(0.,0.);
   if(f.x<y)
     t=vec2(1.,1.);
   if(f.y<y)
     t=vec2(1.,-1.);
   if(f.z<y)
     t=vec2(-1.,1.);
   if(f.w<y)
     t=vec2(-1.,-1.);
   i=min(min(min(f.x,f.y),f.z),f.w);
   return v+x*t;
 }
 vec3 D(vec3 v,vec2 y)
 {
   y=y*.99+.005;
   float t=6.28319*y.x,x=sqrt(y.y);
   vec3 m=normalize(cross(v,vec3(0.,1.,1.))),i=cross(v,m),r=m*cos(t)*x+i*sin(t)*x+v.xyz*sqrt(1.-y.y);
   return r;
 }
 vec3 e(vec3 v,vec3 y)
 {
   vec2 f=t(n(s(v)+y+1.+m()));
   vec3 x=c(f).jbwXZaPXmq;
   return x;
 }
 vec3 D()
 {
   vec2 y=t(v(texcoord.xy)+m()/d());
   vec3 x=c(y).jbwXZaPXmq;
   return x;
 }
 vec3 c()
 {
   int y=f();
   vec3 t=v(texcoord.xy),x=m(t),z=f(x-vec3(1.,1.,0.),y);
   vec2 w=d(z,y);
   float s=1.;
   #ifdef CAVE_GI_LEAK_FIX
   if(isEyeInWater<1)
     s*=saturate(eyeBrightnessSmooth.y/240.*20.);
   #endif
   float c=1000.,n=1.;
   {
     vec3 a=f(x,y);
     float h=1./float(y);
     vec4 g=texture2DLod(shadowcolor,d(a+vec3(0.,0.,0.)*h,y),0),o=texture2DLod(shadowcolor,d(a+vec3(0.,0.,-1.)*h,y),0),q=texture2DLod(shadowcolor,d(a+vec3(1.,0.,0.)*h,y),0),K=texture2DLod(shadowcolor,d(a+vec3(0.,0.,1.)*h,y),0),X=texture2DLod(shadowcolor,d(a+vec3(-1.,0.,0.)*h,y),0),R=texture2DLod(shadowcolor,d(a+vec3(0.,1.,0.)*h,y),0),k=texture2DLod(shadowcolor,d(a+vec3(0.,-1.,0.)*h,y),0);
     n=g.w;
     c=min(c,o.w);
     c=min(c,q.w);
     c=min(c,K.w);
     c=min(c,X.w);
     c=min(c,R.w);
     c=min(c,k.w);
   }
   if(c*255.>240.||n*255.<240.)
     return vec3(0.);
   vec3 a=vec3(0.);
   const float h=2.4,o=h;
   for(int l=0;l<GI_SECONDARY_SAMPLES;l++)
     {
       float g=sin(frameTimeCounter*1.1)+x.x*.11+x.y*.12+x.z*.13+l*.1;
       vec3 q=normalize(rand(vec2(g))*2.-1.);
       q.x+=q.x==q.y||q.x==q.z?.01:0.;
       q.y+=q.y==q.z?.01:0.;
       vec3 p=x+vec3(1.,1.,1.);
       Ray R=MakeRay(f(p,y)*y-vec3(1.,1.,1.),q);
       rXuEJcsNQI S=r(R);
       vec3 X=vec3(1.);
       float T=1000.;
       for(int K=0;K<1;K++)
         {
           vec4 G=vec4(0.);
           float U=0.;
           vec3 k=vec3(0.);
           float J=.2;
           for(int Z=0;Z<DIFFUSE_TRACE_LENGTH;Z++)
             {
               k=S.QbpObHBdUl/float(y);
               vec2 D=d(k,y);
               G=texture2DLod(shadowcolor,D,0);
               U=G.w*255.;
               float C=1.-step(.5,abs(U-241.));
               vec3 F=G.xyz*GI_LIGHT_TORCH_INTENSITY;
               a+=F*J*C*(Z==0?.5:1.);
               if(U<240.)
                 {
                   break;
                 }
               i(S);
               J=saturate(J*1.3);
             }
           T=distance(S.QbpObHBdUl.xyz,S.QbpObHBdUlOrigin.xyz);
           float Z=0.;
           vec3 F=-S.frnQIYJjVJ*S.fgCeZiNBHZ;
           float C=1.;
           if(abs(dot(S.QbpObHBdUl-S.QbpObHBdUlOrigin,F))<1.1)
             C=0.;
           if(U<1.f||U>254.f)
             {
               vec3 D=R.direction;
               if(isEyeInWater>0)
                 D=refract(D,vec3(0.,-1.,0.),1.3333);
               vec3 P=SkyShading(D,worldSunVector,rainStrength);
               P*=saturate(D.y*10.+1.);
               P=DoNightEyeAtNight(P*12.,timeMidnight)*.083333;
               if(isEyeInWater>0)
                 ;
               if(length(D)<.1)
                 Z=300.;
               vec3 Y=P*s*X,b=Y;
               #ifdef CLOUDS_IN_GI
               CloudPlane(b,-R.direction,worldLightVector,worldSunVector,colorSunlight,colorSkyUp,Y,timeMidnight,false);
               Y=mix(Y,b,vec3(s));
               #endif
               Y=TintUnderwaterDepth(Y);
               a+=Y*.1;
             }
           if(abs(U-31.)<.1)
             a+=.09*G.xyz*GI_LIGHT_BLOCK_INTENSITY;
           if(U>=32.&&U<=35.)
             {
               float D=0.;
               if(abs(U-32.)<.1)
                 D=max(-F.z,0.);
               if(abs(U-33.)<.1)
                 D=max(F.x,0.);
               if(abs(U-34.)<.1)
                 D=max(F.z,0.);
               if(abs(U-35.)<.1)
                 D=max(-F.x,0.);
               a+=.02*X*D*vec3(2.,.35,.025)*GI_LIGHT_BLOCK_INTENSITY;
             }
           if(U<240.)
             {
               vec3 D=saturate(G.xyz);
               X*=D;
               vec3 Y=-(S.frnQIYJjVJ*S.fgCeZiNBHZ),P=f(k,worldLightVector,Y,q,y),b=DoNightEyeAtNight(P*h*colorSunlight*X*C*s*12.,timeMidnight)/12.;
               a+=b;
               a+=e(k,Y)*o*.95*mix(vec3(1.),X,vec3(C));
               Z=T;
             }
           {
             vec2 D=IntersectSphere(x,R.direction,vec3(0.,1.5,0.),.75);
             if(T>D.y&&D.y>-.5)
               ;
           }
           if(isEyeInWater>0)
             UnderwaterFog(a,Z,q,colorSkyUp,colorSunlight);
         }
     }
   a/=float(GI_SECONDARY_SAMPLES);
   return saturate(a/o);
 }
 vec4 w(float v)
 {
   float y=v*v,m=y*v;
   vec4 f;
   f.x=-m+3*y-3*v+1;
   f.y=3*m-6*y+4;
   f.z=-3*m+3*y+3*v+1;
   f.w=m;
   return f/6.f;
 }
 bool h(vec3 v,vec3 y)
 {
   vec3 x=normalize(cross(dFdx(v),dFdy(v))),t=normalize(y-v),i=normalize(t);
   float f=.02+length(v)*.04;
   return distance(v,y)<f;
 }
 vec3 i(sampler2D v,vec2 y)
 {
   vec2 f=y*ScreenSize,x=floor(f-.5)+.5,m=f-x,z=m*m,t=m*z;
   float i=.5;
   vec2 s=-i*t+2.*i*z-i*m,c=(2.-i)*t-(3.-i)*z+1.,r=-(2.-i)*t+(3.-2.*i)*z+i*m,w=i*t-i*z,n=c+r,a=ScreenTexel*(x+r/n);
   vec3 h=texture2DLod(v,vec2(a.x,a.y),0).xyz;
   vec2 d=ScreenTexel*(x-1.),q=ScreenTexel*(x+2.);
   vec4 D=vec4(texture2DLod(v,vec2(a.x,d.y),0).xyz,1.)*(n.x*s.y)+vec4(texture2DLod(v,vec2(d.x,a.y),0).xyz,1.)*(s.x*n.y)+vec4(h,1.)*(n.x*n.y)+vec4(texture2DLod(v,vec2(q.x,a.y),0).xyz,1.)*(w.x*n.y)+vec4(texture2DLod(v,vec2(a.x,q.y),0).xyz,1.)*(n.x*w.y);
   return max(vec3(0.),D.xyz*(1./D.w));
 }
 vec4 c(vec2 v,float x,out vec3 y)
 {
   vec4 f=gbufferProjectionInverse*vec4(UndownscaleTexcoord(texcoord.xy)*2.-1.,x*2.-1.,1.);
   f/=f.w;
   vec3 t=(gbufferModelViewInverse*vec4(f.xyz,1.)).xyz;
   vec2 i=fract(v*ScreenSize)-.5,m[4]=vec2[4](vec2(0.,0.),vec2(1.,0.),vec2(0.,1.),vec2(1.,1.));
   vec4 r[4];
   for(int c=0;c<4;c++)
     {
       vec2 z=m[c]*ScreenTexel*sign(i),w=LockRenderPixelCoord(v+z);
       float s=texture2DLod(colortex4,w,0).w;
       vec3 a=texture2DLod(colortex4,w,0).xyz;
       vec4 n=gbufferPreviousProjectionInverse*vec4(UndownscaleTexcoord(w)*2.-1.,s*2.-1.,1.);
       n/=n.w;
       vec3 d=(gbufferPreviousModelViewInverse*vec4(n.xyz,1.)).xyz;
       d+=previousCameraPosition;
       d-=cameraPosition;
       float D=length(d.xyz-t.xyz)/(length(t.xyz)+.001),h=D>.1?0.:1.;
       r[c]=vec4(a*h,h);
     }
   vec2 s=abs(i);
   vec4 z=mix(r[0],r[1],vec4(s.x)),w=mix(r[2],r[3],vec4(s.x)),c=mix(z,w,vec4(s.y));
   c.xyz/=c.w+.0001;
   return vec4(c.xyz,c.w);
 }
 vec2 D(float v,vec2 f,out float y,out vec3 i,out vec4 t)
 {
   float x;
   vec2 z=D(texcoord.xy,v,x);
   y=texture2D(depthtex1,z).x;
   vec4 m=vec4(UndownscaleTexcoord(texcoord.xy)*2.-1.,y*2.-1.,1.),r=gbufferProjectionInverse*m;
   r.xyz/=r.w;
   vec4 c=gbufferModelViewInverse*vec4(r.xyz,1.);
   t=c;
   t.xyz+=cameraPosition-previousCameraPosition;
   vec4 s=gbufferPreviousModelView*vec4(t.xyz,1.),w=gbufferPreviousProjection*vec4(s.xyz,1.);
   w.xyz/=w.w;
   i=(m.xyz-w.xyz)*.5;
   vec2 n=f.xy-i.xy*.5;
   if(y<.7)
     n=texcoord.xy;
   return n;
 }
 void main()
 {
   vec4 y=vec4(0.);
   awIafiSlNY v;
   v.mwtAZpOIMX=.1;
   v.yDFXZDbcEk=.1;
   v.cvVAxIXMRt=.1;
   v.jbwXZaPXmq=vec3(0.);
   if(texcoord.x<HalfScreen.x&&texcoord.y<HalfScreen.y)
     {
       GBufferData t=GetGBufferData(texcoord.xy);
       MaterialMask f=CalculateMasks(t.materialID,texcoord.xy);
       vec4 i=GetViewPosition(texcoord.xy,t.depth),x=gbufferModelViewInverse*vec4(i.xyz,1.),m=gbufferModelViewInverse*vec4(i.xyz,0.);
       vec3 z=normalize(i.xyz),w=normalize(m.xyz),r=normalize((gbufferModelViewInverse*vec4(t.normal,0.)).xyz),s=normalize((gbufferModelViewInverse*vec4(t.geoNormal,0.)).xyz);
       float n=length(i.xyz),q=dot(t.mcLightmap.xy,vec2(.5));
       if(f.grass>.5)
         r=vec3(0.,1.,0.),s=vec3(0.,1.,0.);
       vec4 d=vec4(texcoord.xy,0.,0.);
       float h;
       vec3 a;
       vec4 o;
       vec2 g=D(t.depth,d.xy,h,a,o),U=g.xy;
       U-=(vec2(mod(frameCounter/2,2.f),mod(frameCounter,2.f))-.5)/vec2(viewWidth,viewHeight)*.125;
       vec3 R;
       vec4 S=c(U.xy,t.depth,R);
       awIafiSlNY F=c(g.xy);
       float e=1./(saturate(-dot(t.geoNormal,z))*100.+1.);
       vec4 Y=vec4(g.xy,0.,0.);
       TemporalJitterProjPosPrevInv(Y);
       vec4 G=gbufferPreviousProjectionInverse*vec4(UndownscaleTexcoord(g.xy)*2.-1.,texture2DLod(colortex4,Y.xy,0).w*2.-1.,1.);
       G/=G.w;
       vec3 Z=(gbufferPreviousModelViewInverse*vec4(G.xyz,1.)).xyz;
       F.mwtAZpOIMX+=1.;
       F.mwtAZpOIMX=min(F.mwtAZpOIMX,24.);
       vec2 K=1./vec2(viewWidth,viewHeight),X=1.-K;
       float k=0.,J=1.-1./(F.mwtAZpOIMX+1.);
       if(S.w<.01||(g.x<K.x||g.x>X.x||g.y<K.y||g.y>X.y)||abs(e-F.yDFXZDbcEk)>.02)
         J=0.,k=.99,F.mwtAZpOIMX=0.;
       float T;
       vec3 l=texture2DLod(colortex7,texcoord.xy+vec2(0.,HalfScreen.y),0).xyz;
       l=mix(l,S.xyz,vec3(J));
       k=max(k,mix(k,.9,saturate(-a.z*520.)));
       F.yDFXZDbcEk=e;
       F.cvVAxIXMRt=mix(k,F.cvVAxIXMRt,mix(J*.25,0.,k));
       l=max(vec3(0.),l);
       y=vec4(l,t.depth);
       v=F;
     }
   v.jbwXZaPXmq=mix(D(),c(),vec3(.025));
   gl_FragData[0]=vec4(y);
   {
     awIafiSlNY f=c(texcoord.xy);
     v.KZGLOOTLva=f.KZGLOOTLva;
     gl_FragData[1]=max(vec4(0.),p(v));
   }
 };




/* DRAWBUFFERS:45 */
