#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/





in vec4 texcoord;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorTorchlight;
in vec3 colorSkyUp;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

in vec3 worldLightVector;
in vec3 worldSunVector;

in float timeMidnight;

#include "lib/Uniforms.inc"
#include "lib/Common.inc"


vec2 Texcoord;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////








vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{
	
	
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	vec4 depthSamples;
	depthSamples.x = texture2D(depthtex1, coord + texel * vec2(1.0, 1.0)).x;
	depthSamples.y = texture2D(depthtex1, coord + texel * vec2(1.0, -1.0)).x;
	depthSamples.z = texture2D(depthtex1, coord + texel * vec2(-1.0, 1.0)).x;
	depthSamples.w = texture2D(depthtex1, coord + texel * vec2(-1.0, -1.0)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(1.0, 1.0);
	if (depthSamples.y < depth)
		targetFragment = vec2(1.0, -1.0);
	if (depthSamples.z < depth)
		targetFragment = vec2(-1.0, 1.0);
	if (depthSamples.w < depth)
		targetFragment = vec2(-1.0, -1.0);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}






#include "lib/Materials.inc"
#include "lib/GBufferData.inc"




 int f(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-0;
 }
 int t(int v)
 {
   return v-FloorToInt(mod(float(v),2.))-1;
 }
 int f()
 {
   ivec2 v=ivec2(viewWidth,viewHeight);
   int y=v.x*v.y;
   return f(FloorToInt(floor(pow(float(y),.333333))));
 }
 int t()
 {
   ivec2 v=ivec2(2048,2048);
   int y=v.x*v.y;
   return t(FloorToInt(floor(pow(float(y),.333333))));
 }
 vec3 v(vec2 v)
 {
   ivec2 s=ivec2(viewWidth,viewHeight);
   int x=s.x*s.y,y=f();
   ivec2 d=ivec2(v.x*s.x,v.y*s.y);
   float z=float(d.y/y),i=float(int(d.x+mod(s.x*z,y))/y);
   i+=floor(s.x*z/y);
   vec3 m=vec3(0.,0.,i);
   m.x=mod(d.x+mod(s.x*z,y),y);
   m.y=mod(d.y,y);
   m.xyz=floor(m.xyz);
   m/=y;
   m.xyz=m.xzy;
   return m;
 }
 vec2 s(vec3 v)
 {
   ivec2 m=ivec2(viewWidth,viewHeight);
   int z=f();
   vec3 i=v.xzy*z;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 r;
   r.x=mod(i.x+x*z,m.x);
   float c=i.x+x*z;
   r.y=i.y+floor(c/m.x)*z;
   r+=.5;
   r/=m;
   return r;
 }
 vec3 d(vec2 v)
 {
   vec2 i=v;
   i.xy/=.5;
   ivec2 s=ivec2(2048,2048);
   int x=s.x*s.y,y=t();
   ivec2 d=ivec2(i.x*s.x,i.y*s.y);
   float z=float(d.y/y),f=float(int(d.x+mod(s.x*z,y))/y);
   f+=floor(s.x*z/y);
   vec3 m=vec3(0.,0.,f);
   m.x=mod(d.x+mod(s.x*z,y),y);
   m.y=mod(d.y,y);
   m.xyz=floor(m.xyz);
   m/=y;
   m.xyz=m.xzy;
   return m;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   vec2 m=vec2(2048,2048);
   vec3 i=v.xzy*y;
   i=floor(i+1e-05);
   float x=i.z;
   vec2 f;
   f.x=mod(i.x+x*y,m.x);
   float c=i.x+x*y;
   f.y=i.y+floor(c/m.x)*y;
   f+=.5;
   f/=m;
   f.xy*=.5;
   return f;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 s(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 m(vec3 v)
 {
   int m=t();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 e(vec3 v)
 {
   int y=f();
   v*=1./y;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 x(vec3 v)
 {
   int m=f();
   v=v-vec3(.5);
   v*=m;
   return v;
 }
 vec3 d()
 {
   vec3 v=cameraPosition.xyz+.5,i=previousCameraPosition.xyz+.5,y=floor(v-.0001),z=floor(i-.0001);
   return y-z;
 }
 vec3 n(vec3 v)
 {
   vec4 i=vec4(v,1.);
   i=shadowModelView*i;
   i=shadowProjection*i;
   i/=i.w;
   float x=sqrt(i.x*i.x+i.y*i.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   i.xy*=.95f/y;
   i.z=mix(i.z,.5,.8);
   i=i*.5f+.5f;
   i.xy*=.5;
   i.xy+=.5;
   return i.xyz;
 }
 vec3 d(vec3 v,vec3 i,vec2 d,vec2 y,vec4 f,vec4 s,inout float x,out vec2 m)
 {
   bool r=fract(v.x*2.)>.01&&fract(v.x*2.)<.99||fract(v.y*2.)>.01&&fract(v.y*2.)<.99||fract(v.z*2.)>.01&&fract(v.z*2.)<.99;
   r=!r;
   if(s.x==8||s.x==9||s.x==79||s.x<1.||!r||s.x==20.||s.x==171.||min(abs(i.x),abs(i.z))>.2)
     x=1.;
   if(s.x==50.||s.x==52.||s.x==76.)
     {
       x=0.;
       if(i.y<.5)
         x=1.;
     }
   if(s.x==51||s.x==53)
     x=0.;
   if(s.x>255)
     x=0.;
   vec3 z,c;
   if(i.x>.5)
     z=vec3(0.,0.,-1.),c=vec3(0.,-1.,0.);
   else
      if(i.x<-.5)
       z=vec3(0.,0.,1.),c=vec3(0.,-1.,0.);
     else
        if(i.y>.5)
         z=vec3(1.,0.,0.),c=vec3(0.,0.,1.);
       else
          if(i.y<-.5)
           z=vec3(1.,0.,0.),c=vec3(0.,0.,-1.);
         else
            if(i.z>.5)
             z=vec3(1.,0.,0.),c=vec3(0.,-1.,0.);
           else
              if(i.z<-.5)
               z=vec3(-1.,0.,0.),c=vec3(0.,-1.,0.);
   m=clamp((d.xy-y.xy)*100000.,vec2(0.),vec2(1.));
   float h=.15,T=.15;
   if(s.x==10.||s.x==11.)
     {
       if(abs(i.y)<.01&&r||i.y>.99)
         h=.1,T=.1,x=0.;
       else
          x=1.;
     }
   if(s.x==51||s.x==53)
     h=.5,T=.1;
   if(s.x==76)
     h=.2,T=.2;
   if(s.x-255.+39.>=103.&&s.x-255.+39.<=113.)
     T=.025,h=.025;
   z=normalize(f.xyz);
   c=normalize(cross(z,i.xyz)*sign(f.w));
   vec3 n=v.xyz+mix(z*h,-z*h,vec3(m.x));
   n.xyz+=mix(c*h,-c*h,vec3(m.y));
   n.xyz-=i.xyz*T;
   return n;
 }struct rXuEJcsNQI{vec3 QbpObHBdUl;vec3 QbpObHBdUlOrigin;vec3 ZRrfSsHfvT;vec3 fgCeZiNBHZ;vec3 ZKdJsVHIyK;vec3 frnQIYJjVJ;};
 rXuEJcsNQI r(Ray v)
 {
   rXuEJcsNQI i;
   i.QbpObHBdUl=floor(v.origin);
   i.QbpObHBdUlOrigin=i.QbpObHBdUl;
   i.ZRrfSsHfvT=abs(vec3(length(v.direction))/(v.direction+1e-07));
   i.fgCeZiNBHZ=sign(v.direction);
   i.ZKdJsVHIyK=(sign(v.direction)*(i.QbpObHBdUl-v.origin)+sign(v.direction)*.5+.5)*i.ZRrfSsHfvT;
   i.frnQIYJjVJ=vec3(0.);
   return i;
 }
 void i(inout rXuEJcsNQI v)
 {
   v.frnQIYJjVJ=step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.yzx)*step(v.ZKdJsVHIyK.xyz,v.ZKdJsVHIyK.zxy),v.ZKdJsVHIyK+=v.frnQIYJjVJ*v.ZRrfSsHfvT,v.QbpObHBdUl+=v.frnQIYJjVJ*v.fgCeZiNBHZ;
 }
 void d(in Ray v,in vec3 i[2],out float f,out float y)
 {
   float z,x,r,c;
   f=(i[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   y=(i[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   z=(i[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   x=(i[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   r=(i[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   c=(i[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   f=max(max(f,z),r);
   y=min(min(y,x),c);
 }
 vec3 d(const vec3 v,const vec3 y,vec3 f)
 {
   const float x=1e-05;
   vec3 z=(y+v)*.5,i=(y-v)*.5,s=f-z,c=vec3(0.);
   c+=vec3(sign(s.x),0.,0.)*step(abs(abs(s.x)-i.x),x);
   c+=vec3(0.,sign(s.y),0.)*step(abs(abs(s.y)-i.y),x);
   c+=vec3(0.,0.,sign(s.z))*step(abs(abs(s.z)-i.z),x);
   return normalize(c);
 }
 bool e(const vec3 v,const vec3 y,Ray i,out vec2 f)
 {
   vec3 x=i.inv_direction*(v-i.origin),z=i.inv_direction*(y-i.origin),s=min(z,x),c=max(z,x);
   vec2 d=max(s.xx,s.yz);
   float m=max(d.x,d.y);
   d=min(c.xx,c.yz);
   float n=min(d.x,d.y);
   f.x=m;
   f.y=n;
   return n>max(m,0.);
 }
 bool d(const vec3 v,const vec3 i,Ray s,inout float y,inout vec3 x)
 {
   vec3 z=s.inv_direction*(v-1e-05-s.origin),c=s.inv_direction*(i+1e-05-s.origin),f=min(c,z),m=max(c,z);
   vec2 r=max(f.xx,f.yz);
   float t=max(r.x,r.y);
   r=min(m.xx,m.yz);
   float n=min(r.x,r.y);
   bool T=n>max(t,0.)&&max(t,0.)<y;
   if(T)
     x=d(v-1e-05,i+1e-05,s.origin+s.direction*t),y=t;
   return T;
 }
 vec3 e(vec3 v,vec3 i,vec3 y,vec3 z,int x)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=n(v);
   float f=.5;
   vec3 c=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*f),2).x;
   c*=saturate(dot(i,y));
   {
     vec4 d=texture2DLod(shadowcolor1,s.xy-vec2(0.,.5),4);
     float m=abs(d.x*256.-(v.y+cameraPosition.y)),h=GetCausticsComposite(v,i,m),t=shadow2DLod(shadowtex0,vec3(s.xy-vec2(0.,.5),s.z+1e-06),4).x;
     c=mix(c,c*h,1.-t);
   }
   c=TintUnderwaterDepth(c);
   return c*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 i,vec3 y,vec3 z,int x)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 f=m(v);
   f+=1.;
   f-=Fract01(cameraPosition+.5);
   vec3 s=n(f+y*.99);
   float c=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*c),3).x;
   r*=saturate(dot(i,y));
   r=TintUnderwaterDepth(r);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float t=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*c),3).x;
   vec3 h=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   h*=h;
   r=mix(r,r*h,vec3(1.-t));
   #endif
   return r*(1.-rainStrength);
 }
 vec3 i(vec3 v,vec3 i,vec3 y,vec3 z,int x)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=n(v);
   float f=.5;
   vec3 c=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*f),2).x;
   c*=saturate(dot(i,y));
   c=TintUnderwaterDepth(c);
   #ifdef GI_SUNLIGHT_STAINED_GLASS_TINT
   float t=shadow2DLod(shadowtex0,vec3(s.xy-vec2(.5,0.),s.z-.0006*f),3).x;
   vec3 m=texture2DLod(shadowcolor,vec2(s.xy-vec2(.5,0.)),3).xyz;
   m*=m;
   c=mix(c,c*m,vec3(1.-t));
   #endif
   return c*(1.-rainStrength);
 }struct awIafiSlNY{float mwtAZpOIMX;float KZGLOOTLva;float yDFXZDbcEk;float cvVAxIXMRt;vec3 jbwXZaPXmq;};
 vec4 h(awIafiSlNY v)
 {
   vec4 i;
   v.jbwXZaPXmq=max(vec3(0.),v.jbwXZaPXmq);
   i.x=v.mwtAZpOIMX;
   v.jbwXZaPXmq=pow(v.jbwXZaPXmq,vec3(.125));
   i.y=PackTwo16BitTo32Bit(v.jbwXZaPXmq.x,v.yDFXZDbcEk);
   i.z=PackTwo16BitTo32Bit(v.jbwXZaPXmq.y,v.cvVAxIXMRt);
   i.w=PackTwo16BitTo32Bit(v.jbwXZaPXmq.z,v.KZGLOOTLva/255.);
   return i;
 }
 awIafiSlNY w(vec4 v)
 {
   awIafiSlNY i;
   vec2 s=UnpackTwo16BitFrom32Bit(v.y),m=UnpackTwo16BitFrom32Bit(v.z),c=UnpackTwo16BitFrom32Bit(v.w);
   i.mwtAZpOIMX=v.x;
   i.yDFXZDbcEk=s.y;
   i.cvVAxIXMRt=m.y;
   i.KZGLOOTLva=c.y*255.;
   i.jbwXZaPXmq=pow(vec3(s.x,m.x,c.x),vec3(8.));
   return i;
 }
 awIafiSlNY p(vec2 v)
 {
   vec2 z=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*z;
   return w(texture2DLod(colortex5,v,0));
 }
 float e(float v,float y)
 {
   float z=1.;
   #ifdef FULL_RT_REFLECTIONS
   z=clamp(pow(v,.125)+y,0.,1.);
   #else
   z=clamp(v*10.-7.,0.,1.);
   #endif
   return z;
 }
 bool d(vec3 v,float y,Ray i,bool z,inout float f,inout vec3 x)
 {
   bool m=false,c=false;
   #if RAYTRACE_GEOMETRY_QUALITY==0
   if(z)
     return false;
   if(y>=67.)
     return false;
   c=d(v,v+vec3(1.,1.,1.),i,f,x);
   m=c;
   #else
   if(y<40.)
     return c=d(v,v+vec3(1.,1.,1.),i,f,x),c;
   if(y==40.||y==41.||y>=43.&&y<=54.)
     {
       float s=.5;
       if(y==41.)
         s=.9375;
       c=d(v+vec3(0.,0.,0.),v+vec3(1.,s,1.),i,f,x);
       m=m||c;
     }
   if(y==42.||y>=55.&&y<=66.)
     c=d(v+vec3(0.,.5,0.),v+vec3(1.,1.,1.),i,f,x),m=m||c;
   if(y==43.||y==46.||y==47.||y==52.||y==53.||y==54.||y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
     {
       float s=.5;
       if(y==55.||y==58.||y==59.||y==64.||y==65.||y==66.)
         s=0.;
       c=d(v+vec3(0.,s,0.),v+vec3(.5,.5+s,.5),i,f,x);
       m=m||c;
     }
   if(y==43.||y==45.||y==48.||y==51.||y==53.||y==54.||y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
     {
       float s=.5;
       if(y==55.||y==57.||y==60.||y==63.||y==65.||y==66.)
         s=0.;
       c=d(v+vec3(.5,s,0.),v+vec3(1.,.5+s,.5),i,f,x);
       m=m||c;
     }
   if(y==44.||y==45.||y==49.||y==51.||y==52.||y==54.||y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
     {
       float s=.5;
       if(y==56.||y==57.||y==61.||y==63.||y==64.||y==66.)
         s=0.;
       c=d(v+vec3(.5,s,.5),v+vec3(1.,.5+s,1.),i,f,x);
       m=m||c;
     }
   if(y==44.||y==46.||y==50.||y==51.||y==52.||y==53.||y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
     {
       float s=.5;
       if(y==56.||y==58.||y==62.||y==63.||y==64.||y==65.)
         s=0.;
       c=d(v+vec3(0.,s,.5),v+vec3(.5,.5+s,1.),i,f,x);
       m=m||c;
     }
   if(y>=67.&&y<=82.)
     c=d(v+vec3(6.,0.,6.)/16.,v+vec3(10.,16.,10.)/16.,i,f,x),m=m||c;
   if(y==68.||y==69.||y==70.||y==72.||y==73.||y==74.||y==76.||y==77.||y==78.||y==80.||y==81.||y==82.)
     {
       float s=8.,r=8.;
       if(y==68.||y==70.||y==72.||y==74.||y==76.||y==78.||y==80.||y==82.)
         s=0.;
       if(y==69.||y==70.||y==73.||y==74.||y==77.||y==78.||y==81.||y==82.)
         r=16.;
       c=d(v+vec3(s,6.,7.)/16.,v+vec3(r,9.,9.)/16.,i,f,x);
       m=m||c;
       c=d(v+vec3(s,12.,7.)/16.,v+vec3(r,15.,9.)/16.,i,f,x);
       m=m||c;
     }
   if(y>=71.&&y<=82.)
     {
       float s=8.,t=8.;
       if(y>=71.&&y<=74.||y>=79.&&y<=82.)
         t=16.;
       if(y>=75.&&y<=82.)
         s=0.;
       c=d(v+vec3(7.,6.,s)/16.,v+vec3(9.,9.,t)/16.,i,f,x);
       m=m||c;
       c=d(v+vec3(7.,12.,s)/16.,v+vec3(9.,15.,t)/16.,i,f,x);
       m=m||c;
     }
   #if RAYTRACE_GEOMETRY_QUALITY==2
   if(y>=83.&&y<=86.)
     {
       vec3 s=vec3(0),T=vec3(0);
       if(y==83.)
         s=vec3(0,0,0),T=vec3(16,16,3);
       if(y==84.)
         s=vec3(0,0,13),T=vec3(16,16,16);
       if(y==86.)
         s=vec3(0,0,0),T=vec3(3,16,16);
       if(y==85.)
         s=vec3(13,0,0),T=vec3(16,16,16);
       c=d(v+s/16.,v+T/16.,i,f,x);
       m=m||c;
     }
   if(y>=87.&&y<=102.)
     {
       vec3 r=vec3(0.),s=vec3(1.);
       if(y>=87.&&y<=94.)
         {
           float h=0.;
           if(y>=91.&&y<=94.)
             h=13.;
           r=vec3(0.,h,0.)/16.;
           s=vec3(16.,h+3.,16.)/16.;
         }
       if(y>=95.&&y<=98.)
         {
           float t=13.;
           if(y==97.||y==98.)
             t=0.;
           r=vec3(0.,0.,t)/16.;
           s=vec3(16.,16.,t+3.)/16.;
         }
       if(y>=99.&&y<=102.)
         {
           float h=13.;
           if(y==99.||y==100.)
             h=0.;
           r=vec3(h,0.,0.)/16.;
           s=vec3(h+3.,16.,16.)/16.;
         }
       c=d(v+r,v+s,i,f,x);
       m=m||c;
     }
   if(y>=103.&&y<=113.)
     {
       vec3 s=vec3(0.),r=vec3(1.);
       if(y>=103.&&y<=110.)
         {
           float n=float(y)-float(103.)+1.;
           r.y=n*2./16.;
         }
       if(y==111.)
         r.y=.0625;
       if(y==112.)
         s=vec3(1.,0.,1.)/16.,r=vec3(15.,1.,15.)/16.;
       if(y==113.)
         s=vec3(1.,0.,1.)/16.,r=vec3(15.,.5,15.)/16.;
       c=d(v+s,v+r,i,f,x);
       m=m||c;
     }
   #endif
   #endif
   return m;
 }
 vec3 g(vec2 v)
 {
   vec2 y=vec2(v.xy*vec2(viewWidth,viewHeight));
   y*=1./64.;
   const vec2 i[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   y=(floor(y*64.)+.5)/64.;
   vec3 c=texture2D(noisetex,y).xyz,s=vec3(sqrt(.2),sqrt(2.),1.61803);
   c=mod(c+float(frameCounter%64)*s,vec3(1.));
   return c;
 }
 vec2 H(inout float v)
 {
   return fract(sin(vec2(v+=.1,v+=.1))*vec2(43758.5,22578.1));
 }
 vec3 c(vec2 v)
 {
   vec2 y=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 m[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   y+=m[int(mod(float(frameCounter),8.))]*.5;
   y=(floor(y*64.)+.5)/64.;
   vec3 c=texture2D(noisetex,y).xyz;
   return c;
 }
 vec3 H(vec3 v,inout float y,int x)
 {
   vec2 i=c(Texcoord.xy+vec2(y+=.1,y+=.1)).xy;
   i=fract(i+H(y)*.1);
   float s=6.28319*i.x,z=sqrt(i.y);
   vec3 m=normalize(cross(v,vec3(0.,1.,1.))),f=cross(v,m),r=m*cos(s)*z+f*sin(s)*z+v.xyz*sqrt(1.-i.y);
   return r;
 }
 vec3 H(vec3 v,vec3 y)
 {
   vec2 x=s(e(m(v)+y+1.));
   vec3 c=p(x).jbwXZaPXmq;
   return c;
 }
 vec3 H()
 {
   vec2 y=s(v(Texcoord.xy)+d()/f());
   vec3 c=p(y).jbwXZaPXmq;
   return c;
 }
 vec3 H(float v,float m,float y,vec3 i)
 {
   vec3 s;
   s.x=y*cos(v);
   s.y=y*sin(v);
   s.z=m;
   vec3 c=abs(i.y)<.999?vec3(0,0,1):vec3(1,0,0),x=normalize(cross(i,vec3(0.,1.,1.))),z=cross(x,i);
   return x*s.x+z*s.y+i*s.z;
 }
 vec3 c(vec2 v,float y,vec3 x)
 {
   float s=2*3.14159*v.x,z=sqrt((1-v.y)/(1+(y*y-1)*v.y)),i=sqrt(1-z*z);
   return H(s,z,i,x);
 }
 float G(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 G(in vec2 v,in float y,in vec3 x)
 {
   float s=G(y),i=2*3.14159*v.x,z=pow(v.y,1.f/(s+1.f)),c=sqrt(1-z*z);
   return H(i,z,c,x);
 }
 float G(float v,float y)
 {
   return 1./(v*(1.-y)+y);
 }
 void c(inout vec3 v,in vec3 y)
 {
   vec3 x=normalize(y.xyz),i=v;
   float s=dot(i,x);
   i=normalize(v-x*saturate(s)*.5);
   v=i;
 }
 vec4 R(in vec2 v)
 {
   float y=GetDepth(v);
   vec4 i=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*y-1.f,1.f);
   i/=i.w;
   return i;
 }
 vec4 R(in vec2 v,in float y)
 {
   vec4 i=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*y-1.f,1.f);
   i/=i.w;
   return i;
 }
 void G(inout vec3 v,in vec3 y,in vec3 i,vec3 z,float x)
 {
   float c=length(y);
   c*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   c*=rainStrength;
   float f=pow(exp(-c*1e-05),4.);
   f=max(f,.5);
   vec3 s=vec3(dot(colorSkyUp,vec3(1.)))*.05;
   v=mix(s,v,vec3(f));
 }
 vec4 G(float v,float y,vec3 s,vec3 m,vec3 x,vec3 z,vec3 n,float h,float a,float p,float T,bool w)
 {
   float l=1.;
   #ifdef SUNLIGHT_LEAK_FIX
   if(isEyeInWater<1)
     l=saturate(a*100.);
   #endif
   v=max(v-.05,0.);
   y=0.;
   float R=v*v,o=fract(frameCounter*.0123456);
   vec3 Z=c(Texcoord.xy).xyz*.99+.005,U=c(Texcoord.xy+.1).xyz,g=reflect(n,c(c(Texcoord.xy).xy*vec2(1.,.8),R,x)),q=normalize((gbufferModelView*vec4(g.xyz,0.)).xyz);
   if(dot(g,x)<0.)
     g=reflect(g,x);
   #ifdef REFLECTION_SCREEN_SPACE_TRACING
   bool b=false;
   {
     const int k=16;
     vec2 F=Texcoord.xy;
     vec3 D=m.xyz;
     float S=0.;
     vec3 K=m.xyz;
     float P=.1/saturate(dot(-n,x)+.001),J=P*2.,X=1.,Y=0.;
     for(int N=0;N<k;N++)
       {
         float Q=float(N),E=(Q+.5)/float(k);
         vec3 C=q.xyz*P*(.1+length(K)*.1)*X;
         float j=J*(length(K)*.1);
         K+=C;
         vec2 M=ProjectBack(K).xy;
         vec3 u=GetViewPositionNoJitter(M.xy,GetDepth(DownscaleTexcoord(M.xy))).xyz;
         float I=length(K)-length(u)-.02;
         if(K.z>0.)
           {
             break;
           }
         if(I>0.&&I<j&&M.x>0.&&M.x<1.&&M.y>0.&&M.y<1.)
           {
             K-=C;
             X*=.5;
             Y+=1.;
             if(Y>2.)
               {
                 b=true;
                 F=M.xy;
                 D=u.xyz;
                 S=distance(K,m.xyz)*.4;
                 break;
               }
           }
       }
     vec3 N=(gbufferModelViewInverse*vec4(D,0.)).xyz;
     if(length(N)>far)
       b=false;
     if(b)
       {
         F.xy=floor(F.xy*vec2(viewWidth,viewHeight)+.5)/vec2(viewWidth,viewHeight);
         TemporalJitterProjPos01(F);
         vec2 M=F.xy*.5;
         M=clamp(M,vec2(0.)+ScreenTexel,HalfScreen)+HalfScreen;
         vec3 C=pow(texture2DLod(colortex1,M,0).xyz,vec3(2.2)),E=C*100.;
         LandAtmosphericScattering(E,D-m,q,g,worldSunVector,1.);
         G(E,D,normalize(m.xyz),normalize(s.xyz),1.);
         if(isEyeInWater>0)
           E*=1.2,UnderwaterFog(E,length(D),n,colorSkyUp,colorSunlight),E/=1.2;
         return vec4(E,saturate(S/4.));
       }
   }
   #endif
   const float C=2.4,E=C;
   int K=t(),D=f();
   vec3 M=s+x*(.01+h*.1)-n*(T*.2/(saturate(dot(z,-n))+1e-06)+.005)*(w?0.:1.);
   M+=Fract01(cameraPosition.xyz+.5);
   Ray F=MakeRay(f(M,K)*K-vec3(1.),g);
   vec3 k=vec3(1.),N=vec3(0.);
   float S=0.;
   rXuEJcsNQI P=r(F);
   float J=far;
   vec3 u=vec3(1.);
   for(int Q=0;Q<1;Q++)
     {
       vec4 Y=vec4(0.);
       vec3 I=vec3(0.);
       float X=.5;
       for(int j=0;j<REFLECTION_TRACE_LENGTH;j++)
         {
           I=P.QbpObHBdUl/float(K);
           vec2 L=d(I,K);
           Y=texture2DLod(shadowcolor,L,0);
           S=Y.w*255.;
           float O=1.-step(.5,abs(S-241.));
           vec3 B=Y.xyz;
           float V=dot(P.QbpObHBdUl+.5-F.origin,P.QbpObHBdUl+.5-F.origin),A=saturate(pow(saturate(dot(F.direction,normalize(P.QbpObHBdUl+.5-F.origin))),56.*V)*5.-1.)*5.;
           N+=B*O*X*.5*A;
           if(S<240.)
             {
               if(d(P.QbpObHBdUl,S,F,j==0,J,u))
                 {
                   break;
                 }
             }
           i(P);
           X=1.;
         }
       if(Y.w*255.<1.f||Y.w*255.>254.f)
         {
           vec3 j=SkyShading(F.direction,worldSunVector,rainStrength);
           j=DoNightEyeAtNight(j*12.,timeMidnight)*.083333;
           vec3 L=j*k,A=L;
           #ifdef CLOUDS_IN_GI
           CloudPlane(A,-F.direction,worldLightVector,worldSunVector,colorSunlight,colorSkyUp,L,timeMidnight,false);
           L=mix(L,A,vec3(l));
           #endif
           L=TintUnderwaterDepth(L);
           N+=L*.1;
           J=1000.;
           break;
         }
       vec3 j=mod(F.origin+F.direction*J,vec3(1.))-.5;
       float L=log2(J*.4*v*TEXTURE_RESOLUTION);
       vec2 O=vec2(0.);
       O+=vec2(j.z*-u.x,-j.y)*abs(u.x);
       O+=vec2(j.x,j.z*u.y)*abs(u.y);
       O+=vec2(j.x*u.z,-j.y)*abs(u.z);
       vec3 B=(F.origin+F.direction*J)/float(K);
       vec2 V=textureSize(colortex0,0);
       vec4 A=texture2DLod(shadowcolor1,d(I,K),0);
       vec2 W=A.xy;
       W=(floor(W*V/TEXTURE_RESOLUTION)+.5)/(V/TEXTURE_RESOLUTION);
       vec2 ab=W+O.xy*(TEXTURE_RESOLUTION/V);
       vec3 ac=pow(texture2DLod(colortex0,ab,L).xyz,vec3(2.2));
       ac*=mix(vec3(1.),Y.xyz/(A.w+1e-05),vec3(A.z));
       if(S<240.)
         {
           vec3 ad=saturate(Y.xyz);
           k*=ac;
         }
       if(abs(S-31.)<.1)
         N+=.09*k*GI_LIGHT_BLOCK_INTENSITY;
       {
         vec3 ae=vec3(0.),af=vec3(0.);
         if(abs(u.x)>.5)
           ae=vec3(0.,1.,0.),af=vec3(0.,0.,1.);
         if(abs(u.y)>.5)
           ae=vec3(1.,0.,0.),af=vec3(0.,0.,1.);
         if(abs(u.z)>.5)
           ae=vec3(1.,0.,0.),af=vec3(0.,1.,0.);
         ae*=1.;
         af*=1.;
         vec3 ag=H(I,u),ah=ag,ai=saturate(ag*100000.),aj=H(I+ae/float(K),u);
         ah+=aj;
         ai+=saturate(aj*100000.);
         vec3 ak=H(I-ae/float(K),u);
         ah+=ak;
         ai+=saturate(ak*100000.);
         vec3 al=H(I+af/float(K),u);
         ah+=al;
         ai+=saturate(al*100000.);
         vec3 am=H(I-af/float(K),u);
         ah+=am;
         ai+=saturate(am*100000.);
         ah/=ai+vec3(.0001);
         N+=ah*E*k;
       }
       vec3 an=e(M+F.direction*J-1.,worldLightVector,u,g,K)*k*C*colorSunlight*l;
       if(isEyeInWater>0)
         ;
       N+=an;
     }
   vec3 j=m.xyz+q*J,L=(gbufferModelViewInverse*vec4(j.xyz,0.)).xyz;
   {
     vec3 Y=ProjectBack(j);
     if(Y.x>ScreenTexel.x&&Y.x<1.-ScreenTexel.x&&Y.y>ScreenTexel.y&&Y.y<1.-ScreenTexel.y&&j.z<0.)
       {
         vec2 I=Y.xy*2.-1.;
         float V=1.-max(smoothstep(.5,1.,abs(I.x)),smoothstep(.5,1.,abs(I.y)));
         vec2 A=Y.xy*.5+HalfScreen.xy;
         vec3 Q=GetViewPositionNoJitter(Y.xy,GetDepth(DownscaleTexcoord(Y.xy))).xyz;
         if(length(Q-j)<.03*length(Q))
           N=mix(N.xyz,pow(texture2DLod(colortex1,A,0).xyz,vec3(2.2))*100.,vec3(V));
       }
   }
   if(J<1000.)
     LandAtmosphericScattering(N,j-m,q,g,worldSunVector,1.);
   if(isEyeInWater>0)
     N*=1.2,UnderwaterFog(N,length(L),n,colorSkyUp,colorSunlight),N/=1.2;
   J*=saturate(dot(-n,x))*2.;
   return vec4(N,saturate(J/4.));
 }
 vec4 l(float v)
 {
   float y=v*v,s=y*v;
   vec4 i;
   i.x=-s+3*y-3*v+1;
   i.y=3*s-6*y+4;
   i.z=-3*s+3*y+3*v+1;
   i.w=s;
   return i/6.f;
 }
 vec4 g(in sampler2D v,in vec2 i)
 {
   vec2 y=vec2(viewWidth,viewHeight);
   i*=y;
   i-=.5;
   float s=fract(i.x),c=fract(i.y);
   i.x-=s;
   i.y-=c;
   vec4 f=l(s),x=l(c),m=vec4(i.x-.5,i.x+1.5,i.y-.5,i.y+1.5),z=vec4(f.x+f.y,f.z+f.w,x.x+x.y,x.z+x.w),d=m+vec4(f.y,f.w,x.y,x.w)/z,r=texture2DLod(v,vec2(d.x,d.z)/y,0),a=texture2DLod(v,vec2(d.y,d.z)/y,0),h=texture2DLod(v,vec2(d.x,d.w)/y,0),T=texture2DLod(v,vec2(d.y,d.w)/y,0);
   float t=z.x/(z.x+z.y),n=z.z/(z.z+z.w);
   return mix(mix(T,h,t),mix(a,r,t),n);
 }
 bool h(vec3 v,vec3 y)
 {
   vec3 s=normalize(cross(dFdx(v),dFdy(v))),x=normalize(y-v),c=normalize(x);
   return distance(v,y)<.05;
 }
 vec3 y(vec2 v)
 {
   vec2 y=vec2(viewWidth,viewHeight),x=1./y,s=v*y,i=floor(s-.5)+.5,z=s-i,c=z*z,f=z*c;
   float m=.5;
   vec2 d=-m*f+2.*m*c-m*z,a=(2.-m)*f-(3.-m)*c+1.,r=-(2.-m)*f+(3.-2.*m)*c+m*z,T=m*f-m*c,t=a+r,n=x*(i+r/t);
   vec3 h=texture2DLod(colortex4,vec2(n.x,n.y),0).xyz;
   vec2 F=x*(i-1.),Y=x*(i+2.);
   vec4 j=vec4(texture2DLod(colortex4,vec2(n.x,F.y),0).xyz,1.)*(t.x*d.y)+vec4(texture2DLod(colortex4,vec2(F.x,n.y),0).xyz,1.)*(d.x*t.y)+vec4(h,1.)*(t.x*t.y)+vec4(texture2DLod(colortex4,vec2(Y.x,n.y),0).xyz,1.)*(T.x*t.y)+vec4(texture2DLod(colortex4,vec2(n.x,Y.y),0).xyz,1.)*(t.x*T.y);
   return max(vec3(0.),j.xyz*(1./j.w));
 }
 void main()
 {
   Texcoord=texcoord.xy;
   if(texcoord.x<HalfScreen.x||texcoord.y<HalfScreen.y)
     gl_FragData[0]=texture2DLod(colortex0,Texcoord.xy,0),gl_FragData[1]=texture2DLod(colortex1,Texcoord.xy,0),gl_FragData[2]=texture2DLod(colortex7,Texcoord.xy,0);
   else
     {
       Texcoord=texcoord.xy-HalfScreen;
       GBufferData v=GetGBufferData(Texcoord.xy);
       GBufferDataTransparent y=GetGBufferDataTransparent(Texcoord.xy);
       MaterialMask i=CalculateMasks(v.materialID,Texcoord.xy),s=CalculateMasks(y.materialID,Texcoord.xy);
       bool x=y.depth<v.depth;
       if(x)
         v.depth=y.depth,v.normal=y.normal,v.smoothness=y.smoothness,v.metalness=0.,v.mcLightmap=y.mcLightmap,s.sky=0.;
       bool c=abs(111.-y.materialID*255.)<.4&&x;
       vec4 f=GetViewPosition(Texcoord.xy,v.depth),m=gbufferModelViewInverse*vec4(f.xyz,1.),d=gbufferModelViewInverse*vec4(f.xyz,0.);
       vec3 z=normalize(f.xyz),r=normalize(d.xyz),n=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),h=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
       float a=length(f.xyz);
       vec4 T=vec4(0.);
       float t=e(v.smoothness,v.metalness);
       if(t>.0001&&s.sky<.5)
         T=G(1.-v.smoothness,v.metalness,m.xyz,f.xyz,n.xyz,h,r.xyz,i.leaves,v.mcLightmap.y,ExpToLinearDepth(v.depth),v.parallaxOffset,x);
       vec4 F=texture2DLod(colortex1,Texcoord.xy+HalfScreen,0);
       vec3 j=F.xyz;
       j.xyz=pow(j.xyz,vec3(2.2));
       if(c)
         j.xyz*=pow(y.albedo.xyz,vec3(1.))*10.;
       if(x&&!c)
         {
           vec3 Y=GetViewPosition(Texcoord.xy,texture2DLod(depthtex1,Texcoord.xy,0).x).xyz;
           float p=length(Y.xyz),g=p-a;
           vec3 u=y.normal-y.geoNormal*1.05;
           float k=saturate(g*.5)*.5;
           vec2 K=Texcoord.xy+u.xy/(a+1.5)*k;
           K=clamp(K,vec2(ScreenTexel),HalfScreen-ScreenTexel*2.);
           {
             float l=ExpToLinearDepth(texture2DLod(depthtex1,K,0).x),I=ExpToLinearDepth(texture2DLod(depthtex0,K,0).x);
             if(I>=l)
               K=Texcoord.xy;
           }
           j.xyz=pow(texture2DLod(colortex1,K.xy+HalfScreen,0).xyz,vec3(2.2));
           Y=GetViewPosition(K.xy,texture2DLod(depthtex1,K.xy,0).x).xyz;
           f=GetViewPosition(K.xy,texture2DLod(depthtex0,K.xy,0).x);
           p=length(Y.xyz);
           a=length(f.xyz);
           g=p-a;
           if(s.water>.5&&isEyeInWater<1)
             j.xyz*=100.,UnderwaterFog(j.xyz,g,r,colorSkyUp,colorSunlight),j.xyz*=.01;
           if(s.stainedGlass>.5)
             {
               vec3 L=normalize(y.albedo.xyz+.0001)*pow(length(y.albedo.xyz),.5);
               j.xyz*=mix(vec3(1.),L,vec3(pow(y.albedo.w,.2)));
               j.xyz*=mix(vec3(1.),L,vec3(pow(y.albedo.w,.2)));
             }
         }
       j.xyz=pow(j.xyz,vec3(1./2.2));
       gl_FragData[0]=texture2DLod(colortex0,Texcoord.xy,0);
       gl_FragData[1]=vec4(j.xyz,v.smoothness);
       gl_FragData[2]=max(vec4(0.),T*vec4(vec3(.1),1.));
     }
 };




/* DRAWBUFFERS:017 */
