/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.expr.IExpressionFloat;

public enum RenderEntityParameterFloat implements IExpressionFloat
{
    LIMB_SWING("limb_swing"),
    LIMB_SWING_SPEED("limb_speed"),
    AGE("age"),
    HEAD_YAW("head_yaw"),
    HEAD_PITCH("head_pitch"),
    HEALTH("health"),
    HURT_TIME("hurt_time"),
    IDLE_TIME("idle_time"),
    MAX_HEALTH("max_health"),
    MOVE_FORWARD("move_forward"),
    MOVE_STRAFING("move_strafing"),
    PARTIAL_TICKS("partial_ticks"),
    POS_X("pos_x", true),
    POS_Y("pos_y", true),
    POS_Z("pos_z", true),
    REVENGE_TIME("revenge_time"),
    SWING_PROGRESS("swing_progress");

    private String name;
    private boolean blockEntity;
    private erw renderManager;
    private static final RenderEntityParameterFloat[] VALUES;

    private RenderEntityParameterFloat(String name) {
        this(name, false);
    }

    private RenderEntityParameterFloat(String name, boolean blockEntity) {
        this.name = name;
        this.blockEntity = blockEntity;
        this.renderManager = dvp.C().ac();
    }

    public String getName() {
        return this.name;
    }

    public boolean isBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public float eval() {
        erx render;
        ciq blockEntity = epe.tileEntityRendered;
        if (blockEntity != null) {
            switch (this) {
                case POS_X: {
                    return blockEntity.m().u();
                }
                case POS_Y: {
                    return blockEntity.m().v();
                }
                case POS_Z: {
                    return blockEntity.m().w();
                }
            }
        }
        if ((render = this.renderManager.renderRender) == null) {
            return 0.0f;
        }
        atg entity = this.renderManager.renderEntity;
        if (entity == null) {
            return 0.0f;
        }
        if (render instanceof esy) {
            esy rlb = (esy)render;
            switch (this) {
                case LIMB_SWING: {
                    return rlb.renderLimbSwing;
                }
                case LIMB_SWING_SPEED: {
                    return rlb.renderLimbSwingAmount;
                }
                case AGE: {
                    return rlb.renderAgeInTicks;
                }
                case HEAD_YAW: {
                    return rlb.renderHeadYaw;
                }
                case HEAD_PITCH: {
                    return rlb.renderHeadPitch;
                }
            }
            if (entity instanceof atu) {
                atu livingEntity = (atu)entity;
                switch (this) {
                    case HEALTH: {
                        return livingEntity.dU();
                    }
                    case HURT_TIME: {
                        return livingEntity.aK;
                    }
                    case IDLE_TIME: {
                        return livingEntity.dK();
                    }
                    case MAX_HEALTH: {
                        return livingEntity.ef();
                    }
                    case MOVE_FORWARD: {
                        return livingEntity.bq;
                    }
                    case MOVE_STRAFING: {
                        return livingEntity.bo;
                    }
                    case REVENGE_TIME: {
                        return livingEntity.dH();
                    }
                    case SWING_PROGRESS: {
                        return livingEntity.s(rlb.renderPartialTicks);
                    }
                }
            }
        }
        switch (this) {
            case POS_X: {
                return (float)entity.cX();
            }
            case POS_Y: {
                return (float)entity.cZ();
            }
            case POS_Z: {
                return (float)entity.dd();
            }
        }
        return 0.0f;
    }

    public static RenderEntityParameterFloat parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i2 = 0; i2 < VALUES.length; ++i2) {
            RenderEntityParameterFloat type = VALUES[i2];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterFloat.values();
    }
}

