/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.optifine.Config;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(class_2680 blockStateIn, class_1922 blockReaderIn, class_2338 blockPosIn, class_2350 facingIn, RenderEnv renderEnv) {
        class_2338 posNeighbour = blockPosIn.method_10093(facingIn);
        class_2680 stateNeighbour = blockReaderIn.method_8320(posNeighbour);
        if (stateNeighbour.isCacheOpaqueCube()) {
            return false;
        }
        if (blockStateIn.method_26187(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.method_26225()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(class_2680 blockStateIn, class_1922 blockReaderIn, class_2338 blockPosIn, class_2350 facingIn, RenderEnv renderEnv, class_2680 stateNeighbourIn, class_2338 posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        class_265 voxelshape = blockStateIn.method_26173(blockReaderIn, blockPosIn, facingIn);
        if (voxelshape.method_1110()) {
            return true;
        }
        class_265 voxelshape1 = stateNeighbourIn.method_26173(blockReaderIn, posNeighbourIn, facingIn.method_10153());
        boolean flag = class_259.method_1074(voxelshape, voxelshape1, class_247.field_16886);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(class_2248 block) {
        return class_2378.field_11146.method_10206(block);
    }

    public static class_2248 getBlock(class_2960 loc) {
        if (!class_2378.field_11146.method_10250(loc)) {
            return null;
        }
        return class_2378.field_11146.method_10223(loc);
    }

    public static int getMetadata(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        class_2689<class_2248, class_2680> stateContainer = block.method_9595();
        ImmutableList<class_2680> validStates = stateContainer.method_11662();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(class_2248 block) {
        class_2689<class_2248, class_2680> stateContainer = block.method_9595();
        ImmutableList<class_2680> validStates = stateContainer.method_11662();
        return validStates.size();
    }

    public static class_2680 getBlockState(class_2248 block, int metadata) {
        class_2689<class_2248, class_2680> stateContainer = block.method_9595();
        ImmutableList<class_2680> validStates = stateContainer.method_11662();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        class_2680 blockState = (class_2680)validStates.get(metadata);
        return blockState;
    }

    public static List<class_2680> getBlockStates(class_2248 block) {
        class_2689<class_2248, class_2680> stateContainer = block.method_9595();
        ImmutableList<class_2680> validStates = stateContainer.method_11662();
        return validStates;
    }

    public static boolean isFullCube(class_2680 stateIn, class_1922 blockReaderIn, class_2338 posIn) {
        return stateIn.isCacheOpaqueCollisionShape();
    }

    public static Collection<class_2769> getProperties(class_2680 blockState) {
        return blockState.method_28501();
    }

    public static boolean isPropertyTrue(class_2680 blockState, class_2746 prop) {
        Boolean value = (Boolean)blockState.method_11656().get((Object)prop);
        return Config.isTrue(value);
    }

    public static boolean isPropertyFalse(class_2680 blockState, class_2746 prop) {
        Boolean value = (Boolean)blockState.method_11656().get((Object)prop);
        return Config.isFalse(value);
    }

    public static final class RenderSideCacheKey {
        private class_2680 blockState1;
        private class_2680 blockState2;
        private class_2350 facing;
        private int hashCode;

        private RenderSideCacheKey(class_2680 blockState1In, class_2680 blockState2In, class_2350 facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(class_2680 blockState1In, class_2680 blockState2In, class_2350 facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

