/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5572;
import net.minecraft.class_638;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final class_2350[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays(false);
    public static final class_2350[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays(true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static class_638 worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(class_638 world, class_1297 viewEntity, int renderDistanceChunks) {
        int minHeight = world.method_31607();
        int maxHeight = world.method_31605();
        int minChunkHeight = minHeight >> 4;
        int pcx = class_3532.method_15357(viewEntity.method_23317()) >> 4;
        int pcy = class_3532.method_15357(viewEntity.method_23318() - (double)minHeight) >> 4;
        int pcz = class_3532.method_15357(viewEntity.method_23321()) >> 4;
        int pcyMax = maxHeight - minHeight >> 4;
        pcy = Config.limit(pcy, 0, pcyMax - 1);
        long playerSectionKey = class_4076.method_33706(viewEntity.method_24515());
        class_5572 playerSection = world.getEntityStorage().getSectionStorage().method_31785(playerSectionKey);
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            for (int cz = czStart; cz < czEnd; ++cz) {
                class_2818 chunk = world.method_8497(cx, cz);
                if (chunk.method_12223()) continue;
                class_2826[] ebss = chunk.method_12006();
                for (int i = ebss.length - 1; i > iMax; --i) {
                    class_2826 ebs = ebss[i];
                    if (ebs == null || ebs.method_12261()) continue;
                    if (i <= iMax) break;
                    iMax = i;
                    break;
                }
                try {
                    Map<class_2338, class_2586> mapTileEntities = chunk.method_12214();
                    if (mapTileEntities.isEmpty()) continue;
                    Set<class_2338> keys = mapTileEntities.keySet();
                    for (class_2338 pos : keys) {
                        int i = pos.method_10264() - minHeight >> 4;
                        if (i <= iMax) continue;
                        iMax = i;
                    }
                    continue;
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            LongSet sectionKeys = world.getEntityStorage().getSectionStorage().getSectionKeys();
            LongIterator it = sectionKeys.iterator();
            while (it.hasNext()) {
                long sectionKey = it.nextLong();
                int sectionY = class_4076.method_18689(sectionKey);
                int i = sectionY - minChunkHeight;
                if (sectionKey == playerSectionKey && i == pcy && playerSection != null && playerSection.getEntityList().size() == 1 || i <= iMax) continue;
                iMax = i;
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return (iMax << 4) + minHeight;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static class_2350[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        class_2350[][] arrs = new class_2350[count][];
        for (int i = 0; i < count; ++i) {
            ArrayList<class_2350> list = new ArrayList<class_2350>();
            for (int ix = 0; ix < class_2350.field_11040.length; ++ix) {
                class_2350 facing = class_2350.field_11040[ix];
                class_2350 facingMask = opposite ? facing.method_10153() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i & mask) == 0) continue;
                list.add(facing);
            }
            class_2350[] fs = list.toArray(new class_2350[list.size()]);
            arrs[i] = fs;
        }
        return arrs;
    }

    public static class_2350[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

