/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3873;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.class_465;
import net.minecraft.class_466;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_476;
import net.minecraft.class_479;
import net.minecraft.class_480;
import net.minecraft.class_481;
import net.minecraft.class_486;
import net.minecraft.class_488;
import net.minecraft.class_490;
import net.minecraft.class_491;
import net.minecraft.class_492;
import net.minecraft.class_495;
import net.minecraft.class_638;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static class_310 mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static class_2960 getTextureLocation(class_2960 loc) {
        class_1297 entity;
        if (guiProperties == null) {
            return loc;
        }
        class_437 screen = CustomGuis.mc.field_1755;
        if (!(screen instanceof class_465)) {
            return loc;
        }
        if (!loc.method_12836().equals("minecraft") || !loc.method_12832().startsWith("textures/gui/")) {
            return loc;
        }
        if (playerControllerOF == null) {
            return loc;
        }
        class_638 world = CustomGuis.mc.field_1687;
        if (world == null) {
            return loc;
        }
        if (screen instanceof class_481) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.field_1724.method_24515(), world, loc, screen);
        }
        if (screen instanceof class_490) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.field_1724.method_24515(), world, loc, screen);
        }
        class_2338 pos = playerControllerOF.getLastClickBlockPos();
        if (pos != null) {
            if (screen instanceof class_471) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, pos, world, loc, screen);
            }
            if (screen instanceof class_466) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, pos, world, loc, screen);
            }
            if (screen instanceof class_472) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, pos, world, loc, screen);
            }
            if (screen instanceof class_476) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, pos, world, loc, screen);
            }
            if (screen instanceof class_479) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, pos, world, loc, screen);
            }
            if (screen instanceof class_480) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, pos, world, loc, screen);
            }
            if (screen instanceof class_486) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, pos, world, loc, screen);
            }
            if (screen instanceof class_3873) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, pos, world, loc, screen);
            }
            if (screen instanceof class_488) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, pos, world, loc, screen);
            }
            if (screen instanceof class_495) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, pos, world, loc, screen);
            }
        }
        if ((entity = playerControllerOF.getLastClickEntity()) != null) {
            if (screen instanceof class_491) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, world, loc);
            }
            if (screen instanceof class_492) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, world, loc);
            }
        }
        return loc;
    }

    private static class_2960 getTexturePos(CustomGuiProperties.EnumContainer container, class_2338 pos, class_4538 blockAccess, class_2960 loc, class_437 screen) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesPos(container, pos, blockAccess, screen)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    private static class_2960 getTextureEntity(CustomGuiProperties.EnumContainer container, class_1297 entity, class_4538 blockAccess, class_2960 loc) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesEntity(container, entity, blockAccess)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (!Config.isCustomGuis()) {
            return;
        }
        ArrayList<List<CustomGuiProperties>> listProps = new ArrayList<List<CustomGuiProperties>>();
        class_3262[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            class_3262 rp = rps[i];
            CustomGuis.update(rp, listProps);
        }
        guiProperties = CustomGuis.propertyListToArray(listProps);
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] cgps = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        for (int i = 0; i < cgps.length; ++i) {
            List<CustomGuiProperties> subList;
            if (listProps.size() <= i || (subList = listProps.get(i)) == null) continue;
            CustomGuiProperties[] subArr = subList.toArray(new CustomGuiProperties[subList.size()]);
            cgps[i] = subArr;
        }
        return cgps;
    }

    private static void update(class_3262 rp, List<List<CustomGuiProperties>> listProps) {
        Object[] paths = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(paths);
        for (int i = 0; i < paths.length; ++i) {
            Object name = paths[i];
            Config.dbg("CustomGuis: " + (String)name);
            try {
                class_2960 locFile = new class_2960((String)name);
                InputStream in = rp.method_14405(class_3264.field_14188, locFile);
                if (in == null) {
                    Config.warn("CustomGuis file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomGuiProperties cgp = new CustomGuiProperties(props, (String)name);
                if (!cgp.isValid((String)name)) continue;
                CustomGuis.addToList(cgp, listProps);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("CustomGuis file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
            return;
        }
        int indexContainer = cgp.getContainer().ordinal();
        while (listProps.size() <= indexContainer) {
            listProps.add(null);
        }
        List<CustomGuiProperties> subList = listProps.get(indexContainer);
        if (subList == null) {
            subList = new ArrayList<CustomGuiProperties>();
            listProps.set(indexContainer, subList);
        }
        subList.add(cgp);
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

