/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.Visibility;
import net.minecraft.world.phys.AABB;

public class EntitySectionStorage<T extends EntityAccess> {
    private final Class<T> f_175609_;
    private final Long2ObjectFunction<Visibility> f_175610_;
    private final Long2ObjectMap<EntitySection<T>> f_175611_ = new Long2ObjectOpenHashMap();
    private final LongSortedSet f_175612_ = new LongAVLTreeSet();
    private boolean updated;

    public EntitySectionStorage(Class<T> p_i175613_1_, Long2ObjectFunction<Visibility> p_i175613_2_) {
        this.f_175609_ = p_i175613_1_;
        this.f_175610_ = p_i175613_2_;
    }

    public void m_175636_(AABB p_175636_1_, Consumer<EntitySection<T>> p_175636_2_) {
        int i = SectionPos.m_213994_((double)(p_175636_1_.f_82288_ - 2.0));
        int j = SectionPos.m_213994_((double)(p_175636_1_.f_82289_ - 2.0));
        int k = SectionPos.m_213994_((double)(p_175636_1_.f_82290_ - 2.0));
        int l = SectionPos.m_213994_((double)(p_175636_1_.f_82291_ + 2.0));
        int i1 = SectionPos.m_213994_((double)(p_175636_1_.f_82292_ + 2.0));
        int j1 = SectionPos.m_213994_((double)(p_175636_1_.f_82293_ + 2.0));
        for (int k1 = i; k1 <= l; ++k1) {
            long l1 = SectionPos.m_123209_((int)k1, (int)0, (int)0);
            long i2 = SectionPos.m_123209_((int)k1, (int)-1, (int)-1);
            LongBidirectionalIterator longiterator = this.f_175612_.subSet(l1, i2 + 1L).iterator();
            while (longiterator.hasNext()) {
                EntitySection entitysection;
                long j2 = longiterator.nextLong();
                int k2 = SectionPos.m_123225_((long)j2);
                int l2 = SectionPos.m_123230_((long)j2);
                if (k2 < j || k2 > i1 || l2 < k || l2 > j1 || (entitysection = (EntitySection)this.f_175611_.get(j2)) == null || !entitysection.m_175565_().m_175965_()) continue;
                p_175636_2_.accept(entitysection);
            }
        }
    }

    public LongStream m_175620_(long p_175620_1_) {
        int j;
        int i = ChunkPos.m_45592_(p_175620_1_);
        LongSortedSet longsortedset = this.m_175617_(i, j = ChunkPos.m_45602_(p_175620_1_));
        if (longsortedset.isEmpty()) {
            return LongStream.empty();
        }
        LongBidirectionalIterator oflong = longsortedset.iterator();
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize((PrimitiveIterator.OfLong)oflong, 1301), false);
    }

    private LongSortedSet m_175617_(int p_175617_1_, int p_175617_2_) {
        long i = SectionPos.m_123209_((int)p_175617_1_, (int)0, (int)p_175617_2_);
        long j = SectionPos.m_123209_((int)p_175617_1_, (int)-1, (int)p_175617_2_);
        return this.f_175612_.subSet(i, j + 1L);
    }

    public Stream<EntitySection<T>> m_175647_(long p_175647_1_) {
        return this.m_175620_(p_175647_1_).mapToObj(arg_0 -> this.f_175611_.get(arg_0)).filter(Objects::nonNull);
    }

    private static long m_175658_(long p_175658_0_) {
        return ChunkPos.m_45589_(SectionPos.m_123213_((long)p_175658_0_), SectionPos.m_123230_((long)p_175658_0_));
    }

    public EntitySection<T> m_175652_(long p_175652_1_) {
        this.updated = true;
        return (EntitySection)this.f_175611_.computeIfAbsent(p_175652_1_, this::m_175660_);
    }

    @Nullable
    public EntitySection<T> m_175654_(long p_175654_1_) {
        return (EntitySection)this.f_175611_.get(p_175654_1_);
    }

    private EntitySection<T> m_175660_(long p_175660_1_) {
        long i = EntitySectionStorage.m_175658_(p_175660_1_);
        Visibility visibility = (Visibility)this.f_175610_.get(i);
        this.f_175612_.add(p_175660_1_);
        return new EntitySection<T>(this.f_175609_, visibility);
    }

    public LongSet m_175616_() {
        LongOpenHashSet longset = new LongOpenHashSet();
        this.f_175611_.keySet().forEach(arg_0 -> EntitySectionStorage.lambda$getAllChunksWithExistingSections$0((LongSet)longset, arg_0));
        return longset;
    }

    private static <T extends EntityAccess> Predicate<T> m_175631_(AABB p_175631_0_) {
        return p_175633_1_ -> p_175633_1_.m_141786_().m_82381_(p_175631_0_);
    }

    public void m_175649_(AABB p_175649_1_, Consumer<T> p_175649_2_) {
        this.m_175636_(p_175649_1_, p_175639_2_ -> p_175639_2_.m_175559_(EntitySectionStorage.m_175631_(p_175649_1_), p_175649_2_));
    }

    public <U extends T> void m_175622_(EntityTypeTest<T, U> p_175622_1_, AABB p_175622_2_, Consumer<U> p_175622_3_) {
        this.m_175636_(p_175622_2_, p_175626_3_ -> p_175626_3_.m_175551_(p_175622_1_, EntitySectionStorage.m_175631_(p_175622_2_), p_175622_3_));
    }

    public void m_175656_(long p_175656_1_) {
        this.updated = true;
        this.f_175611_.remove(p_175656_1_);
        this.f_175612_.remove(p_175656_1_);
    }

    @VisibleForDebug
    public int m_175646_() {
        return this.f_175612_.size();
    }

    public boolean resetUpdated() {
        boolean ret = this.updated;
        this.updated = false;
        return ret;
    }

    public LongSet getSectionKeys() {
        return this.f_175611_.keySet();
    }

    private static /* synthetic */ void lambda$getAllChunksWithExistingSections$0(LongSet longset, long p_175643_1_) {
        longset.add(EntitySectionStorage.m_175658_(p_175643_1_));
    }
}

