/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedPlayerList;
import net.minecraft.client.server.LanServerPinger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerResources;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListenerFactory;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.stats.Stats;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Snooper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServer
extends MinecraftServer {
    public static final int f_316849_ = -1;
    private static final Logger f_120014_ = LogManager.getLogger();
    private final Minecraft f_120015_;
    private boolean f_120016_;
    private int f_120017_ = -1;
    @Nullable
    private GameType f_212532_;
    private LanServerPinger f_120018_;
    private UUID f_120019_;
    private long ticksSaveLast = 0L;
    public Level difficultyUpdateWorld = null;
    public BlockPos difficultyUpdatePos = null;
    public DifficultyInstance difficultyLast = null;

    public IntegratedServer(Thread threadIn, Minecraft mcIn, RegistryAccess.RegistryHolder regImplIn, LevelStorageSource.LevelStorageAccess levelSaveIn, PackRepository resPackListIn, ServerResources dataPackRegIn, WorldData serverConfigIn, MinecraftSessionService sessionServiceIn, GameProfileRepository profileRepositoryIn, GameProfileCache profileCacheIn, ChunkProgressListenerFactory listenerFactoryIn) {
        super(threadIn, regImplIn, levelSaveIn, serverConfigIn, resPackListIn, mcIn.m_91096_(), mcIn.m_91295_(), dataPackRegIn, sessionServiceIn, profileRepositoryIn, profileCacheIn, listenerFactoryIn);
        this.m_129981_(mcIn.m_91094_().m_92546_());
        this.m_129975_(mcIn.m_91402_());
        this.m_129823_((PlayerList)new IntegratedPlayerList(this, this.f_129746_, this.f_129745_));
        this.f_120015_ = mcIn;
    }

    public boolean m_7038_() {
        f_120014_.info("Starting integrated minecraft server version {}", (Object)SharedConstants.m_136187_().getName());
        this.m_129985_(true);
        this.m_129997_(true);
        this.m_129999_(true);
        this.m_129793_();
        if (Reflector.ServerLifecycleHooks_handleServerAboutToStart.exists() && !Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerAboutToStart, this)) {
            return false;
        }
        this.m_130006_();
        this.m_129989_(this.m_129791_() + " - " + this.m_129910_().m_5462_());
        if (Reflector.ServerLifecycleHooks_handleServerStarting.exists()) {
            return Reflector.callBoolean(Reflector.ServerLifecycleHooks_handleServerStarting, this);
        }
        return true;
    }

    public void m_5705_(BooleanSupplier hasTimeLeft) {
        this.onTick();
        boolean flag = this.f_120016_;
        this.f_120016_ = Minecraft.m_91087_().m_91403_() != null && Minecraft.m_91087_().m_91104_();
        ProfilerFiller profilerfiller = this.m_129905_();
        if (!flag && this.f_120016_) {
            profilerfiller.m_6180_("autoSave");
            f_120014_.info("Saving and pausing game...");
            this.m_6846_().m_11302_();
            this.m_129885_(false, false, false);
            profilerfiller.m_7238_();
        }
        if (this.f_120016_) {
            this.m_316851_();
        } else {
            super.m_5705_(hasTimeLeft);
            int i = Math.max(2, this.f_120015_.f_91066_.f_92106_ + -1);
            if (i != this.m_6846_().m_11312_()) {
                f_120014_.info("Changing view distance to {}, from {}", (Object)i, (Object)this.m_6846_().m_11312_());
                this.m_6846_().m_11217_(i);
            }
        }
    }

    private void m_316851_() {
        for (ServerPlayer serverplayer : this.m_6846_().m_11314_()) {
            serverplayer.m_36220_(Stats.f_300773_);
        }
    }

    public boolean m_6983_() {
        return true;
    }

    public boolean m_6102_() {
        return true;
    }

    public File m_6237_() {
        return this.f_120015_.f_91069_;
    }

    public boolean m_6982_() {
        return false;
    }

    public int m_7032_() {
        return 0;
    }

    public boolean m_6994_() {
        return false;
    }

    public void m_7268_(CrashReport report) {
        this.f_120015_.m_91253_(report);
    }

    public SystemReport m_299720_(SystemReport report) {
        report.m_300462_("Type", "Integrated Server (map_client.txt)");
        report.m_300465_("Is Modded", () -> this.m_6730_().orElse("Probably not. Jar signature remains and both client + server brands are untouched."));
        return report;
    }

    public Optional<String> m_6730_() {
        String s = ClientBrandRetriever.m_129629_();
        if (!s.equals("vanilla")) {
            return Optional.of("Definitely; Client brand changed to '" + s + "'");
        }
        s = this.m_130001_();
        if (!"vanilla".equals(s)) {
            return Optional.of("Definitely; Server brand changed to '" + s + "'");
        }
        return Minecraft.class.getSigners() == null ? Optional.of("Very likely; Jar signature invalidated") : Optional.empty();
    }

    public void m_7108_(Snooper snooper) {
        super.m_7108_(snooper);
        snooper.m_19223_("snooper_partner", (Object)this.f_120015_.m_91093_().m_19232_());
    }

    public boolean m_299917_() {
        return Minecraft.m_91087_().m_299917_();
    }

    public boolean m_7386_(@Nullable GameType gameMode, boolean cheats, int port) {
        try {
            this.m_129919_().m_9711_((InetAddress)null, port);
            f_120014_.info("Started serving on {}", (Object)port);
            this.f_120017_ = port;
            this.f_120018_ = new LanServerPinger(this.m_129916_(), "" + port);
            this.f_120018_.start();
            this.f_212532_ = gameMode;
            this.m_6846_().m_11284_(cheats);
            int i = this.m_129944_(this.f_120015_.f_91074_.m_36316_());
            this.f_120015_.f_91074_.m_108648_(i);
            for (ServerPlayer serverplayer : this.m_6846_().m_11314_()) {
                this.m_129892_().m_82095_(serverplayer);
            }
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public void m_7041_() {
        super.m_7041_();
        if (this.f_120018_ != null) {
            this.f_120018_.interrupt();
            this.f_120018_ = null;
        }
    }

    public void m_7570_(boolean waitForServer) {
        if (!Reflector.MinecraftForge.exists() || this.m_130010_()) {
            this.m_18709_(() -> {
                for (ServerPlayer serverplayer : Lists.newArrayList((Iterable)this.m_6846_().m_11314_())) {
                    if (serverplayer.m_141538_().equals(this.f_120019_)) continue;
                    this.m_6846_().m_11286_(serverplayer);
                }
            });
        }
        super.m_7570_(waitForServer);
        if (this.f_120018_ != null) {
            this.f_120018_.interrupt();
            this.f_120018_ = null;
        }
    }

    public boolean m_6992_() {
        return this.f_120017_ > -1;
    }

    public int m_7010_() {
        return this.f_120017_;
    }

    public void m_7835_(GameType gameMode) {
        super.m_7835_(gameMode);
        this.f_212532_ = null;
    }

    public boolean m_6993_() {
        return true;
    }

    public int m_7022_() {
        return 2;
    }

    public int m_7034_() {
        return 2;
    }

    public void m_120046_(UUID uuid) {
        this.f_120019_ = uuid;
    }

    public boolean m_7779_(GameProfile profileIn) {
        return profileIn.getName().equalsIgnoreCase(this.m_129791_());
    }

    public int m_7186_(int distanceIn) {
        return (int)(this.f_120015_.f_91066_.f_92112_ * (float)distanceIn);
    }

    public boolean m_6365_() {
        return this.f_120015_.f_91066_.f_92076_;
    }

    @Nullable
    public GameType m_141499_() {
        return this.m_6992_() ? (GameType)MoreObjects.firstNonNull((Object)this.f_212532_, (Object)this.f_129749_.m_5464_()) : null;
    }

    private void onTick() {
        Iterable iws = this.m_129785_();
        for (ServerLevel ws : iws) {
            this.onTick(ws);
        }
    }

    private void onTick(ServerLevel ws) {
        if (!Config.isTimeDefault()) {
            this.fixWorldTime(ws);
        }
        if (!Config.isWeatherEnabled()) {
            this.fixWorldWeather(ws);
        }
        if (this.difficultyUpdateWorld == ws && this.difficultyUpdatePos != null) {
            this.difficultyLast = ws.m_6436_(this.difficultyUpdatePos);
            this.difficultyUpdateWorld = null;
            this.difficultyUpdatePos = null;
        }
    }

    public DifficultyInstance getDifficultyAsync(Level world, BlockPos blockPos) {
        this.difficultyUpdateWorld = world;
        this.difficultyUpdatePos = blockPos;
        return this.difficultyLast;
    }

    private void fixWorldWeather(ServerLevel ws) {
        if (ws.m_46722_(1.0f) > 0.0f || ws.m_46470_()) {
            ws.m_8606_(6000, 0, false, false);
        }
    }

    private void fixWorldTime(ServerLevel ws) {
        if (this.m_130008_() != GameType.CREATIVE) {
            return;
        }
        long time = ws.m_46468_();
        long timeOfDay = time % 24000L;
        if (Config.isTimeDayOnly()) {
            if (timeOfDay <= 1000L) {
                ws.m_8615_(time - timeOfDay + 1001L);
            }
            if (timeOfDay >= 11000L) {
                ws.m_8615_(time - timeOfDay + 24001L);
            }
        }
        if (Config.isTimeNightOnly()) {
            if (timeOfDay <= 14000L) {
                ws.m_8615_(time - timeOfDay + 14001L);
            }
            if (timeOfDay >= 22000L) {
                ws.m_8615_(time - timeOfDay + 24000L + 14001L);
            }
        }
    }

    public boolean m_129885_(boolean silentIn, boolean flushIn, boolean commandIn) {
        if (silentIn) {
            int ticksSaveInterval;
            int ticks = this.m_129921_();
            if ((long)ticks < this.ticksSaveLast + (long)(ticksSaveInterval = this.f_120015_.f_91066_.ofAutoSaveTicks)) {
                return false;
            }
            this.ticksSaveLast = ticks;
        }
        return super.m_129885_(silentIn, flushIn, commandIn);
    }
}

