/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.Team;
import net.optifine.Config;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final Logger f_115289_ = LogManager.getLogger();
    private static final float f_316594_ = 0.1f;
    public M f_115290_;
    protected final List<RenderLayer<T, M>> f_115291_ = Lists.newArrayList();
    public float renderLimbSwing;
    public float renderLimbSwingAmount;
    public float renderAgeInTicks;
    public float renderHeadYaw;
    public float renderHeadPitch;
    public float renderPartialTicks;
    public static final boolean animateModelLiving = Boolean.getBoolean("animate.model.living");

    public LivingEntityRenderer(EntityRendererProvider.Context contextIn, M entityModelIn, float shadowSizeIn) {
        super(contextIn);
        this.f_115290_ = entityModelIn;
        this.f_114477_ = shadowSizeIn;
    }

    public final boolean m_115326_(RenderLayer<T, M> layer) {
        return this.f_115291_.add(layer);
    }

    public M m_7200_() {
        return this.f_115290_;
    }

    @Override
    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean flag2;
        boolean flag;
        Direction direction;
        if (Reflector.RenderLivingEvent_Pre_Constructor.exists() && Reflector.postForgeBusEvent(Reflector.RenderLivingEvent_Pre_Constructor, entityIn, this, Float.valueOf(partialTicks), matrixStackIn, bufferIn, packedLightIn)) {
            return;
        }
        if (animateModelLiving) {
            ((LivingEntity)entityIn).f_20924_ = 1.0f;
        }
        matrixStackIn.m_85836_();
        ((EntityModel)this.f_115290_).f_102608_ = this.m_115342_(entityIn, partialTicks);
        ((EntityModel)this.f_115290_).f_102609_ = entityIn.m_20159_();
        if (Reflector.IForgeEntity_shouldRiderSit.exists()) {
            ((EntityModel)this.f_115290_).f_102609_ = entityIn.m_20159_() && entityIn.m_20202_() != null && Reflector.callBoolean(entityIn.m_20202_(), Reflector.IForgeEntity_shouldRiderSit, new Object[0]);
        }
        ((EntityModel)this.f_115290_).f_102610_ = entityIn.m_6162_();
        float f = Mth.m_14189_(partialTicks, ((LivingEntity)entityIn).f_20884_, ((LivingEntity)entityIn).f_20883_);
        float f1 = Mth.m_14189_(partialTicks, ((LivingEntity)entityIn).f_20886_, ((LivingEntity)entityIn).f_20885_);
        float f2 = f1 - f;
        if (((EntityModel)this.f_115290_).f_102609_ && entityIn.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.m_20202_();
            f = Mth.m_14189_(partialTicks, livingentity.f_20884_, livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_(f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_(partialTicks, ((LivingEntity)entityIn).f_19860_, entityIn.m_302839_());
        if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
            float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
            matrixStackIn.m_85837_((float)(-direction.m_122429_()) * f4, 0.0, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = this.m_6930_(entityIn, partialTicks);
        this.m_7523_(entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        this.m_7546_(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.m_85837_(0.0, -1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!entityIn.m_20159_() && entityIn.m_6084_()) {
            f8 = Mth.m_14179_(partialTicks, ((LivingEntity)entityIn).f_20923_, ((LivingEntity)entityIn).f_20924_);
            f5 = ((LivingEntity)entityIn).f_20925_ - ((LivingEntity)entityIn).f_20924_ * (1.0f - partialTicks);
            if (entityIn.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.f_115290_.m_6839_(entityIn, f5, f8, partialTicks);
        this.f_115290_.m_6973_(entityIn, f5, f8, f7, f2, f6);
        if (CustomEntityModels.isActive()) {
            this.renderLimbSwing = f5;
            this.renderLimbSwingAmount = f8;
            this.renderAgeInTicks = f7;
            this.renderHeadYaw = f2;
            this.renderHeadPitch = f6;
            this.renderPartialTicks = partialTicks;
        }
        boolean isShaders = Config.isShaders();
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag1 = !(flag = this.m_5933_(entityIn)) && !entityIn.m_20177_((Player)minecraft.f_91074_);
        RenderType rendertype = this.m_7225_(entityIn, flag, flag1, flag2 = minecraft.m_91314_(entityIn));
        if (rendertype != null) {
            VertexConsumer vertexconsumer = bufferIn.m_6299_(rendertype);
            float overlayProgress = this.m_6931_(entityIn, partialTicks);
            if (isShaders) {
                if (((LivingEntity)entityIn).f_20916_ > 0 || ((LivingEntity)entityIn).f_20919_ > 0) {
                    Shaders.setEntityColor(1.0f, 0.0f, 0.0f, 0.3f);
                }
                if (overlayProgress > 0.0f) {
                    Shaders.setEntityColor(overlayProgress, overlayProgress, overlayProgress, 0.5f);
                }
            }
            int i = LivingEntityRenderer.m_115338_(entityIn, overlayProgress);
            this.f_115290_.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entityIn.m_5833_()) {
            for (RenderLayer<T, M> renderlayer : this.f_115291_) {
                renderlayer.m_6494_(matrixStackIn, bufferIn, packedLightIn, entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        if (Config.isShaders()) {
            Shaders.setEntityColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        if (Reflector.RenderLivingEvent_Post_Constructor.exists()) {
            Reflector.postForgeBusEvent(Reflector.RenderLivingEvent_Post_Constructor, entityIn, this, Float.valueOf(partialTicks), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    @Nullable
    protected RenderType m_7225_(T entityIn, boolean visibleIn, boolean translucentIn, boolean glowingIn) {
        ResourceLocation resourcelocation = this.m_5478_(entityIn);
        if (this.getLocationTextureCustom() != null) {
            resourcelocation = this.getLocationTextureCustom();
        }
        if (translucentIn) {
            return RenderType.m_110467_(resourcelocation);
        }
        if (visibleIn) {
            return this.f_115290_.m_103119_(resourcelocation);
        }
        if (entityIn.m_302832_() && !Config.getMinecraft().f_91060_.m_109817_()) {
            return this.f_115290_.m_103119_(resourcelocation);
        }
        return glowingIn ? RenderType.m_110491_(resourcelocation) : null;
    }

    public static int m_115338_(LivingEntity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((livingEntityIn.f_20916_ > 0 || livingEntityIn.f_20919_ > 0 ? 1 : 0) != 0));
    }

    protected boolean m_5933_(T livingEntityIn) {
        return !livingEntityIn.m_20145_();
    }

    private static float m_115328_(Direction facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean m_5936_(T entityIn) {
        return entityIn.m_149614_();
    }

    protected void m_7523_(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        Pose pose;
        if (this.m_5936_(entityLiving)) {
            rotationYaw += (float)(Math.cos((double)((LivingEntity)entityLiving).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if ((pose = entityLiving.m_20089_()) != Pose.SLEEPING) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        }
        if (((LivingEntity)entityLiving).f_20919_ > 0) {
            float f = ((float)((LivingEntity)entityLiving).f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_(f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * this.m_6441_(entityLiving)));
        } else if (entityLiving.m_21209_()) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f - entityLiving.m_302839_()));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((float)((LivingEntity)entityLiving).f_19797_ + partialTicks) * -75.0f));
        } else if (pose == Pose.SLEEPING) {
            Direction direction = entityLiving.m_21259_();
            float f1 = direction != null ? LivingEntityRenderer.m_115328_(direction) : rotationYaw;
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(this.m_6441_(entityLiving)));
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
        } else if ((entityLiving.m_8077_() || entityLiving instanceof Player) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)entityLiving.m_7755_().getString())) || "Grumm".equals(s)) && (!(entityLiving instanceof Player) || ((Player)entityLiving).m_36170_(PlayerModelPart.CAPE))) {
            matrixStackIn.m_85837_(0.0, entityLiving.m_20206_() + 0.1f, 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    protected float m_115342_(T livingBase, float partialTickTime) {
        return livingBase.m_21324_(partialTickTime);
    }

    protected float m_6930_(T livingBase, float partialTicks) {
        return (float)((LivingEntity)livingBase).f_19797_ + partialTicks;
    }

    protected float m_6441_(T entityLivingBaseIn) {
        return 90.0f;
    }

    protected float m_6931_(T livingEntityIn, float partialTicks) {
        return 0.0f;
    }

    protected void m_7546_(T entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
    }

    @Override
    protected boolean m_6512_(T entity) {
        boolean flag;
        float f;
        double d0 = this.f_114476_.m_114471_((Entity)entity);
        float f2 = f = entity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        boolean bl = flag = !entity.m_20177_((Player)localplayer);
        if (entity != localplayer) {
            Team team = entity.m_5647_();
            Team team1 = localplayer.m_5647_();
            if (team != null) {
                Team.Visibility team$visibility = team.m_7470_();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.m_83536_(team1) && (team.m_6259_() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.m_83536_(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && entity != minecraft.m_91288_() && flag && !entity.m_20160_();
    }

    public List<RenderLayer> getLayerRenderers() {
        return this.f_115291_;
    }
}

