/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.AxolotlRenderer;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.CaveSpiderRenderer;
import net.minecraft.client.renderer.entity.ChestedHorseRenderer;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.DragonFireballRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.ElderGuardianRenderer;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EvokerFangsRenderer;
import net.minecraft.client.renderer.entity.EvokerRenderer;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.FireworkEntityRenderer;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.GiantMobRenderer;
import net.minecraft.client.renderer.entity.GlowSquidRenderer;
import net.minecraft.client.renderer.entity.GoatRenderer;
import net.minecraft.client.renderer.entity.GuardianRenderer;
import net.minecraft.client.renderer.entity.HoglinRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.HuskRenderer;
import net.minecraft.client.renderer.entity.IllusionerRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.LeashKnotRenderer;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.LlamaSpitRenderer;
import net.minecraft.client.renderer.entity.MagmaCubeRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.MushroomCowRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.OcelotRenderer;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.PillagerRenderer;
import net.minecraft.client.renderer.entity.PolarBearRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.RavagerRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.ShulkerBulletRenderer;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.SilverfishRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.SnowGolemRenderer;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.client.renderer.entity.TippableArrowRenderer;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.entity.TntRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.TurtleRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.VindicatorRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.WitchRenderer;
import net.minecraft.client.renderer.entity.WitherBossRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZoglinRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.optifine.player.PlayerItemsLayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityRenderers {
    private static final Logger f_208806_ = LogManager.getLogger();
    public static final String f_316549_ = "default";
    private static final Map<EntityType<?>, EntityRendererProvider<?>> f_208807_ = Maps.newHashMap();
    private static final Map<String, EntityRendererProvider<AbstractClientPlayer>> f_208808_ = ImmutableMap.of((Object)"default", p_208872_0_ -> {
        PlayerRenderer playerRenderer = new PlayerRenderer(p_208872_0_, false);
        playerRenderer.m_115326_((RenderLayer)((Object)new PlayerItemsLayer(playerRenderer)));
        return playerRenderer;
    }, (Object)"slim", p_208870_0_ -> {
        PlayerRenderer playerRenderer = new PlayerRenderer(p_208870_0_, true);
        playerRenderer.m_115326_((RenderLayer)((Object)new PlayerItemsLayer(playerRenderer)));
        return playerRenderer;
    });

    private static <T extends Entity> void m_208811_(EntityType<? extends T> p_208811_0_, EntityRendererProvider<T> p_208811_1_) {
        f_208807_.put(p_208811_0_, p_208811_1_);
    }

    public static Map<EntityType<?>, EntityRenderer<?>> m_208824_(EntityRendererProvider.Context p_208824_0_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        f_208807_.forEach((p_208814_2_, p_208814_3_) -> {
            try {
                builder.put(p_208814_2_, (Object)p_208814_3_.m_208786_(p_208824_0_));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create model for " + Registry.f_122826_.m_7981_(p_208814_2_), exception);
            }
        });
        return builder.build();
    }

    public static Map<String, EntityRenderer<? extends Player>> m_208826_(EntityRendererProvider.Context p_208826_0_) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        f_208808_.forEach((p_208819_2_, p_208819_3_) -> {
            try {
                builder.put(p_208819_2_, (Object)p_208819_3_.m_208786_(p_208826_0_));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create player model for " + p_208819_2_, exception);
            }
        });
        return builder.build();
    }

    public static boolean m_208810_() {
        boolean flag = true;
        for (EntityType entitytype : Registry.f_122826_) {
            if (entitytype == EntityType.f_20532_ || f_208807_.containsKey(entitytype)) continue;
            f_208806_.warn("No renderer registered for {}", (Object)Registry.f_122826_.m_7981_((Object)entitytype));
            flag = false;
        }
        return !flag;
    }

    static {
        EntityRenderers.m_208811_(EntityType.f_20476_, NoopRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20529_, ArmorStandRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20548_, TippableArrowRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_149839_, AxolotlRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20549_, BatRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20550_, BeeRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20551_, BlazeRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20552_, BoatRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20553_, CatRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20554_, CaveSpiderRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20470_, p_208868_0_ -> new MinecartRenderer(p_208868_0_, ModelLayers.f_201567_));
        EntityRenderers.m_208811_(EntityType.f_20555_, ChickenRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20556_, CodRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20471_, p_208866_0_ -> new MinecartRenderer(p_208866_0_, ModelLayers.f_201570_));
        EntityRenderers.m_208811_(EntityType.f_20557_, CowRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20558_, CreeperRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20559_, DolphinRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20560_, p_208864_0_ -> new ChestedHorseRenderer(p_208864_0_, 0.87f, ModelLayers.f_201425_));
        EntityRenderers.m_208811_(EntityType.f_20561_, DragonFireballRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20562_, DrownedRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20483_, ThrownItemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20563_, ElderGuardianRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20566_, EndermanRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20567_, EndermiteRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20565_, EnderDragonRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20484_, ThrownItemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20564_, EndCrystalRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20568_, EvokerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20569_, EvokerFangsRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20485_, ThrownItemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20570_, ExperienceOrbRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20571_, p_208862_0_ -> new ThrownItemRenderer(p_208862_0_, 1.0f, true));
        EntityRenderers.m_208811_(EntityType.f_20450_, FallingBlockRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20463_, p_208860_0_ -> new ThrownItemRenderer(p_208860_0_, 3.0f, true));
        EntityRenderers.m_208811_(EntityType.f_20451_, FireworkEntityRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20533_, FishingHookRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20452_, FoxRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20472_, p_208858_0_ -> new MinecartRenderer(p_208858_0_, ModelLayers.f_201442_));
        EntityRenderers.m_208811_(EntityType.f_20453_, GhastRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20454_, p_208856_0_ -> new GiantMobRenderer(p_208856_0_, 6.0f));
        EntityRenderers.m_208811_(EntityType.f_149837_, ItemFrameRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_149838_, p_208854_0_ -> new GlowSquidRenderer(p_208854_0_, new SquidModel(p_208854_0_.m_208800_(ModelLayers.f_201447_))));
        EntityRenderers.m_208811_(EntityType.f_302928_, GoatRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20455_, GuardianRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20456_, HoglinRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20473_, p_208852_0_ -> new MinecartRenderer(p_208852_0_, ModelLayers.f_201477_));
        EntityRenderers.m_208811_(EntityType.f_20457_, HorseRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20458_, HuskRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20459_, IllusionerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20460_, IronGolemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20461_, ItemEntityRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20462_, ItemFrameRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20464_, LeashKnotRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20465_, LightningBoltRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20466_, p_208850_0_ -> new LlamaRenderer(p_208850_0_, ModelLayers.f_201486_));
        EntityRenderers.m_208811_(EntityType.f_20467_, LlamaSpitRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20468_, MagmaCubeRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_302929_, NoopRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20469_, p_208848_0_ -> new MinecartRenderer(p_208848_0_, ModelLayers.f_201490_));
        EntityRenderers.m_208811_(EntityType.f_20504_, MushroomCowRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20503_, p_208846_0_ -> new ChestedHorseRenderer(p_208846_0_, 0.92f, ModelLayers.f_201492_));
        EntityRenderers.m_208811_(EntityType.f_20505_, OcelotRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20506_, PaintingRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20507_, PandaRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20508_, ParrotRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20509_, PhantomRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20510_, PigRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20511_, p_208844_0_ -> new PiglinRenderer(p_208844_0_, ModelLayers.f_201498_, ModelLayers.f_201450_, ModelLayers.f_201451_, false));
        EntityRenderers.m_208811_(EntityType.f_20512_, p_208842_0_ -> new PiglinRenderer(p_208842_0_, ModelLayers.f_201499_, ModelLayers.f_201500_, ModelLayers.f_201449_, false));
        EntityRenderers.m_208811_(EntityType.f_20513_, PillagerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20514_, PolarBearRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20486_, ThrownItemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20516_, PufferfishRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20517_, RabbitRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20518_, RavagerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20519_, SalmonRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20520_, SheepRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20521_, ShulkerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20522_, ShulkerBulletRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20523_, SilverfishRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20524_, SkeletonRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20525_, p_208840_0_ -> new UndeadHorseRenderer(p_208840_0_, ModelLayers.f_201528_));
        EntityRenderers.m_208811_(EntityType.f_20526_, SlimeRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20527_, p_208838_0_ -> new ThrownItemRenderer(p_208838_0_, 0.75f, true));
        EntityRenderers.m_208811_(EntityType.f_20477_, ThrownItemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20528_, SnowGolemRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20474_, p_208836_0_ -> new MinecartRenderer(p_208836_0_, ModelLayers.f_201535_));
        EntityRenderers.m_208811_(EntityType.f_20478_, SpectralArrowRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20479_, SpiderRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20480_, p_208834_0_ -> new SquidRenderer(p_208834_0_, new SquidModel(p_208834_0_.m_208800_(ModelLayers.f_201537_))));
        EntityRenderers.m_208811_(EntityType.f_20481_, StrayRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20482_, StriderRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20515_, TntRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20475_, TntMinecartRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20488_, p_208832_0_ -> new LlamaRenderer(p_208832_0_, ModelLayers.f_201545_));
        EntityRenderers.m_208811_(EntityType.f_20487_, ThrownTridentRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20489_, TropicalFishRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20490_, TurtleRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20491_, VexRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20492_, VillagerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20493_, VindicatorRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20494_, WanderingTraderRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20495_, WitchRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20496_, WitherBossRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20497_, WitherSkeletonRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20498_, WitherSkullRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20499_, WolfRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20500_, ZoglinRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20501_, ZombieRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20502_, p_208830_0_ -> new UndeadHorseRenderer(p_208830_0_, ModelLayers.f_201517_));
        EntityRenderers.m_208811_(EntityType.f_20530_, ZombieVillagerRenderer::new);
        EntityRenderers.m_208811_(EntityType.f_20531_, p_208828_0_ -> new PiglinRenderer(p_208828_0_, ModelLayers.f_201523_, ModelLayers.f_201524_, ModelLayers.f_201525_, true));
    }
}

