/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.culling;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.world.phys.AABB;
import net.optifine.render.ICamera;

public class Frustum
implements ICamera {
    private final Vector4f[] f_112995_ = new Vector4f[6];
    private double f_112996_;
    private double f_112997_;
    private double f_112998_;
    public boolean disabled = false;

    public Frustum(Matrix4f matrixIn, Matrix4f projectionIn) {
        this.m_113026_(matrixIn, projectionIn);
    }

    public void m_113002_(double camX, double camY, double camZ) {
        this.f_112996_ = camX;
        this.f_112997_ = camY;
        this.f_112998_ = camZ;
    }

    private void m_113026_(Matrix4f matrixIn, Matrix4f projectionIn) {
        Matrix4f matrix4f = projectionIn.m_27658_();
        matrix4f.m_27644_(matrixIn);
        matrix4f.m_27659_();
        this.m_113020_(matrix4f, -1, 0, 0, 0);
        this.m_113020_(matrix4f, 1, 0, 0, 1);
        this.m_113020_(matrix4f, 0, -1, 0, 2);
        this.m_113020_(matrix4f, 0, 1, 0, 3);
        this.m_113020_(matrix4f, 0, 0, -1, 4);
        this.m_113020_(matrix4f, 0, 0, 1, 5);
    }

    private void m_113020_(Matrix4f p_113020_1_, int p_113020_2_, int p_113020_3_, int p_113020_4_, int p_113020_5_) {
        Vector4f vector4f = new Vector4f((float)p_113020_2_, (float)p_113020_3_, (float)p_113020_4_, 1.0f);
        vector4f.m_123607_(p_113020_1_);
        vector4f.m_123618_();
        this.f_112995_[p_113020_5_] = vector4f;
    }

    public boolean m_113029_(AABB aabbIn) {
        return this.m_113006_(aabbIn.f_82288_, aabbIn.f_82289_, aabbIn.f_82290_, aabbIn.f_82291_, aabbIn.f_82292_, aabbIn.f_82293_);
    }

    private boolean m_113006_(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.disabled) {
            return true;
        }
        float f = (float)(minX - this.f_112996_);
        float f1 = (float)(minY - this.f_112997_);
        float f2 = (float)(minZ - this.f_112998_);
        float f3 = (float)(maxX - this.f_112996_);
        float f4 = (float)(maxY - this.f_112997_);
        float f5 = (float)(maxZ - this.f_112998_);
        return this.m_113013_(f, f1, f2, f3, f4, f5);
    }

    private boolean m_113013_(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (int i = 0; i < 6; ++i) {
            float w;
            float z;
            float y;
            Vector4f vector4f = this.f_112995_[i];
            float x = vector4f.m_123601_();
            if (!(x * minX + (y = vector4f.m_123615_()) * minY + (z = vector4f.m_123616_()) * minZ + (w = vector4f.m_123617_()) <= 0.0f) || !(x * maxX + y * minY + z * minZ + w <= 0.0f) || !(x * minX + y * maxY + z * minZ + w <= 0.0f) || !(x * maxX + y * maxY + z * minZ + w <= 0.0f) || !(x * minX + y * minY + z * maxZ + w <= 0.0f) || !(x * maxX + y * minY + z * maxZ + w <= 0.0f) || !(x * minX + y * maxY + z * maxZ + w <= 0.0f) || !(x * maxX + y * maxY + z * maxZ + w <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isBoxInFrustumFully(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.disabled) {
            return true;
        }
        float minXf = (float)minX;
        float minYf = (float)minY;
        float minZf = (float)minZ;
        float maxXf = (float)maxX;
        float maxYf = (float)maxY;
        float maxZf = (float)maxZ;
        for (int i = 0; i < 6; ++i) {
            Vector4f frustumi = this.f_112995_[i];
            float x = frustumi.m_123601_();
            float y = frustumi.m_123615_();
            float z = frustumi.m_123616_();
            float w = frustumi.m_123617_();
            if (!(i < 4 ? x * minXf + y * minYf + z * minZf + w <= 0.0f || x * maxXf + y * minYf + z * minZf + w <= 0.0f || x * minXf + y * maxYf + z * minZf + w <= 0.0f || x * maxXf + y * maxYf + z * minZf + w <= 0.0f || x * minXf + y * minYf + z * maxZf + w <= 0.0f || x * maxXf + y * minYf + z * maxZf + w <= 0.0f || x * minXf + y * maxYf + z * maxZf + w <= 0.0f || x * maxXf + y * maxYf + z * maxZf + w <= 0.0f : x * minXf + y * minYf + z * minZf + w <= 0.0f && x * maxXf + y * minYf + z * minZf + w <= 0.0f && x * minXf + y * maxYf + z * minZf + w <= 0.0f && x * maxXf + y * maxYf + z * minZf + w <= 0.0f && x * minXf + y * minYf + z * maxZf + w <= 0.0f && x * maxXf + y * minYf + z * maxZf + w <= 0.0f && x * minXf + y * maxYf + z * maxZf + w <= 0.0f && x * maxXf + y * maxYf + z * maxZf + w <= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public Vector4f[] getFrustum() {
        return this.f_112995_;
    }
}

