/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.optifine.BetterSnow;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.EmissiveTextures;
import net.optifine.model.BlockModelCustomizer;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.BlockUtils;

public class ModelBlockRenderer {
    private static final int f_316326_ = 0;
    private static final int f_316327_ = 1;
    static final Direction[] f_206446_ = Direction.values();
    private final BlockColors f_110995_;
    private static final int f_316328_ = 100;
    static final ThreadLocal<Cache> f_110996_ = ThreadLocal.withInitial(() -> new Cache());
    private static float aoLightValueOpaque = 0.2f;
    private static boolean separateAoLightValue = false;
    private static final LightCacheOF LIGHT_CACHE_OF = new LightCacheOF();
    private static final RenderType[] OVERLAY_LAYERS = new RenderType[]{RenderTypes.CUTOUT, RenderTypes.CUTOUT_MIPPED, RenderTypes.TRANSLUCENT};
    private boolean forgeModelData = Reflector.ForgeHooksClient.exists();

    public ModelBlockRenderer(BlockColors blockColorsIn) {
        this.f_110995_ = blockColorsIn;
    }

    public boolean m_111047_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.tesselateBlock(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, EmptyModelData.INSTANCE);
    }

    public boolean tesselateBlock(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag;
        boolean bl = flag = Minecraft.m_91086_() && ReflectorForge.getLightValue((BlockState)stateIn, (BlockAndTintGetter)worldIn, (BlockPos)posIn) == 0 && modelIn.m_7541_();
        if (this.forgeModelData) {
            modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        }
        Vec3 vec3 = stateIn.m_60824_((BlockGetter)worldIn, posIn);
        matrixIn.m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        try {
            boolean rendered;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity((BlockState)stateIn, (VertexConsumer)buffer);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
            modelIn = BlockModelCustomizer.getRenderModel((BakedModel)modelIn, (BlockState)stateIn, (RenderEnv)renderEnv);
            boolean bl2 = rendered = flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
            if (rendered) {
                this.renderOverlayModels(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, combinedOverlayIn, checkSides, randomIn, rand, renderEnv, flag, vec3);
            }
            if (Config.isShaders()) {
                SVertexBuilder.popEntity((VertexConsumer)buffer);
            }
            return rendered;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block model being tesselated");
            CrashReportCategory.m_216880_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)worldIn, (BlockPos)posIn, (BlockState)stateIn);
            crashreportcategory.m_128159_("Using AO", (Object)flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean m_111078_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List list1;
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getRenderType();
        for (Direction direction : f_206446_) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (BlockGetter)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.m_6840_(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            if (list.isEmpty()) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list, combinedOverlayIn, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, null, randomIn, modelData) : modelIn.m_6840_(stateIn, null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, combinedOverlayIn, renderEnv);
            flag = true;
        }
        return flag;
    }

    public boolean m_111090_(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List list1;
        boolean flag = false;
        RenderEnv renderEnv = buffer.getRenderEnv(stateIn, posIn);
        RenderType layer = buffer.getRenderType();
        for (Direction direction : f_206446_) {
            if (checkSides && !BlockUtils.shouldSideBeRendered((BlockState)stateIn, (BlockGetter)worldIn, (BlockPos)posIn, (Direction)direction, (RenderEnv)renderEnv)) continue;
            randomIn.setSeed(rand);
            List list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.m_6840_(stateIn, direction, randomIn);
            list = BlockModelCustomizer.getRenderQuads((List)list, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, (Direction)direction, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            if (list.isEmpty()) continue;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = renderEnv.getRenderMutableBlockPos();
            blockpos$mutableblockpos.m_122159_((Vec3i)posIn, direction);
            int i = LevelRenderer.m_109537_(worldIn, stateIn, (BlockPos)blockpos$mutableblockpos);
            this.renderQuadsFlat(worldIn, stateIn, posIn, i, combinedOverlayIn, false, matrixStackIn, buffer, list, renderEnv);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, null, randomIn, modelData) : modelIn.m_6840_(stateIn, null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads((List)list1, (BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn, null, (RenderType)layer, (long)rand, (RenderEnv)renderEnv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, renderEnv);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, int combinedOverlayIn, RenderEnv renderEnv) {
        float[] quadBounds = renderEnv.getQuadBounds();
        BitSet bitSet = renderEnv.getBoundsFlags();
        AmbientOcclusionFace aoFace = renderEnv.getAoFace();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = list.get(ix);
            this.m_111039_(blockAccessIn, stateIn, posIn, bakedquad.m_111303_(), bakedquad.m_111306_(), quadBounds, bitSet);
            aoFace.m_111167_(blockAccessIn, stateIn, posIn, bakedquad.m_111306_(), quadBounds, bitSet, bakedquad.m_111307_());
            if (bakedquad.m_316332_().isSpriteEmissive) {
                aoFace.setMaxBlockLight();
            }
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.m_85850_(), bakedquad, aoFace.f_111149_[0], aoFace.f_111149_[1], aoFace.f_111149_[2], aoFace.f_111149_[3], aoFace.f_111150_[0], aoFace.f_111150_[1], aoFace.f_111150_[2], aoFace.f_111150_[3], combinedOverlayIn, renderEnv);
        }
    }

    private void renderQuadSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, VertexConsumer buffer, PoseStack.Pose matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn, RenderEnv renderEnv) {
        float f2;
        float f1;
        float f;
        int colorMultiplier = CustomColors.getColorMultiplier((BakedQuad)quadIn, (BlockState)stateIn, (BlockAndTintGetter)blockAccessIn, (BlockPos)posIn, (RenderEnv)renderEnv);
        if (quadIn.m_111304_() || colorMultiplier != -1) {
            int i = colorMultiplier != -1 ? colorMultiplier : this.f_110995_.m_92577_(stateIn, blockAccessIn, posIn, quadIn.m_111305_());
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        buffer.m_85995_(matrixEntry, quadIn, buffer.getTempFloat4(colorMul0, colorMul1, colorMul2, colorMul3), f, f1, f2, buffer.getTempInt4(brightness0, brightness1, brightness2, brightness3), combinedOverlayIn, true);
    }

    private void m_111039_(BlockAndTintGetter blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * step]);
            float f7 = Float.intBitsToFloat(vertexData[i * step + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * step + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.m_122411_()] = f;
            quadBounds[Direction.EAST.m_122411_()] = f3;
            quadBounds[Direction.DOWN.m_122411_()] = f1;
            quadBounds[Direction.UP.m_122411_()] = f4;
            quadBounds[Direction.NORTH.m_122411_()] = f2;
            quadBounds[Direction.SOUTH.m_122411_()] = f5;
            int j = f_206446_.length;
            quadBounds[Direction.WEST.m_122411_() + j] = 1.0f - f;
            quadBounds[Direction.EAST.m_122411_() + j] = 1.0f - f3;
            quadBounds[Direction.DOWN.m_122411_() + j] = 1.0f - f1;
            quadBounds[Direction.UP.m_122411_() + j] = 1.0f - f4;
            quadBounds[Direction.NORTH.m_122411_() + j] = 1.0f - f2;
            quadBounds[Direction.SOUTH.m_122411_() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f4 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f2 < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f5 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f < 1.0E-4f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f3 > 0.9999f || stateIn.m_60838_((BlockGetter)blockReaderIn, posIn)));
            }
        }
    }

    private void renderQuadsFlat(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        BitSet bitSet = renderEnv.getBoundsFlags();
        int listSize = list.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = list.get(ix);
            if (ownBrightness) {
                this.m_111039_(blockAccessIn, stateIn, posIn, bakedquad.m_111303_(), bakedquad.m_111306_(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.m_299633_(bakedquad.m_111306_()) : posIn;
                brightnessIn = LevelRenderer.m_109537_(blockAccessIn, stateIn, blockpos);
            }
            if (bakedquad.m_316332_().isSpriteEmissive) {
                brightnessIn = LightTexture.MAX_BRIGHTNESS;
            }
            float f = blockAccessIn.m_7717_(bakedquad.m_111306_(), bakedquad.m_111307_());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.m_85850_(), bakedquad, f, f, f, f, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn, renderEnv);
        }
    }

    public void m_111067_(PoseStack.Pose matrixEntry, VertexConsumer buffer, @Nullable BlockState state, BakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn) {
        this.renderModel(matrixEntry, buffer, state, modelIn, red, green, blue, combinedLightIn, combinedOverlayIn, EmptyModelData.INSTANCE);
    }

    public void renderModel(PoseStack.Pose matrixEntry, VertexConsumer buffer, @Nullable BlockState state, BakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : f_206446_) {
            random.setSeed(42L);
            if (this.forgeModelData) {
                ModelBlockRenderer.m_111058_(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn);
                continue;
            }
            ModelBlockRenderer.m_111058_(matrixEntry, buffer, red, green, blue, modelIn.m_6840_(state, direction, random), combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        if (this.forgeModelData) {
            ModelBlockRenderer.m_111058_(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, null, random, modelData), combinedLightIn, combinedOverlayIn);
        } else {
            ModelBlockRenderer.m_111058_(matrixEntry, buffer, red, green, blue, modelIn.m_6840_(state, null, random), combinedLightIn, combinedOverlayIn);
        }
    }

    private static void m_111058_(PoseStack.Pose matrixEntry, VertexConsumer buffer, float red, float green, float blue, List<BakedQuad> listQuads, int combinedLightIn, int combinedOverlayIn) {
        boolean emissive = EmissiveTextures.isActive();
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (emissive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            if (bakedquad.m_111304_()) {
                f = Mth.m_14036_(red, 0.0f, 1.0f);
                f1 = Mth.m_14036_(green, 0.0f, 1.0f);
                f2 = Mth.m_14036_(blue, 0.0f, 1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            buffer.m_85987_(matrixEntry, bakedquad, f, f1, f2, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void m_111000_() {
        f_110996_.get().m_111220_();
    }

    public static void m_111077_() {
        f_110996_.get().m_111225_();
    }

    public static float fixAoLightValue(float val) {
        if (val == 0.2f) {
            return aoLightValueOpaque;
        }
        return val;
    }

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
        separateAoLightValue = Config.isShaders() && Shaders.isSeparateAo();
    }

    public static boolean isSeparateAoLightValue() {
        return separateAoLightValue;
    }

    private void renderOverlayModels(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, int combinedOverlayIn, boolean checkSides, Random random, long rand, RenderEnv renderEnv, boolean smooth, Vec3 renderOffset) {
        if (renderEnv.isOverlaysRendered()) {
            for (int l = 0; l < OVERLAY_LAYERS.length; ++l) {
                RenderType layer = OVERLAY_LAYERS[l];
                ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(layer);
                if (listQuadsOverlay.size() <= 0) continue;
                ChunkBufferBuilderPack rrcb = renderEnv.getRegionRenderCacheBuilder();
                if (rrcb != null) {
                    BufferBuilder overlayBuffer = rrcb.m_108839_(layer);
                    if (!overlayBuffer.m_85732_()) {
                        overlayBuffer.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                    }
                    for (int q = 0; q < listQuadsOverlay.size(); ++q) {
                        BakedQuad quad = listQuadsOverlay.getQuad(q);
                        List listQuadSingle = listQuadsOverlay.getListQuadsSingle(quad);
                        BlockState quadBlockState = listQuadsOverlay.getBlockState(q);
                        if (quad.getQuadEmissive() != null) {
                            listQuadsOverlay.addQuad(quad.getQuadEmissive(), quadBlockState);
                        }
                        renderEnv.reset(quadBlockState, posIn);
                        if (smooth) {
                            this.renderQuadsSmooth(worldIn, quadBlockState, posIn, matrixStackIn, (VertexConsumer)((Object)overlayBuffer), listQuadSingle, combinedOverlayIn, renderEnv);
                            continue;
                        }
                        int col = LevelRenderer.m_109537_(worldIn, quadBlockState, posIn.m_299633_(quad.m_111306_()));
                        this.renderQuadsFlat(worldIn, quadBlockState, posIn, col, combinedOverlayIn, false, matrixStackIn, (VertexConsumer)((Object)overlayBuffer), listQuadSingle, renderEnv);
                    }
                }
                listQuadsOverlay.clear();
            }
        }
        if (Config.isBetterSnow() && !renderEnv.isBreakingAnimation() && BetterSnow.shouldRender((BlockAndTintGetter)worldIn, (BlockState)stateIn, (BlockPos)posIn)) {
            BakedModel modelSnow = BetterSnow.getModelSnowLayer();
            BlockState stateSnow = BetterSnow.getStateSnowLayer();
            matrixStackIn.m_85837_(-renderOffset.f_82479_, -renderOffset.f_82480_, -renderOffset.f_82481_);
            this.m_111047_(worldIn, modelSnow, stateSnow, posIn, matrixStackIn, buffer, checkSides, random, rand, combinedOverlayIn);
        }
    }

    protected static enum SizeInfo {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        final int f_111258_;

        private SizeInfo(Direction facingIn, boolean flip) {
            this.f_111258_ = facingIn.m_122411_() + (flip ? f_206446_.length : 0);
        }
    }

    static class Cache {
        private boolean f_111214_;
        private final Long2IntLinkedOpenHashMap f_111215_ = Util.m_137537_(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap f_111216_ = Util.m_137537_(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });

        private Cache() {
        }

        public void m_111220_() {
            this.f_111214_ = true;
        }

        public void m_111225_() {
            this.f_111214_ = false;
            this.f_111215_.clear();
            this.f_111216_.clear();
        }

        public int m_111221_(BlockState blockStateIn, BlockAndTintGetter lightReaderIn, BlockPos blockPosIn) {
            int j;
            long i = blockPosIn.m_121878_();
            if (this.f_111214_ && (j = this.f_111215_.get(i)) != Integer.MAX_VALUE) {
                return j;
            }
            int k = LevelRenderer.m_109537_(lightReaderIn, blockStateIn, blockPosIn);
            if (this.f_111214_) {
                if (this.f_111215_.size() == 100) {
                    this.f_111215_.removeFirstInt();
                }
                this.f_111215_.put(i, k);
            }
            return k;
        }

        public float m_111226_(BlockState blockStateIn, BlockAndTintGetter lightReaderIn, BlockPos blockPosIn) {
            float f;
            long i = blockPosIn.m_121878_();
            if (this.f_111214_ && !Float.isNaN(f = this.f_111216_.get(i))) {
                return f;
            }
            float f1 = blockStateIn.m_60792_((BlockGetter)lightReaderIn, blockPosIn);
            if (this.f_111214_) {
                if (this.f_111216_.size() == 100) {
                    this.f_111216_.removeFirstFloat();
                }
                this.f_111216_.put(i, f1);
            }
            return f1;
        }
    }

    static enum AmbientVertexRemap {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        final int f_111185_;
        final int f_111186_;
        final int f_111187_;
        final int f_111188_;
        private static final AmbientVertexRemap[] f_111189_;

        private AmbientVertexRemap(int vert0In, int vert1In, int vert2In, int vert3In) {
            this.f_111185_ = vert0In;
            this.f_111186_ = vert1In;
            this.f_111187_ = vert2In;
            this.f_111188_ = vert3In;
        }

        public static AmbientVertexRemap m_111201_(Direction facingIn) {
            return f_111189_[facingIn.m_122411_()];
        }

        static {
            f_111189_ = Util.m_137469_(new AmbientVertexRemap[6], remapIn -> {
                remapIn[Direction.DOWN.m_122411_()] = DOWN;
                remapIn[Direction.UP.m_122411_()] = UP;
                remapIn[Direction.NORTH.m_122411_()] = NORTH;
                remapIn[Direction.SOUTH.m_122411_()] = SOUTH;
                remapIn[Direction.WEST.m_122411_()] = WEST;
                remapIn[Direction.EAST.m_122411_()] = EAST;
            });
        }
    }

    public static class AmbientOcclusionFace {
        final float[] f_111149_ = new float[4];
        final int[] f_111150_ = new int[4];
        private BlockPosM blockPos = new BlockPosM();

        public AmbientOcclusionFace() {
            this(null);
        }

        public AmbientOcclusionFace(ModelBlockRenderer bmr) {
        }

        public void setMaxBlockLight() {
            int maxBlockLight;
            this.f_111150_[0] = maxBlockLight = LightTexture.MAX_BRIGHTNESS;
            this.f_111150_[1] = maxBlockLight;
            this.f_111150_[2] = maxBlockLight;
            this.f_111150_[3] = maxBlockLight;
            this.f_111149_[0] = 1.0f;
            this.f_111149_[1] = 1.0f;
            this.f_111149_[2] = 1.0f;
            this.f_111149_[3] = 1.0f;
        }

        public void m_111167_(BlockAndTintGetter worldIn, BlockState state, BlockPos centerPos, Direction directionIn, float[] faceShape, BitSet shapeState, boolean shadeIn) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = shapeState.get(0) ? centerPos.m_299633_(directionIn) : centerPos;
            AdjacencyInfo modelblockrenderer$adjacencyinfo = AdjacencyInfo.m_111131_(directionIn);
            BlockPosM blockpos$mutableblockpos = this.blockPos;
            LightCacheOF modelblockrenderer$cache = LIGHT_CACHE_OF;
            blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[0]);
            BlockState blockstate = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
            int i = LightCacheOF.getPackedLight((BlockState)blockstate, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            float f = LightCacheOF.getBrightness((BlockState)blockstate, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[1]);
            BlockState blockstate1 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
            int j = LightCacheOF.getPackedLight((BlockState)blockstate1, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            float f1 = LightCacheOF.getBrightness((BlockState)blockstate1, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[2]);
            BlockState blockstate2 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
            int k = LightCacheOF.getPackedLight((BlockState)blockstate2, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            float f2 = LightCacheOF.getBrightness((BlockState)blockstate2, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[3]);
            BlockState blockstate3 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
            int l = LightCacheOF.getPackedLight((BlockState)blockstate3, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            float f3 = LightCacheOF.getBrightness((BlockState)blockstate3, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            BlockState blockstate4 = worldIn.m_8055_(blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[0], directionIn));
            boolean flag = !blockstate4.m_60831_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate4.m_60739_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            BlockState blockstate5 = worldIn.m_8055_(blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[1], directionIn));
            boolean flag1 = !blockstate5.m_60831_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate5.m_60739_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            BlockState blockstate6 = worldIn.m_8055_(blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[2], directionIn));
            boolean flag2 = !blockstate6.m_60831_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate6.m_60739_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            BlockState blockstate7 = worldIn.m_8055_(blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[3], directionIn));
            boolean bl = flag3 = !blockstate7.m_60831_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) || blockstate7.m_60739_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[0], modelblockrenderer$adjacencyinfo.f_111110_[2]);
                BlockState blockstate8 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
                f4 = LightCacheOF.getBrightness((BlockState)blockstate8, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
                i1 = LightCacheOF.getPackedLight((BlockState)blockstate8, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[0], modelblockrenderer$adjacencyinfo.f_111110_[3]);
                BlockState blockstate10 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
                f5 = LightCacheOF.getBrightness((BlockState)blockstate10, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
                j1 = LightCacheOF.getPackedLight((BlockState)blockstate10, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag2 && !flag1) {
                f6 = f;
                k1 = i;
            } else {
                blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[1], modelblockrenderer$adjacencyinfo.f_111110_[2]);
                BlockState blockstate11 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
                f6 = LightCacheOF.getBrightness((BlockState)blockstate11, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
                k1 = LightCacheOF.getPackedLight((BlockState)blockstate11, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag1) {
                f7 = f;
                l1 = i;
            } else {
                blockpos$mutableblockpos.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.f_111110_[1], modelblockrenderer$adjacencyinfo.f_111110_[3]);
                BlockState blockstate12 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
                f7 = LightCacheOF.getBrightness((BlockState)blockstate12, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
                l1 = LightCacheOF.getPackedLight((BlockState)blockstate12, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            int i3 = LightCacheOF.getPackedLight((BlockState)state, (BlockAndTintGetter)worldIn, (BlockPos)centerPos);
            blockpos$mutableblockpos.setPosOffset(centerPos, directionIn);
            BlockState blockstate9 = worldIn.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (shapeState.get(0) || !blockstate9.m_60804_((BlockGetter)worldIn, (BlockPos)blockpos$mutableblockpos)) {
                i3 = LightCacheOF.getPackedLight((BlockState)blockstate9, (BlockAndTintGetter)worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            float f8 = shapeState.get(0) ? LightCacheOF.getBrightness((BlockState)worldIn.m_8055_(blockpos), (BlockAndTintGetter)worldIn, (BlockPos)blockpos) : LightCacheOF.getBrightness((BlockState)worldIn.m_8055_(centerPos), (BlockAndTintGetter)worldIn, (BlockPos)centerPos);
            AmbientVertexRemap modelblockrenderer$ambientvertexremap = AmbientVertexRemap.m_111201_(directionIn);
            if (shapeState.get(1) && modelblockrenderer$adjacencyinfo.f_111111_) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f31 = (f2 + f + f4 + f8) * 0.25f;
                float f32 = (f2 + f1 + f6 + f8) * 0.25f;
                float f33 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = faceShape[modelblockrenderer$adjacencyinfo.f_111112_[0].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111112_[1].f_111258_];
                float f14 = faceShape[modelblockrenderer$adjacencyinfo.f_111112_[2].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111112_[3].f_111258_];
                float f15 = faceShape[modelblockrenderer$adjacencyinfo.f_111112_[4].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111112_[5].f_111258_];
                float f16 = faceShape[modelblockrenderer$adjacencyinfo.f_111112_[6].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111112_[7].f_111258_];
                float f17 = faceShape[modelblockrenderer$adjacencyinfo.f_111113_[0].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111113_[1].f_111258_];
                float f18 = faceShape[modelblockrenderer$adjacencyinfo.f_111113_[2].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111113_[3].f_111258_];
                float f19 = faceShape[modelblockrenderer$adjacencyinfo.f_111113_[4].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111113_[5].f_111258_];
                float f20 = faceShape[modelblockrenderer$adjacencyinfo.f_111113_[6].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111113_[7].f_111258_];
                float f21 = faceShape[modelblockrenderer$adjacencyinfo.f_111114_[0].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111114_[1].f_111258_];
                float f22 = faceShape[modelblockrenderer$adjacencyinfo.f_111114_[2].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111114_[3].f_111258_];
                float f23 = faceShape[modelblockrenderer$adjacencyinfo.f_111114_[4].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111114_[5].f_111258_];
                float f24 = faceShape[modelblockrenderer$adjacencyinfo.f_111114_[6].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111114_[7].f_111258_];
                float f25 = faceShape[modelblockrenderer$adjacencyinfo.f_111115_[0].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111115_[1].f_111258_];
                float f26 = faceShape[modelblockrenderer$adjacencyinfo.f_111115_[2].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111115_[3].f_111258_];
                float f27 = faceShape[modelblockrenderer$adjacencyinfo.f_111115_[4].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111115_[5].f_111258_];
                float f28 = faceShape[modelblockrenderer$adjacencyinfo.f_111115_[6].f_111258_] * faceShape[modelblockrenderer$adjacencyinfo.f_111115_[7].f_111258_];
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111185_] = f29 * f13 + f31 * f14 + f32 * f15 + f33 * f16;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111186_] = f29 * f17 + f31 * f18 + f32 * f19 + f33 * f20;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111187_] = f29 * f21 + f31 * f22 + f32 * f23 + f33 * f24;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111188_] = f29 * f25 + f31 * f26 + f32 * f27 + f33 * f28;
                int i2 = this.m_111153_(l, i, j1, i3);
                int j2 = this.m_111153_(k, i, i1, i3);
                int k2 = this.m_111153_(k, j, k1, i3);
                int l2 = this.m_111153_(l, j, l1, i3);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111185_] = this.m_111158_(i2, j2, k2, l2, f13, f14, f15, f16);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111186_] = this.m_111158_(i2, j2, k2, l2, f17, f18, f19, f20);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111187_] = this.m_111158_(i2, j2, k2, l2, f21, f22, f23, f24);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111188_] = this.m_111158_(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111185_] = this.m_111153_(l, i, j1, i3);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111186_] = this.m_111153_(k, i, i1, i3);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111187_] = this.m_111153_(k, j, k1, i3);
                this.f_111150_[modelblockrenderer$ambientvertexremap.f_111188_] = this.m_111153_(l, j, l1, i3);
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111185_] = f9;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111186_] = f10;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111187_] = f11;
                this.f_111149_[modelblockrenderer$ambientvertexremap.f_111188_] = f12;
            }
            float f30 = worldIn.m_7717_(directionIn, shadeIn);
            int j3 = 0;
            while (j3 < this.f_111149_.length) {
                int n = j3++;
                this.f_111149_[n] = this.f_111149_[n] * f30;
            }
        }

        private int m_111153_(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int m_111158_(int b1, int b2, int b3, int b4, float w1, float w2, float w3, float w4) {
            int i = (int)((float)(b1 >> 16 & 0xFF) * w1 + (float)(b2 >> 16 & 0xFF) * w2 + (float)(b3 >> 16 & 0xFF) * w3 + (float)(b4 >> 16 & 0xFF) * w4) & 0xFF;
            int j = (int)((float)(b1 & 0xFF) * w1 + (float)(b2 & 0xFF) * w2 + (float)(b3 & 0xFF) * w3 + (float)(b4 & 0xFF) * w4) & 0xFF;
            return i << 16 | j;
        }
    }

    protected static enum AdjacencyInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new SizeInfo[]{SizeInfo.EAST, SizeInfo.SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.EAST, SizeInfo.NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.UP, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.DOWN, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.DOWN, SizeInfo.EAST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.UP, SizeInfo.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.UP, SizeInfo.NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.SOUTH});

        final Direction[] f_111110_;
        final boolean f_111111_;
        final SizeInfo[] f_111112_;
        final SizeInfo[] f_111113_;
        final SizeInfo[] f_111114_;
        final SizeInfo[] f_111115_;
        private static final AdjacencyInfo[] f_111116_;

        private AdjacencyInfo(Direction[] cornersIn, float brightness, boolean doNonCubicWeightIn, SizeInfo[] vert0WeightsIn, SizeInfo[] vert1WeightsIn, SizeInfo[] vert2WeightsIn, SizeInfo[] vert3WeightsIn) {
            this.f_111110_ = cornersIn;
            this.f_111111_ = doNonCubicWeightIn;
            this.f_111112_ = vert0WeightsIn;
            this.f_111113_ = vert1WeightsIn;
            this.f_111114_ = vert2WeightsIn;
            this.f_111115_ = vert3WeightsIn;
        }

        public static AdjacencyInfo m_111131_(Direction facing) {
            return f_111116_[facing.m_122411_()];
        }

        static {
            f_111116_ = Util.m_137469_(new AdjacencyInfo[6], infoIn -> {
                infoIn[Direction.DOWN.m_122411_()] = DOWN;
                infoIn[Direction.UP.m_122411_()] = UP;
                infoIn[Direction.NORTH.m_122411_()] = NORTH;
                infoIn[Direction.SOUTH.m_122411_()] = SOUTH;
                infoIn[Direction.WEST.m_122411_()] = WEST;
                infoIn[Direction.EAST.m_122411_()] = EAST;
            });
        }
    }
}

