/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;

public class LiquidBlockRenderer {
    private static final float f_316325_ = 0.8888889f;
    private final TextureAtlasSprite[] f_110940_ = new TextureAtlasSprite[2];
    private final TextureAtlasSprite[] f_110941_ = new TextureAtlasSprite[2];
    private TextureAtlasSprite f_110942_;

    protected void m_110944_() {
        this.f_110940_[0] = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49991_.m_49966_()).m_6160_();
        this.f_110940_[1] = ModelBakery.f_119221_.m_119204_();
        this.f_110941_[0] = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(Blocks.f_49990_.m_49966_()).m_6160_();
        this.f_110941_[1] = ModelBakery.f_119222_.m_119204_();
        this.f_110942_ = ModelBakery.f_119223_.m_119204_();
    }

    private static boolean m_110973_(BlockGetter worldIn, BlockPos pos, Direction side, FluidState state) {
        BlockPos blockpos = pos.m_299633_(side);
        FluidState fluidstate = worldIn.m_6425_(blockpos);
        return fluidstate.m_76152_().m_6212_(state.m_76152_());
    }

    private static boolean m_110978_(BlockGetter reader, Direction face, float heightIn, BlockPos pos, BlockState blockState) {
        if (blockState.m_60815_()) {
            VoxelShape voxelshape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)heightIn, (double)1.0);
            VoxelShape voxelshape1 = blockState.m_60768_(reader, pos);
            return Shapes.m_83117_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)face);
        }
        return false;
    }

    private static boolean m_110968_(BlockGetter reader, BlockPos pos, Direction face, float heightIn) {
        BlockPos blockpos = pos.m_299633_(face);
        BlockState blockstate = reader.m_8055_(blockpos);
        return LiquidBlockRenderer.m_110978_(reader, face, heightIn, blockpos, blockstate);
    }

    private static boolean m_110959_(BlockGetter reader, BlockPos pos, BlockState blockState, Direction face) {
        return LiquidBlockRenderer.m_110978_(reader, face.m_122424_(), 1.0f, pos, blockState);
    }

    public static boolean m_110948_(BlockAndTintGetter reader, BlockPos pos, FluidState fluidStateIn, BlockState blockStateIn, Direction sideIn) {
        return !LiquidBlockRenderer.m_110959_((BlockGetter)reader, pos, blockStateIn, sideIn) && !LiquidBlockRenderer.m_110973_((BlockGetter)reader, pos, sideIn, fluidStateIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_110954_(BlockAndTintGetter lightReaderIn, BlockPos posIn, VertexConsumer vertexBuilderIn, FluidState fluidStateIn) {
        BlockState blockStateIn = fluidStateIn.m_76188_();
        try {
            float f12;
            Object fluidAttributes;
            TextureAtlasSprite[] forgeFluidSprites;
            boolean flag;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity((BlockState)blockStateIn, (VertexConsumer)vertexBuilderIn);
            }
            TextureAtlasSprite[] atextureatlassprite = (flag = fluidStateIn.m_76153_((Tag)FluidTags.f_13132_)) ? this.f_110940_ : this.f_110941_;
            BlockState blockstate = lightReaderIn.m_8055_(posIn);
            if (Reflector.ForgeHooksClient_getFluidSprites.exists() && (forgeFluidSprites = (TextureAtlasSprite[])Reflector.call(Reflector.ForgeHooksClient_getFluidSprites, lightReaderIn, posIn, fluidStateIn)) != null) {
                atextureatlassprite = forgeFluidSprites;
            }
            RenderEnv renderEnv = vertexBuilderIn.getRenderEnv(blockStateIn, posIn);
            int i = -1;
            float alpha = 1.0f;
            if (Reflector.IForgeFluid_getAttributes.exists() && (fluidAttributes = Reflector.call(fluidStateIn.m_76152_(), Reflector.IForgeFluid_getAttributes, new Object[0])) != null && Reflector.FluidAttributes_getColor.exists()) {
                i = Reflector.callInt(fluidAttributes, Reflector.FluidAttributes_getColor, lightReaderIn, posIn);
                alpha = (float)(i >> 24 & 0xFF) / 255.0f;
            }
            boolean flag1 = !LiquidBlockRenderer.m_110973_((BlockGetter)lightReaderIn, posIn, Direction.UP, fluidStateIn);
            boolean flag2 = LiquidBlockRenderer.m_110948_(lightReaderIn, posIn, fluidStateIn, blockstate, Direction.DOWN) && !LiquidBlockRenderer.m_110968_((BlockGetter)lightReaderIn, posIn, Direction.DOWN, 0.8888889f);
            boolean flag3 = LiquidBlockRenderer.m_110948_(lightReaderIn, posIn, fluidStateIn, blockstate, Direction.NORTH);
            boolean flag4 = LiquidBlockRenderer.m_110948_(lightReaderIn, posIn, fluidStateIn, blockstate, Direction.SOUTH);
            boolean flag5 = LiquidBlockRenderer.m_110948_(lightReaderIn, posIn, fluidStateIn, blockstate, Direction.WEST);
            boolean flag6 = LiquidBlockRenderer.m_110948_(lightReaderIn, posIn, fluidStateIn, blockstate, Direction.EAST);
            if (!(flag1 || flag2 || flag6 || flag5 || flag3 || flag4)) {
                boolean bl = false;
                return bl;
            }
            if (i < 0) {
                i = CustomColors.getFluidColor((BlockAndTintGetter)lightReaderIn, (BlockState)blockStateIn, (BlockPos)posIn, (RenderEnv)renderEnv);
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            boolean flag7 = false;
            float f3 = lightReaderIn.m_7717_(Direction.DOWN, true);
            float f4 = lightReaderIn.m_7717_(Direction.UP, true);
            float f5 = lightReaderIn.m_7717_(Direction.NORTH, true);
            float f6 = lightReaderIn.m_7717_(Direction.WEST, true);
            float f7 = this.m_110964_((BlockGetter)lightReaderIn, posIn, fluidStateIn.m_76152_());
            float f8 = this.m_110964_((BlockGetter)lightReaderIn, posIn.m_299523_(), fluidStateIn.m_76152_());
            float f9 = this.m_110964_((BlockGetter)lightReaderIn, posIn.m_299521_().m_299523_(), fluidStateIn.m_76152_());
            float f10 = this.m_110964_((BlockGetter)lightReaderIn, posIn.m_299521_(), fluidStateIn.m_76152_());
            double d0 = posIn.m_123341_() & 0xF;
            double d1 = posIn.m_123342_() & 0xF;
            double d2 = posIn.m_123343_() & 0xF;
            if (Config.isRenderRegions()) {
                int chunkX = posIn.m_123341_() >> 4 << 4;
                int chunkY = posIn.m_123342_() >> 4 << 4;
                int chunkZ = posIn.m_123343_() >> 4 << 4;
                int bits = 8;
                int regionX = chunkX >> bits << bits;
                int regionZ = chunkZ >> bits << bits;
                int dx = chunkX - regionX;
                int dy = chunkY;
                int dz = chunkZ - regionZ;
                d0 += (double)dx;
                d1 += (double)dy;
                d2 += (double)dz;
            }
            if (Config.isShaders() && Shaders.useMidBlockAttrib) {
                vertexBuilderIn.setMidBlock((float)(d0 + 0.5), (float)(d1 + 0.5), (float)(d2 + 0.5));
            }
            float f11 = 0.001f;
            float f13 = f12 = flag2 ? 0.001f : 0.0f;
            if (flag1 && !LiquidBlockRenderer.m_110968_((BlockGetter)lightReaderIn, posIn, Direction.UP, Math.min(Math.min(f7, f8), Math.min(f9, f10)))) {
                float f20;
                float f16;
                float f19;
                float f15;
                float f18;
                float f14;
                float f17;
                float f132;
                flag7 = true;
                f7 -= 0.001f;
                f8 -= 0.001f;
                f9 -= 0.001f;
                f10 -= 0.001f;
                Vec3 vec3 = fluidStateIn.m_76179_((BlockGetter)lightReaderIn, posIn);
                if (vec3.f_82479_ == 0.0 && vec3.f_82481_ == 0.0) {
                    TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                    vertexBuilderIn.setSprite(textureatlassprite1);
                    f132 = textureatlassprite1.m_118367_(0.0);
                    f17 = textureatlassprite1.m_118393_(0.0);
                    f14 = f132;
                    f18 = textureatlassprite1.m_118393_(16.0);
                    f15 = textureatlassprite1.m_118367_(16.0);
                    f19 = f18;
                    f16 = f15;
                    f20 = f17;
                } else {
                    TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                    vertexBuilderIn.setSprite(textureatlassprite);
                    float f21 = (float)Mth.m_14136_(vec3.f_82481_, vec3.f_82479_) - 1.5707964f;
                    float f22 = Mth.m_14031_(f21) * 0.25f;
                    float f23 = Mth.m_14089_(f21) * 0.25f;
                    float f24 = 8.0f;
                    f132 = textureatlassprite.m_118367_(8.0f + (-f23 - f22) * 16.0f);
                    f17 = textureatlassprite.m_118393_(8.0f + (-f23 + f22) * 16.0f);
                    f14 = textureatlassprite.m_118367_(8.0f + (-f23 + f22) * 16.0f);
                    f18 = textureatlassprite.m_118393_(8.0f + (f23 + f22) * 16.0f);
                    f15 = textureatlassprite.m_118367_(8.0f + (f23 + f22) * 16.0f);
                    f19 = textureatlassprite.m_118393_(8.0f + (f23 - f22) * 16.0f);
                    f16 = textureatlassprite.m_118367_(8.0f + (f23 - f22) * 16.0f);
                    f20 = textureatlassprite.m_118393_(8.0f + (-f23 - f22) * 16.0f);
                }
                float f44 = (f132 + f14 + f15 + f16) / 4.0f;
                float f45 = (f17 + f18 + f19 + f20) / 4.0f;
                float f46 = (float)atextureatlassprite[0].m_118405_() / (atextureatlassprite[0].m_118410_() - atextureatlassprite[0].m_118409_());
                float f47 = (float)atextureatlassprite[0].m_118408_() / (atextureatlassprite[0].m_118412_() - atextureatlassprite[0].m_118411_());
                float f48 = 4.0f / Math.max(f47, f46);
                f132 = Mth.m_14179_(f48, f132, f44);
                f14 = Mth.m_14179_(f48, f14, f44);
                f15 = Mth.m_14179_(f48, f15, f44);
                f16 = Mth.m_14179_(f48, f16, f44);
                f17 = Mth.m_14179_(f48, f17, f45);
                f18 = Mth.m_14179_(f48, f18, f45);
                f19 = Mth.m_14179_(f48, f19, f45);
                f20 = Mth.m_14179_(f48, f20, f45);
                int j = this.m_110945_(lightReaderIn, posIn);
                float f25 = f4 * f;
                float f26 = f4 * f1;
                float f27 = f4 * f2;
                this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f25, f26, f27, alpha, f132, f17, j);
                this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f25, f26, f27, alpha, f14, f18, j);
                this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f25, f26, f27, alpha, f15, f19, j);
                this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f25, f26, f27, alpha, f16, f20, j);
                if (fluidStateIn.m_76171_((BlockGetter)lightReaderIn, posIn.m_7494_())) {
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f7, d2 + 0.0, f25, f26, f27, alpha, f132, f17, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f10, d2 + 0.0, f25, f26, f27, alpha, f16, f20, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f9, d2 + 1.0, f25, f26, f27, alpha, f15, f19, j);
                    this.vertexVanilla(vertexBuilderIn, d0 + 0.0, d1 + (double)f8, d2 + 1.0, f25, f26, f27, alpha, f14, f18, j);
                }
            }
            if (flag2) {
                vertexBuilderIn.setSprite(atextureatlassprite[0]);
                float f35 = atextureatlassprite[0].m_118409_();
                float f36 = atextureatlassprite[0].m_118410_();
                float f37 = atextureatlassprite[0].m_118411_();
                float f39 = atextureatlassprite[0].m_118412_();
                int i1 = this.m_110945_(lightReaderIn, posIn.m_7495_());
                float fbr = lightReaderIn.m_7717_(Direction.DOWN, true);
                float f41 = fbr * f;
                float f42 = fbr * f1;
                float f43 = fbr * f2;
                this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f12, d2 + 1.0, f41, f42, f43, alpha, f35, f39, i1);
                this.vertexVanilla(vertexBuilderIn, d0, d1 + (double)f12, d2, f41, f42, f43, alpha, f35, f37, i1);
                this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2, f41, f42, f43, alpha, f36, f37, i1);
                this.vertexVanilla(vertexBuilderIn, d0 + 1.0, d1 + (double)f12, d2 + 1.0, f41, f42, f43, alpha, f36, f39, i1);
                flag7 = true;
            }
            int k = this.m_110945_(lightReaderIn, posIn);
            for (int l = 0; l < 4; ++l) {
                boolean notLava;
                boolean flag8;
                Direction direction;
                double d6;
                double d4;
                double d5;
                double d3;
                float f40;
                float f38;
                if (l == 0) {
                    f38 = f7;
                    f40 = f10;
                    d3 = d0;
                    d5 = d0 + 1.0;
                    d4 = d2 + (double)0.001f;
                    d6 = d2 + (double)0.001f;
                    direction = Direction.NORTH;
                    flag8 = flag3;
                } else if (l == 1) {
                    f38 = f9;
                    f40 = f8;
                    d3 = d0 + 1.0;
                    d5 = d0;
                    d4 = d2 + 1.0 - (double)0.001f;
                    d6 = d2 + 1.0 - (double)0.001f;
                    direction = Direction.SOUTH;
                    flag8 = flag4;
                } else if (l == 2) {
                    f38 = f8;
                    f40 = f7;
                    d3 = d0 + (double)0.001f;
                    d5 = d0 + (double)0.001f;
                    d4 = d2 + 1.0;
                    d6 = d2;
                    direction = Direction.WEST;
                    flag8 = flag5;
                } else {
                    f38 = f10;
                    f40 = f9;
                    d3 = d0 + 1.0 - (double)0.001f;
                    d5 = d0 + 1.0 - (double)0.001f;
                    d4 = d2;
                    d6 = d2 + 1.0;
                    direction = Direction.EAST;
                    flag8 = flag6;
                }
                if (!flag8 || LiquidBlockRenderer.m_110968_((BlockGetter)lightReaderIn, posIn, direction, Math.max(f38, f40))) continue;
                flag7 = true;
                BlockPos blockpos = posIn.m_299633_(direction);
                TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
                float yMin1 = 0.0f;
                float yMin2 = 0.0f;
                boolean bl = notLava = !flag;
                if (Reflector.IForgeBlockState_shouldDisplayFluidOverlay.exists()) {
                    boolean bl2 = notLava = atextureatlassprite[2] != null;
                }
                if (notLava) {
                    BlockState blockState = lightReaderIn.m_8055_(blockpos);
                    Block block = blockState.m_60734_();
                    boolean forgeFluidOverlay = false;
                    if (Reflector.IForgeBlockState_shouldDisplayFluidOverlay.exists()) {
                        forgeFluidOverlay = Reflector.callBoolean(blockState, Reflector.IForgeBlockState_shouldDisplayFluidOverlay, lightReaderIn, blockpos, fluidStateIn);
                    }
                    if (forgeFluidOverlay || block instanceof HalfTransparentBlock || block instanceof LeavesBlock || block == Blocks.f_50273_) {
                        textureatlassprite2 = this.f_110942_;
                    }
                    if (block == Blocks.f_50093_ || block == Blocks.f_165558_) {
                        yMin1 = 0.9375f;
                        yMin2 = 0.9375f;
                    }
                    if (block instanceof SlabBlock) {
                        SlabBlock blockSlab = (SlabBlock)block;
                        if (blockState.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM) {
                            yMin1 = 0.5f;
                            yMin2 = 0.5f;
                        }
                    }
                }
                vertexBuilderIn.setSprite(textureatlassprite2);
                if (f38 <= yMin1 && f40 <= yMin2) continue;
                yMin1 = Math.min(yMin1, f38);
                yMin2 = Math.min(yMin2, f40);
                if (yMin1 > f11) {
                    yMin1 -= f11;
                }
                if (yMin2 > f11) {
                    yMin2 -= f11;
                }
                float vMin1 = textureatlassprite2.m_118393_((1.0f - yMin1) * 16.0f * 0.5f);
                float vMin2 = textureatlassprite2.m_118393_((1.0f - yMin2) * 16.0f * 0.5f);
                float f49 = textureatlassprite2.m_118367_(0.0);
                float f50 = textureatlassprite2.m_118367_(8.0);
                float f28 = textureatlassprite2.m_118393_((1.0f - f38) * 16.0f * 0.5f);
                float f29 = textureatlassprite2.m_118393_((1.0f - f40) * 16.0f * 0.5f);
                float f30 = textureatlassprite2.m_118393_(8.0);
                float f31 = l < 2 ? lightReaderIn.m_7717_(Direction.NORTH, true) : lightReaderIn.m_7717_(Direction.WEST, true);
                float f32 = f4 * f31 * f;
                float f33 = f4 * f31 * f1;
                float f34 = f4 * f31 * f2;
                this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f38, d4, f32, f33, f34, alpha, f49, f28, k);
                this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f40, d6, f32, f33, f34, alpha, f50, f29, k);
                this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f12, d6, f32, f33, f34, alpha, f50, vMin2, k);
                this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f12, d4, f32, f33, f34, alpha, f49, vMin1, k);
                if (textureatlassprite2 == this.f_110942_) continue;
                this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f12, d4, f32, f33, f34, alpha, f49, vMin1, k);
                this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f12, d6, f32, f33, f34, alpha, f50, vMin2, k);
                this.vertexVanilla(vertexBuilderIn, d5, d1 + (double)f40, d6, f32, f33, f34, alpha, f50, f29, k);
                this.vertexVanilla(vertexBuilderIn, d3, d1 + (double)f38, d4, f32, f33, f34, alpha, f49, f28, k);
            }
            vertexBuilderIn.setSprite(null);
            boolean bl = flag7;
            return bl;
        }
        finally {
            if (Config.isShaders()) {
                SVertexBuilder.popEntity((VertexConsumer)vertexBuilderIn);
            }
        }
    }

    private void m_110984_(VertexConsumer vertexBuilderIn, double x, double y, double z, float red, float green, float blue, float u, float v, int packedLight) {
        vertexBuilderIn.m_5483_(x, y, z).m_85950_(red, green, blue, 1.0f).m_7421_(u, v).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private void vertexVanilla(VertexConsumer buffer, double x, double y, double z, float red, float green, float blue, float alpha, float u, float v, int combinedLight) {
        buffer.m_5483_(x, y, z).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_85969_(combinedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private int m_110945_(BlockAndTintGetter lightReaderIn, BlockPos posIn) {
        int i = LevelRenderer.m_109541_(lightReaderIn, posIn);
        int j = LevelRenderer.m_109541_(lightReaderIn, posIn.m_7494_());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    private float m_110964_(BlockGetter reader, BlockPos pos, Fluid fluidIn) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.m_224058_(-(j & 1), 0, -(j >> 1 & 1));
            if (reader.m_6425_(blockpos.m_7494_()).m_76152_().m_6212_(fluidIn)) {
                return 1.0f;
            }
            FluidState fluidstate = reader.m_6425_(blockpos);
            if (fluidstate.m_76152_().m_6212_(fluidIn)) {
                float f1 = fluidstate.m_76155_(reader, blockpos);
                if (f1 >= 0.8f) {
                    f += f1 * 10.0f;
                    i += 10;
                    continue;
                }
                f += f1;
                ++i;
                continue;
            }
            if (reader.m_8055_(blockpos).m_60767_().m_76333_()) continue;
            ++i;
        }
        return f / (float)i;
    }
}

