/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.optifine.Config;
import net.optifine.render.RenderUtils;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTex;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderInstance
implements Shader,
AutoCloseable {
    private static final String f_316311_ = "shaders/core/";
    private static final String f_316312_ = "shaders/include/";
    static final Logger f_283108_ = LogManager.getLogger();
    private static final AbstractUniform f_283109_ = new AbstractUniform();
    private static final boolean f_316313_ = true;
    private static ShaderInstance f_283110_;
    private static int f_283111_;
    private final Map<String, Object> f_283112_ = Maps.newHashMap();
    private final List<String> f_283113_ = Lists.newArrayList();
    private final List<Integer> f_283114_ = Lists.newArrayList();
    private final List<Uniform> f_283115_ = Lists.newArrayList();
    private final List<Integer> f_283116_ = Lists.newArrayList();
    private final Map<String, Uniform> f_283117_ = Maps.newHashMap();
    private final int f_283118_;
    private final String f_283119_;
    private boolean f_283120_;
    private final BlendMode f_283089_;
    private final List<Integer> f_283090_;
    private final List<String> f_283091_;
    private final Program f_283092_;
    private final Program f_283093_;
    private final VertexFormat f_283094_;
    @Nullable
    public final Uniform f_283095_;
    @Nullable
    public final Uniform f_283096_;
    @Nullable
    public final Uniform f_283097_;
    @Nullable
    public final Uniform f_283098_;
    @Nullable
    public final Uniform f_283099_;
    @Nullable
    public final Uniform f_283100_;
    @Nullable
    public final Uniform f_283101_;
    @Nullable
    public final Uniform f_283102_;
    @Nullable
    public final Uniform f_283103_;
    @Nullable
    public final Uniform f_283104_;
    @Nullable
    public final Uniform f_283105_;
    @Nullable
    public final Uniform f_283106_;
    @Nullable
    public final Uniform f_283107_;

    public ShaderInstance(ResourceProvider providerIn, String nameIn, VertexFormat formatIn) throws IOException {
        this(providerIn, new ResourceLocation(nameIn), formatIn);
    }

    public ShaderInstance(ResourceProvider providerIn, ResourceLocation shaderLocation, VertexFormat formatIn) throws IOException {
        this.f_283119_ = shaderLocation.m_135827_().equals("minecraft") ? shaderLocation.m_135815_() : shaderLocation.toString();
        this.f_283094_ = formatIn;
        ResourceLocation resourcelocation = new ResourceLocation(shaderLocation.m_135827_(), f_316311_ + shaderLocation.m_135815_() + ".json");
        Resource resource = null;
        try {
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            resource = providerIn.m_223800_(resourcelocation);
            JsonObject jsonobject = GsonHelper.m_13859_((Reader)new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"vertex");
            String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.m_283131_((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception2);
                        chainedjsonexception1.m_135908_("samplers[" + i + "]");
                        throw chainedjsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.f_283090_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.f_283091_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.f_283091_.add(GsonHelper.m_13805_((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception1);
                        chainedjsonexception2.m_135908_("attributes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            } else {
                this.f_283090_ = null;
                this.f_283091_ = null;
            }
            if ((jsonarray2 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.m_283141_(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception3.m_135908_("uniforms[" + k + "]");
                        throw chainedjsonexception3;
                    }
                    ++k;
                }
            }
            this.f_283089_ = ShaderInstance.m_283133_(GsonHelper.m_13841_((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.f_283092_ = ShaderInstance.m_283127_(providerIn, Program.Type.VERTEX, s);
            this.f_283093_ = ShaderInstance.m_283127_(providerIn, Program.Type.FRAGMENT, s1);
            this.f_283118_ = ProgramManager.m_85577_();
            if (this.f_283091_ != null) {
                int l = 0;
                for (String s2 : formatIn.m_268657_()) {
                    VertexFormatElement vfe = (VertexFormatElement)this.f_283094_.getElementMapping().get((Object)s2);
                    l = vfe.getAttributeIndex(l);
                    if (l < 0) continue;
                    Uniform.m_268369_((int)this.f_283118_, (int)l, (CharSequence)s2);
                    this.f_283090_.add(l);
                    ++l;
                }
            }
            ProgramManager.m_268345_((Shader)this);
            this.m_283150_();
        }
        catch (Exception exception3) {
            ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception3);
            chainedjsonexception.m_135910_(resourcelocation.m_135815_());
            throw chainedjsonexception;
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
        this.m_224078_();
        this.f_283095_ = this.m_283135_("ModelViewMat");
        this.f_283096_ = this.m_283135_("ProjMat");
        this.f_283097_ = this.m_283135_("TextureMat");
        this.f_283098_ = this.m_283135_("ScreenSize");
        this.f_283099_ = this.m_283135_("ColorModulator");
        this.f_283100_ = this.m_283135_("Light0_Direction");
        this.f_283101_ = this.m_283135_("Light1_Direction");
        this.f_283102_ = this.m_283135_("FogStart");
        this.f_283103_ = this.m_283135_("FogEnd");
        this.f_283104_ = this.m_283135_("FogColor");
        this.f_283105_ = this.m_283135_("LineWidth");
        this.f_283106_ = this.m_283135_("GameTime");
        this.f_283107_ = this.m_283135_("ChunkOffset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Program m_283127_(final ResourceProvider providerIn, Program.Type typeIn, String nameIn) throws IOException {
        Program program;
        Program program1 = typeIn.m_85570_().get(nameIn);
        if (program1 == null) {
            ResourceLocation loc = new ResourceLocation(nameIn);
            String s = f_316311_ + loc.m_135815_() + typeIn.m_85569_();
            ResourceLocation resourcelocation = new ResourceLocation(loc.m_135827_(), s);
            Resource resource = providerIn.m_223800_(resourcelocation);
            final String s1 = FileUtil.m_295541_((String)s);
            try {
                program = Program.m_313026_(typeIn, nameIn, resource.m_6679_(), resource.m_7816_(), new GlslPreprocessor(){
                    private final Set<String> f_283153_ = Sets.newHashSet();

                    public String m_299530_(boolean localIn, String fileIn) {
                        fileIn = FileUtil.m_295547_((String)((localIn ? s1 : ShaderInstance.f_316312_) + fileIn));
                        if (!this.f_283153_.add(fileIn)) {
                            return null;
                        }
                        ResourceLocation resourcelocation1 = new ResourceLocation(fileIn);
                        try {
                            String s2;
                            try (Resource resource1 = providerIn.m_223800_(resourcelocation1);){
                                s2 = IOUtils.toString((InputStream)resource1.m_6679_(), (Charset)StandardCharsets.UTF_8);
                            }
                            return s2;
                        }
                        catch (IOException ioexception) {
                            f_283108_.error("Could not open GLSL import {}: {}", (Object)fileIn, (Object)ioexception.getMessage());
                            return "#error " + ioexception.getMessage();
                        }
                    }
                });
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        } else {
            program = program1;
        }
        return program;
    }

    public static BlendMode m_283133_(JsonObject jsonIn) {
        if (jsonIn == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"func") && (i = BlendMode.m_85527_((String)jsonIn.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcrgb") && (j = BlendMode.m_85530_((String)jsonIn.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstrgb") && (k = BlendMode.m_85530_((String)jsonIn.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcalpha")) {
            l = BlendMode.m_85530_((String)jsonIn.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstalpha")) {
            i1 = BlendMode.m_85530_((String)jsonIn.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.f_283115_) {
            uniform.close();
        }
        ProgramManager.m_268343_((Shader)this);
    }

    public void m_283147_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        f_283111_ = -1;
        f_283110_ = null;
        int i = GlStateManager.m_267903_();
        if (Boolean.FALSE.booleanValue()) {
            for (int j = 0; j < this.f_283114_.size(); ++j) {
                if (this.f_283112_.get(this.f_283113_.get(j)) == null) continue;
                int textureUnit = this.getTextureUnit(this.f_283113_.get(j), j);
                GlStateManager.m_84538_((int)(33984 + textureUnit));
                GlStateManager.m_84544_((int)0);
            }
        }
        GlStateManager.m_84538_((int)i);
    }

    public void m_283148_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        this.f_283120_ = false;
        f_283110_ = this;
        this.f_283089_.m_85526_();
        if (this.f_283118_ != GlStateManager.getProgram()) {
            ProgramManager.m_85578_((int)this.f_283118_);
            f_283111_ = this.f_283118_;
        }
        int i = GlStateManager.m_267903_();
        for (int j = 0; j < this.f_283114_.size(); ++j) {
            String s = this.f_283113_.get(j);
            if (this.f_283112_.get(s) == null) continue;
            int k = Uniform.m_85624_((int)this.f_283118_, (CharSequence)s);
            int textureUnit = this.getTextureUnit(s, j);
            Uniform.m_85616_((int)k, (int)textureUnit);
            RenderSystem.m_69388_((int)(33984 + textureUnit));
            RenderSystem.m_69493_();
            Object object = this.f_283112_.get(s);
            int l = -1;
            if (object instanceof RenderTarget) {
                l = ((RenderTarget)object).m_83975_();
            } else if (object instanceof AbstractTexture) {
                l = ((AbstractTexture)object).m_117963_();
            } else if (object instanceof Integer) {
                l = (Integer)object;
            }
            if (textureUnit == 1 && Shaders.activeProgramID > 0 && Shaders.isOverlayDisabled() || l == -1) continue;
            if (Config.isShaders()) {
                ShadersTex.bindTexture(l);
                continue;
            }
            RenderSystem.m_69396_((int)l);
        }
        GlStateManager.m_84538_((int)i);
        for (Uniform uniform : this.f_283115_) {
            uniform.m_85633_();
        }
        if (Config.isShaders() && Shaders.activeProgramID > 0) {
            GlStateManager.m_84478_((int)Shaders.activeProgramID);
            boolean oldFlush = RenderUtils.setFlushRenderBuffers(false);
            Shaders.uniform_atlasSize.setValue(Shaders.atlasSizeX, Shaders.atlasSizeY);
            RenderUtils.setFlushRenderBuffers(oldFlush);
        }
    }

    public void m_224078_() {
        this.f_283120_ = true;
    }

    @Nullable
    public Uniform m_283135_(String nameIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        return this.f_283117_.get(nameIn);
    }

    public AbstractUniform m_316314_(String nameIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69584_(), ()Ljava/lang/Boolean;)());
        Uniform uniform = this.m_283135_(nameIn);
        return uniform == null ? f_283109_ : uniform;
    }

    private void m_283150_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.f_283113_.size(); ++i) {
            String s = this.f_283113_.get(i);
            int j = Uniform.m_85624_((int)this.f_283118_, (CharSequence)s);
            if (j == -1) {
                f_283108_.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.f_283119_, (Object)s);
                this.f_283112_.remove(s);
                intlist.add(i);
                continue;
            }
            this.f_283114_.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            int i1 = intlist.getInt(l);
            this.f_283113_.remove(i1);
        }
        for (Uniform uniform : this.f_283115_) {
            String s1 = uniform.m_85599_();
            int k = Uniform.m_85624_((int)this.f_283118_, (CharSequence)s1);
            if (k == -1) {
                f_283108_.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.f_283119_, (Object)s1);
                continue;
            }
            this.f_283116_.add(k);
            uniform.m_85614_(k);
            this.f_283117_.put(s1, uniform);
        }
    }

    private void m_283131_(JsonElement jsonElementIn) {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"sampler");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.m_13813_((JsonObject)jsonobject, (String)"file")) {
            this.f_283112_.put(s, null);
            this.f_283113_.add(s);
        } else {
            this.f_283113_.add(s);
        }
    }

    public void m_283137_(String nameIn, Object samplerIn) {
        this.f_283112_.put(nameIn, samplerIn);
        this.m_224078_();
    }

    private void m_283141_(JsonElement jsonElementIn) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(afloat);
        }
        this.f_283115_.add(uniform);
    }

    public Program m_223753_() {
        return this.f_283092_;
    }

    public Program m_223757_() {
        return this.f_283093_;
    }

    public void m_224079_() {
        this.f_283093_.m_268326_(this);
        this.f_283092_.m_268326_(this);
    }

    public VertexFormat m_316316_() {
        return this.f_283094_;
    }

    public String m_316317_() {
        return this.f_283119_;
    }

    public int m_224063_() {
        return this.f_283118_;
    }

    public static void useVanillaProgram() {
        if (f_283111_ > 0) {
            GlStateManager.m_84478_((int)f_283111_);
            return;
        }
    }

    private int getTextureUnit(String sampler, int index) {
        if (sampler.equals("Sampler0")) {
            return 0;
        }
        if (sampler.equals("Sampler1")) {
            return 1;
        }
        if (sampler.equals("Sampler2")) {
            return 2;
        }
        return index;
    }

    public void setSampler(int indexIn, Object samplerIn) {
        String samplerName = ShaderInstance.getSamplerName(indexIn);
        this.m_283137_(samplerName, samplerIn);
    }

    public static String getSamplerName(int indexIn) {
        switch (indexIn) {
            case 0: {
                return "Sampler0";
            }
            case 1: {
                return "Sampler1";
            }
            case 2: {
                return "Sampler2";
            }
            case 3: {
                return "Sampler3";
            }
            case 4: {
                return "Sampler4";
            }
            case 5: {
                return "Sampler5";
            }
            case 6: {
                return "Sampler6";
            }
            case 7: {
                return "Sampler7";
            }
            case 8: {
                return "Sampler8";
            }
            case 9: {
                return "Sampler9";
            }
            case 10: {
                return "Sampler10";
            }
            case 11: {
                return "Sampler11";
            }
        }
        return "Sampler" + indexIn;
    }

    static {
        f_283111_ = -1;
    }
}

