/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.render.GLConst;
import net.optifine.shaders.Shaders;

public class FogRenderer {
    private static final int f_315864_ = 192;
    public static final float f_315863_ = 5000.0f;
    public static float f_109010_;
    public static float f_109011_;
    public static float f_109012_;
    private static int f_109013_;
    private static int f_109014_;
    private static long f_109015_;
    public static boolean fogStandard;

    public static void m_109018_(Camera activeRenderInfoIn, float partialTicks, ClientLevel worldIn, int renderDistanceChunks, float bossColorModifier) {
        Entity renderViewEntity;
        Vec3 colUnderlava;
        FogType fogtype = activeRenderInfoIn.m_192938_();
        Entity entity = activeRenderInfoIn.m_90592_();
        if (fogtype == FogType.WATER) {
            long i = Util.m_137550_();
            int j = worldIn.m_46857_(new BlockPos(activeRenderInfoIn.m_90583_())).m_47561_();
            if (f_109015_ < 0L) {
                f_109013_ = j;
                f_109014_ = j;
                f_109015_ = i;
            }
            int k = f_109013_ >> 16 & 0xFF;
            int l = f_109013_ >> 8 & 0xFF;
            int i1 = f_109013_ & 0xFF;
            int j1 = f_109014_ >> 16 & 0xFF;
            int k1 = f_109014_ >> 8 & 0xFF;
            int l1 = f_109014_ & 0xFF;
            float f = Mth.m_14036_((float)(i - f_109015_) / 5000.0f, 0.0f, 1.0f);
            float f1 = Mth.m_14179_(f, j1, k);
            float f2 = Mth.m_14179_(f, k1, l);
            float f3 = Mth.m_14179_(f, l1, i1);
            f_109010_ = f1 / 255.0f;
            f_109011_ = f2 / 255.0f;
            f_109012_ = f3 / 255.0f;
            if (f_109013_ != j) {
                f_109013_ = j;
                f_109014_ = Mth.m_14143_(f1) << 16 | Mth.m_14143_(f2) << 8 | Mth.m_14143_(f3);
                f_109015_ = i;
            }
        } else if (fogtype == FogType.LAVA) {
            f_109010_ = 0.6f;
            f_109011_ = 0.1f;
            f_109012_ = 0.0f;
            f_109015_ = -1L;
        } else if (fogtype == FogType.POWDER_SNOW) {
            f_109010_ = 0.623f;
            f_109011_ = 0.734f;
            f_109012_ = 0.785f;
            f_109015_ = -1L;
            RenderSystem.m_69424_((float)f_109010_, (float)f_109011_, (float)f_109012_, (float)0.0f);
        } else {
            float f14;
            float f4 = 0.25f + 0.75f * (float)renderDistanceChunks / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = worldIn.m_202072_(activeRenderInfoIn.m_90583_(), partialTicks);
            vec3 = CustomColors.getWorldSkyColor((Vec3)vec3, (Level)worldIn, (Entity)activeRenderInfoIn.m_90592_(), (float)partialTicks);
            float f5 = (float)vec3.f_82479_;
            float f7 = (float)vec3.f_82480_;
            float f9 = (float)vec3.f_82481_;
            float f10 = Mth.m_14036_(Mth.m_14089_(worldIn.m_46942_(partialTicks) * ((float)Math.PI * 2)) * 2.0f + 0.5f, 0.0f, 1.0f);
            BiomeManager biomemanager = worldIn.m_7062_();
            Vec3 vec31 = activeRenderInfoIn.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
            Vec3 vec32 = CubicSampler.m_130038_((Vec3)vec31, (xIn, yIn, zIn) -> worldIn.m_104583_().m_5927_(Vec3.m_82501_((int)biomemanager.m_47873_(xIn, yIn, zIn).m_47539_()), f10));
            vec32 = CustomColors.getWorldFogColor((Vec3)vec32, (Level)worldIn, (Entity)activeRenderInfoIn.m_90592_(), (float)partialTicks);
            f_109010_ = (float)vec32.m_7096_();
            f_109011_ = (float)vec32.m_7098_();
            f_109012_ = (float)vec32.m_7094_();
            if (renderDistanceChunks >= 4) {
                float[] afloat;
                float f11 = Mth.m_14031_(worldIn.m_46490_(partialTicks)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f = new Vector3f(f11, 0.0f, 0.0f);
                float f15 = activeRenderInfoIn.m_90596_().m_122276_(vector3f);
                if (f15 < 0.0f) {
                    f15 = 0.0f;
                }
                if (f15 > 0.0f && (afloat = worldIn.m_104583_().m_7518_(worldIn.m_46942_(partialTicks), partialTicks)) != null) {
                    f_109010_ = f_109010_ * (1.0f - (f15 *= afloat[3])) + afloat[0] * f15;
                    f_109011_ = f_109011_ * (1.0f - f15) + afloat[1] * f15;
                    f_109012_ = f_109012_ * (1.0f - f15) + afloat[2] * f15;
                }
            }
            f_109010_ += (f5 - f_109010_) * f4;
            f_109011_ += (f7 - f_109011_) * f4;
            f_109012_ += (f9 - f_109012_) * f4;
            float f12 = worldIn.m_46722_(partialTicks);
            if (f12 > 0.0f) {
                float f13 = 1.0f - f12 * 0.5f;
                float f16 = 1.0f - f12 * 0.4f;
                f_109010_ *= f13;
                f_109011_ *= f13;
                f_109012_ *= f16;
            }
            if ((f14 = worldIn.m_46661_(partialTicks)) > 0.0f) {
                float f17 = 1.0f - f14 * 0.5f;
                f_109010_ *= f17;
                f_109011_ *= f17;
                f_109012_ *= f17;
            }
            f_109015_ = -1L;
        }
        double d0 = (activeRenderInfoIn.m_90583_().f_82480_ - (double)worldIn.m_141493_()) * worldIn.m_6106_().m_104876_();
        if (activeRenderInfoIn.m_90592_() instanceof LivingEntity && ((LivingEntity)activeRenderInfoIn.m_90592_()).m_21023_(MobEffects.f_19610_)) {
            int i2 = ((LivingEntity)activeRenderInfoIn.m_90592_()).m_21124_(MobEffects.f_19610_).m_19557_();
            d0 = i2 < 20 ? (d0 *= (double)(1.0f - (float)i2 / 20.0f)) : 0.0;
        }
        if (d0 < 1.0 && fogtype != FogType.LAVA) {
            if (d0 < 0.0) {
                d0 = 0.0;
            }
            d0 *= d0;
            f_109010_ = (float)((double)f_109010_ * d0);
            f_109011_ = (float)((double)f_109011_ * d0);
            f_109012_ = (float)((double)f_109012_ * d0);
        }
        if (bossColorModifier > 0.0f) {
            f_109010_ = f_109010_ * (1.0f - bossColorModifier) + f_109010_ * 0.7f * bossColorModifier;
            f_109011_ = f_109011_ * (1.0f - bossColorModifier) + f_109011_ * 0.6f * bossColorModifier;
            f_109012_ = f_109012_ * (1.0f - bossColorModifier) + f_109012_ * 0.6f * bossColorModifier;
        }
        float f6 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).m_108639_() : 1.0f) : (entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19611_) ? GameRenderer.m_109108_((LivingEntity)entity, partialTicks) : 0.0f);
        if (f_109010_ != 0.0f && f_109011_ != 0.0f && f_109012_ != 0.0f) {
            float f8 = Math.min(1.0f / f_109010_, Math.min(1.0f / f_109011_, 1.0f / f_109012_));
            if (Float.isInfinite(f8)) {
                f8 = Math.nextAfter(f8, 0.0);
            }
            f_109010_ = f_109010_ * (1.0f - f6) + f_109010_ * f8 * f6;
            f_109011_ = f_109011_ * (1.0f - f6) + f_109011_ * f8 * f6;
            f_109012_ = f_109012_ * (1.0f - f6) + f_109012_ * f8 * f6;
        }
        if (fogtype == FogType.WATER) {
            Entity renderViewEntity2 = activeRenderInfoIn.m_90592_();
            Vec3 colUnderwater = CustomColors.getUnderwaterColor((BlockAndTintGetter)worldIn, (double)renderViewEntity2.m_20185_(), (double)(renderViewEntity2.m_20186_() + 1.0), (double)renderViewEntity2.m_20189_());
            if (colUnderwater != null) {
                f_109010_ = (float)colUnderwater.f_82479_;
                f_109011_ = (float)colUnderwater.f_82480_;
                f_109012_ = (float)colUnderwater.f_82481_;
            }
        } else if (fogtype == FogType.LAVA && (colUnderlava = CustomColors.getUnderlavaColor((BlockAndTintGetter)worldIn, (double)(renderViewEntity = activeRenderInfoIn.m_90592_()).m_20185_(), (double)(renderViewEntity.m_20186_() + 1.0), (double)renderViewEntity.m_20189_())) != null) {
            f_109010_ = (float)colUnderlava.f_82479_;
            f_109011_ = (float)colUnderlava.f_82480_;
            f_109012_ = (float)colUnderlava.f_82481_;
        }
        if (Reflector.EntityViewRenderEvent_FogColors_Constructor.exists()) {
            Object event = Reflector.newInstance(Reflector.EntityViewRenderEvent_FogColors_Constructor, activeRenderInfoIn, Float.valueOf(partialTicks), Float.valueOf(f_109010_), Float.valueOf(f_109011_), Float.valueOf(f_109012_));
            Reflector.postForgeBusEvent(event);
            f_109010_ = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getRed, new Object[0]);
            f_109011_ = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getGreen, new Object[0]);
            f_109012_ = Reflector.callFloat(event, Reflector.EntityViewRenderEvent_FogColors_getBlue, new Object[0]);
        }
        Shaders.setClearColor(f_109010_, f_109011_, f_109012_, 0.0f);
        RenderSystem.m_69424_((float)f_109010_, (float)f_109011_, (float)f_109012_, (float)0.0f);
    }

    public static void m_109017_() {
        RenderSystem.m_256258_((float)Float.MAX_VALUE);
        if (Config.isShaders()) {
            Shaders.setFogDensity(0.0f);
            Shaders.setFogMode(GLConst.GL_EXP2);
            Shaders.setFogStart(1.7014117E38f);
            Shaders.setFogEnd(Float.MAX_VALUE);
        }
    }

    public static void m_109024_(Camera activeRenderInfoIn, FogMode fogTypeIn, float farPlaneDistance, boolean nearFog) {
        FogRenderer.setupFog(activeRenderInfoIn, fogTypeIn, farPlaneDistance, nearFog, 0.0f);
    }

    public static void setupFog(Camera activeRenderInfoIn, FogMode fogTypeIn, float farPlaneDistance, boolean nearFog, float partialTicks) {
        fogStandard = false;
        FogType fogtype = activeRenderInfoIn.m_192938_();
        Entity entity = activeRenderInfoIn.m_90592_();
        float forgeFogDensity = -1.0f;
        if (Reflector.ForgeHooksClient_getFogDensity.exists()) {
            forgeFogDensity = Reflector.callFloat(Reflector.ForgeHooksClient_getFogDensity, new Object[]{fogTypeIn, activeRenderInfoIn, Float.valueOf(partialTicks), Float.valueOf(0.1f)});
        }
        if (forgeFogDensity >= 0.0f) {
            if (Config.isShaders()) {
                Shaders.setFogDensity(forgeFogDensity);
            }
        } else if (fogtype == FogType.WATER) {
            float f = 192.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                f *= Math.max(0.25f, localplayer.m_108639_());
                Biome biome = localplayer.f_19853_.m_46857_(localplayer.m_141983_());
                if (biome.m_47567_() == Biome.BiomeCategory.SWAMP) {
                    f *= 0.85f;
                }
            }
            RenderSystem.m_256258_((float)-8.0f);
            RenderSystem.m_256256_((float)(f * 0.5f));
            if (Config.isShaders()) {
                Shaders.setFogStart(-8.0f);
                Shaders.setFogEnd(f * 0.5f);
                float fogDensity116 = 0.05f - f / 192.0f * 0.03f;
                Shaders.setFogDensity(fogDensity116);
                Shaders.setFogMode(GLConst.GL_EXP2);
            }
        } else {
            float f3;
            float f2;
            if (fogtype == FogType.LAVA) {
                if (entity.m_5833_()) {
                    f2 = -8.0f;
                    f3 = farPlaneDistance * 0.5f;
                } else if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19607_)) {
                    f2 = 0.0f;
                    f3 = 3.0f;
                } else {
                    f2 = 0.25f;
                    f3 = 1.0f;
                }
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19610_)) {
                int i = ((LivingEntity)entity).m_21124_(MobEffects.f_19610_).m_19557_();
                float f1 = Mth.m_14179_(Math.min(1.0f, (float)i / 20.0f), farPlaneDistance, 5.0f);
                if (fogTypeIn == FogMode.FOG_SKY) {
                    f2 = 0.0f;
                    f3 = f1 * 0.8f;
                } else {
                    f2 = f1 * 0.25f;
                    f3 = f1;
                }
            } else if (fogtype == FogType.POWDER_SNOW) {
                if (entity.m_5833_()) {
                    f2 = -8.0f;
                    f3 = farPlaneDistance * 0.5f;
                } else {
                    f2 = 0.0f;
                    f3 = 2.0f;
                }
            } else if (nearFog) {
                fogStandard = true;
                f2 = farPlaneDistance * 0.05f;
                f3 = Math.min(farPlaneDistance, 192.0f) * 0.5f;
            } else if (fogTypeIn == FogMode.FOG_SKY) {
                f2 = 0.0f;
                f3 = farPlaneDistance;
            } else {
                fogStandard = true;
                f2 = farPlaneDistance * Config.getFogStart();
                f3 = farPlaneDistance;
            }
            RenderSystem.m_256258_((float)f2);
            RenderSystem.m_256256_((float)f3);
            if (Config.isShaders()) {
                Shaders.setFogStart(f2);
                Shaders.setFogEnd(f3);
                Shaders.setFogMode(9729);
            }
            if (Reflector.ForgeHooksClient_onFogRender.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_onFogRender, new Object[]{fogTypeIn, activeRenderInfoIn, Float.valueOf(partialTicks), Float.valueOf(f3)});
            }
        }
    }

    public static void m_109036_() {
        RenderSystem.m_256247_((float)f_109010_, (float)f_109011_, (float)f_109012_);
        if (Config.isShaders()) {
            Shaders.setFogColor(f_109010_, f_109011_, f_109012_);
        }
    }

    static {
        f_109013_ = -1;
        f_109014_ = -1;
        f_109015_ = -1L;
        fogStandard = false;
    }

    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }
}

