/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Effect;
import com.mojang.blaze3d.shaders.EffectProgram;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.optifine.reflect.Reflector;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectInstance
implements Effect,
AutoCloseable {
    private static final String f_315858_ = "shaders/program/";
    private static final Logger f_108921_ = LogManager.getLogger();
    private static final AbstractUniform f_108922_ = new AbstractUniform();
    private static final boolean f_315859_ = true;
    private static EffectInstance f_108923_;
    private static int f_108924_;
    private final Map<String, IntSupplier> f_108925_ = Maps.newHashMap();
    private final List<String> f_108926_ = Lists.newArrayList();
    private final List<Integer> f_108927_ = Lists.newArrayList();
    private final List<Uniform> f_108928_ = Lists.newArrayList();
    private final List<Integer> f_108929_ = Lists.newArrayList();
    private final Map<String, Uniform> f_108930_ = Maps.newHashMap();
    private final int f_108931_;
    private final String f_108932_;
    private boolean f_108933_;
    private final BlendMode f_108934_;
    private final List<Integer> f_108935_;
    private final List<String> f_108936_;
    private final EffectProgram f_108937_;
    private final EffectProgram f_108938_;

    public EffectInstance(ResourceManager resourceManagerIn, String nameIn) throws IOException {
        ResourceLocation resourcelocation = new ResourceLocation(f_315858_ + nameIn + ".json");
        if (Reflector.MinecraftForgeClient.exists()) {
            ResourceLocation rl = ResourceLocation.m_135820_(nameIn);
            resourcelocation = new ResourceLocation(rl.m_135827_(), f_315858_ + rl.m_135815_() + ".json");
        }
        this.f_108932_ = nameIn;
        Resource resource = null;
        try {
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            resource = resourceManagerIn.m_223800_(resourcelocation);
            JsonObject jsonobject = GsonHelper.m_13859_((Reader)new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"vertex");
            String s2 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.m_108948_((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception2);
                        chainedjsonexception1.m_135908_("samplers[" + i + "]");
                        throw chainedjsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.f_108935_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.f_108936_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (Iterator jsonelement1 : jsonarray1) {
                    try {
                        this.f_108936_.add(GsonHelper.m_13805_((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception1);
                        chainedjsonexception2.m_135908_("attributes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            } else {
                this.f_108935_ = null;
                this.f_108936_ = null;
            }
            if ((jsonarray2 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.m_108958_(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception3.m_135908_("uniforms[" + k + "]");
                        throw chainedjsonexception3;
                    }
                    ++k;
                }
            }
            this.f_108934_ = EffectInstance.m_108950_(GsonHelper.m_13841_((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.f_108937_ = EffectInstance.m_282027_(resourceManagerIn, Program.Type.VERTEX, s);
            this.f_108938_ = EffectInstance.m_282027_(resourceManagerIn, Program.Type.FRAGMENT, s2);
            this.f_108931_ = ProgramManager.m_85577_();
            ProgramManager.m_268345_((Shader)this);
            this.m_108967_();
            if (this.f_108936_ != null) {
                for (String s3 : this.f_108936_) {
                    int l = Uniform.m_85639_((int)this.f_108931_, (CharSequence)s3);
                    this.f_108935_.add(l);
                }
            }
        }
        catch (Exception exception3) {
            String s1 = resource != null ? " (" + resource.m_7816_() + ")" : "";
            ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception3);
            chainedjsonexception.m_135910_(resourcelocation.m_135815_() + s1);
            throw chainedjsonexception;
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
        this.m_224078_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EffectProgram m_282027_(ResourceManager resourceManagerIn, Program.Type typeIn, String nameIn) throws IOException {
        EffectProgram effectprogram;
        Program program = typeIn.m_85570_().get(nameIn);
        if (program != null && !(program instanceof EffectProgram)) {
            throw new InvalidClassException("Program is not of type EffectProgram");
        }
        if (program == null) {
            ResourceLocation resourcelocation = new ResourceLocation(f_315858_ + nameIn + typeIn.m_85569_());
            if (Reflector.MinecraftForgeClient.exists()) {
                ResourceLocation rl = ResourceLocation.m_135820_(nameIn);
                resourcelocation = new ResourceLocation(rl.m_135827_(), f_315858_ + rl.m_135815_() + typeIn.m_85569_());
            }
            Resource resource = resourceManagerIn.m_223800_(resourcelocation);
            try {
                effectprogram = EffectProgram.m_268308_((Program.Type)typeIn, (String)nameIn, (InputStream)resource.m_6679_(), (String)resource.m_7816_());
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        } else {
            effectprogram = (EffectProgram)program;
        }
        return effectprogram;
    }

    public static BlendMode m_108950_(JsonObject jsonIn) {
        if (jsonIn == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"func") && (i = BlendMode.m_85527_((String)jsonIn.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcrgb") && (j = BlendMode.m_85530_((String)jsonIn.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstrgb") && (k = BlendMode.m_85530_((String)jsonIn.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"srcalpha")) {
            l = BlendMode.m_85530_((String)jsonIn.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.m_13813_((JsonObject)jsonIn, (String)"dstalpha")) {
            i1 = BlendMode.m_85530_((String)jsonIn.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.f_108928_) {
            uniform.close();
        }
        ProgramManager.m_268343_((Shader)this);
    }

    public void m_108965_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        f_108924_ = -1;
        f_108923_ = null;
        for (int i = 0; i < this.f_108927_.size(); ++i) {
            if (this.f_108925_.get(this.f_108926_.get(i)) == null) continue;
            GlStateManager.m_84538_((int)(33984 + i));
            GlStateManager.m_84110_();
            GlStateManager.m_84544_((int)0);
        }
    }

    public void m_108966_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69584_(), ()Ljava/lang/Boolean;)());
        this.f_108933_ = false;
        f_108923_ = this;
        this.f_108934_.m_85526_();
        if (this.f_108931_ != GlStateManager.getProgram()) {
            ProgramManager.m_85578_((int)this.f_108931_);
            f_108924_ = this.f_108931_;
        }
        for (int i = 0; i < this.f_108927_.size(); ++i) {
            String s = this.f_108926_.get(i);
            IntSupplier intsupplier = this.f_108925_.get(s);
            if (intsupplier == null) continue;
            RenderSystem.m_69388_((int)(33984 + i));
            RenderSystem.m_69493_();
            int j = intsupplier.getAsInt();
            if (j == -1) continue;
            RenderSystem.m_69396_((int)j);
            Uniform.m_85616_((int)this.f_108927_.get(i), (int)i);
        }
        for (Uniform uniform : this.f_108928_) {
            uniform.m_85633_();
        }
    }

    public void m_224078_() {
        this.f_108933_ = true;
    }

    @Nullable
    public Uniform m_108952_(String nameIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        return this.f_108930_.get(nameIn);
    }

    public AbstractUniform m_108960_(String nameIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69584_(), ()Ljava/lang/Boolean;)());
        Uniform uniform = this.m_108952_(nameIn);
        return uniform == null ? f_108922_ : uniform;
    }

    private void m_108967_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.f_108926_.size(); ++i) {
            String s = this.f_108926_.get(i);
            int j = Uniform.m_85624_((int)this.f_108931_, (CharSequence)s);
            if (j == -1) {
                f_108921_.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.f_108932_, (Object)s);
                this.f_108925_.remove(s);
                intlist.add(i);
                continue;
            }
            this.f_108927_.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            this.f_108926_.remove(intlist.getInt(l));
        }
        for (Uniform uniform : this.f_108928_) {
            String s1 = uniform.m_85599_();
            int k = Uniform.m_85624_((int)this.f_108931_, (CharSequence)s1);
            if (k == -1) {
                f_108921_.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.f_108932_, (Object)s1);
                continue;
            }
            this.f_108929_.add(k);
            uniform.m_85614_(k);
            this.f_108930_.put(s1, uniform);
        }
    }

    private void m_108948_(JsonElement jsonElementIn) {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"sampler");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.m_13813_((JsonObject)jsonobject, (String)"file")) {
            this.f_108925_.put(s, null);
            this.f_108926_.add(s);
        } else {
            this.f_108926_.add(s);
        }
    }

    public void m_108954_(String nameIn, IntSupplier samplerIn) {
        if (this.f_108925_.containsKey(nameIn)) {
            this.f_108925_.remove(nameIn);
        }
        this.f_108925_.put(nameIn, samplerIn);
        this.m_224078_();
    }

    private void m_108958_(JsonElement jsonElementIn) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonElementIn, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(afloat);
        }
        this.f_108928_.add(uniform);
    }

    public Program m_223753_() {
        return this.f_108937_;
    }

    public Program m_223757_() {
        return this.f_108938_;
    }

    public void m_224079_() {
        this.f_108938_.m_268306_((Effect)this);
        this.f_108937_.m_268306_((Effect)this);
    }

    public String m_315860_() {
        return this.f_108932_;
    }

    public int m_224063_() {
        return this.f_108931_;
    }

    static {
        f_108924_ = -1;
    }
}

