/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.EmissiveTextures;
import org.apache.commons.lang3.StringUtils;

public class BlockEntityWithoutLevelRenderer
implements ResourceManagerReloadListener {
    private static final ShulkerBoxBlockEntity[] f_108815_ = (ShulkerBoxBlockEntity[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::m_41060_)).map(dyeColorIn -> new ShulkerBoxBlockEntity(dyeColorIn, BlockPos.f_121853_, Blocks.f_50456_.m_49966_())).toArray(ShulkerBoxBlockEntity[]::new);
    private static final ShulkerBoxBlockEntity f_108816_ = new ShulkerBoxBlockEntity(BlockPos.f_121853_, Blocks.f_50456_.m_49966_());
    private final ChestBlockEntity f_108817_ = new ChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_());
    private final ChestBlockEntity f_108818_ = new TrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_());
    private final EnderChestBlockEntity f_108819_ = new EnderChestBlockEntity(BlockPos.f_121853_, Blocks.f_50265_.m_49966_());
    private final BannerBlockEntity f_108820_ = new BannerBlockEntity(BlockPos.f_121853_, Blocks.f_50414_.m_49966_());
    private final BedBlockEntity f_108821_ = new BedBlockEntity(BlockPos.f_121853_, Blocks.f_50028_.m_49966_());
    private final ConduitBlockEntity f_108822_ = new ConduitBlockEntity(BlockPos.f_121853_, Blocks.f_50569_.m_49966_());
    private ShieldModel f_108823_;
    public TridentModel f_108824_;
    private Map<SkullBlock.Type, SkullModelBase> f_205360_;
    private final BlockEntityRenderDispatcher f_205361_;
    private final EntityModelSet f_205362_;

    public BlockEntityWithoutLevelRenderer(BlockEntityRenderDispatcher dispatcherIn, EntityModelSet modelSetIn) {
        this.f_205361_ = dispatcherIn;
        this.f_205362_ = modelSetIn;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.f_108823_ = new ShieldModel(this.f_205362_.m_201399_(ModelLayers.f_201471_));
        this.f_108824_ = new TridentModel(this.f_205362_.m_201399_(ModelLayers.f_201546_));
        this.f_205360_ = SkullBlockRenderer.m_207500_(this.f_205362_);
    }

    public void m_108829_(ItemStack itemStackIn, ItemTransforms.TransformType transformIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (EmissiveTextures.isActive()) {
            EmissiveTextures.beginRender();
        }
        this.renderRaw(itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        if (EmissiveTextures.isActive()) {
            if (EmissiveTextures.hasEmissive()) {
                EmissiveTextures.beginRenderEmissive();
                this.renderRaw(itemStackIn, matrixStackIn, bufferIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn);
                EmissiveTextures.endRenderEmissive();
            }
            EmissiveTextures.endRender();
        }
    }

    public void renderRaw(ItemStack itemStackIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Item item = itemStackIn.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof AbstractSkullBlock) {
                GameProfile gameprofile = null;
                if (itemStackIn.m_41782_()) {
                    CompoundTag compoundtag = itemStackIn.m_41783_();
                    if (compoundtag.m_128425_("SkullOwner", 10)) {
                        gameprofile = NbtUtils.m_129228_((CompoundTag)compoundtag.m_128469_("SkullOwner"));
                    } else if (compoundtag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundtag.m_128461_("SkullOwner"))) {
                        gameprofile = new GameProfile((UUID)null, compoundtag.m_128461_("SkullOwner"));
                        compoundtag.m_128473_("SkullOwner");
                        SkullBlockEntity.m_307051_((GameProfile)gameprofile, p_315852_1_ -> compoundtag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)p_315852_1_)));
                    }
                }
                SkullBlock.Type skullblock$type = ((AbstractSkullBlock)block).m_48754_();
                SkullModelBase skullmodelbase = this.f_205360_.get(skullblock$type);
                RenderType rendertype = SkullBlockRenderer.m_112523_(skullblock$type, gameprofile);
                SkullBlockRenderer.m_207502_(null, 180.0f, 0.0f, matrixStackIn, bufferIn, combinedLightIn, skullmodelbase, rendertype);
            } else {
                BannerBlockEntity blockentity;
                BlockState blockstate = block.m_49966_();
                if (block instanceof AbstractBannerBlock) {
                    this.f_108820_.m_58489_(itemStackIn, ((AbstractBannerBlock)block).m_48674_());
                    blockentity = this.f_108820_;
                } else if (block instanceof BedBlock) {
                    this.f_108821_.m_58729_(((BedBlock)block).m_49554_());
                    blockentity = this.f_108821_;
                } else if (blockstate.m_60713_(Blocks.f_50569_)) {
                    blockentity = this.f_108822_;
                } else if (blockstate.m_60713_(Blocks.f_50087_)) {
                    blockentity = this.f_108817_;
                } else if (blockstate.m_60713_(Blocks.f_50265_)) {
                    blockentity = this.f_108819_;
                } else if (blockstate.m_60713_(Blocks.f_50325_)) {
                    blockentity = this.f_108818_;
                } else {
                    if (!(block instanceof ShulkerBoxBlock)) {
                        return;
                    }
                    DyeColor dyecolor = ShulkerBoxBlock.m_56252_((Item)item);
                    blockentity = dyecolor == null ? f_108816_ : f_108815_[dyecolor.m_41060_()];
                }
                this.f_205361_.m_112272_(blockentity, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
        } else if (itemStackIn.m_160754_(Items.f_42740_)) {
            boolean flag = itemStackIn.m_41737_("BlockEntityTag") != null;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
            Material material = flag ? ModelBakery.f_119225_ : ModelBakery.f_119226_;
            VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_(bufferIn, this.f_108823_.m_103119_(material.m_119193_()), true, itemStackIn.m_41790_()));
            this.f_108823_.m_103711_().m_104306_(matrixStackIn, vertexconsumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            if (flag) {
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)itemStackIn), (ListTag)BannerBlockEntity.m_58487_((ItemStack)itemStackIn));
                BannerRenderer.m_112074_((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (ModelPart)this.f_108823_.m_103701_(), (Material)material, (boolean)false, (List)list, (boolean)itemStackIn.m_41790_());
            } else {
                this.f_108823_.m_103701_().m_104306_(matrixStackIn, vertexconsumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.m_85849_();
        } else if (itemStackIn.m_160754_(Items.f_42713_)) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(1.0f, -1.0f, -1.0f);
            VertexConsumer vertexconsumer1 = ItemRenderer.m_115222_(bufferIn, this.f_108824_.m_103119_(TridentModel.f_103914_), false, itemStackIn.m_41790_());
            this.f_108824_.m_7695_(matrixStackIn, vertexconsumer1, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
        }
    }
}

