/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.optifine.ChunkOF;
import net.optifine.reflect.Reflector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientChunkCache
extends ChunkSource {
    static final Logger f_104407_ = LogManager.getLogger();
    private final LevelChunk f_104408_;
    private final LevelLightEngine f_104409_;
    volatile Storage f_104410_;
    final ClientLevel f_104411_;

    public ClientChunkCache(ClientLevel clientWorldIn, int viewDistance) {
        this.f_104411_ = clientWorldIn;
        this.f_104408_ = new EmptyLevelChunk((Level)clientWorldIn, new ChunkPos(0, 0));
        this.f_104409_ = new LevelLightEngine((LightChunkGetter)this, true, clientWorldIn.m_6042_().m_63935_());
        this.f_104410_ = new Storage(ClientChunkCache.m_104448_(viewDistance));
    }

    public LevelLightEngine m_7827_() {
        return this.f_104409_;
    }

    private static boolean m_104438_(@Nullable LevelChunk chunkIn, int x, int z) {
        if (chunkIn == null) {
            return false;
        }
        ChunkPos chunkpos = chunkIn.m_7697_();
        return chunkpos.f_45578_ == x && chunkpos.f_45579_ == z;
    }

    public void m_104455_(int x, int z) {
        int i;
        LevelChunk levelchunk;
        if (this.f_104410_.m_104500_(x, z) && ClientChunkCache.m_104438_(levelchunk = this.f_104410_.m_104479_(i = this.f_104410_.m_104481_(x, z)), x, z)) {
            if (Reflector.ChunkEvent_Unload_Constructor.exists()) {
                Reflector.postForgeBusEvent(Reflector.ChunkEvent_Unload_Constructor, levelchunk);
            }
            levelchunk.m_62913_(false);
            this.f_104410_.m_104487_(i, levelchunk, null);
        }
    }

    @Nullable
    public LevelChunk m_7587_(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        LevelChunk levelchunk;
        if (this.f_104410_.m_104500_(chunkX, chunkZ) && ClientChunkCache.m_104438_(levelchunk = this.f_104410_.m_104479_(this.f_104410_.m_104481_(chunkX, chunkZ)), chunkX, chunkZ)) {
            return levelchunk;
        }
        return load ? this.f_104408_ : null;
    }

    public BlockGetter m_7653_() {
        return this.f_104411_;
    }

    @Nullable
    public LevelChunk m_201895_(int chunkX, int chunkZ, ChunkBiomeContainer biomeContainerIn, FriendlyByteBuf packetIn, CompoundTag nbtTagIn, BitSet bitSetIn) {
        if (!this.f_104410_.m_104500_(chunkX, chunkZ)) {
            f_104407_.warn("Ignoring chunk since it's not in the view range: {}, {}", (Object)chunkX, (Object)chunkZ);
            return null;
        }
        int i = this.f_104410_.m_104481_(chunkX, chunkZ);
        Object levelchunk = this.f_104410_.f_104466_.get(i);
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        if (!ClientChunkCache.m_104438_(levelchunk, chunkX, chunkZ)) {
            if (levelchunk != null) {
                levelchunk.m_62913_(false);
            }
            levelchunk = new ChunkOF((Level)this.f_104411_, chunkpos, biomeContainerIn);
            levelchunk.m_174675_(biomeContainerIn, packetIn, nbtTagIn, bitSetIn);
            this.f_104410_.m_104484_(i, (LevelChunk)levelchunk);
        } else {
            levelchunk.m_174675_(biomeContainerIn, packetIn, nbtTagIn, bitSetIn);
        }
        LevelChunkSection[] alevelchunksection = levelchunk.m_7103_();
        LevelLightEngine levellightengine = this.m_7827_();
        levellightengine.m_299393_(chunkpos, true);
        for (int j = 0; j < alevelchunksection.length; ++j) {
            LevelChunkSection levelchunksection = alevelchunksection[j];
            int k = this.f_104411_.m_163344_(j);
            levellightengine.m_6191_(SectionPos.m_123173_((int)chunkX, (int)k, (int)chunkZ), LevelChunkSection.m_63000_(levelchunksection));
        }
        this.f_104411_.m_202142_(chunkpos);
        if (Reflector.ChunkEvent_Load_Constructor.exists()) {
            Reflector.postForgeBusEvent(Reflector.ChunkEvent_Load_Constructor, levelchunk);
        }
        levelchunk.m_62913_(true);
        return levelchunk;
    }

    public void m_299757_(BooleanSupplier p_299757_1_) {
    }

    public void m_104459_(int x, int z) {
        this.f_104410_.f_104469_ = x;
        this.f_104410_.f_104470_ = z;
    }

    public void m_104416_(int viewDistance) {
        int i = this.f_104410_.f_104467_;
        int j = ClientChunkCache.m_104448_(viewDistance);
        if (i != j) {
            Storage clientchunkcache$storage = new Storage(j);
            clientchunkcache$storage.f_104469_ = this.f_104410_.f_104469_;
            clientchunkcache$storage.f_104470_ = this.f_104410_.f_104470_;
            for (int k = 0; k < this.f_104410_.f_104466_.length(); ++k) {
                LevelChunk levelchunk = this.f_104410_.f_104466_.get(k);
                if (levelchunk == null) continue;
                ChunkPos chunkpos = levelchunk.m_7697_();
                if (!clientchunkcache$storage.m_104500_(chunkpos.f_45578_, chunkpos.f_45579_)) continue;
                clientchunkcache$storage.m_104484_(clientchunkcache$storage.m_104481_(chunkpos.f_45578_, chunkpos.f_45579_), levelchunk);
            }
            this.f_104410_ = clientchunkcache$storage;
        }
    }

    private static int m_104448_(int distanceIn) {
        return Math.max(2, distanceIn) + 3;
    }

    public String m_6754_() {
        return this.f_104410_.f_104466_.length() + ", " + this.m_299476_();
    }

    public int m_299476_() {
        return this.f_104410_.f_104471_;
    }

    public void m_6506_(LightLayer type, SectionPos pos) {
        Minecraft.m_91087_().f_91060_.m_109770_(pos.m_123170_(), pos.m_123206_(), pos.m_123222_());
    }

    final class Storage {
        final AtomicReferenceArray<LevelChunk> f_104466_;
        final int f_104467_;
        private final int f_104468_;
        volatile int f_104469_;
        volatile int f_104470_;
        int f_104471_;

        Storage(int viewDistanceIn) {
            this.f_104467_ = viewDistanceIn;
            this.f_104468_ = viewDistanceIn * 2 + 1;
            this.f_104466_ = new AtomicReferenceArray(this.f_104468_ * this.f_104468_);
        }

        int m_104481_(int x, int z) {
            return Math.floorMod(z, this.f_104468_) * this.f_104468_ + Math.floorMod(x, this.f_104468_);
        }

        protected void m_104484_(int chunkIndex, @Nullable LevelChunk chunkIn) {
            LevelChunk levelchunk = this.f_104466_.getAndSet(chunkIndex, chunkIn);
            if (levelchunk != null) {
                --this.f_104471_;
                ClientChunkCache.this.f_104411_.m_104665_(levelchunk);
            }
            if (chunkIn != null) {
                ++this.f_104471_;
            }
        }

        protected LevelChunk m_104487_(int chunkIndex, LevelChunk chunkIn, @Nullable LevelChunk replaceWith) {
            if (this.f_104466_.compareAndSet(chunkIndex, chunkIn, replaceWith) && replaceWith == null) {
                --this.f_104471_;
            }
            ClientChunkCache.this.f_104411_.m_104665_(chunkIn);
            return chunkIn;
        }

        boolean m_104500_(int x, int z) {
            return Math.abs(x - this.f_104469_) <= this.f_104467_ && Math.abs(z - this.f_104470_) <= this.f_104467_;
        }

        @Nullable
        protected LevelChunk m_104479_(int chunkIndex) {
            return this.f_104466_.get(chunkIndex);
        }

        private void m_315468_(String fileNameIn) {
            try (FileOutputStream fileoutputstream = new FileOutputStream(new File(fileNameIn));){
                int i = ClientChunkCache.this.f_104410_.f_104467_;
                for (int j = this.f_104470_ - i; j <= this.f_104470_ + i; ++j) {
                    for (int k = this.f_104469_ - i; k <= this.f_104469_ + i; ++k) {
                        LevelChunk levelchunk = ClientChunkCache.this.f_104410_.f_104466_.get(ClientChunkCache.this.f_104410_.m_104481_(k, j));
                        if (levelchunk == null) continue;
                        ChunkPos chunkpos = levelchunk.m_7697_();
                        fileoutputstream.write((chunkpos.f_45578_ + "\t" + chunkpos.f_45579_ + "\t" + levelchunk.m_6430_() + "\n").getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            catch (IOException ioexception) {
                f_104407_.error((Object)ioexception);
            }
        }
    }
}

