/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.AmbientOcclusionStatus;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CameraType;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Option;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomSky;
import net.optifine.DynamicLights;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.config.FloatOptions;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import net.optifine.util.FontUtils;
import net.optifine.util.KeyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Options {
    static final Logger f_92077_ = LogManager.getLogger();
    private static final Gson f_92078_ = new Gson();
    private static final TypeToken<List<String>> f_92079_ = new TypeToken<List<String>>(){};
    public static final int f_313916_ = 2;
    public static final int f_313917_ = 4;
    public static final int f_313919_ = 8;
    public static final int f_313920_ = 12;
    public static final int f_313921_ = 16;
    public static final int f_313922_ = 32;
    private static final Splitter f_92107_ = Splitter.on((char)':').limit(2);
    private static final float f_313918_ = 1.0f;
    public boolean f_313923_;
    public double f_92053_ = 0.5;
    public int f_92106_;
    public float f_92112_ = 1.0f;
    public int f_92113_ = 120;
    public CloudStatus f_92114_ = CloudStatus.FANCY;
    public GraphicsStatus f_92115_ = GraphicsStatus.FANCY;
    public AmbientOcclusionStatus f_92116_ = AmbientOcclusionStatus.MAX;
    public List<String> f_92117_ = Lists.newArrayList();
    public List<String> f_92118_ = Lists.newArrayList();
    public ChatVisiblity f_92119_ = ChatVisiblity.FULL;
    public double f_92120_ = 1.0;
    public double f_92121_;
    public double f_92122_ = 0.5;
    @Nullable
    public String f_92123_;
    public boolean f_92124_;
    public boolean f_92125_;
    public boolean f_92126_ = true;
    private final Set<PlayerModelPart> f_92108_ = EnumSet.allOf(PlayerModelPart.class);
    public HumanoidArm f_92127_ = HumanoidArm.RIGHT;
    public int f_92128_;
    public int f_92129_;
    public boolean f_92130_ = true;
    public double f_92131_ = 1.0;
    public double f_92132_ = 1.0;
    public double f_92133_ = 0.44366195797920227;
    public double f_92134_ = 1.0;
    public double f_92135_;
    public int f_92027_ = 4;
    private final Object2FloatMap<SoundSource> f_92109_ = (Object2FloatMap)Util.m_137469_(new Object2FloatOpenHashMap(), mapIn -> mapIn.defaultReturnValue(1.0f));
    public boolean f_92028_ = true;
    public AttackIndicatorStatus f_92029_ = AttackIndicatorStatus.CROSSHAIR;
    public TutorialSteps f_92030_ = TutorialSteps.MOVEMENT;
    public boolean f_92031_ = false;
    public boolean f_193910_ = false;
    public int f_92032_ = 2;
    public double f_92033_ = 1.0;
    public boolean f_92034_ = true;
    public int f_92035_ = 1;
    public boolean f_92036_ = true;
    public boolean f_92037_ = true;
    public boolean f_92038_ = true;
    public boolean f_92039_ = true;
    public boolean f_92040_ = true;
    public boolean f_92041_ = true;
    public boolean f_92042_ = true;
    public boolean f_92043_;
    public boolean f_92044_;
    public boolean f_92045_;
    public boolean f_92046_ = true;
    public boolean f_92047_;
    public boolean f_92048_ = true;
    public boolean f_92049_;
    public boolean f_92050_ = true;
    public boolean f_92051_;
    public boolean f_92052_;
    public boolean f_92080_ = true;
    public boolean f_92081_;
    public boolean f_92082_;
    public boolean f_92083_;
    public boolean f_92084_ = true;
    public final KeyMapping f_92085_ = new KeyMapping("key.forward", 87, "key.categories.movement");
    public final KeyMapping f_92086_ = new KeyMapping("key.left", 65, "key.categories.movement");
    public final KeyMapping f_92087_ = new KeyMapping("key.back", 83, "key.categories.movement");
    public final KeyMapping f_92088_ = new KeyMapping("key.right", 68, "key.categories.movement");
    public final KeyMapping f_92089_ = new KeyMapping("key.jump", 32, "key.categories.movement");
    public final KeyMapping f_92090_ = new ToggleKeyMapping("key.sneak", 340, "key.categories.movement", () -> this.f_92081_);
    public final KeyMapping f_92091_ = new ToggleKeyMapping("key.sprint", 341, "key.categories.movement", () -> this.f_92082_);
    public final KeyMapping f_92092_ = new KeyMapping("key.inventory", 69, "key.categories.inventory");
    public final KeyMapping f_92093_ = new KeyMapping("key.swapOffhand", 70, "key.categories.inventory");
    public final KeyMapping f_92094_ = new KeyMapping("key.drop", 81, "key.categories.inventory");
    public final KeyMapping f_92095_ = new KeyMapping("key.use", InputConstants.Type.MOUSE, 1, "key.categories.gameplay");
    public final KeyMapping f_92096_ = new KeyMapping("key.attack", InputConstants.Type.MOUSE, 0, "key.categories.gameplay");
    public final KeyMapping f_92097_ = new KeyMapping("key.pickItem", InputConstants.Type.MOUSE, 2, "key.categories.gameplay");
    public final KeyMapping f_92098_ = new KeyMapping("key.chat", 84, "key.categories.multiplayer");
    public final KeyMapping f_92099_ = new KeyMapping("key.playerlist", 258, "key.categories.multiplayer");
    public final KeyMapping f_92100_ = new KeyMapping("key.command", 47, "key.categories.multiplayer");
    public final KeyMapping f_92101_ = new KeyMapping("key.socialInteractions", 80, "key.categories.multiplayer");
    public final KeyMapping f_92102_ = new KeyMapping("key.screenshot", 291, "key.categories.misc");
    public final KeyMapping f_92103_ = new KeyMapping("key.togglePerspective", 294, "key.categories.misc");
    public final KeyMapping f_92104_ = new KeyMapping("key.smoothCamera", InputConstants.f_84822_.m_84873_(), "key.categories.misc");
    public final KeyMapping f_92105_ = new KeyMapping("key.fullscreen", 300, "key.categories.misc");
    public final KeyMapping f_92054_ = new KeyMapping("key.spectatorOutlines", InputConstants.f_84822_.m_84873_(), "key.categories.misc");
    public final KeyMapping f_92055_ = new KeyMapping("key.advancements", 76, "key.categories.misc");
    public final KeyMapping[] f_92056_ = new KeyMapping[]{new KeyMapping("key.hotbar.1", 49, "key.categories.inventory"), new KeyMapping("key.hotbar.2", 50, "key.categories.inventory"), new KeyMapping("key.hotbar.3", 51, "key.categories.inventory"), new KeyMapping("key.hotbar.4", 52, "key.categories.inventory"), new KeyMapping("key.hotbar.5", 53, "key.categories.inventory"), new KeyMapping("key.hotbar.6", 54, "key.categories.inventory"), new KeyMapping("key.hotbar.7", 55, "key.categories.inventory"), new KeyMapping("key.hotbar.8", 56, "key.categories.inventory"), new KeyMapping("key.hotbar.9", 57, "key.categories.inventory")};
    public final KeyMapping f_92057_ = new KeyMapping("key.saveToolbarActivator", 67, "key.categories.creative");
    public final KeyMapping f_92058_ = new KeyMapping("key.loadToolbarActivator", 88, "key.categories.creative");
    public KeyMapping[] f_92059_ = (KeyMapping[])ArrayUtils.addAll((Object[])new KeyMapping[]{this.f_92096_, this.f_92095_, this.f_92085_, this.f_92086_, this.f_92087_, this.f_92088_, this.f_92089_, this.f_92090_, this.f_92091_, this.f_92094_, this.f_92092_, this.f_92098_, this.f_92099_, this.f_92097_, this.f_92100_, this.f_92101_, this.f_92102_, this.f_92103_, this.f_92104_, this.f_92105_, this.f_92054_, this.f_92093_, this.f_92057_, this.f_92058_, this.f_92055_}, (Object[])this.f_92056_);
    protected Minecraft f_92060_;
    private final File f_92110_;
    public Difficulty f_92061_ = Difficulty.NORMAL;
    public boolean f_92062_;
    private CameraType f_92111_ = CameraType.FIRST_PERSON;
    public boolean f_92063_;
    public boolean f_92064_;
    public boolean f_92065_;
    public String f_92066_ = "";
    public boolean f_92067_;
    public double f_92068_ = 70.0;
    public float f_92069_ = 1.0f;
    public float f_92070_ = 1.0f;
    public double f_92071_;
    public int f_92072_;
    public ParticleStatus f_92073_ = ParticleStatus.ALL;
    public NarratorStatus f_92074_ = NarratorStatus.OFF;
    public String f_92075_ = "en_us";
    public boolean f_92076_;
    public int ofFogType = 1;
    public float ofFogStart = 0.8f;
    public int ofMipmapType = 0;
    public boolean ofOcclusionFancy = false;
    public boolean ofSmoothFps = false;
    public boolean ofSmoothWorld = Config.isSingleProcessor();
    public boolean ofLazyChunkLoading = Config.isSingleProcessor();
    public boolean ofRenderRegions = false;
    public boolean ofSmartAnimations = false;
    public double ofAoLevel = 1.0;
    public int ofAaLevel = 0;
    public int ofAfLevel = 1;
    public int ofClouds = 0;
    public double ofCloudsHeight = 0.0;
    public int ofTrees = 0;
    public int ofRain = 0;
    public int ofDroppedItems = 0;
    public int ofBetterGrass = 3;
    public int ofAutoSaveTicks = 4000;
    public boolean ofLagometer = false;
    public boolean ofProfiler = false;
    public boolean ofShowFps = false;
    public boolean ofWeather = true;
    public boolean ofSky = true;
    public boolean ofStars = true;
    public boolean ofSunMoon = true;
    public int ofVignette = 0;
    public int ofChunkUpdates = 1;
    public boolean ofChunkUpdatesDynamic = false;
    public int ofTime = 0;
    public boolean ofBetterSnow = false;
    public boolean ofSwampColors = true;
    public boolean ofRandomEntities = true;
    public boolean ofCustomFonts = true;
    public boolean ofCustomColors = true;
    public boolean ofCustomSky = true;
    public boolean ofShowCapes = true;
    public int ofConnectedTextures = 2;
    public boolean ofCustomItems = true;
    public boolean ofNaturalTextures = false;
    public boolean ofEmissiveTextures = true;
    public boolean ofFastMath = false;
    public boolean ofFastRender = false;
    public int ofTranslucentBlocks = 0;
    public boolean ofDynamicFov = true;
    public boolean ofAlternateBlocks = true;
    public int ofDynamicLights = 3;
    public boolean ofCustomEntityModels = true;
    public boolean ofCustomGuis = true;
    public boolean ofShowGlErrors = true;
    public int ofScreenshotSize = 1;
    public int ofChatBackground = 0;
    public boolean ofChatShadow = true;
    public int ofAnimatedWater = 0;
    public int ofAnimatedLava = 0;
    public boolean ofAnimatedFire = true;
    public boolean ofAnimatedPortal = true;
    public boolean ofAnimatedRedstone = true;
    public boolean ofAnimatedExplosion = true;
    public boolean ofAnimatedFlame = true;
    public boolean ofAnimatedSmoke = true;
    public boolean ofVoidParticles = true;
    public boolean ofWaterParticles = true;
    public boolean ofRainSplash = true;
    public boolean ofPortalParticles = true;
    public boolean ofPotionParticles = true;
    public boolean ofFireworkParticles = true;
    public boolean ofDrippingWaterLava = true;
    public boolean ofAnimatedTerrain = true;
    public boolean ofAnimatedTextures = true;
    public static final int DEFAULT = 0;
    public static final int FAST = 1;
    public static final int FANCY = 2;
    public static final int OFF = 3;
    public static final int SMART = 4;
    public static final int COMPACT = 5;
    public static final int ANIM_ON = 0;
    public static final int ANIM_GENERATED = 1;
    public static final int ANIM_OFF = 2;
    public static final String DEFAULT_STR = "Default";
    public static final double CHAT_WIDTH_SCALE = 4.0571431;
    private static final int[] OF_TREES_VALUES = new int[]{0, 1, 4, 2};
    private static final int[] OF_DYNAMIC_LIGHTS = new int[]{3, 1, 2};
    private static final String[] KEYS_DYNAMIC_LIGHTS = new String[]{"options.off", "options.graphics.fast", "options.graphics.fancy"};
    public KeyMapping ofKeyBindZoom;
    private File optionsFileOF;
    private boolean loadOptions;
    private boolean saveOptions;

    public Options(Minecraft mcIn, File mcDataDir) {
        this.setForgeKeybindProperties();
        this.f_92060_ = mcIn;
        this.f_92110_ = new File(mcDataDir, "options.txt");
        if (mcIn.m_91103_() && Runtime.getRuntime().maxMemory() >= 1000000000L) {
            Option.f_91675_.m_92219_(32.0f);
            long MB = 1000000L;
            if (Runtime.getRuntime().maxMemory() >= 1500L * MB) {
                Option.f_91675_.m_92219_(48.0f);
            }
            if (Runtime.getRuntime().maxMemory() >= 2500L * MB) {
                Option.f_91675_.m_92219_(64.0f);
            }
        } else {
            Option.f_91675_.m_92219_(16.0f);
        }
        this.f_92106_ = mcIn.m_91103_() ? 12 : 8;
        this.f_92076_ = Util.m_137581_() == Util.OS.WINDOWS;
        this.optionsFileOF = new File(mcDataDir, "optionsof.txt");
        this.f_92113_ = (int)Option.f_91670_.m_92235_();
        this.ofKeyBindZoom = new KeyMapping("of.key.zoom", 67, "key.categories.misc");
        this.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])this.f_92059_, (Object)this.ofKeyBindZoom);
        KeyUtils.fixKeyConflicts((KeyMapping[])this.f_92059_, (KeyMapping[])new KeyMapping[]{this.ofKeyBindZoom});
        this.f_92106_ = 8;
        this.m_92140_();
        Config.initGameSettings((Options)this);
    }

    public float m_92141_(float opacityIn) {
        return this.f_92050_ ? opacityIn : (float)this.f_92122_;
    }

    public int m_92170_(float opacityIn) {
        return (int)(this.m_92141_(opacityIn) * 255.0f) << 24 & 0xFF000000;
    }

    public int m_92143_(int colorIn) {
        return this.f_92050_ ? colorIn : (int)(this.f_92122_ * 255.0) << 24 & 0xFF000000;
    }

    public void m_92159_(KeyMapping keyBindingIn, InputConstants.Key inputIn) {
        keyBindingIn.m_90848_(inputIn);
        this.m_92169_();
    }

    private void m_193933_(FieldAccess fieldAccessIn) {
        this.f_92036_ = fieldAccessIn.m_142028_("autoJump", this.f_92036_);
        this.f_92037_ = fieldAccessIn.m_142028_("autoSuggestions", this.f_92037_);
        this.f_92038_ = fieldAccessIn.m_142028_("chatColors", this.f_92038_);
        this.f_92039_ = fieldAccessIn.m_142028_("chatLinks", this.f_92039_);
        this.f_92040_ = fieldAccessIn.m_142028_("chatLinksPrompt", this.f_92040_);
        this.f_92041_ = fieldAccessIn.m_142028_("enableVsync", this.f_92041_);
        if (this.loadOptions) {
            if (this.f_92041_) {
                this.f_92113_ = (int)Option.f_91670_.m_92235_();
            }
            this.updateVSync();
        }
        this.f_92042_ = fieldAccessIn.m_142028_("entityShadows", this.f_92042_);
        this.f_92043_ = fieldAccessIn.m_142028_("forceUnicodeFont", this.f_92043_);
        this.f_92045_ = fieldAccessIn.m_142028_("discrete_mouse_scroll", this.f_92045_);
        this.f_92044_ = fieldAccessIn.m_142028_("invertYMouse", this.f_92044_);
        this.f_92046_ = fieldAccessIn.m_142028_("realmsNotifications", this.f_92046_);
        this.f_92047_ = fieldAccessIn.m_142028_("reducedDebugInfo", this.f_92047_);
        this.f_92048_ = fieldAccessIn.m_142028_("snooperEnabled", this.f_92048_);
        this.f_92049_ = fieldAccessIn.m_142028_("showSubtitles", this.f_92049_);
        this.f_92051_ = fieldAccessIn.m_142028_("touchscreen", this.f_92051_);
        this.f_92052_ = fieldAccessIn.m_142028_("fullscreen", this.f_92052_);
        this.f_92080_ = fieldAccessIn.m_142028_("bobView", this.f_92080_);
        this.f_92081_ = fieldAccessIn.m_142028_("toggleCrouch", this.f_92081_);
        this.f_92082_ = fieldAccessIn.m_142028_("toggleSprint", this.f_92082_);
        this.f_313923_ = fieldAccessIn.m_142028_("darkMojangStudiosBackground", this.f_313923_);
        this.f_92053_ = fieldAccessIn.m_141940_("mouseSensitivity", this.f_92053_);
        this.f_92068_ = fieldAccessIn.m_141940_("fov", (this.f_92068_ - 70.0) / 40.0) * 40.0 + 70.0;
        this.f_92069_ = fieldAccessIn.m_141839_("screenEffectScale", this.f_92069_);
        this.f_92070_ = fieldAccessIn.m_141839_("fovEffectScale", this.f_92070_);
        this.f_92071_ = fieldAccessIn.m_141940_("gamma", this.f_92071_);
        this.f_92106_ = fieldAccessIn.m_142003_("renderDistance", this.f_92106_);
        this.f_92112_ = fieldAccessIn.m_141839_("entityDistanceScaling", this.f_92112_);
        this.f_92072_ = fieldAccessIn.m_142003_("guiScale", this.f_92072_);
        this.f_92073_ = fieldAccessIn.m_141702_("particles", this.f_92073_, ParticleStatus::m_92196_, ParticleStatus::m_92198_);
        this.f_92113_ = fieldAccessIn.m_142003_("maxFps", this.f_92113_);
        if (this.loadOptions) {
            if (this.f_92041_) {
                this.f_92113_ = (int)Option.f_91670_.m_92235_();
            }
            if (this.f_92113_ <= 0) {
                this.f_92113_ = (int)Option.f_91670_.m_92235_();
            }
        }
        this.f_92061_ = fieldAccessIn.m_141702_("difficulty", this.f_92061_, Difficulty::m_19029_, Difficulty::m_19028_);
        this.f_92115_ = fieldAccessIn.m_141702_("graphicsMode", this.f_92115_, GraphicsStatus::m_90774_, GraphicsStatus::m_90773_);
        if (this.loadOptions) {
            this.updateRenderClouds();
        }
        this.f_92116_ = fieldAccessIn.m_141961_("ao", this.f_92116_, Options::m_193961_, aoIn -> Integer.toString(aoIn.m_90486_()));
        this.f_92032_ = fieldAccessIn.m_142003_("biomeBlendRadius", this.f_92032_);
        this.f_92114_ = fieldAccessIn.m_141961_("renderClouds", this.f_92114_, Options::m_193958_, Options::m_193929_);
        this.f_92117_ = fieldAccessIn.m_141961_("resourcePacks", this.f_92117_, Options::m_193956_, arg_0 -> ((Gson)f_92078_).toJson(arg_0));
        this.f_92118_ = fieldAccessIn.m_141961_("incompatibleResourcePacks", this.f_92118_, Options::m_193956_, arg_0 -> ((Gson)f_92078_).toJson(arg_0));
        this.f_92066_ = fieldAccessIn.m_141577_("lastServer", this.f_92066_);
        this.f_92075_ = fieldAccessIn.m_141577_("lang", this.f_92075_);
        this.f_92119_ = fieldAccessIn.m_141702_("chatVisibility", this.f_92119_, ChatVisiblity::m_35966_, ChatVisiblity::m_35965_);
        this.f_92120_ = fieldAccessIn.m_141940_("chatOpacity", this.f_92120_);
        this.f_92121_ = fieldAccessIn.m_141940_("chatLineSpacing", this.f_92121_);
        this.f_92122_ = fieldAccessIn.m_141940_("textBackgroundOpacity", this.f_92122_);
        this.f_92050_ = fieldAccessIn.m_142028_("backgroundForChatOnly", this.f_92050_);
        this.f_92124_ = fieldAccessIn.m_142028_("hideServerAddress", this.f_92124_);
        this.f_92125_ = fieldAccessIn.m_142028_("advancedItemTooltips", this.f_92125_);
        this.f_92126_ = fieldAccessIn.m_142028_("pauseOnLostFocus", this.f_92126_);
        this.f_92128_ = fieldAccessIn.m_142003_("overrideWidth", this.f_92128_);
        this.f_92129_ = fieldAccessIn.m_142003_("overrideHeight", this.f_92129_);
        this.f_92130_ = fieldAccessIn.m_142028_("heldItemTooltips", this.f_92130_);
        this.f_92134_ = fieldAccessIn.m_141940_("chatHeightFocused", this.f_92134_);
        this.f_92135_ = fieldAccessIn.m_141940_("chatDelay", this.f_92135_);
        this.f_92133_ = fieldAccessIn.m_141940_("chatHeightUnfocused", this.f_92133_);
        this.f_92131_ = fieldAccessIn.m_141940_("chatScale", this.f_92131_);
        this.f_92132_ = fieldAccessIn.m_141940_("chatWidth", this.f_92132_);
        this.f_92027_ = fieldAccessIn.m_142003_("mipmapLevels", this.f_92027_);
        this.f_92028_ = fieldAccessIn.m_142028_("useNativeTransport", this.f_92028_);
        this.f_92127_ = fieldAccessIn.m_141961_("mainHand", this.f_92127_, Options::m_193964_, Options::m_193919_);
        this.f_92029_ = fieldAccessIn.m_141702_("attackIndicator", this.f_92029_, AttackIndicatorStatus::m_90509_, AttackIndicatorStatus::m_90508_);
        this.f_92074_ = fieldAccessIn.m_141702_("narrator", this.f_92074_, NarratorStatus::m_91619_, NarratorStatus::m_91618_);
        this.f_92030_ = fieldAccessIn.m_141961_("tutorialStep", this.f_92030_, TutorialSteps::m_120642_, TutorialSteps::m_120639_);
        this.f_92033_ = fieldAccessIn.m_141940_("mouseWheelSensitivity", this.f_92033_);
        this.f_92034_ = fieldAccessIn.m_142028_("rawMouseInput", this.f_92034_);
        this.f_92035_ = fieldAccessIn.m_142003_("glDebugVerbosity", this.f_92035_);
        this.f_92083_ = fieldAccessIn.m_142028_("skipMultiplayerWarning", this.f_92083_);
        this.f_92084_ = fieldAccessIn.m_142028_("hideMatchedNames", this.f_92084_);
        this.f_92031_ = fieldAccessIn.m_142028_("joinedFirstServer", this.f_92031_);
        this.f_193910_ = fieldAccessIn.m_142028_("hideBundleTutorial", this.f_193910_);
        this.f_92076_ = fieldAccessIn.m_142028_("syncChunkWrites", this.f_92076_);
        for (KeyMapping keyMapping : this.f_92059_) {
            String s = keyMapping.m_90865_();
            String s1 = fieldAccessIn.m_141577_("key_" + keyMapping.m_90860_(), s);
            if (Reflector.ForgeKeyBinding_getKeyModifier.exists()) {
                Object keyModifier = Reflector.call(keyMapping, Reflector.ForgeKeyBinding_getKeyModifier, new Object[0]);
                Object keyModifierNone = Reflector.getFieldValue(Reflector.KeyModifier_NONE);
                s = keyMapping.m_90865_() + (keyModifier != keyModifierNone ? ":" + keyModifier : "");
            }
            if (s.equals(s1)) continue;
            if (Reflector.KeyModifier_valueFromString.exists()) {
                if (s1.indexOf(58) != -1) {
                    String[] pts = s1.split(":");
                    Object keyModifier = Reflector.call(Reflector.KeyModifier_valueFromString, pts[1]);
                    Reflector.call(keyMapping, Reflector.ForgeKeyBinding_setKeyModifierAndCode, keyModifier, InputConstants.m_84851_((String)pts[0]));
                    continue;
                }
                Object keyModifierNone = Reflector.getFieldValue(Reflector.KeyModifier_NONE);
                Reflector.call(keyMapping, Reflector.ForgeKeyBinding_setKeyModifierAndCode, keyModifierNone, InputConstants.m_84851_((String)s1));
                continue;
            }
            keyMapping.m_90848_(InputConstants.m_84851_((String)s1));
        }
        for (KeyMapping keyMapping : SoundSource.values()) {
            this.f_92109_.computeFloat((Object)keyMapping, (sourceIn, levelIn) -> Float.valueOf(fieldAccessIn.m_141839_("soundCategory_" + sourceIn.m_12676_(), levelIn != null ? levelIn.floatValue() : 1.0f)));
        }
        for (KeyMapping keyMapping : PlayerModelPart.values()) {
            boolean flag = this.f_92108_.contains(keyMapping);
            boolean flag1 = fieldAccessIn.m_142028_("modelPart_" + keyMapping.m_36446_(), flag);
            if (flag1 == flag) continue;
            this.m_92154_((PlayerModelPart)keyMapping, flag1);
        }
    }

    public void m_92140_() {
        this.loadOptions = true;
        try {
            if (!this.f_92110_.exists()) {
                return;
            }
            this.f_92109_.clear();
            CompoundTag compoundtag = new CompoundTag();
            try (BufferedReader bufferedreader = Files.newReader((File)this.f_92110_, (Charset)Charsets.UTF_8);){
                bufferedreader.lines().forEach(lineIn -> {
                    try {
                        Iterator iterator = f_92107_.split((CharSequence)lineIn).iterator();
                        compoundtag.m_128359_((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception1) {
                        f_92077_.warn("Skipping bad option: {}", lineIn);
                    }
                });
            }
            final CompoundTag compoundtag1 = this.m_92164_(compoundtag);
            if (!compoundtag1.m_128441_("graphicsMode") && compoundtag1.m_128441_("fancyGraphics")) {
                this.f_92115_ = Options.m_193952_(compoundtag1.m_128461_("fancyGraphics")) ? GraphicsStatus.FANCY : GraphicsStatus.FAST;
            }
            this.m_193933_(new FieldAccess(){

                @Nullable
                private String m_193971_(String p_193971_1_) {
                    return compoundtag1.m_128441_(p_193971_1_) ? compoundtag1.m_128461_(p_193971_1_) : null;
                }

                @Override
                public int m_142003_(String p_142003_1_, int p_142003_2_) {
                    String s = this.m_193971_(p_142003_1_);
                    if (s != null) {
                        try {
                            return Integer.parseInt(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            f_92077_.warn("Invalid integer value for option {} = {}", (Object)p_142003_1_, (Object)s, (Object)numberformatexception);
                        }
                    }
                    return p_142003_2_;
                }

                @Override
                public boolean m_142028_(String p_142028_1_, boolean p_142028_2_) {
                    String s = this.m_193971_(p_142028_1_);
                    return s != null ? Options.m_193952_(s) : p_142028_2_;
                }

                @Override
                public String m_141577_(String p_141577_1_, String p_141577_2_) {
                    return (String)MoreObjects.firstNonNull((Object)this.m_193971_(p_141577_1_), (Object)p_141577_2_);
                }

                @Override
                public double m_141940_(String p_141940_1_, double p_141940_2_) {
                    String s = this.m_193971_(p_141940_1_);
                    if (s != null) {
                        if (Options.m_193952_(s)) {
                            return 1.0;
                        }
                        if (Options.m_193954_(s)) {
                            return 0.0;
                        }
                        try {
                            return Double.parseDouble(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            f_92077_.warn("Invalid floating point value for option {} = {}", (Object)p_141940_1_, (Object)s, (Object)numberformatexception);
                        }
                    }
                    return p_141940_2_;
                }

                @Override
                public float m_141839_(String p_141839_1_, float p_141839_2_) {
                    String s = this.m_193971_(p_141839_1_);
                    if (s != null) {
                        if (Options.m_193952_(s)) {
                            return 1.0f;
                        }
                        if (Options.m_193954_(s)) {
                            return 0.0f;
                        }
                        try {
                            return Float.parseFloat(s);
                        }
                        catch (NumberFormatException numberformatexception) {
                            f_92077_.warn("Invalid floating point value for option {} = {}", (Object)p_141839_1_, (Object)s, (Object)numberformatexception);
                        }
                    }
                    return p_141839_2_;
                }

                @Override
                public <T> T m_141961_(String p_141961_1_, T p_141961_2_, Function<String, T> p_141961_3_, Function<T, String> p_141961_4_) {
                    String s = this.m_193971_(p_141961_1_);
                    return s == null ? p_141961_2_ : p_141961_3_.apply(s);
                }

                @Override
                public <T> T m_141702_(String p_141702_1_, T p_141702_2_, IntFunction<T> p_141702_3_, ToIntFunction<T> p_141702_4_) {
                    String s = this.m_193971_(p_141702_1_);
                    if (s != null) {
                        try {
                            return p_141702_3_.apply(Integer.parseInt(s));
                        }
                        catch (Exception exception1) {
                            f_92077_.warn("Invalid integer value for option {} = {}", (Object)p_141702_1_, (Object)s, (Object)exception1);
                        }
                    }
                    return p_141702_2_;
                }
            });
            if (compoundtag1.m_128441_("fullscreenResolution")) {
                this.f_92123_ = compoundtag1.m_128461_("fullscreenResolution");
            }
            if (this.f_92060_.m_91268_() != null) {
                this.f_92060_.m_91268_().m_85380_(this.f_92113_);
            }
            KeyMapping.m_90854_();
        }
        catch (Exception exception) {
            f_92077_.error("Failed to load options", (Throwable)exception);
        }
        this.loadOptions = false;
        this.loadOfOptions();
    }

    static boolean m_193952_(String textIn) {
        return "true".equals(textIn);
    }

    static boolean m_193954_(String textIn) {
        return "false".equals(textIn);
    }

    private CompoundTag m_92164_(CompoundTag nbt) {
        int i = 0;
        try {
            i = Integer.parseInt(nbt.m_128461_("version"));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return NbtUtils.m_129213_((DataFixer)this.f_92060_.m_91295_(), (DataFixTypes)DataFixTypes.OPTIONS, (CompoundTag)nbt, (int)i);
    }

    public void m_92169_() {
        this.saveOptions = true;
        if (Reflector.ClientModLoader_isLoading.exists() && Reflector.callBoolean(Reflector.ClientModLoader_isLoading, new Object[0])) {
            return;
        }
        try (final PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.f_92110_), StandardCharsets.UTF_8));){
            printwriter.println("version:" + SharedConstants.m_136187_().getWorldVersion());
            this.m_193933_(new FieldAccess(){

                public void m_194003_(String p_194003_1_) {
                    printwriter.print(p_194003_1_);
                    printwriter.print(':');
                }

                @Override
                public int m_142003_(String p_142003_1_, int p_142003_2_) {
                    this.m_194003_(p_142003_1_);
                    printwriter.println(p_142003_2_);
                    return p_142003_2_;
                }

                @Override
                public boolean m_142028_(String p_142028_1_, boolean p_142028_2_) {
                    this.m_194003_(p_142028_1_);
                    printwriter.println(p_142028_2_);
                    return p_142028_2_;
                }

                @Override
                public String m_141577_(String p_141577_1_, String p_141577_2_) {
                    this.m_194003_(p_141577_1_);
                    printwriter.println(p_141577_2_);
                    return p_141577_2_;
                }

                @Override
                public double m_141940_(String p_141940_1_, double p_141940_2_) {
                    this.m_194003_(p_141940_1_);
                    printwriter.println(p_141940_2_);
                    return p_141940_2_;
                }

                @Override
                public float m_141839_(String p_141839_1_, float p_141839_2_) {
                    this.m_194003_(p_141839_1_);
                    printwriter.println(p_141839_2_);
                    return p_141839_2_;
                }

                @Override
                public <T> T m_141961_(String p_141961_1_, T p_141961_2_, Function<String, T> p_141961_3_, Function<T, String> p_141961_4_) {
                    this.m_194003_(p_141961_1_);
                    printwriter.println(p_141961_4_.apply(p_141961_2_));
                    return p_141961_2_;
                }

                @Override
                public <T> T m_141702_(String p_141702_1_, T p_141702_2_, IntFunction<T> p_141702_3_, ToIntFunction<T> p_141702_4_) {
                    this.m_194003_(p_141702_1_);
                    printwriter.println(p_141702_4_.applyAsInt(p_141702_2_));
                    return p_141702_2_;
                }
            });
            if (this.f_92060_.m_91268_().m_85436_().isPresent()) {
                printwriter.println("fullscreenResolution:" + this.f_92060_.m_91268_().m_85436_().get().m_85342_());
            }
        }
        catch (Exception exception) {
            f_92077_.error("Failed to save options", (Throwable)exception);
        }
        this.saveOptions = false;
        this.saveOfOptions();
        this.m_92172_();
    }

    public float m_92147_(SoundSource category) {
        return this.f_92109_.getFloat((Object)category);
    }

    public void m_92149_(SoundSource category, float volume) {
        this.f_92109_.put((Object)category, volume);
        this.f_92060_.m_91106_().m_120358_(category, volume);
    }

    public void m_92172_() {
        if (this.f_92060_.f_91074_ != null) {
            int i = 0;
            for (PlayerModelPart playermodelpart : this.f_92108_) {
                i |= playermodelpart.m_36445_();
            }
            this.f_92060_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundClientInformationPacket(this.f_92075_, this.f_92106_, this.f_92119_, this.f_92038_, i, this.f_92127_, this.f_92060_.m_193403_()));
        }
    }

    private void m_92154_(PlayerModelPart modelPart, boolean enable) {
        if (enable) {
            this.f_92108_.add(modelPart);
        } else {
            this.f_92108_.remove(modelPart);
        }
    }

    public boolean m_193921_(PlayerModelPart partIn) {
        return this.f_92108_.contains(partIn);
    }

    public void m_193923_(PlayerModelPart partIn, boolean enabledIn) {
        this.m_92154_(partIn, enabledIn);
        this.m_92172_();
    }

    public CloudStatus m_92174_() {
        return this.f_92106_ >= 4 ? this.f_92114_ : CloudStatus.OFF;
    }

    public boolean m_92175_() {
        return this.f_92028_;
    }

    public void setOptionFloatValueOF(Option option, double val) {
        int valInt;
        if (option == Option.CLOUD_HEIGHT) {
            this.ofCloudsHeight = val;
        }
        if (option == Option.AO_LEVEL) {
            this.ofAoLevel = val;
            this.f_92060_.f_91060_.m_109818_();
        }
        if (option == Option.AA_LEVEL) {
            valInt = (int)val;
            if (valInt > 0 && Config.isShaders()) {
                Config.showGuiMessage(Lang.get("of.message.aa.shaders1"), Lang.get("of.message.aa.shaders2"));
                return;
            }
            if (valInt > 0 && Config.isGraphicsFabulous()) {
                Config.showGuiMessage(Lang.get("of.message.aa.gf1"), Lang.get("of.message.aa.gf2"));
                return;
            }
            this.ofAaLevel = valInt;
            this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
        }
        if (option == Option.AF_LEVEL) {
            this.ofAfLevel = valInt = (int)val;
            this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
            this.f_92060_.m_91088_();
            Shaders.uninit();
        }
        if (option == Option.MIPMAP_TYPE) {
            valInt = (int)val;
            this.ofMipmapType = Config.limit(valInt, 0, 3);
            this.updateMipmaps();
        }
    }

    public double getOptionFloatValueOF(Option settingOption) {
        if (settingOption == Option.CLOUD_HEIGHT) {
            return this.ofCloudsHeight;
        }
        if (settingOption == Option.AO_LEVEL) {
            return this.ofAoLevel;
        }
        if (settingOption == Option.AA_LEVEL) {
            return this.ofAaLevel;
        }
        if (settingOption == Option.AF_LEVEL) {
            return this.ofAfLevel;
        }
        if (settingOption == Option.MIPMAP_TYPE) {
            return this.ofMipmapType;
        }
        if (settingOption == Option.f_91670_) {
            if ((double)this.f_92113_ == Option.f_91670_.m_92235_() && this.f_92041_) {
                return 0.0;
            }
            return this.f_92113_;
        }
        return 3.4028234663852886E38;
    }

    public void setOptionValueOF(Option par1EnumOptions, int par2) {
        if (par1EnumOptions == Option.FOG_FANCY) {
            switch (this.ofFogType) {
                case 2: {
                    this.ofFogType = 3;
                    break;
                }
                default: {
                    this.ofFogType = 2;
                }
            }
        }
        if (par1EnumOptions == Option.FOG_START) {
            this.ofFogStart += 0.2f;
            if (this.ofFogStart > 0.81f) {
                this.ofFogStart = 0.2f;
            }
        }
        if (par1EnumOptions == Option.SMOOTH_FPS) {
            boolean bl = this.ofSmoothFps = !this.ofSmoothFps;
        }
        if (par1EnumOptions == Option.SMOOTH_WORLD) {
            this.ofSmoothWorld = !this.ofSmoothWorld;
            Config.updateThreadPriorities();
        }
        if (par1EnumOptions == Option.CLOUDS) {
            ++this.ofClouds;
            if (this.ofClouds > 3) {
                this.ofClouds = 0;
            }
            this.updateRenderClouds();
        }
        if (par1EnumOptions == Option.TREES) {
            this.ofTrees = Options.nextValue(this.ofTrees, OF_TREES_VALUES);
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.DROPPED_ITEMS) {
            ++this.ofDroppedItems;
            if (this.ofDroppedItems > 2) {
                this.ofDroppedItems = 0;
            }
        }
        if (par1EnumOptions == Option.RAIN) {
            ++this.ofRain;
            if (this.ofRain > 3) {
                this.ofRain = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_WATER) {
            ++this.ofAnimatedWater;
            if (this.ofAnimatedWater == 1) {
                ++this.ofAnimatedWater;
            }
            if (this.ofAnimatedWater > 2) {
                this.ofAnimatedWater = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_LAVA) {
            ++this.ofAnimatedLava;
            if (this.ofAnimatedLava == 1) {
                ++this.ofAnimatedLava;
            }
            if (this.ofAnimatedLava > 2) {
                this.ofAnimatedLava = 0;
            }
        }
        if (par1EnumOptions == Option.ANIMATED_FIRE) {
            boolean bl = this.ofAnimatedFire = !this.ofAnimatedFire;
        }
        if (par1EnumOptions == Option.ANIMATED_PORTAL) {
            boolean bl = this.ofAnimatedPortal = !this.ofAnimatedPortal;
        }
        if (par1EnumOptions == Option.ANIMATED_REDSTONE) {
            boolean bl = this.ofAnimatedRedstone = !this.ofAnimatedRedstone;
        }
        if (par1EnumOptions == Option.ANIMATED_EXPLOSION) {
            boolean bl = this.ofAnimatedExplosion = !this.ofAnimatedExplosion;
        }
        if (par1EnumOptions == Option.ANIMATED_FLAME) {
            boolean bl = this.ofAnimatedFlame = !this.ofAnimatedFlame;
        }
        if (par1EnumOptions == Option.ANIMATED_SMOKE) {
            boolean bl = this.ofAnimatedSmoke = !this.ofAnimatedSmoke;
        }
        if (par1EnumOptions == Option.VOID_PARTICLES) {
            boolean bl = this.ofVoidParticles = !this.ofVoidParticles;
        }
        if (par1EnumOptions == Option.WATER_PARTICLES) {
            boolean bl = this.ofWaterParticles = !this.ofWaterParticles;
        }
        if (par1EnumOptions == Option.PORTAL_PARTICLES) {
            boolean bl = this.ofPortalParticles = !this.ofPortalParticles;
        }
        if (par1EnumOptions == Option.POTION_PARTICLES) {
            boolean bl = this.ofPotionParticles = !this.ofPotionParticles;
        }
        if (par1EnumOptions == Option.FIREWORK_PARTICLES) {
            boolean bl = this.ofFireworkParticles = !this.ofFireworkParticles;
        }
        if (par1EnumOptions == Option.DRIPPING_WATER_LAVA) {
            boolean bl = this.ofDrippingWaterLava = !this.ofDrippingWaterLava;
        }
        if (par1EnumOptions == Option.ANIMATED_TERRAIN) {
            boolean bl = this.ofAnimatedTerrain = !this.ofAnimatedTerrain;
        }
        if (par1EnumOptions == Option.ANIMATED_TEXTURES) {
            boolean bl = this.ofAnimatedTextures = !this.ofAnimatedTextures;
        }
        if (par1EnumOptions == Option.RAIN_SPLASH) {
            boolean bl = this.ofRainSplash = !this.ofRainSplash;
        }
        if (par1EnumOptions == Option.LAGOMETER) {
            boolean bl = this.ofLagometer = !this.ofLagometer;
        }
        if (par1EnumOptions == Option.SHOW_FPS) {
            boolean bl = this.ofShowFps = !this.ofShowFps;
        }
        if (par1EnumOptions == Option.AUTOSAVE_TICKS) {
            int step = 900;
            this.ofAutoSaveTicks = Math.max(this.ofAutoSaveTicks / step * step, step);
            this.ofAutoSaveTicks *= 2;
            if (this.ofAutoSaveTicks > 32 * step) {
                this.ofAutoSaveTicks = step;
            }
        }
        if (par1EnumOptions == Option.BETTER_GRASS) {
            ++this.ofBetterGrass;
            if (this.ofBetterGrass > 3) {
                this.ofBetterGrass = 1;
            }
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.CONNECTED_TEXTURES) {
            ++this.ofConnectedTextures;
            if (this.ofConnectedTextures > 3) {
                this.ofConnectedTextures = 1;
            }
            if (this.ofConnectedTextures == 2) {
                this.f_92060_.f_91060_.m_109818_();
            } else {
                this.f_92060_.m_91088_();
            }
        }
        if (par1EnumOptions == Option.WEATHER) {
            boolean bl = this.ofWeather = !this.ofWeather;
        }
        if (par1EnumOptions == Option.SKY) {
            boolean bl = this.ofSky = !this.ofSky;
        }
        if (par1EnumOptions == Option.STARS) {
            boolean bl = this.ofStars = !this.ofStars;
        }
        if (par1EnumOptions == Option.SUN_MOON) {
            boolean bl = this.ofSunMoon = !this.ofSunMoon;
        }
        if (par1EnumOptions == Option.VIGNETTE) {
            ++this.ofVignette;
            if (this.ofVignette > 2) {
                this.ofVignette = 0;
            }
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES) {
            ++this.ofChunkUpdates;
            if (this.ofChunkUpdates > 5) {
                this.ofChunkUpdates = 1;
            }
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES_DYNAMIC) {
            boolean bl = this.ofChunkUpdatesDynamic = !this.ofChunkUpdatesDynamic;
        }
        if (par1EnumOptions == Option.TIME) {
            ++this.ofTime;
            if (this.ofTime > 2) {
                this.ofTime = 0;
            }
        }
        if (par1EnumOptions == Option.PROFILER) {
            boolean bl = this.ofProfiler = !this.ofProfiler;
        }
        if (par1EnumOptions == Option.BETTER_SNOW) {
            this.ofBetterSnow = !this.ofBetterSnow;
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.SWAMP_COLORS) {
            this.ofSwampColors = !this.ofSwampColors;
            CustomColors.updateUseDefaultGrassFoliageColors();
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.RANDOM_ENTITIES) {
            this.ofRandomEntities = !this.ofRandomEntities;
            RandomEntities.update();
        }
        if (par1EnumOptions == Option.CUSTOM_FONTS) {
            this.ofCustomFonts = !this.ofCustomFonts;
            FontUtils.reloadFonts();
        }
        if (par1EnumOptions == Option.CUSTOM_COLORS) {
            this.ofCustomColors = !this.ofCustomColors;
            CustomColors.update();
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.CUSTOM_ITEMS) {
            this.ofCustomItems = !this.ofCustomItems;
            this.f_92060_.m_91088_();
        }
        if (par1EnumOptions == Option.CUSTOM_SKY) {
            this.ofCustomSky = !this.ofCustomSky;
            CustomSky.update();
        }
        if (par1EnumOptions == Option.SHOW_CAPES) {
            boolean bl = this.ofShowCapes = !this.ofShowCapes;
        }
        if (par1EnumOptions == Option.NATURAL_TEXTURES) {
            this.ofNaturalTextures = !this.ofNaturalTextures;
            NaturalTextures.update();
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.EMISSIVE_TEXTURES) {
            this.ofEmissiveTextures = !this.ofEmissiveTextures;
            this.f_92060_.m_91088_();
        }
        if (par1EnumOptions == Option.FAST_MATH) {
            Mth.fastMath = this.ofFastMath = !this.ofFastMath;
        }
        if (par1EnumOptions == Option.FAST_RENDER) {
            boolean bl = this.ofFastRender = !this.ofFastRender;
        }
        if (par1EnumOptions == Option.TRANSLUCENT_BLOCKS) {
            this.ofTranslucentBlocks = this.ofTranslucentBlocks == 0 ? 1 : (this.ofTranslucentBlocks == 1 ? 2 : (this.ofTranslucentBlocks == 2 ? 0 : 0));
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.LAZY_CHUNK_LOADING) {
            boolean bl = this.ofLazyChunkLoading = !this.ofLazyChunkLoading;
        }
        if (par1EnumOptions == Option.RENDER_REGIONS) {
            this.ofRenderRegions = !this.ofRenderRegions;
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.SMART_ANIMATIONS) {
            this.ofSmartAnimations = !this.ofSmartAnimations;
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.DYNAMIC_FOV) {
            boolean bl = this.ofDynamicFov = !this.ofDynamicFov;
        }
        if (par1EnumOptions == Option.ALTERNATE_BLOCKS) {
            this.ofAlternateBlocks = !this.ofAlternateBlocks;
            this.f_92060_.f_91060_.m_109818_();
        }
        if (par1EnumOptions == Option.DYNAMIC_LIGHTS) {
            this.ofDynamicLights = Options.nextValue(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
            DynamicLights.removeLights((LevelRenderer)this.f_92060_.f_91060_);
        }
        if (par1EnumOptions == Option.SCREENSHOT_SIZE) {
            ++this.ofScreenshotSize;
            if (this.ofScreenshotSize > 4) {
                this.ofScreenshotSize = 1;
            }
        }
        if (par1EnumOptions == Option.CUSTOM_ENTITY_MODELS) {
            this.ofCustomEntityModels = !this.ofCustomEntityModels;
            this.f_92060_.m_91088_();
        }
        if (par1EnumOptions == Option.CUSTOM_GUIS) {
            this.ofCustomGuis = !this.ofCustomGuis;
            CustomGuis.update();
        }
        if (par1EnumOptions == Option.SHOW_GL_ERRORS) {
            boolean bl = this.ofShowGlErrors = !this.ofShowGlErrors;
        }
        if (par1EnumOptions == Option.HELD_ITEM_TOOLTIPS) {
            boolean bl = this.f_92130_ = !this.f_92130_;
        }
        if (par1EnumOptions == Option.ADVANCED_TOOLTIPS) {
            boolean bl = this.f_92125_ = !this.f_92125_;
        }
        if (par1EnumOptions == Option.CHAT_BACKGROUND) {
            this.ofChatBackground = this.ofChatBackground == 0 ? 5 : (this.ofChatBackground == 5 ? 3 : 0);
        }
        if (par1EnumOptions == Option.CHAT_SHADOW) {
            this.ofChatShadow = !this.ofChatShadow;
        }
    }

    public Component getKeyComponentOF(Option option) {
        String str = this.getKeyBindingOF(option);
        TextComponent comp = new TextComponent(str);
        return comp;
    }

    public String getKeyBindingOF(Option par1EnumOptions) {
        String var2 = I18n.m_118938_((String)par1EnumOptions.getResourceKey(), (Object[])new Object[0]) + ": ";
        if (var2 == null) {
            var2 = par1EnumOptions.getResourceKey();
        }
        String s = var2;
        if (par1EnumOptions == Option.f_91675_) {
            int distChunks = (int)Option.f_91675_.m_92221_(this);
            String str = I18n.m_118938_((String)"of.options.renderDistance.tiny", (Object[])new Object[0]);
            int baseDist = 2;
            if (distChunks >= 4) {
                str = I18n.m_118938_((String)"of.options.renderDistance.short", (Object[])new Object[0]);
                baseDist = 4;
            }
            if (distChunks >= 8) {
                str = I18n.m_118938_((String)"of.options.renderDistance.normal", (Object[])new Object[0]);
                baseDist = 8;
            }
            if (distChunks >= 16) {
                str = I18n.m_118938_((String)"of.options.renderDistance.far", (Object[])new Object[0]);
                baseDist = 16;
            }
            if (distChunks >= 32) {
                str = Lang.get("of.options.renderDistance.extreme");
                baseDist = 32;
            }
            if (distChunks >= 48) {
                str = Lang.get("of.options.renderDistance.insane");
                baseDist = 48;
            }
            if (distChunks >= 64) {
                str = Lang.get("of.options.renderDistance.ludicrous");
                baseDist = 64;
            }
            int diff = this.f_92106_ - baseDist;
            String descr = str;
            if (diff > 0) {
                descr = descr + "+";
            }
            return var2 + distChunks + " " + descr + "";
        }
        if (par1EnumOptions == Option.FOG_FANCY) {
            switch (this.ofFogType) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
                case 3: {
                    return s + Lang.getOff();
                }
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.FOG_START) {
            return s + this.ofFogStart;
        }
        if (par1EnumOptions == Option.MIPMAP_TYPE) {
            return FloatOptions.getText((Option)par1EnumOptions, (double)this.ofMipmapType);
        }
        if (par1EnumOptions == Option.SMOOTH_FPS) {
            if (this.ofSmoothFps) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SMOOTH_WORLD) {
            if (this.ofSmoothWorld) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CLOUDS) {
            switch (this.ofClouds) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
                case 3: {
                    return s + Lang.getOff();
                }
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.TREES) {
            switch (this.ofTrees) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
                case 4: {
                    return s + Lang.get("of.general.smart");
                }
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.DROPPED_ITEMS) {
            switch (this.ofDroppedItems) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.RAIN) {
            switch (this.ofRain) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
                case 3: {
                    return s + Lang.getOff();
                }
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.ANIMATED_WATER) {
            switch (this.ofAnimatedWater) {
                case 1: {
                    return s + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return s + Lang.getOff();
                }
            }
            return s + Lang.getOn();
        }
        if (par1EnumOptions == Option.ANIMATED_LAVA) {
            switch (this.ofAnimatedLava) {
                case 1: {
                    return s + Lang.get("of.options.animation.dynamic");
                }
                case 2: {
                    return s + Lang.getOff();
                }
            }
            return s + Lang.getOn();
        }
        if (par1EnumOptions == Option.ANIMATED_FIRE) {
            if (this.ofAnimatedFire) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_PORTAL) {
            if (this.ofAnimatedPortal) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_REDSTONE) {
            if (this.ofAnimatedRedstone) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_EXPLOSION) {
            if (this.ofAnimatedExplosion) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_FLAME) {
            if (this.ofAnimatedFlame) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_SMOKE) {
            if (this.ofAnimatedSmoke) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.VOID_PARTICLES) {
            if (this.ofVoidParticles) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.WATER_PARTICLES) {
            if (this.ofWaterParticles) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.PORTAL_PARTICLES) {
            if (this.ofPortalParticles) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.POTION_PARTICLES) {
            if (this.ofPotionParticles) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.FIREWORK_PARTICLES) {
            if (this.ofFireworkParticles) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.DRIPPING_WATER_LAVA) {
            if (this.ofDrippingWaterLava) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_TERRAIN) {
            if (this.ofAnimatedTerrain) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ANIMATED_TEXTURES) {
            if (this.ofAnimatedTextures) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.RAIN_SPLASH) {
            if (this.ofRainSplash) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.LAGOMETER) {
            if (this.ofLagometer) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_FPS) {
            if (this.ofShowFps) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.AUTOSAVE_TICKS) {
            int step = 900;
            if (this.ofAutoSaveTicks <= step) {
                return s + Lang.get("of.options.save.45s");
            }
            if (this.ofAutoSaveTicks <= 2 * step) {
                return s + Lang.get("of.options.save.90s");
            }
            if (this.ofAutoSaveTicks <= 4 * step) {
                return s + Lang.get("of.options.save.3min");
            }
            if (this.ofAutoSaveTicks <= 8 * step) {
                return s + Lang.get("of.options.save.6min");
            }
            if (this.ofAutoSaveTicks <= 16 * step) {
                return s + Lang.get("of.options.save.12min");
            }
            return s + Lang.get("of.options.save.24min");
        }
        if (par1EnumOptions == Option.BETTER_GRASS) {
            switch (this.ofBetterGrass) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CONNECTED_TEXTURES) {
            switch (this.ofConnectedTextures) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.WEATHER) {
            if (this.ofWeather) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SKY) {
            if (this.ofSky) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.STARS) {
            if (this.ofStars) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SUN_MOON) {
            if (this.ofSunMoon) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.VIGNETTE) {
            switch (this.ofVignette) {
                case 1: {
                    return s + Lang.getFast();
                }
                case 2: {
                    return s + Lang.getFancy();
                }
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES) {
            return s + this.ofChunkUpdates;
        }
        if (par1EnumOptions == Option.CHUNK_UPDATES_DYNAMIC) {
            if (this.ofChunkUpdatesDynamic) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.TIME) {
            if (this.ofTime == 1) {
                return s + Lang.get("of.options.time.dayOnly");
            }
            if (this.ofTime == 2) {
                return s + Lang.get("of.options.time.nightOnly");
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.AA_LEVEL) {
            return FloatOptions.getText((Option)par1EnumOptions, (double)this.ofAaLevel);
        }
        if (par1EnumOptions == Option.AF_LEVEL) {
            return FloatOptions.getText((Option)par1EnumOptions, (double)this.ofAfLevel);
        }
        if (par1EnumOptions == Option.PROFILER) {
            if (this.ofProfiler) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.BETTER_SNOW) {
            if (this.ofBetterSnow) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SWAMP_COLORS) {
            if (this.ofSwampColors) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.RANDOM_ENTITIES) {
            if (this.ofRandomEntities) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_FONTS) {
            if (this.ofCustomFonts) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_COLORS) {
            if (this.ofCustomColors) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_SKY) {
            if (this.ofCustomSky) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_CAPES) {
            if (this.ofShowCapes) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_ITEMS) {
            if (this.ofCustomItems) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.NATURAL_TEXTURES) {
            if (this.ofNaturalTextures) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.EMISSIVE_TEXTURES) {
            if (this.ofEmissiveTextures) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.FAST_MATH) {
            if (this.ofFastMath) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.FAST_RENDER) {
            if (this.ofFastRender) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.TRANSLUCENT_BLOCKS) {
            if (this.ofTranslucentBlocks == 1) {
                return s + Lang.getFast();
            }
            if (this.ofTranslucentBlocks == 2) {
                return s + Lang.getFancy();
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.LAZY_CHUNK_LOADING) {
            if (this.ofLazyChunkLoading) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.RENDER_REGIONS) {
            if (this.ofRenderRegions) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SMART_ANIMATIONS) {
            if (this.ofSmartAnimations) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.DYNAMIC_FOV) {
            if (this.ofDynamicFov) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ALTERNATE_BLOCKS) {
            if (this.ofAlternateBlocks) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.DYNAMIC_LIGHTS) {
            int index = Options.indexOf(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
            return s + Options.getTranslation(KEYS_DYNAMIC_LIGHTS, index);
        }
        if (par1EnumOptions == Option.SCREENSHOT_SIZE) {
            if (this.ofScreenshotSize <= 1) {
                return s + Lang.getDefault();
            }
            return s + this.ofScreenshotSize + "x";
        }
        if (par1EnumOptions == Option.CUSTOM_ENTITY_MODELS) {
            if (this.ofCustomEntityModels) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.CUSTOM_GUIS) {
            if (this.ofCustomGuis) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.SHOW_GL_ERRORS) {
            if (this.ofShowGlErrors) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.HELD_ITEM_TOOLTIPS) {
            if (this.f_92130_) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.ADVANCED_TOOLTIPS) {
            if (this.f_92125_) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions == Option.f_91670_) {
            double var6 = Option.f_91670_.m_92221_(this);
            if (var6 == 0.0) {
                return var2 + Lang.get("of.options.framerateLimit.vsync");
            }
            if (var6 == Option.f_91670_.m_92235_()) {
                return var2 + I18n.m_118938_((String)"options.framerateLimit.max", (Object[])new Object[0]);
            }
            return var2 + (int)var6 + " fps";
        }
        if (par1EnumOptions == Option.CHAT_BACKGROUND) {
            if (this.ofChatBackground == 3) {
                return s + Lang.getOff();
            }
            if (this.ofChatBackground == 5) {
                return s + Lang.get("of.general.compact");
            }
            return s + Lang.getDefault();
        }
        if (par1EnumOptions == Option.CHAT_SHADOW) {
            if (this.ofChatShadow) {
                return s + Lang.getOn();
            }
            return s + Lang.getOff();
        }
        if (par1EnumOptions instanceof ProgressOption) {
            ProgressOption spo = (ProgressOption)par1EnumOptions;
            double d0 = spo.m_92221_(this);
            return d0 == 0.0 ? s + I18n.m_118938_((String)"options.off", (Object[])new Object[0]) : s + (int)(d0 * 100.0) + "%";
        }
        return null;
    }

    public void loadOfOptions() {
        try {
            File ofReadFile = this.optionsFileOF;
            if (!ofReadFile.exists()) {
                ofReadFile = this.f_92110_;
            }
            if (!ofReadFile.exists()) {
                return;
            }
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(ofReadFile), StandardCharsets.UTF_8));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                try {
                    String[] as = s.split(":");
                    if (as[0].equals("ofRenderDistanceChunks") && as.length >= 2) {
                        this.f_92106_ = Integer.valueOf(as[1]);
                        this.f_92106_ = Config.limit(this.f_92106_, 2, 1024);
                    }
                    if (as[0].equals("ofFogType") && as.length >= 2) {
                        this.ofFogType = Integer.valueOf(as[1]);
                        this.ofFogType = Config.limit(this.ofFogType, 2, 3);
                    }
                    if (as[0].equals("ofFogStart") && as.length >= 2) {
                        this.ofFogStart = Float.valueOf(as[1]).floatValue();
                        if (this.ofFogStart < 0.2f) {
                            this.ofFogStart = 0.2f;
                        }
                        if (this.ofFogStart > 0.81f) {
                            this.ofFogStart = 0.8f;
                        }
                    }
                    if (as[0].equals("ofMipmapType") && as.length >= 2) {
                        this.ofMipmapType = Integer.valueOf(as[1]);
                        this.ofMipmapType = Config.limit(this.ofMipmapType, 0, 3);
                    }
                    if (as[0].equals("ofOcclusionFancy") && as.length >= 2) {
                        this.ofOcclusionFancy = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmoothFps") && as.length >= 2) {
                        this.ofSmoothFps = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmoothWorld") && as.length >= 2) {
                        this.ofSmoothWorld = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAoLevel") && as.length >= 2) {
                        this.ofAoLevel = Float.valueOf(as[1]).floatValue();
                        this.ofAoLevel = Config.limit(this.ofAoLevel, 0.0, 1.0);
                    }
                    if (as[0].equals("ofClouds") && as.length >= 2) {
                        this.ofClouds = Integer.valueOf(as[1]);
                        this.ofClouds = Config.limit(this.ofClouds, 0, 3);
                        this.updateRenderClouds();
                    }
                    if (as[0].equals("ofCloudsHeight") && as.length >= 2) {
                        this.ofCloudsHeight = Float.valueOf(as[1]).floatValue();
                        this.ofCloudsHeight = Config.limit(this.ofCloudsHeight, 0.0, 1.0);
                    }
                    if (as[0].equals("ofTrees") && as.length >= 2) {
                        this.ofTrees = Integer.valueOf(as[1]);
                        this.ofTrees = Options.limit(this.ofTrees, OF_TREES_VALUES);
                    }
                    if (as[0].equals("ofDroppedItems") && as.length >= 2) {
                        this.ofDroppedItems = Integer.valueOf(as[1]);
                        this.ofDroppedItems = Config.limit(this.ofDroppedItems, 0, 2);
                    }
                    if (as[0].equals("ofRain") && as.length >= 2) {
                        this.ofRain = Integer.valueOf(as[1]);
                        this.ofRain = Config.limit(this.ofRain, 0, 3);
                    }
                    if (as[0].equals("ofAnimatedWater") && as.length >= 2) {
                        this.ofAnimatedWater = Integer.valueOf(as[1]);
                        this.ofAnimatedWater = Config.limit(this.ofAnimatedWater, 0, 2);
                    }
                    if (as[0].equals("ofAnimatedLava") && as.length >= 2) {
                        this.ofAnimatedLava = Integer.valueOf(as[1]);
                        this.ofAnimatedLava = Config.limit(this.ofAnimatedLava, 0, 2);
                    }
                    if (as[0].equals("ofAnimatedFire") && as.length >= 2) {
                        this.ofAnimatedFire = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedPortal") && as.length >= 2) {
                        this.ofAnimatedPortal = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedRedstone") && as.length >= 2) {
                        this.ofAnimatedRedstone = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedExplosion") && as.length >= 2) {
                        this.ofAnimatedExplosion = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedFlame") && as.length >= 2) {
                        this.ofAnimatedFlame = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedSmoke") && as.length >= 2) {
                        this.ofAnimatedSmoke = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofVoidParticles") && as.length >= 2) {
                        this.ofVoidParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofWaterParticles") && as.length >= 2) {
                        this.ofWaterParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofPortalParticles") && as.length >= 2) {
                        this.ofPortalParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofPotionParticles") && as.length >= 2) {
                        this.ofPotionParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofFireworkParticles") && as.length >= 2) {
                        this.ofFireworkParticles = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDrippingWaterLava") && as.length >= 2) {
                        this.ofDrippingWaterLava = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedTerrain") && as.length >= 2) {
                        this.ofAnimatedTerrain = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAnimatedTextures") && as.length >= 2) {
                        this.ofAnimatedTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRainSplash") && as.length >= 2) {
                        this.ofRainSplash = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofLagometer") && as.length >= 2) {
                        this.ofLagometer = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowFps") && as.length >= 2) {
                        this.ofShowFps = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAutoSaveTicks") && as.length >= 2) {
                        this.ofAutoSaveTicks = Integer.valueOf(as[1]);
                        this.ofAutoSaveTicks = Config.limit(this.ofAutoSaveTicks, 40, 40000);
                    }
                    if (as[0].equals("ofBetterGrass") && as.length >= 2) {
                        this.ofBetterGrass = Integer.valueOf(as[1]);
                        this.ofBetterGrass = Config.limit(this.ofBetterGrass, 1, 3);
                    }
                    if (as[0].equals("ofConnectedTextures") && as.length >= 2) {
                        this.ofConnectedTextures = Integer.valueOf(as[1]);
                        this.ofConnectedTextures = Config.limit(this.ofConnectedTextures, 1, 3);
                    }
                    if (as[0].equals("ofWeather") && as.length >= 2) {
                        this.ofWeather = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSky") && as.length >= 2) {
                        this.ofSky = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofStars") && as.length >= 2) {
                        this.ofStars = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSunMoon") && as.length >= 2) {
                        this.ofSunMoon = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofVignette") && as.length >= 2) {
                        this.ofVignette = Integer.valueOf(as[1]);
                        this.ofVignette = Config.limit(this.ofVignette, 0, 2);
                    }
                    if (as[0].equals("ofChunkUpdates") && as.length >= 2) {
                        this.ofChunkUpdates = Integer.valueOf(as[1]);
                        this.ofChunkUpdates = Config.limit(this.ofChunkUpdates, 1, 5);
                    }
                    if (as[0].equals("ofChunkUpdatesDynamic") && as.length >= 2) {
                        this.ofChunkUpdatesDynamic = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofTime") && as.length >= 2) {
                        this.ofTime = Integer.valueOf(as[1]);
                        this.ofTime = Config.limit(this.ofTime, 0, 2);
                    }
                    if (as[0].equals("ofAaLevel") && as.length >= 2) {
                        this.ofAaLevel = Integer.valueOf(as[1]);
                        this.ofAaLevel = Config.limit(this.ofAaLevel, 0, 16);
                    }
                    if (as[0].equals("ofAfLevel") && as.length >= 2) {
                        this.ofAfLevel = Integer.valueOf(as[1]);
                        this.ofAfLevel = Config.limit(this.ofAfLevel, 1, 16);
                    }
                    if (as[0].equals("ofProfiler") && as.length >= 2) {
                        this.ofProfiler = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofBetterSnow") && as.length >= 2) {
                        this.ofBetterSnow = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSwampColors") && as.length >= 2) {
                        this.ofSwampColors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRandomEntities") && as.length >= 2) {
                        this.ofRandomEntities = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomFonts") && as.length >= 2) {
                        this.ofCustomFonts = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomColors") && as.length >= 2) {
                        this.ofCustomColors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomItems") && as.length >= 2) {
                        this.ofCustomItems = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomSky") && as.length >= 2) {
                        this.ofCustomSky = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowCapes") && as.length >= 2) {
                        this.ofShowCapes = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofNaturalTextures") && as.length >= 2) {
                        this.ofNaturalTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofEmissiveTextures") && as.length >= 2) {
                        this.ofEmissiveTextures = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofLazyChunkLoading") && as.length >= 2) {
                        this.ofLazyChunkLoading = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofRenderRegions") && as.length >= 2) {
                        this.ofRenderRegions = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofSmartAnimations") && as.length >= 2) {
                        this.ofSmartAnimations = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDynamicFov") && as.length >= 2) {
                        this.ofDynamicFov = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofAlternateBlocks") && as.length >= 2) {
                        this.ofAlternateBlocks = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofDynamicLights") && as.length >= 2) {
                        this.ofDynamicLights = Integer.valueOf(as[1]);
                        this.ofDynamicLights = Options.limit(this.ofDynamicLights, OF_DYNAMIC_LIGHTS);
                    }
                    if (as[0].equals("ofScreenshotSize") && as.length >= 2) {
                        this.ofScreenshotSize = Integer.valueOf(as[1]);
                        this.ofScreenshotSize = Config.limit(this.ofScreenshotSize, 1, 4);
                    }
                    if (as[0].equals("ofCustomEntityModels") && as.length >= 2) {
                        this.ofCustomEntityModels = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofCustomGuis") && as.length >= 2) {
                        this.ofCustomGuis = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofShowGlErrors") && as.length >= 2) {
                        this.ofShowGlErrors = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofFastMath") && as.length >= 2) {
                        Mth.fastMath = this.ofFastMath = Boolean.valueOf(as[1]).booleanValue();
                    }
                    if (as[0].equals("ofFastRender") && as.length >= 2) {
                        this.ofFastRender = Boolean.valueOf(as[1]);
                    }
                    if (as[0].equals("ofTranslucentBlocks") && as.length >= 2) {
                        this.ofTranslucentBlocks = Integer.valueOf(as[1]);
                        this.ofTranslucentBlocks = Config.limit(this.ofTranslucentBlocks, 0, 2);
                    }
                    if (as[0].equals("ofChatBackground") && as.length >= 2) {
                        this.ofChatBackground = Integer.valueOf(as[1]);
                    }
                    if (as[0].equals("ofChatShadow") && as.length >= 2) {
                        this.ofChatShadow = Boolean.valueOf(as[1]);
                    }
                    if (!as[0].equals("key_" + this.ofKeyBindZoom.m_90860_())) continue;
                    this.ofKeyBindZoom.m_90848_(InputConstants.m_84851_((String)as[1]));
                }
                catch (Exception exception1) {
                    Config.dbg("Skipping bad option: " + s);
                    exception1.printStackTrace();
                }
            }
            KeyUtils.fixKeyConflicts((KeyMapping[])this.f_92059_, (KeyMapping[])new KeyMapping[]{this.ofKeyBindZoom});
            KeyMapping.m_90854_();
            bufferedreader.close();
        }
        catch (Exception exception) {
            Config.warn("Failed to load options");
            exception.printStackTrace();
        }
    }

    public void saveOfOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.optionsFileOF), StandardCharsets.UTF_8));
            printwriter.println("ofFogType:" + this.ofFogType);
            printwriter.println("ofFogStart:" + this.ofFogStart);
            printwriter.println("ofMipmapType:" + this.ofMipmapType);
            printwriter.println("ofOcclusionFancy:" + this.ofOcclusionFancy);
            printwriter.println("ofSmoothFps:" + this.ofSmoothFps);
            printwriter.println("ofSmoothWorld:" + this.ofSmoothWorld);
            printwriter.println("ofAoLevel:" + this.ofAoLevel);
            printwriter.println("ofClouds:" + this.ofClouds);
            printwriter.println("ofCloudsHeight:" + this.ofCloudsHeight);
            printwriter.println("ofTrees:" + this.ofTrees);
            printwriter.println("ofDroppedItems:" + this.ofDroppedItems);
            printwriter.println("ofRain:" + this.ofRain);
            printwriter.println("ofAnimatedWater:" + this.ofAnimatedWater);
            printwriter.println("ofAnimatedLava:" + this.ofAnimatedLava);
            printwriter.println("ofAnimatedFire:" + this.ofAnimatedFire);
            printwriter.println("ofAnimatedPortal:" + this.ofAnimatedPortal);
            printwriter.println("ofAnimatedRedstone:" + this.ofAnimatedRedstone);
            printwriter.println("ofAnimatedExplosion:" + this.ofAnimatedExplosion);
            printwriter.println("ofAnimatedFlame:" + this.ofAnimatedFlame);
            printwriter.println("ofAnimatedSmoke:" + this.ofAnimatedSmoke);
            printwriter.println("ofVoidParticles:" + this.ofVoidParticles);
            printwriter.println("ofWaterParticles:" + this.ofWaterParticles);
            printwriter.println("ofPortalParticles:" + this.ofPortalParticles);
            printwriter.println("ofPotionParticles:" + this.ofPotionParticles);
            printwriter.println("ofFireworkParticles:" + this.ofFireworkParticles);
            printwriter.println("ofDrippingWaterLava:" + this.ofDrippingWaterLava);
            printwriter.println("ofAnimatedTerrain:" + this.ofAnimatedTerrain);
            printwriter.println("ofAnimatedTextures:" + this.ofAnimatedTextures);
            printwriter.println("ofRainSplash:" + this.ofRainSplash);
            printwriter.println("ofLagometer:" + this.ofLagometer);
            printwriter.println("ofShowFps:" + this.ofShowFps);
            printwriter.println("ofAutoSaveTicks:" + this.ofAutoSaveTicks);
            printwriter.println("ofBetterGrass:" + this.ofBetterGrass);
            printwriter.println("ofConnectedTextures:" + this.ofConnectedTextures);
            printwriter.println("ofWeather:" + this.ofWeather);
            printwriter.println("ofSky:" + this.ofSky);
            printwriter.println("ofStars:" + this.ofStars);
            printwriter.println("ofSunMoon:" + this.ofSunMoon);
            printwriter.println("ofVignette:" + this.ofVignette);
            printwriter.println("ofChunkUpdates:" + this.ofChunkUpdates);
            printwriter.println("ofChunkUpdatesDynamic:" + this.ofChunkUpdatesDynamic);
            printwriter.println("ofTime:" + this.ofTime);
            printwriter.println("ofAaLevel:" + this.ofAaLevel);
            printwriter.println("ofAfLevel:" + this.ofAfLevel);
            printwriter.println("ofProfiler:" + this.ofProfiler);
            printwriter.println("ofBetterSnow:" + this.ofBetterSnow);
            printwriter.println("ofSwampColors:" + this.ofSwampColors);
            printwriter.println("ofRandomEntities:" + this.ofRandomEntities);
            printwriter.println("ofCustomFonts:" + this.ofCustomFonts);
            printwriter.println("ofCustomColors:" + this.ofCustomColors);
            printwriter.println("ofCustomItems:" + this.ofCustomItems);
            printwriter.println("ofCustomSky:" + this.ofCustomSky);
            printwriter.println("ofShowCapes:" + this.ofShowCapes);
            printwriter.println("ofNaturalTextures:" + this.ofNaturalTextures);
            printwriter.println("ofEmissiveTextures:" + this.ofEmissiveTextures);
            printwriter.println("ofLazyChunkLoading:" + this.ofLazyChunkLoading);
            printwriter.println("ofRenderRegions:" + this.ofRenderRegions);
            printwriter.println("ofSmartAnimations:" + this.ofSmartAnimations);
            printwriter.println("ofDynamicFov:" + this.ofDynamicFov);
            printwriter.println("ofAlternateBlocks:" + this.ofAlternateBlocks);
            printwriter.println("ofDynamicLights:" + this.ofDynamicLights);
            printwriter.println("ofScreenshotSize:" + this.ofScreenshotSize);
            printwriter.println("ofCustomEntityModels:" + this.ofCustomEntityModels);
            printwriter.println("ofCustomGuis:" + this.ofCustomGuis);
            printwriter.println("ofShowGlErrors:" + this.ofShowGlErrors);
            printwriter.println("ofFastMath:" + this.ofFastMath);
            printwriter.println("ofFastRender:" + this.ofFastRender);
            printwriter.println("ofTranslucentBlocks:" + this.ofTranslucentBlocks);
            printwriter.println("ofChatBackground:" + this.ofChatBackground);
            printwriter.println("ofChatShadow:" + this.ofChatShadow);
            printwriter.println("key_" + this.ofKeyBindZoom.m_90860_() + ":" + this.ofKeyBindZoom.m_90865_());
            printwriter.close();
        }
        catch (Exception exception) {
            Config.warn("Failed to save options");
            exception.printStackTrace();
        }
    }

    public void updateRenderClouds() {
        RenderTarget framebuffer;
        LevelRenderer wr;
        switch (this.ofClouds) {
            case 3: {
                this.f_92114_ = CloudStatus.OFF;
                break;
            }
            case 1: {
                this.f_92114_ = CloudStatus.FAST;
                break;
            }
            case 2: {
                this.f_92114_ = CloudStatus.FANCY;
                break;
            }
            default: {
                this.f_92114_ = this.f_92115_ != GraphicsStatus.FAST ? CloudStatus.FANCY : CloudStatus.FAST;
            }
        }
        if (this.f_92115_ == GraphicsStatus.FABULOUS && (wr = Minecraft.m_91087_().f_91060_) != null && (framebuffer = wr.m_109832_()) != null) {
            framebuffer.m_83954_(Minecraft.f_91002_);
        }
    }

    public void resetSettings() {
        this.f_92106_ = 8;
        this.f_92112_ = 1.0f;
        this.f_92080_ = true;
        this.f_92113_ = (int)Option.f_91670_.m_92235_();
        this.f_92041_ = false;
        this.updateVSync();
        this.f_92027_ = 4;
        this.f_92115_ = GraphicsStatus.FANCY;
        this.f_92116_ = AmbientOcclusionStatus.MAX;
        this.f_92114_ = CloudStatus.FANCY;
        this.f_92068_ = 70.0;
        this.f_92071_ = 0.0;
        this.f_92072_ = 0;
        this.f_92073_ = ParticleStatus.ALL;
        this.f_92130_ = true;
        this.f_92043_ = false;
        this.ofFogType = 2;
        this.ofFogStart = 0.8f;
        this.ofMipmapType = 0;
        this.ofOcclusionFancy = false;
        this.ofSmartAnimations = false;
        this.ofSmoothFps = false;
        Config.updateAvailableProcessors();
        this.ofSmoothWorld = Config.isSingleProcessor();
        this.ofLazyChunkLoading = false;
        this.ofRenderRegions = false;
        this.ofFastMath = false;
        this.ofFastRender = false;
        this.ofTranslucentBlocks = 0;
        this.ofDynamicFov = true;
        this.ofAlternateBlocks = true;
        this.ofDynamicLights = 3;
        this.ofScreenshotSize = 1;
        this.ofCustomEntityModels = true;
        this.ofCustomGuis = true;
        this.ofShowGlErrors = true;
        this.ofChatBackground = 0;
        this.ofChatShadow = true;
        this.ofAoLevel = 1.0;
        this.ofAaLevel = 0;
        this.ofAfLevel = 1;
        this.ofClouds = 0;
        this.ofCloudsHeight = 0.0;
        this.ofTrees = 0;
        this.ofRain = 0;
        this.ofBetterGrass = 3;
        this.ofAutoSaveTicks = 4000;
        this.ofLagometer = false;
        this.ofShowFps = false;
        this.ofProfiler = false;
        this.ofWeather = true;
        this.ofSky = true;
        this.ofStars = true;
        this.ofSunMoon = true;
        this.ofVignette = 0;
        this.ofChunkUpdates = 1;
        this.ofChunkUpdatesDynamic = false;
        this.ofTime = 0;
        this.ofBetterSnow = false;
        this.ofSwampColors = true;
        this.ofRandomEntities = true;
        this.f_92032_ = 2;
        this.ofCustomFonts = true;
        this.ofCustomColors = true;
        this.ofCustomItems = true;
        this.ofCustomSky = true;
        this.ofShowCapes = true;
        this.ofConnectedTextures = 2;
        this.ofNaturalTextures = false;
        this.ofEmissiveTextures = true;
        this.ofAnimatedWater = 0;
        this.ofAnimatedLava = 0;
        this.ofAnimatedFire = true;
        this.ofAnimatedPortal = true;
        this.ofAnimatedRedstone = true;
        this.ofAnimatedExplosion = true;
        this.ofAnimatedFlame = true;
        this.ofAnimatedSmoke = true;
        this.ofVoidParticles = true;
        this.ofWaterParticles = true;
        this.ofRainSplash = true;
        this.ofPortalParticles = true;
        this.ofPotionParticles = true;
        this.ofFireworkParticles = true;
        this.ofDrippingWaterLava = true;
        this.ofAnimatedTerrain = true;
        this.ofAnimatedTextures = true;
        Shaders.setShaderPack("OFF");
        Shaders.configAntialiasingLevel = 0;
        Shaders.uninit();
        Shaders.storeConfig();
        this.f_92060_.m_91088_();
        this.m_92169_();
    }

    public void updateVSync() {
        if (this.f_92060_.m_91268_() != null) {
            this.f_92060_.m_91268_().m_85409_(this.f_92041_);
        }
    }

    public void updateMipmaps() {
        this.f_92060_.m_91312_(this.f_92027_);
        this.f_92060_.m_91088_();
    }

    public void setAllAnimations(boolean flag) {
        int animVal;
        this.ofAnimatedWater = animVal = flag ? 0 : 2;
        this.ofAnimatedLava = animVal;
        this.ofAnimatedFire = flag;
        this.ofAnimatedPortal = flag;
        this.ofAnimatedRedstone = flag;
        this.ofAnimatedExplosion = flag;
        this.ofAnimatedFlame = flag;
        this.ofAnimatedSmoke = flag;
        this.ofVoidParticles = flag;
        this.ofWaterParticles = flag;
        this.ofRainSplash = flag;
        this.ofPortalParticles = flag;
        this.ofPotionParticles = flag;
        this.ofFireworkParticles = flag;
        this.f_92073_ = flag ? ParticleStatus.ALL : ParticleStatus.MINIMAL;
        this.ofDrippingWaterLava = flag;
        this.ofAnimatedTerrain = flag;
        this.ofAnimatedTextures = flag;
    }

    private static int nextValue(int val, int[] vals) {
        int index = Options.indexOf(val, vals);
        if (index < 0) {
            return vals[0];
        }
        if (++index >= vals.length) {
            index = 0;
        }
        return vals[index];
    }

    private static int limit(int val, int[] vals) {
        int index = Options.indexOf(val, vals);
        if (index < 0) {
            return vals[0];
        }
        return val;
    }

    private static int indexOf(int val, int[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != val) continue;
            return i;
        }
        return -1;
    }

    private static String getTranslation(String[] strArray, int index) {
        if (index < 0 || index >= strArray.length) {
            index = 0;
        }
        return I18n.m_118938_((String)strArray[index], (Object[])new Object[0]);
    }

    private void setForgeKeybindProperties() {
        if (!Reflector.KeyConflictContext_IN_GAME.exists()) {
            return;
        }
        if (!Reflector.ForgeKeyBinding_setKeyConflictContext.exists()) {
            return;
        }
        Object inGame = Reflector.getFieldValue(Reflector.KeyConflictContext_IN_GAME);
        Reflector.call(this.f_92085_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92086_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92087_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92088_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92089_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92090_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92091_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92096_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92098_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92099_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92100_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92103_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
        Reflector.call(this.f_92104_, Reflector.ForgeKeyBinding_setKeyConflictContext, inGame);
    }

    public void m_92145_(PackRepository resourcePackListIn) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        Iterator<String> iterator = this.f_92117_.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            Pack pack = resourcePackListIn.m_10507_(s);
            if (pack == null && !s.startsWith("file/")) {
                pack = resourcePackListIn.m_10507_("file/" + s);
            }
            if (pack == null) {
                f_92077_.warn("Removed resource pack {} from options because it doesn't seem to exist anymore", (Object)s);
                iterator.remove();
                continue;
            }
            if (!pack.m_10443_().m_10489_() && !this.f_92118_.contains(s)) {
                f_92077_.warn("Removed resource pack {} from options because it is no longer compatible", (Object)s);
                iterator.remove();
                continue;
            }
            if (pack.m_10443_().m_10489_() && this.f_92118_.contains(s)) {
                f_92077_.info("Removed resource pack {} from incompatibility list because it's now compatible", (Object)s);
                this.f_92118_.remove(s);
                continue;
            }
            set.add(pack.m_10446_());
        }
        resourcePackListIn.m_10509_((Collection)set);
    }

    public CameraType m_92176_() {
        return this.f_92111_;
    }

    public void m_92157_(CameraType pointOfViewIn) {
        this.f_92111_ = pointOfViewIn;
    }

    private static List<String> m_193956_(String stringIn) {
        List list = (List)GsonHelper.m_13785_((Gson)f_92078_, (String)stringIn, f_92079_);
        return list != null ? list : Lists.newArrayList();
    }

    private static CloudStatus m_193958_(String stringIn) {
        switch (stringIn) {
            case "true": {
                return CloudStatus.FANCY;
            }
            case "fast": {
                return CloudStatus.FAST;
            }
        }
        return CloudStatus.OFF;
    }

    private static String m_193929_(CloudStatus statusIn) {
        switch (statusIn) {
            case FANCY: {
                return "true";
            }
            case FAST: {
                return "fast";
            }
        }
        return "false";
    }

    private static AmbientOcclusionStatus m_193961_(String stringIn) {
        if (Options.m_193952_(stringIn)) {
            return AmbientOcclusionStatus.MAX;
        }
        return Options.m_193954_(stringIn) ? AmbientOcclusionStatus.OFF : AmbientOcclusionStatus.m_90487_((int)Integer.parseInt(stringIn));
    }

    private static HumanoidArm m_193964_(String stringIn) {
        return "left".equals(stringIn) ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
    }

    private static String m_193919_(HumanoidArm handIn) {
        return handIn == HumanoidArm.LEFT ? "left" : "right";
    }

    public File m_313926_() {
        return this.f_92110_;
    }

    public String m_313927_() {
        ImmutableList immutablelist = ImmutableList.builder().add((Object)Pair.of((Object)"ao", (Object)String.valueOf(this.f_92116_))).add((Object)Pair.of((Object)"biomeBlendRadius", (Object)String.valueOf(this.f_92032_))).add((Object)Pair.of((Object)"enableVsync", (Object)String.valueOf(this.f_92041_))).add((Object)Pair.of((Object)"entityDistanceScaling", (Object)String.valueOf(this.f_92112_))).add((Object)Pair.of((Object)"entityShadows", (Object)String.valueOf(this.f_92042_))).add((Object)Pair.of((Object)"forceUnicodeFont", (Object)String.valueOf(this.f_92043_))).add((Object)Pair.of((Object)"fov", (Object)String.valueOf(this.f_92068_))).add((Object)Pair.of((Object)"fovEffectScale", (Object)String.valueOf(this.f_92070_))).add((Object)Pair.of((Object)"fullscreen", (Object)String.valueOf(this.f_92052_))).add((Object)Pair.of((Object)"fullscreenResolution", (Object)String.valueOf(this.f_92123_))).add((Object)Pair.of((Object)"gamma", (Object)String.valueOf(this.f_92071_))).add((Object)Pair.of((Object)"glDebugVerbosity", (Object)String.valueOf(this.f_92035_))).add((Object)Pair.of((Object)"graphicsMode", (Object)String.valueOf(this.f_92115_))).add((Object)Pair.of((Object)"guiScale", (Object)String.valueOf(this.f_92072_))).add((Object)Pair.of((Object)"maxFps", (Object)String.valueOf(this.f_92113_))).add((Object)Pair.of((Object)"mipmapLevels", (Object)String.valueOf(this.f_92027_))).add((Object)Pair.of((Object)"narrator", (Object)String.valueOf(this.f_92074_))).add((Object)Pair.of((Object)"overrideHeight", (Object)String.valueOf(this.f_92129_))).add((Object)Pair.of((Object)"overrideWidth", (Object)String.valueOf(this.f_92128_))).add((Object)Pair.of((Object)"particles", (Object)String.valueOf(this.f_92073_))).add((Object)Pair.of((Object)"reducedDebugInfo", (Object)String.valueOf(this.f_92047_))).add((Object)Pair.of((Object)"renderClouds", (Object)String.valueOf(this.f_92114_))).add((Object)Pair.of((Object)"renderDistance", (Object)String.valueOf(this.f_92106_))).add((Object)Pair.of((Object)"resourcePacks", (Object)String.valueOf(this.f_92117_))).add((Object)Pair.of((Object)"screenEffectScale", (Object)String.valueOf(this.f_92069_))).add((Object)Pair.of((Object)"syncChunkWrites", (Object)String.valueOf(this.f_92076_))).add((Object)Pair.of((Object)"useNativeTransport", (Object)String.valueOf(this.f_92028_))).build();
        return immutablelist.stream().map(p_313924_0_ -> (String)p_313924_0_.getFirst() + ": " + (String)p_313924_0_.getSecond()).collect(Collectors.joining(System.lineSeparator()));
    }

    static interface FieldAccess {
        public int m_142003_(String var1, int var2);

        public boolean m_142028_(String var1, boolean var2);

        public String m_141577_(String var1, String var2);

        public double m_141940_(String var1, double var2);

        public float m_141839_(String var1, float var2);

        public <T> T m_141961_(String var1, T var2, Function<String, T> var3, Function<T, String> var4);

        public <T> T m_141702_(String var1, T var2, IntFunction<T> var3, ToIntFunction<T> var4);
    }
}

