/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4720;
import net.minecraft.class_5603;
import net.minecraft.class_761;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.model.ModelSprite;
import net.optifine.render.BoxVertexPositions;
import net.optifine.render.VertexPosition;
import net.optifine.shaders.Shaders;

public final class class_630 {
    public float field_3657;
    public float field_3656;
    public float field_3655;
    public float field_3654;
    public float field_3675;
    public float field_3674;
    public boolean field_3665 = true;
    public final List<class_628> field_3663;
    public final Map<String, class_630> field_3661;
    public List<class_630> childModelsList;
    public List<ModelSprite> spriteList = new ArrayList<ModelSprite>();
    public boolean mirrorV = false;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    private class_2960 textureLocation = null;
    private String id = null;
    private ModelUpdater modelUpdater;
    private class_761 renderGlobal = Config.getRenderGlobal();
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public boolean mirror;

    public class_630 setTextureOffset(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        return this;
    }

    public class_630 setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.textureWidth = textureWidthIn;
        this.textureHeight = textureHeightIn;
        return this;
    }

    public class_630(List<class_628> cubeListIn, Map<String, class_630> childModelsIn) {
        if (cubeListIn instanceof ImmutableList) {
            cubeListIn = new ArrayList<class_628>(cubeListIn);
        }
        this.field_3663 = cubeListIn;
        this.field_3661 = childModelsIn;
        this.childModelsList = new ArrayList<class_630>(this.field_3661.values());
    }

    public class_5603 method_32084() {
        return class_5603.method_32091(this.field_3657, this.field_3656, this.field_3655, this.field_3654, this.field_3675, this.field_3674);
    }

    public void method_32085(class_5603 partPoseIn) {
        this.field_3657 = partPoseIn.field_27702;
        this.field_3656 = partPoseIn.field_27703;
        this.field_3655 = partPoseIn.field_27704;
        this.field_3654 = partPoseIn.field_27705;
        this.field_3675 = partPoseIn.field_27706;
        this.field_3674 = partPoseIn.field_27707;
    }

    public void method_17138(class_630 modelRendererIn) {
        this.field_3654 = modelRendererIn.field_3654;
        this.field_3675 = modelRendererIn.field_3675;
        this.field_3674 = modelRendererIn.field_3674;
        this.field_3657 = modelRendererIn.field_3657;
        this.field_3656 = modelRendererIn.field_3656;
        this.field_3655 = modelRendererIn.field_3655;
    }

    public class_630 method_32086(String nameIn) {
        class_630 modelpart = this.field_3661.get(nameIn);
        if (modelpart == null) {
            throw new NoSuchElementException("Can't find part " + nameIn);
        }
        return modelpart;
    }

    public void method_2851(float rotationPointXIn, float rotationPointYIn, float rotationPointZIn) {
        this.field_3657 = rotationPointXIn;
        this.field_3656 = rotationPointYIn;
        this.field_3655 = rotationPointZIn;
    }

    public void method_33425(float xRotIn, float yRotIn, float zRotIn) {
        this.field_3654 = xRotIn;
        this.field_3675 = yRotIn;
        this.field_3674 = zRotIn;
    }

    public void method_22698(class_4587 matrixStackIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn) {
        this.method_22699(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void method_22699(class_4587 matrixStackIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.field_3665 || this.field_3663.isEmpty() && this.field_3661.isEmpty() && this.spriteList.isEmpty())) {
            class_1921 lastRenderType = null;
            class_4597.class_4598 renderTypeBuffer = null;
            if (this.textureLocation != null) {
                if (this.renderGlobal.renderOverlayEyes) {
                    return;
                }
                renderTypeBuffer = bufferIn.getRenderTypeBuffer();
                if (renderTypeBuffer != null) {
                    class_4588 secondaryBuilder = bufferIn.getSecondaryBuilder();
                    lastRenderType = renderTypeBuffer.getLastRenderType();
                    bufferIn = renderTypeBuffer.getBuffer(this.textureLocation, bufferIn);
                    if (secondaryBuilder != null) {
                        bufferIn = class_4720.method_24037(secondaryBuilder, bufferIn);
                    }
                }
            }
            if (this.modelUpdater != null) {
                this.modelUpdater.update();
            }
            matrixStackIn.method_22903();
            this.method_22703(matrixStackIn);
            this.method_22702(matrixStackIn.method_23760(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            int childModelsSize = this.childModelsList.size();
            for (int ix = 0; ix < childModelsSize; ++ix) {
                class_630 modelpart = this.childModelsList.get(ix);
                modelpart.method_22699(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            int spriteListSize = this.spriteList.size();
            for (int ix = 0; ix < spriteListSize; ++ix) {
                ModelSprite sprite = this.spriteList.get(ix);
                sprite.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.method_22909();
            if (lastRenderType != null) {
                renderTypeBuffer.getBuffer(lastRenderType);
            }
        }
    }

    public void method_35745(class_4587 p_315388_1_, class_6229 p_315388_2_) {
        this.method_35746(p_315388_1_, p_315388_2_, "");
    }

    private void method_35746(class_4587 p_315391_1_, class_6229 p_315391_2_, String p_315391_3_) {
        if (!this.field_3663.isEmpty() || !this.field_3661.isEmpty()) {
            p_315391_1_.method_22903();
            this.method_22703(p_315391_1_);
            class_4587.class_4665 posestack$pose = p_315391_1_.method_23760();
            for (int i = 0; i < this.field_3663.size(); ++i) {
                p_315391_2_.method_35748(posestack$pose, p_315391_3_, i, this.field_3663.get(i));
            }
            String s = p_315391_3_ + "/";
            this.field_3661.forEach((p_315395_3_, p_315395_4_) -> p_315395_4_.method_35746(p_315391_1_, p_315391_2_, s + p_315395_3_));
            p_315391_1_.method_22909();
        }
    }

    public void method_22703(class_4587 matrixStackIn) {
        matrixStackIn.method_22904(this.field_3657 / 16.0f, this.field_3656 / 16.0f, this.field_3655 / 16.0f);
        if (this.field_3674 != 0.0f) {
            matrixStackIn.method_22907(class_1160.field_20707.method_23626(this.field_3674));
        }
        if (this.field_3675 != 0.0f) {
            matrixStackIn.method_22907(class_1160.field_20705.method_23626(this.field_3675));
        }
        if (this.field_3654 != 0.0f) {
            matrixStackIn.method_22907(class_1160.field_20703.method_23626(this.field_3654));
        }
    }

    private void method_22702(class_4587.class_4665 matrixEntryIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        boolean shadersVelocity = Config.isShaders() && Shaders.useVelocityAttrib && Config.isMinecraftThread();
        int cubeListSize = this.field_3663.size();
        for (int ic = 0; ic < cubeListSize; ++ic) {
            IRandomEntity entity;
            class_628 modelpart$cube = this.field_3663.get(ic);
            VertexPosition[][] boxPos = null;
            if (shadersVelocity && (entity = RandomEntities.getRandomEntityRendered()) != null) {
                boxPos = modelpart$cube.getBoxVertexPositions(entity.getId());
            }
            modelpart$cube.compile(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, boxPos);
        }
    }

    public class_628 method_22700(Random randomIn) {
        return this.field_3663.get(randomIn.nextInt(this.field_3663.size()));
    }

    public boolean method_32087() {
        return this.field_3663.isEmpty();
    }

    public Stream<class_630> method_32088() {
        return Stream.concat(Stream.of(this), this.field_3661.values().stream().flatMap(class_630::method_32088));
    }

    public void addSprite(float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.spriteList.add(new ModelSprite(this, this.textureOffsetX, this.textureOffsetY, posX, posY, posZ, sizeX, sizeY, sizeZ, sizeAdd));
    }

    public class_2960 getTextureLocation() {
        return this.textureLocation;
    }

    public void setTextureLocation(class_2960 textureLocation) {
        this.textureLocation = textureLocation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addBox(int[][] faceUvs, float x, float y, float z, float dx, float dy, float dz, float delta) {
        this.field_3663.add(new class_628(faceUvs, x, y, z, dx, dy, dz, delta, delta, delta, this.mirror, this.textureWidth, this.textureHeight));
    }

    public void addBox(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, x, y, z, width, height, depth, delta, delta, delta, this.mirror, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, boolean dummyIn) {
        this.field_3663.add(new class_628(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirror, this.textureWidth, this.textureHeight));
    }

    public class_630 getChildModelDeep(String name) {
        if (name == null) {
            return null;
        }
        if (this.field_3661.containsKey(name)) {
            return this.method_32086(name);
        }
        if (this.field_3661 != null) {
            Set<String> keys = this.field_3661.keySet();
            for (String key : keys) {
                class_630 child = this.field_3661.get(key);
                class_630 mr = child.getChildModelDeep(name);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public class_630 getChild(String id) {
        if (id == null) {
            return null;
        }
        if (this.field_3661 != null) {
            Set<String> keys = this.field_3661.keySet();
            for (String key : keys) {
                class_630 child = this.field_3661.get(key);
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public class_630 getChildDeep(String id) {
        if (id == null) {
            return null;
        }
        class_630 mrChild = this.getChild(id);
        if (mrChild != null) {
            return mrChild;
        }
        if (this.field_3661 != null) {
            Set<String> keys = this.field_3661.keySet();
            for (String key : keys) {
                class_630 child = this.field_3661.get(key);
                class_630 mr = child.getChildDeep(id);
                if (mr == null) continue;
                return mr;
            }
        }
        return null;
    }

    public void setModelUpdater(ModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    public void addChildModel(String name, class_630 part) {
        if (part == null) {
            return;
        }
        this.field_3661.put(name, part);
        this.childModelsList = new ArrayList<class_630>(this.field_3661.values());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: " + this.id + ", boxes: " + (this.field_3663 != null ? Integer.valueOf(this.field_3663.size()) : null) + ", submodels: " + (this.field_3661 != null ? Integer.valueOf(this.field_3661.size()) : null));
        return sb.toString();
    }

    @FunctionalInterface
    public static interface class_6229 {
        public void method_35748(class_4587.class_4665 var1, String var2, int var3, class_628 var4);
    }

    static class class_618 {
        public final class_1160 field_3605;
        public final float field_3604;
        public final float field_3603;

        public class_618(float x, float y, float z, float texU, float texV) {
            this(new class_1160(x, y, z), texU, texV);
        }

        public class_618 method_2837(float texU, float texV) {
            return new class_618(this.field_3605, texU, texV);
        }

        public class_618(class_1160 posIn, float texU, float texV) {
            this.field_3605 = posIn;
            this.field_3604 = texU;
            this.field_3603 = texV;
        }
    }

    static class class_593 {
        public final class_618[] field_3502;
        public final class_1160 field_21618;

        public class_593(class_618[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, class_2350 directionIn) {
            this.field_3502 = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            if (Config.isAntialiasing()) {
                f = 0.05f / texWidth;
                f1 = 0.05f / texHeight;
                if (u2 < u1) {
                    f = -f;
                }
                if (v2 < v1) {
                    f1 = -f1;
                }
            }
            positionsIn[0] = positionsIn[0].method_2837(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].method_2837(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].method_2837(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].method_2837(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    class_618 modelpart$vertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = modelpart$vertex;
                }
            }
            this.field_21618 = directionIn.method_23955();
            if (mirrorIn) {
                this.field_21618.method_23849(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static class class_628 {
        private final class_593[] field_3649;
        public final float field_3645;
        public final float field_3644;
        public final float field_3643;
        public final float field_3648;
        public final float field_3647;
        public final float field_3646;
        private BoxVertexPositions boxVertexPositions;

        public class_628(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirror, float texWidth, float texHeight) {
            this.field_3645 = x;
            this.field_3644 = y;
            this.field_3643 = z;
            this.field_3648 = x + width;
            this.field_3647 = y + height;
            this.field_3646 = z + depth;
            this.field_3649 = new class_593[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirror) {
                float f3 = f;
                f = x;
                x = f3;
            }
            class_618 modelpart$vertex7 = new class_618(x, y, z, 0.0f, 0.0f);
            class_618 modelpart$vertex = new class_618(f, y, z, 0.0f, 8.0f);
            class_618 modelpart$vertex1 = new class_618(f, f1, z, 8.0f, 8.0f);
            class_618 modelpart$vertex2 = new class_618(x, f1, z, 8.0f, 0.0f);
            class_618 modelpart$vertex3 = new class_618(x, y, f2, 0.0f, 0.0f);
            class_618 modelpart$vertex4 = new class_618(f, y, f2, 0.0f, 8.0f);
            class_618 modelpart$vertex5 = new class_618(f, f1, f2, 8.0f, 8.0f);
            class_618 modelpart$vertex6 = new class_618(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.field_3649[2] = new class_593(new class_618[]{modelpart$vertex4, modelpart$vertex3, modelpart$vertex7, modelpart$vertex}, f5, f10, f6, f11, texWidth, texHeight, mirror, class_2350.field_11033);
            this.field_3649[3] = new class_593(new class_618[]{modelpart$vertex1, modelpart$vertex2, modelpart$vertex6, modelpart$vertex5}, f6, f11, f7, f10, texWidth, texHeight, mirror, class_2350.field_11036);
            this.field_3649[1] = new class_593(new class_618[]{modelpart$vertex7, modelpart$vertex3, modelpart$vertex6, modelpart$vertex2}, f4, f11, f5, f12, texWidth, texHeight, mirror, class_2350.field_11039);
            this.field_3649[4] = new class_593(new class_618[]{modelpart$vertex, modelpart$vertex7, modelpart$vertex2, modelpart$vertex1}, f5, f11, f6, f12, texWidth, texHeight, mirror, class_2350.field_11043);
            this.field_3649[0] = new class_593(new class_618[]{modelpart$vertex4, modelpart$vertex, modelpart$vertex1, modelpart$vertex5}, f6, f11, f8, f12, texWidth, texHeight, mirror, class_2350.field_11034);
            this.field_3649[5] = new class_593(new class_618[]{modelpart$vertex3, modelpart$vertex4, modelpart$vertex5, modelpart$vertex6}, f8, f11, f9, f12, texWidth, texHeight, mirror, class_2350.field_11035);
        }

        public class_628(int[][] faceUvs, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, float texWidth, float texHeight) {
            this.field_3645 = x;
            this.field_3644 = y;
            this.field_3643 = z;
            this.field_3648 = x + width;
            this.field_3647 = y + height;
            this.field_3646 = z + depth;
            this.field_3649 = new class_593[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirorIn) {
                float f3 = f;
                f = x;
                x = f3;
            }
            class_618 pos0 = new class_618(x, y, z, 0.0f, 0.0f);
            class_618 pos1 = new class_618(f, y, z, 0.0f, 8.0f);
            class_618 pos2 = new class_618(f, f1, z, 8.0f, 8.0f);
            class_618 pos3 = new class_618(x, f1, z, 8.0f, 0.0f);
            class_618 pos4 = new class_618(x, y, f2, 0.0f, 0.0f);
            class_618 pos5 = new class_618(f, y, f2, 0.0f, 8.0f);
            class_618 pos6 = new class_618(f, f1, f2, 8.0f, 8.0f);
            class_618 pos7 = new class_618(x, f1, f2, 8.0f, 0.0f);
            this.field_3649[2] = this.makeTexturedQuad(new class_618[]{pos5, pos4, pos0, pos1}, faceUvs[1], true, texWidth, texHeight, mirorIn, class_2350.field_11033);
            this.field_3649[3] = this.makeTexturedQuad(new class_618[]{pos2, pos3, pos7, pos6}, faceUvs[0], true, texWidth, texHeight, mirorIn, class_2350.field_11036);
            this.field_3649[1] = this.makeTexturedQuad(new class_618[]{pos0, pos4, pos7, pos3}, faceUvs[5], false, texWidth, texHeight, mirorIn, class_2350.field_11039);
            this.field_3649[4] = this.makeTexturedQuad(new class_618[]{pos1, pos0, pos3, pos2}, faceUvs[2], false, texWidth, texHeight, mirorIn, class_2350.field_11043);
            this.field_3649[0] = this.makeTexturedQuad(new class_618[]{pos5, pos1, pos2, pos6}, faceUvs[4], false, texWidth, texHeight, mirorIn, class_2350.field_11034);
            this.field_3649[5] = this.makeTexturedQuad(new class_618[]{pos4, pos5, pos6, pos7}, faceUvs[3], false, texWidth, texHeight, mirorIn, class_2350.field_11035);
        }

        private class_593 makeTexturedQuad(class_618[] positionTextureVertexs, int[] faceUvs, boolean reverseUV, float textureWidth, float textureHeight, boolean mirrorIn, class_2350 directionIn) {
            if (faceUvs == null) {
                return null;
            }
            if (reverseUV) {
                return new class_593(positionTextureVertexs, faceUvs[2], faceUvs[3], faceUvs[0], faceUvs[1], textureWidth, textureHeight, mirrorIn, directionIn);
            }
            return new class_593(positionTextureVertexs, faceUvs[0], faceUvs[1], faceUvs[2], faceUvs[3], textureWidth, textureHeight, mirrorIn, directionIn);
        }

        public VertexPosition[][] getBoxVertexPositions(int key) {
            if (this.boxVertexPositions == null) {
                this.boxVertexPositions = new BoxVertexPositions();
            }
            return (VertexPosition[][])this.boxVertexPositions.get(key);
        }

        public void method_32089(class_4587.class_4665 matrixEntryIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.compile(matrixEntryIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, null);
        }

        public void compile(class_4587.class_4665 matrixEntryIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, VertexPosition[][] boxPos) {
            class_1159 matrix4f = matrixEntryIn.method_23761();
            class_4581 matrix3f = matrixEntryIn.method_23762();
            int quadsSize = this.field_3649.length;
            for (int iq = 0; iq < quadsSize; ++iq) {
                class_593 modelpart$polygon = this.field_3649[iq];
                if (modelpart$polygon == null) continue;
                if (boxPos != null) {
                    bufferIn.setQuadVertexPositions(boxPos[iq]);
                }
                class_1160 vector3f = bufferIn.getTempVec3f(modelpart$polygon.field_21618);
                vector3f.method_23215(matrix3f);
                float f = vector3f.method_4943();
                float f1 = vector3f.method_4945();
                float f2 = vector3f.method_4947();
                for (class_618 modelpart$vertex : modelpart$polygon.field_3502) {
                    float f3 = modelpart$vertex.field_3605.method_4943() / 16.0f;
                    float f4 = modelpart$vertex.field_3605.method_4945() / 16.0f;
                    float f5 = modelpart$vertex.field_3605.method_4947() / 16.0f;
                    float xt = matrix4f.getTransformX(f3, f4, f5, 1.0f);
                    float yt = matrix4f.getTransformY(f3, f4, f5, 1.0f);
                    float zt = matrix4f.getTransformZ(f3, f4, f5, 1.0f);
                    bufferIn.method_23919(xt, yt, zt, red, green, blue, alpha, modelpart$vertex.field_3604, modelpart$vertex.field_3603, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }
}

