/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1208;

public class class_5947
extends DataFix {
    private static final Pattern field_29545 = Pattern.compile("\\[(\\d+)\\]");
    private static final Set<String> field_29546 = Sets.newHashSet((Object[])new String[]{"minecraft:jigsaw", "minecraft:nvi", "minecraft:pcp", "minecraft:bastionremnant", "minecraft:runtime"});
    private static final Set<String> field_29547 = Sets.newHashSet((Object[])new String[]{"minecraft:tree", "minecraft:flower", "minecraft:block_pile", "minecraft:random_patch"});

    public class_5947(Schema schema) {
        super(schema, false);
    }

    public TypeRewriteRule makeRule() {
        return this.writeFixAndRead("SavedDataFeaturePoolElementFix", this.getInputSchema().getType(class_1208.field_5724), this.getOutputSchema().getType(class_1208.field_5724), class_5947::method_34692);
    }

    private static <T> Dynamic<T> method_34692(Dynamic<T> dynamic) {
        return dynamic.update("Children", class_5947::method_34693);
    }

    private static <T> Dynamic<T> method_34693(Dynamic<T> dynamic) {
        return dynamic.asStreamOpt().map(class_5947::method_34691).map(arg_0 -> dynamic.createList(arg_0)).result().orElse(dynamic);
    }

    private static Stream<? extends Dynamic<?>> method_34691(Stream<? extends Dynamic<?>> stream) {
        return stream.map(dynamic2 -> {
            String string = dynamic2.get("id").asString("");
            if (!field_29546.contains(string)) {
                return dynamic2;
            }
            OptionalDynamic \u00e2\u02dc\u01922 = dynamic2.get("pool_element");
            if (!\u00e2\u02dc\u01922.get("element_type").asString("").equals("minecraft:feature_pool_element")) {
                return dynamic2;
            }
            if (!\u00e2\u02dc\u01922.get("feature").get("name").result().isPresent()) {
                return dynamic2;
            }
            return dynamic2.update("pool_element", dynamic -> dynamic.update("feature", class_5947::method_34688));
        });
    }

    private static <T> OptionalDynamic<T> method_34689(Dynamic<T> dynamic2, String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Missing path");
        }
        OptionalDynamic \u00e2\u02dc\u01924 = dynamic2.get(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Matcher \u00e2\u02dc\u01922 = field_29545.matcher(string);
            if (\u00e2\u02dc\u01922.matches()) {
                Dynamic<T> dynamic2;
                int n = Integer.parseInt(\u00e2\u02dc\u01922.group(1));
                List \u00e2\u02dc\u01923 = \u00e2\u02dc\u01924.asList(Function.identity());
                if (n >= 0 && n < \u00e2\u02dc\u01923.size()) {
                    \u00e2\u02dc\u01924 = new OptionalDynamic(dynamic2.getOps(), DataResult.success((Object)((Dynamic)\u00e2\u02dc\u01923.get(n))));
                    continue;
                }
                \u00e2\u02dc\u01924 = new OptionalDynamic(dynamic2.getOps(), DataResult.error((String)("Missing id:" + n)));
                continue;
            }
            \u00e2\u02dc\u01924 = \u00e2\u02dc\u01924.get(string);
        }
        return \u00e2\u02dc\u01924;
    }

    @VisibleForTesting
    protected static Dynamic<?> method_34688(Dynamic<?> dynamic) {
        Optional<String> optional = class_5947.method_34690(class_5947.method_34689(dynamic, "type").asString(""), class_5947.method_34689(dynamic, "name").asString(""), class_5947.method_34689(dynamic, "config", "state_provider", "type").asString(""), class_5947.method_34689(dynamic, "config", "state_provider", "state", "Name").asString(""), class_5947.method_34689(dynamic, "config", "state_provider", "entries", "[0]", "data", "Name").asString(""), class_5947.method_34689(dynamic, "config", "foliage_placer", "type").asString(""), class_5947.method_34689(dynamic, "config", "leaves_provider", "state", "Name").asString(""));
        if (optional.isPresent()) {
            return dynamic.createString(optional.get());
        }
        return dynamic;
    }

    private static Optional<String> method_34690(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (!string.isEmpty()) {
            \u00e2\u02dc\u0192 = string;
        } else if (!string2.isEmpty()) {
            \u00e2\u02dc\u0192 = "minecraft:normal_tree".equals(string2) ? "minecraft:tree" : string2;
        } else {
            return Optional.empty();
        }
        if (field_29547.contains(\u00e2\u02dc\u0192)) {
            if ("minecraft:random_patch".equals(\u00e2\u02dc\u0192)) {
                if ("minecraft:simple_state_provider".equals(string3)) {
                    if ("minecraft:sweet_berry_bush".equals(string4)) {
                        return Optional.of("minecraft:patch_berry_bush");
                    }
                    if ("minecraft:cactus".equals(string4)) {
                        return Optional.of("minecraft:patch_cactus");
                    }
                } else if ("minecraft:weighted_state_provider".equals(string3) && ("minecraft:grass".equals(string5) || "minecraft:fern".equals(string5))) {
                    return Optional.of("minecraft:patch_taiga_grass");
                }
            } else if ("minecraft:block_pile".equals(\u00e2\u02dc\u0192)) {
                if ("minecraft:simple_state_provider".equals(string3) || "minecraft:rotated_block_provider".equals(string3)) {
                    if ("minecraft:hay_block".equals(string4)) {
                        return Optional.of("minecraft:pile_hay");
                    }
                    if ("minecraft:melon".equals(string4)) {
                        return Optional.of("minecraft:pile_melon");
                    }
                    if ("minecraft:snow".equals(string4)) {
                        return Optional.of("minecraft:pile_snow");
                    }
                } else if ("minecraft:weighted_state_provider".equals(string3)) {
                    if ("minecraft:packed_ice".equals(string5) || "minecraft:blue_ice".equals(string5)) {
                        return Optional.of("minecraft:pile_ice");
                    }
                    if ("minecraft:jack_o_lantern".equals(string5) || "minecraft:pumpkin".equals(string5)) {
                        return Optional.of("minecraft:pile_pumpkin");
                    }
                }
            } else {
                if ("minecraft:flower".equals(\u00e2\u02dc\u0192)) {
                    return Optional.of("minecraft:flower_plain");
                }
                if ("minecraft:tree".equals(\u00e2\u02dc\u0192)) {
                    if ("minecraft:acacia_foliage_placer".equals(string6)) {
                        return Optional.of("minecraft:acacia");
                    }
                    if ("minecraft:blob_foliage_placer".equals(string6) && "minecraft:oak_leaves".equals(string7)) {
                        return Optional.of("minecraft:oak");
                    }
                    if ("minecraft:pine_foliage_placer".equals(string6)) {
                        return Optional.of("minecraft:pine");
                    }
                    if ("minecraft:spruce_foliage_placer".equals(string6)) {
                        return Optional.of("minecraft:spruce");
                    }
                }
            }
        }
        return Optional.empty();
    }
}

