/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2617;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3442
extends class_3469 {
    private static final Logger field_15309 = LogManager.getLogger();
    private final MinecraftServer field_15308;
    private final File field_15305;
    private final Set<class_3445<?>> field_15307 = Sets.newHashSet();

    public class_3442(MinecraftServer minecraftServer, File file) {
        this.field_15308 = minecraftServer;
        this.field_15305 = file;
        if (file.isFile()) {
            try {
                this.method_14906(minecraftServer.method_3855(), FileUtils.readFileToString((File)file));
            }
            catch (IOException iOException) {
                field_15309.error("Couldn't read statistics file {}", (Object)file, (Object)iOException);
            }
            catch (JsonParseException jsonParseException) {
                field_15309.error("Couldn't parse statistics file {}", (Object)file, (Object)jsonParseException);
            }
        }
    }

    public void method_14912() {
        try {
            FileUtils.writeStringToFile((File)this.field_15305, (String)this.method_14911());
        }
        catch (IOException iOException) {
            field_15309.error("Couldn't save stats", (Throwable)iOException);
        }
    }

    @Override
    public void method_15023(class_1657 class_16572, class_3445<?> class_34452, int n) {
        super.method_15023(class_16572, class_34452, n);
        this.field_15307.add(class_34452);
    }

    private Set<class_3445<?>> method_14909() {
        HashSet hashSet = Sets.newHashSet(this.field_15307);
        this.field_15307.clear();
        return hashSet;
    }

    public void method_14906(DataFixer dataFixer, String string) {
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));){
            jsonReader.setLenient(false);
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            if (jsonElement.isJsonNull()) {
                field_15309.error("Unable to parse Stat data from {}", (Object)this.field_15305);
                return;
            }
            class_2487 \u00e2\u02dc\u01922 = class_3442.method_14908(jsonElement.getAsJsonObject());
            if (!\u00e2\u02dc\u01922.method_10573("DataVersion", 99)) {
                \u00e2\u02dc\u01922.method_10569("DataVersion", 1343);
            }
            if ((\u00e2\u02dc\u01922 = class_2512.method_10688(dataFixer, class_4284.field_19218, \u00e2\u02dc\u01922, \u00e2\u02dc\u01922.method_10550("DataVersion"))).method_10573("stats", 10)) {
                class_2487 class_24872 = \u00e2\u02dc\u01922.method_10562("stats");
                for (String string2 : class_24872.method_10541()) {
                    if (!class_24872.method_10573(string2, 10)) continue;
                    class_156.method_17974(class_2378.field_11152.method_17966(new class_2960(string2)), class_34482 -> {
                        class_2487 class_24873 = class_24872.method_10562(string2);
                        for (String string2 : class_24873.method_10541()) {
                            if (class_24873.method_10573(string2, 99)) {
                                class_156.method_17974(this.method_14905((class_3448)class_34482, string2), class_34452 -> this.field_15431.put(class_34452, class_24873.method_10550(string2)), () -> field_15309.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.field_15305, (Object)string2));
                                continue;
                            }
                            field_15309.warn("Invalid statistic value in {}: Don't know what {} is for key {}", (Object)this.field_15305, (Object)class_24873.method_10580(string2), (Object)string2);
                        }
                    }, () -> field_15309.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.field_15305, (Object)string2));
                }
            }
        }
        catch (JsonParseException | IOException throwable) {
            field_15309.error("Unable to parse Stat data from {}", (Object)this.field_15305, (Object)throwable);
        }
    }

    private <T> Optional<class_3445<T>> method_14905(class_3448<T> class_34482, String string) {
        return Optional.ofNullable(class_2960.method_12829(string)).flatMap(class_34482.method_14959()::method_17966).map(class_34482::method_14956);
    }

    private static class_2487 method_14908(JsonObject jsonObject) {
        class_2487 class_24872 = new class_2487();
        for (Map.Entry entry : jsonObject.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonObject()) {
                class_24872.method_10566((String)entry.getKey(), class_3442.method_14908(jsonElement.getAsJsonObject()));
                continue;
            }
            if (!jsonElement.isJsonPrimitive() || !(\u00e2\u02dc\u0192 = jsonElement.getAsJsonPrimitive()).isNumber()) continue;
            class_24872.method_10569((String)entry.getKey(), \u00e2\u02dc\u0192.getAsInt());
        }
        return class_24872;
    }

    protected String method_14911() {
        HashMap hashMap = Maps.newHashMap();
        for (Object object2 : this.field_15431.object2IntEntrySet()) {
            class_3445 class_34452 = (class_3445)object2.getKey();
            hashMap.computeIfAbsent(class_34452.method_14949(), class_34482 -> new JsonObject()).addProperty(class_3442.method_14907(class_34452).toString(), (Number)object2.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : hashMap.entrySet()) {
            jsonObject.add(class_2378.field_11152.method_10221((class_3448)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("stats", (JsonElement)jsonObject);
        jsonObject2.addProperty("DataVersion", (Number)class_155.method_16673().getWorldVersion());
        return jsonObject2.toString();
    }

    private static <T> class_2960 method_14907(class_3445<T> class_34452) {
        return class_34452.method_14949().method_14959().method_10221(class_34452.method_14951());
    }

    public void method_14914() {
        this.field_15307.addAll((Collection<class_3445<?>>)this.field_15431.keySet());
    }

    public void method_14910(class_3222 class_322222) {
        class_3222 class_322222;
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (class_3445<?> class_34452 : this.method_14909()) {
            object2IntOpenHashMap.put(class_34452, this.method_15025(class_34452));
        }
        class_322222.field_13987.method_14364(new class_2617((Object2IntMap<class_3445<?>>)object2IntOpenHashMap));
    }
}

