/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1050;
import net.minecraft.class_1059;
import net.minecraft.class_1061;
import net.minecraft.class_1079;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4723;
import net.minecraft.class_4725;
import net.minecraftforge.client.extensions.IForgeTextureAtlasSprite;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersTextureType;
import net.optifine.texture.IColorBlender;
import net.optifine.util.CounterInt;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1058
implements AutoCloseable,
IForgeTextureAtlasSprite {
    private static final Logger field_28464 = LogManager.getLogger();
    private final class_1059 field_21750;
    private final class_2960 field_28465;
    final int field_28466;
    final int field_28467;
    protected final class_1011[] field_5262;
    @Nullable
    private final class_5790 field_28468;
    private final int field_5258;
    private final int field_5256;
    private final float field_5270;
    private final float field_5269;
    private final float field_5268;
    private final float field_5267;
    private int indexInMap = -1;
    public float baseU;
    public float baseV;
    public int sheetWidth;
    public int sheetHeight;
    public int glSpriteTextureId = -1;
    public class_1058 spriteSingle = null;
    public boolean isSpriteSingle = false;
    public static final String SUFFIX_SPRITE_SINGLE = ".sprite_single";
    public int mipmapLevels = 0;
    public class_1058 spriteNormal = null;
    public class_1058 spriteSpecular = null;
    public ShadersTextureType spriteShadersType = null;
    public class_1058 spriteEmissive = null;
    public boolean isSpriteEmissive = false;
    private int animationIndex = -1;
    private boolean animationActive = false;
    private boolean usesParentAnimationTime = false;
    private boolean terrain;
    private boolean shaders;
    private boolean multiTexture;
    private class_3300 resourceManager;
    private final int imageWidth;
    private final int imageHeight;
    private final class_1079 animationMetadata;

    public class_1058(class_2960 name) {
        this.field_21750 = null;
        this.field_28465 = name;
        this.field_28466 = 0;
        this.field_28467 = 0;
        this.animationMetadata = null;
        this.field_5262 = null;
        this.field_5258 = 0;
        this.field_5256 = 0;
        this.field_5270 = 0.0f;
        this.field_5269 = 0.0f;
        this.field_5268 = 0.0f;
        this.field_5267 = 0.0f;
        this.field_28468 = null;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    private class_1058(class_1058 parent) {
        this.field_21750 = parent.field_21750;
        this.field_28465 = parent.method_4598();
        this.field_28466 = parent.method_4578();
        this.field_28467 = parent.method_4595();
        this.imageWidth = parent.imageWidth;
        this.imageHeight = parent.imageHeight;
        this.animationMetadata = parent.animationMetadata;
        this.usesParentAnimationTime = true;
        this.field_5262 = parent.field_5262;
        class_4727 info = new class_4727(this.field_28465, this.field_28466, this.field_28467, this.animationMetadata);
        this.field_28468 = this.method_33437(info, this.imageWidth, this.imageHeight, parent.mipmapLevels);
        if (this.field_28468 != null && this.field_28468.field_28474 != null && parent.field_28468 != null && parent.field_28468.field_28474 != null) {
            class_4728.access$102(this.field_28468.field_28474, parent.field_28468.field_28474.field_21758);
        }
        this.field_5258 = 0;
        this.field_5256 = 0;
        this.field_5270 = 0.0f;
        this.field_5269 = 1.0f;
        this.field_5268 = 0.0f;
        this.field_5267 = 1.0f;
        this.indexInMap = parent.indexInMap;
        this.baseU = parent.baseU;
        this.baseV = parent.baseV;
        this.sheetWidth = parent.sheetWidth;
        this.sheetHeight = parent.sheetHeight;
        this.isSpriteSingle = true;
        this.mipmapLevels = parent.mipmapLevels;
        this.animationIndex = parent.animationIndex;
        this.animationActive = parent.animationActive;
    }

    protected class_1058(class_1059 atlasTextureIn, class_4727 spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, class_1011 imageIn) {
        this(atlasTextureIn, spriteInfoIn, mipmapLevelsIn, atlasWidthIn, atlasHeightIn, xIn, yIn, imageIn, null);
    }

    protected class_1058(class_1059 atlasTextureIn, class_4727 spriteInfoIn, int mipmapLevelsIn, int atlasWidthIn, int atlasHeightIn, int xIn, int yIn, class_1011 imageIn, ShadersTextureType spriteShadersTypeIn) {
        int widthScaled;
        class_1011 imageScaled;
        this.field_21750 = atlasTextureIn;
        this.field_28466 = spriteInfoIn.field_21754;
        this.field_28467 = spriteInfoIn.field_21755;
        this.field_28465 = spriteInfoIn.field_21753;
        this.imageWidth = imageIn.method_4307();
        this.imageHeight = imageIn.method_4323();
        this.animationMetadata = spriteInfoIn.getSpriteAnimationMetadata();
        this.field_5258 = xIn;
        this.field_5256 = yIn;
        this.field_5270 = (float)xIn / (float)atlasWidthIn;
        this.field_5269 = (float)(xIn + this.field_28466) / (float)atlasWidthIn;
        this.field_5268 = (float)yIn / (float)atlasHeightIn;
        this.field_5267 = (float)(yIn + this.field_28467) / (float)atlasHeightIn;
        if (spriteInfoIn.scaleFactor > 1.0 && (imageScaled = TextureUtils.scaleImage(imageIn, widthScaled = (int)Math.round((double)imageIn.method_4307() * spriteInfoIn.scaleFactor))) != imageIn) {
            imageIn.close();
            imageIn = imageScaled;
        }
        this.spriteShadersType = spriteShadersTypeIn;
        IColorBlender colorBlender = this.field_21750.getShadersColorBlender(this.spriteShadersType);
        if (this.spriteShadersType == null && !spriteInfoIn.method_24121().method_12832().endsWith("_leaves")) {
            this.fixTransparentColor(imageIn);
        }
        class_1011 imageInF = imageIn;
        this.field_28468 = this.method_33437(spriteInfoIn, imageIn.method_4307(), imageIn.method_4323(), mipmapLevelsIn);
        try {
            try {
                this.field_5262 = class_4725.generateMipmaps(imageIn, mipmapLevelsIn, colorBlender);
            }
            catch (Throwable throwable) {
                class_128 crashreport1 = class_128.method_560(throwable, "Generating mipmaps for frame");
                class_129 crashreportcategory1 = crashreport1.method_562("Frame being iterated");
                crashreportcategory1.method_577("First frame", () -> {
                    StringBuilder stringbuilder = new StringBuilder();
                    if (stringbuilder.length() > 0) {
                        stringbuilder.append(", ");
                    }
                    stringbuilder.append(imageInF.method_4307()).append("x").append(imageInF.method_4323());
                    return stringbuilder.toString();
                });
                throw new class_148(crashreport1);
            }
        }
        catch (Throwable throwable1) {
            class_128 crashreport = class_128.method_560(throwable1, "Applying mipmap");
            class_129 crashreportcategory = crashreport.method_562("Sprite being mipmapped");
            crashreportcategory.method_577("Sprite name", this.field_28465::toString);
            crashreportcategory.method_577("Sprite size", () -> this.field_28466 + " x " + this.field_28467);
            crashreportcategory.method_577("Sprite frames", () -> this.method_4592() + " frames");
            crashreportcategory.method_578("Mipmap levels", mipmapLevelsIn);
            throw new class_148(crashreport);
        }
        this.mipmapLevels = mipmapLevelsIn;
        this.baseU = Math.min(this.field_5270, this.field_5269);
        this.baseV = Math.min(this.field_5268, this.field_5267);
        this.sheetWidth = atlasWidthIn;
        this.sheetHeight = atlasHeightIn;
    }

    private int method_4592() {
        return this.field_28468 != null ? this.field_28468.field_28472.size() : 1;
    }

    @Nullable
    private class_5790 method_33437(class_4727 infoIn, int widthIn, int heightIn, int mipmapsIn) {
        class_1079 animationmetadatasection = infoIn.field_21756;
        int i = widthIn / animationmetadatasection.method_4687(infoIn.field_21754);
        int j = heightIn / animationmetadatasection.method_4686(infoIn.field_21755);
        int k = i * j;
        ArrayList list = Lists.newArrayList();
        animationmetadatasection.method_33460((indexIn, timeIn) -> list.add(new class_5791(indexIn, timeIn)));
        if (list.isEmpty()) {
            for (int l = 0; l < k; ++l) {
                list.add(new class_5791(l, animationmetadatasection.method_4684()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet intset = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                class_5791 textureatlassprite$frameinfo = (class_5791)iterator.next();
                boolean flag = true;
                if (textureatlassprite$frameinfo.field_28476 <= 0) {
                    field_28464.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)this.field_28465, (Object)i1, (Object)textureatlassprite$frameinfo.field_28476);
                    flag = false;
                }
                if (textureatlassprite$frameinfo.field_28475 < 0 || textureatlassprite$frameinfo.field_28475 >= k) {
                    field_28464.warn("Invalid frame index on sprite {} frame {}: {}", (Object)this.field_28465, (Object)i1, (Object)textureatlassprite$frameinfo.field_28475);
                    flag = false;
                }
                if (flag) {
                    intset.add(textureatlassprite$frameinfo.field_28475);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] aint = IntStream.range(0, k).filter(arg_0 -> class_1058.lambda$createTicker$4((IntSet)intset, arg_0)).toArray();
            if (aint.length > 0) {
                field_28464.warn("Unused frames in sprite {}: {}", (Object)this.field_28465, (Object)Arrays.toString(aint));
            }
        }
        if (list.size() <= 1) {
            return null;
        }
        class_4728 textureatlassprite$interpolationdata = animationmetadatasection.method_4685() ? new class_4728(infoIn, mipmapsIn) : null;
        return new class_5790((List<class_5791>)ImmutableList.copyOf((Collection)list), i, textureatlassprite$interpolationdata);
    }

    void method_4579(int xOffsetIn, int yOffsetIn, class_1011[] framesIn) {
        boolean blur = false;
        boolean clamp = this.isSpriteSingle;
        for (int i = 0; i < framesIn.length && this.method_4578() >> i > 0 && this.method_4595() >> i > 0; ++i) {
            framesIn[i].method_4312(i, this.field_5258 >> i, this.field_5256 >> i, xOffsetIn >> i, yOffsetIn >> i, this.field_28466 >> i, this.field_28467 >> i, framesIn.length > 1, false);
        }
    }

    public int method_35806() {
        return this.field_5258;
    }

    public int method_35807() {
        return this.field_5256;
    }

    public int method_4578() {
        return this.field_28466;
    }

    public int method_4595() {
        return this.field_28467;
    }

    public float method_4594() {
        return this.field_5270;
    }

    public float method_4577() {
        return this.field_5269;
    }

    public float method_4580(double u) {
        float f = this.field_5269 - this.field_5270;
        return this.field_5270 + f * (float)u / 16.0f;
    }

    public float method_35804(float u) {
        float f = this.field_5269 - this.field_5270;
        return (u - this.field_5270) / f * 16.0f;
    }

    public float method_4593() {
        return this.field_5268;
    }

    public float method_4575() {
        return this.field_5267;
    }

    public float method_4570(double v) {
        float f = this.field_5267 - this.field_5268;
        return this.field_5268 + f * (float)v / 16.0f;
    }

    public float method_35805(float v) {
        float f = this.field_5267 - this.field_5268;
        return (v - this.field_5268) / f * 16.0f;
    }

    public class_2960 method_4598() {
        return this.field_28465;
    }

    public class_1059 method_24119() {
        return this.field_21750;
    }

    public IntStream method_33442() {
        return this.field_28468 != null ? this.field_28468.method_33450() : IntStream.of(1);
    }

    @Override
    public void close() {
        for (class_1011 nativeimage : this.field_5262) {
            if (nativeimage == null) continue;
            nativeimage.close();
        }
        if (this.field_28468 != null) {
            this.field_28468.close();
        }
        if (this.spriteSingle != null) {
            // empty if block
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.close();
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.close();
        }
    }

    public String toString() {
        return "TextureAtlasSprite{name='" + this.field_28465 + "', frameCount=" + this.method_4592() + ", x=" + this.field_5258 + ", y=" + this.field_5256 + ", height=" + this.field_28467 + ", width=" + this.field_28466 + ", u0=" + this.field_5270 + ", u1=" + this.field_5269 + ", v0=" + this.field_5268 + ", v1=" + this.field_5267 + "}";
    }

    public boolean method_4583(int frameIndex, int pixelX, int pixelY) {
        int i = pixelX;
        int j = pixelY;
        if (this.field_28468 != null) {
            i = pixelX + this.field_28468.method_33446(frameIndex) * this.field_28466;
            j = pixelY + this.field_28468.method_33451(frameIndex) * this.field_28467;
        }
        return (this.field_5262[0].method_4315(i, j) >> 24 & 0xFF) == 0;
    }

    public void method_4584() {
        if (this.field_28468 != null) {
            this.field_28468.method_33445();
        } else {
            this.method_4579(0, 0, this.field_5262);
        }
    }

    private float method_23841() {
        float f = (float)this.field_28466 / (this.field_5269 - this.field_5270);
        float f1 = (float)this.field_28467 / (this.field_5267 - this.field_5268);
        return Math.max(f1, f);
    }

    public float method_23842() {
        return 4.0f / this.method_23841();
    }

    @Nullable
    public class_1061 method_33443() {
        return this.field_28468;
    }

    public class_4588 method_24108(class_4588 bufferIn) {
        class_4597.class_4598 rtb;
        if (this.method_4598() == TextureUtils.LOCATION_SPRITE_EMPTY && (rtb = bufferIn.getRenderTypeBuffer()) != null) {
            return rtb.getDummyBuffer();
        }
        return new class_4723(bufferIn, this);
    }

    public int getIndexInMap() {
        return this.indexInMap;
    }

    public void updateIndexInMap(CounterInt counterInt) {
        class_1058 registeredSprite;
        if (this.indexInMap >= 0) {
            return;
        }
        if (this.field_21750 != null && (registeredSprite = this.field_21750.getRegisteredSprite(this.method_4598())) != null) {
            this.indexInMap = registeredSprite.getIndexInMap();
        }
        if (this.indexInMap < 0) {
            this.indexInMap = counterInt.nextValue();
        }
    }

    public int getAnimationIndex() {
        return this.animationIndex;
    }

    public void setAnimationIndex(int animationIndex) {
        this.animationIndex = animationIndex;
        if (this.spriteSingle != null) {
            this.spriteSingle.setAnimationIndex(animationIndex);
        }
        if (this.spriteNormal != null) {
            this.spriteNormal.setAnimationIndex(animationIndex);
        }
        if (this.spriteSpecular != null) {
            this.spriteSpecular.setAnimationIndex(animationIndex);
        }
    }

    public boolean isAnimationActive() {
        return this.animationActive;
    }

    private void fixTransparentColor(class_1011 ni) {
        int[] data = new int[ni.method_4307() * ni.method_4323()];
        ni.getBufferRGBA().get(data);
        this.fixTransparentColor(data);
        ni.getBufferRGBA().put(data);
    }

    private void fixTransparentColor(int[] data) {
        if (data == null) {
            return;
        }
        long redSum = 0L;
        long greenSum = 0L;
        long blueSum = 0L;
        long count = 0L;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha < 16) continue;
            int red = col >> 16 & 0xFF;
            int green = col >> 8 & 0xFF;
            int blue = col & 0xFF;
            redSum += (long)red;
            greenSum += (long)green;
            blueSum += (long)blue;
            ++count;
        }
        if (count <= 0L) {
            return;
        }
        int redAvg = (int)(redSum / count);
        int greenAvg = (int)(greenSum / count);
        int blueAvg = (int)(blueSum / count);
        int colAvg = redAvg << 16 | greenAvg << 8 | blueAvg;
        for (int i = 0; i < data.length; ++i) {
            int col = data[i];
            int alpha = col >> 24 & 0xFF;
            if (alpha > 16) continue;
            data[i] = colAvg;
        }
    }

    public double getSpriteU16(float atlasU) {
        float dU = this.field_5269 - this.field_5270;
        return (atlasU - this.field_5270) / dU * 16.0f;
    }

    public double getSpriteV16(float atlasV) {
        float dV = this.field_5267 - this.field_5268;
        return (atlasV - this.field_5268) / dV * 16.0f;
    }

    public void bindSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            this.glSpriteTextureId = TextureUtil.generateTextureId();
            TextureUtil.prepareImage(this.glSpriteTextureId, this.mipmapLevels, this.method_4578(), this.method_4595());
            boolean blend = this.field_21750.isTextureBlend(this.spriteShadersType);
            if (blend) {
                TextureUtils.applyAnisotropicLevel();
            } else {
                GlStateManager._texParameter(3553, 34046, 1.0f);
                int minFilter = this.mipmapLevels > 0 ? 9984 : 9728;
                GlStateManager._texParameter(3553, 10241, minFilter);
                GlStateManager._texParameter(3553, 10240, 9728);
            }
        }
        TextureUtils.bindTexture(this.glSpriteTextureId);
    }

    public void deleteSpriteTexture() {
        if (this.glSpriteTextureId < 0) {
            return;
        }
        TextureUtil.releaseTextureId(this.glSpriteTextureId);
        this.glSpriteTextureId = -1;
    }

    public float toSingleU(float u) {
        u -= this.baseU;
        float ku = (float)this.sheetWidth / (float)this.method_4578();
        return u *= ku;
    }

    public float toSingleV(float v) {
        v -= this.baseV;
        float kv = (float)this.sheetHeight / (float)this.method_4595();
        return v *= kv;
    }

    public class_1011[] getMipmapImages() {
        return this.field_5262;
    }

    public class_1079 getAnimationMetadata() {
        return this.animationMetadata;
    }

    public int getOriginX() {
        return this.field_5258;
    }

    public int getOriginY() {
        return this.field_5256;
    }

    public float getUnInterpolatedU(float u) {
        float f = this.field_5269 - this.field_5270;
        return (u - this.field_5270) / f * 16.0f;
    }

    public float getUnInterpolatedV(float v) {
        float f = this.field_5267 - this.field_5268;
        return (v - this.field_5268) / f * 16.0f;
    }

    public class_1058 makeSpriteSingle() {
        class_1058 ss = new class_1058(this);
        ss.isSpriteSingle = true;
        return ss;
    }

    public class_1058 makeSpriteShaders(ShadersTextureType type, int colDef, class_1079 parentAnimation) {
        String suffix = type.getSuffix();
        class_2960 loc = new class_2960(this.method_4598().method_12836(), this.method_4598().method_12832() + suffix);
        class_2960 locPng = this.field_21750.method_4603(loc);
        class_1058 ss = null;
        if (this.resourceManager.method_18234(locPng)) {
            try (class_3298 iresource2 = this.resourceManager.method_14486(locPng);){
                class_1011 imageScaled;
                class_3298 resPngSize = this.resourceManager.method_14486(locPng);
                class_1050 pngSize = new class_1050(locPng.toString(), resPngSize.method_14482());
                class_1079 animMeta = iresource2.method_14481(class_1079.field_5337);
                if (animMeta == null) {
                    animMeta = class_1079.field_21768;
                }
                Pair<Integer, Integer> sizePair = animMeta.method_24141(pngSize.field_5227, pngSize.field_5226);
                class_4727 infoShaders = new class_4727(loc, (Integer)sizePair.getFirst(), (Integer)sizePair.getSecond(), animMeta);
                class_1011 image = class_1011.method_4309(iresource2.method_14482());
                if (image.method_4307() != this.method_4578() && (imageScaled = TextureUtils.scaleImage(image, this.method_4578())) != image) {
                    double scaleFactor = 1.0 * (double)this.method_4578() / (double)image.method_4307();
                    image.close();
                    image = imageScaled;
                    infoShaders = new class_4727(loc, (int)((double)((Integer)sizePair.getFirst()).intValue() * scaleFactor), (int)((double)((Integer)sizePair.getSecond()).intValue() * scaleFactor), animMeta);
                }
                ss = new class_1058(this.field_21750, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.field_5258, this.field_5256, image, type);
            }
            catch (IOException iresource2) {
                // empty catch block
            }
        }
        if (ss == null) {
            class_1011 image = new class_1011(this.method_4578(), this.method_4595(), false);
            int colAbgr = TextureUtils.toAbgr(colDef);
            image.method_4326(0, 0, image.method_4307(), image.method_4323(), colAbgr);
            class_4727 infoShaders = new class_4727(loc, this.method_4578(), this.method_4595(), class_1079.field_21768);
            ss = new class_1058(this.field_21750, infoShaders, this.mipmapLevels, this.sheetWidth, this.sheetHeight, this.field_5258, this.field_5256, image, type);
        }
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            ss.spriteSingle = ss.makeSpriteSingle();
        }
        ss.usesParentAnimationTime = class_1058.matchesTiming(ss.animationMetadata, parentAnimation);
        return ss;
    }

    public boolean isTerrain() {
        return this.terrain;
    }

    private void setTerrain(boolean terrainIn) {
        this.terrain = terrainIn;
        this.multiTexture = false;
        this.shaders = false;
        if (this.spriteSingle != null) {
            this.deleteSpriteTexture();
            this.spriteSingle = null;
        }
        if (this.spriteNormal != null) {
            if (this.spriteNormal.spriteSingle != null) {
                this.spriteNormal.deleteSpriteTexture();
            }
            this.spriteNormal.close();
            this.spriteNormal = null;
        }
        if (this.spriteSpecular != null) {
            if (this.spriteSpecular.spriteSingle != null) {
                this.spriteSpecular.deleteSpriteTexture();
            }
            this.spriteSpecular.close();
            this.spriteSpecular = null;
        }
        this.multiTexture = Config.isMultiTexture();
        this.shaders = Config.isShaders();
        if (this.terrain && this.multiTexture && !this.isSpriteSingle) {
            this.spriteSingle = this.makeSpriteSingle();
        }
        if (this.shaders && !this.isSpriteSingle) {
            if (this.spriteNormal == null && Shaders.configNormalMap) {
                this.spriteNormal = this.makeSpriteShaders(ShadersTextureType.NORMAL, -8421377, this.animationMetadata);
            }
            if (this.spriteSpecular == null && Shaders.configSpecularMap) {
                this.spriteSpecular = this.makeSpriteShaders(ShadersTextureType.SPECULAR, 0, this.animationMetadata);
            }
        }
    }

    private static boolean matchesTiming(class_1079 am1, class_1079 am2) {
        if (am1 == am2) {
            return true;
        }
        if (am1 == null || am2 == null) {
            return false;
        }
        if (am1.method_4684() != am2.method_4684()) {
            return false;
        }
        if (am1.method_4685() != am2.method_4685()) {
            return false;
        }
        if (am1.getFrameCount() != am2.getFrameCount()) {
            return false;
        }
        for (int i = 0; i < am1.getFrameCount(); ++i) {
        }
        return true;
    }

    public void update(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
        this.updateIndexInMap(this.field_21750.getCounterIndexInMap());
        this.setTerrain(this.field_21750.isTerrain());
    }

    public void updateAnimation() {
        if (this.field_28468 != null) {
            this.field_28468.method_4622();
        }
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        if (this.field_28468 != null) {
            x += this.field_28468.method_33446(frameIndex) * this.field_28466;
            y += this.field_28468.method_33451(frameIndex) * this.field_28467;
        }
        return this.field_5262[0].method_4315(x, y);
    }

    private static /* synthetic */ boolean lambda$createTicker$4(IntSet intset, int intIn) {
        return !intset.contains(intIn);
    }

    final class class_4728
    implements AutoCloseable {
        private class_1011[] field_21758;

        public String toString() {
            return "interpolation:" + class_1058.this.toString();
        }

        class_4728(class_4727 spriteInfoIn, int mipmapLevelsIn) {
            this.field_21758 = new class_1011[mipmapLevelsIn + 1];
            for (int i = 0; i < this.field_21758.length; ++i) {
                int j = spriteInfoIn.field_21754 >> i;
                int k = spriteInfoIn.field_21755 >> i;
                if (this.field_21758[i] != null) continue;
                this.field_21758[i] = new class_1011(j, k, false);
            }
        }

        void method_24128(class_5790 animatedTextureIn) {
            class_5791 textureatlassprite$frameinfo = animatedTextureIn.field_28472.get(animatedTextureIn.field_28470);
            double d0 = 1.0 - (double)animatedTextureIn.field_28471 / (double)textureatlassprite$frameinfo.field_28476;
            int i = textureatlassprite$frameinfo.field_28475;
            int j = animatedTextureIn.field_28472.get((int)((animatedTextureIn.field_28470 + 1) % animatedTextureIn.field_28472.size())).field_28475;
            if (i != j) {
                if (!class_1058.this.isSpriteSingle) {
                    for (int k = 0; k < this.field_21758.length; ++k) {
                        int l = class_1058.this.field_28466 >> k;
                        int i1 = class_1058.this.field_28467 >> k;
                        for (int j1 = 0; j1 < i1; ++j1) {
                            for (int k1 = 0; k1 < l; ++k1) {
                                int l1 = this.method_24130(animatedTextureIn, i, k, k1, j1);
                                int i2 = this.method_24130(animatedTextureIn, j, k, k1, j1);
                                int j2 = this.method_24129(d0, l1 >> 16 & 0xFF, i2 >> 16 & 0xFF);
                                int k2 = this.method_24129(d0, l1 >> 8 & 0xFF, i2 >> 8 & 0xFF);
                                int l2 = this.method_24129(d0, l1 & 0xFF, i2 & 0xFF);
                                this.field_21758[k].method_4305(k1, j1, l1 & 0xFF000000 | j2 << 16 | k2 << 8 | l2);
                            }
                        }
                    }
                }
                class_1058.this.method_4579(0, 0, this.field_21758);
            }
        }

        private int method_24130(class_5790 animatedTextureIn, int frameIndex, int mipmapLevel, int x, int y) {
            return class_1058.this.field_5262[mipmapLevel].method_4315(x + (animatedTextureIn.method_33446(frameIndex) * class_1058.this.field_28466 >> mipmapLevel), y + (animatedTextureIn.method_33451(frameIndex) * class_1058.this.field_28467 >> mipmapLevel));
        }

        private int method_24129(double ratio, int val1, int val2) {
            return (int)(ratio * (double)val1 + (1.0 - ratio) * (double)val2);
        }

        @Override
        public void close() {
            for (class_1011 nativeimage : this.field_21758) {
                if (nativeimage == null) continue;
                nativeimage.close();
            }
        }

        static /* synthetic */ class_1011[] access$102(class_4728 x0, class_1011[] x1) {
            x0.field_21758 = x1;
            return x1;
        }
    }

    public static final class class_4727 {
        final class_2960 field_21753;
        int field_21754;
        int field_21755;
        final class_1079 field_21756;
        private double scaleFactor = 1.0;

        public class_4727(class_2960 locationIn, int widthIn, int heightIn, class_1079 animationMetadataIn) {
            this.field_21753 = locationIn;
            this.field_21754 = widthIn;
            this.field_21755 = heightIn;
            this.field_21756 = animationMetadataIn;
        }

        public class_2960 method_24121() {
            return this.field_21753;
        }

        public int method_24123() {
            return this.field_21754;
        }

        public int method_24125() {
            return this.field_21755;
        }

        public void setSpriteWidth(int spriteWidth) {
            this.field_21754 = spriteWidth;
        }

        public void setSpriteHeight(int spriteHeight) {
            this.field_21755 = spriteHeight;
        }

        public class_1079 getSpriteAnimationMetadata() {
            return this.field_21756;
        }

        public double getScaleFactor() {
            return this.scaleFactor;
        }

        public void setScaleFactor(double scaleFactor) {
            this.scaleFactor = scaleFactor;
        }

        public String toString() {
            return "" + this.field_21753 + ", width: " + this.field_21754 + ", height: " + this.field_21755 + ", frames: " + this.field_21756.getFrameCount() + ", scale: " + this.scaleFactor;
        }
    }

    static class class_5791 {
        final int field_28475;
        final int field_28476;

        class_5791(int indexIn, int timeIn) {
            this.field_28475 = indexIn;
            this.field_28476 = timeIn;
        }
    }

    class class_5790
    implements class_1061,
    AutoCloseable {
        int field_28470;
        int field_28471;
        final List<class_5791> field_28472;
        private final int field_28473;
        @Nullable
        private final class_4728 field_28474;
        private class_1058 sprite;

        class_5790(@Nullable List<class_5791> infosIn, int rowsIn, class_4728 dataIn) {
            this.sprite = class_1058.this;
            this.field_28472 = infosIn;
            this.field_28473 = rowsIn;
            this.field_28474 = dataIn;
        }

        int method_33446(int frameIn) {
            return frameIn % this.field_28473;
        }

        int method_33451(int frameIn) {
            return frameIn / this.field_28473;
        }

        private void method_33455(int frameIn) {
            int i = this.method_33446(frameIn) * class_1058.this.field_28466;
            int j = this.method_33451(frameIn) * class_1058.this.field_28467;
            class_1058.this.method_4579(i, j, class_1058.this.field_5262);
        }

        @Override
        public void close() {
            if (this.field_28474 != null) {
                this.field_28474.close();
            }
        }

        @Override
        public void method_4622() {
            class_1058.this.animationActive = SmartAnimations.isActive() ? SmartAnimations.isSpriteRendered(this.sprite) : true;
            if (this.field_28472.size() <= 1) {
                class_1058.this.animationActive = false;
            }
            if (class_1058.this.spriteSingle != null && class_1058.this.spriteSingle.usesParentAnimationTime && class_1058.this.spriteSingle.field_28468 != null) {
                ((class_1058)class_1058.this.spriteSingle).field_28468.field_28470 = this.field_28470;
                ((class_1058)class_1058.this.spriteSingle).field_28468.field_28471 = this.field_28471;
            }
            if (class_1058.this.spriteNormal != null && class_1058.this.spriteNormal.usesParentAnimationTime && class_1058.this.spriteNormal.field_28468 != null) {
                ((class_1058)class_1058.this.spriteNormal).field_28468.field_28470 = this.field_28470;
                ((class_1058)class_1058.this.spriteNormal).field_28468.field_28471 = this.field_28471;
            }
            if (class_1058.this.spriteSpecular != null && class_1058.this.spriteSpecular.usesParentAnimationTime && class_1058.this.spriteSpecular.field_28468 != null) {
                ((class_1058)class_1058.this.spriteSpecular).field_28468.field_28470 = this.field_28470;
                ((class_1058)class_1058.this.spriteSpecular).field_28468.field_28471 = this.field_28471;
            }
            ++this.field_28471;
            class_5791 textureatlassprite$frameinfo = this.field_28472.get(this.field_28470);
            if (this.field_28471 >= textureatlassprite$frameinfo.field_28476) {
                int i = textureatlassprite$frameinfo.field_28475;
                this.field_28470 = (this.field_28470 + 1) % this.field_28472.size();
                this.field_28471 = 0;
                int j = this.field_28472.get((int)this.field_28470).field_28475;
                if (!class_1058.this.animationActive) {
                    return;
                }
                if (i != j) {
                    this.method_33455(j);
                }
            } else if (this.field_28474 != null) {
                if (!class_1058.this.animationActive) {
                    return;
                }
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.field_28474.method_24128(this));
                } else {
                    this.field_28474.method_24128(this);
                }
            }
        }

        public void method_33445() {
            this.method_33455(this.field_28472.get((int)0).field_28475);
        }

        public IntStream method_33450() {
            return this.field_28472.stream().mapToInt(infoIn -> infoIn.field_28475).distinct();
        }

        public class_1058 getSprite() {
            return this.sprite;
        }

        public String toString() {
            return "animation:" + class_1058.this.toString();
        }
    }
}

