/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_313;
import net.minecraft.class_319;
import net.minecraft.class_323;
import net.minecraft.class_3675;
import net.minecraft.class_3678;
import net.minecraft.class_4718;
import net.minecraft.class_543;
import net.minecraft.class_6417;
import net.minecraftforge.fml.loading.progress.EarlyProgressVisualization;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.TextureUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.opengl.GL;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class class_1041
implements AutoCloseable {
    private static final Logger field_5178 = LogManager.getLogger();
    private final GLFWErrorCallback field_5190 = GLFWErrorCallback.create(this::method_4482);
    private final class_3678 field_5176;
    private final class_323 field_5195;
    private final long field_5187;
    private int field_5175;
    private int field_5185;
    private int field_5174;
    private int field_5184;
    private Optional<class_319> field_5193;
    private boolean field_5191;
    private boolean field_5177;
    private int field_5183;
    private int field_5198;
    private int field_5182;
    private int field_5197;
    private int field_5181;
    private int field_5196;
    private int field_5180;
    private int field_5194;
    private double field_5179;
    private String field_5192 = "";
    private boolean field_5186;
    private int field_16238;
    private boolean field_16517;
    private boolean closed;

    public class_1041(class_3678 p_i85371_1_, class_323 p_i85371_2_, class_543 p_i85371_3_, @Nullable String videoModeName, String titleIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        this.field_5195 = p_i85371_2_;
        this.method_4481();
        this.method_4474("Pre startup");
        this.field_5176 = p_i85371_1_;
        Optional<class_319> optional = class_319.method_1665(videoModeName);
        this.field_5193 = optional.isPresent() ? optional : (p_i85371_3_.field_3282.isPresent() && p_i85371_3_.field_3286.isPresent() ? Optional.of(new class_319(p_i85371_3_.field_3282.getAsInt(), p_i85371_3_.field_3286.getAsInt(), 8, 8, 8, 60)) : Optional.empty());
        this.field_5177 = this.field_5191 = p_i85371_3_.field_3283;
        class_313 monitor = p_i85371_2_.method_1680(GLFW.glfwGetPrimaryMonitor());
        this.field_5182 = p_i85371_3_.field_3285 > 0 ? p_i85371_3_.field_3285 : 1;
        this.field_5174 = this.field_5182;
        this.field_5197 = p_i85371_3_.field_3284 > 0 ? p_i85371_3_.field_3284 : 1;
        this.field_5184 = this.field_5197;
        GLFW.glfwDefaultWindowHints();
        if (Config.isAntialiasing()) {
            GLFW.glfwWindowHint((int)135181, (int)Config.getAntialiasingLevel());
        }
        GLFW.glfwWindowHint((int)139265, (int)196609);
        GLFW.glfwWindowHint((int)139275, (int)221185);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        long handleForge = 0L;
        if (Reflector.EarlyProgressVisualization_handOffWindow.exists()) {
            Object epvInstance = Reflector.getFieldValue(Reflector.EarlyProgressVisualization_INSTANCE);
            handleForge = Reflector.callLong(epvInstance, Reflector.EarlyProgressVisualization_handOffWindow, () -> this.field_5182, () -> this.field_5197, () -> titleIn, () -> this.field_5191 && monitor != null ? monitor.method_1622() : 0L);
            if (Config.isAntialiasing()) {
                GLFW.glfwDestroyWindow((long)handleForge);
                handleForge = 0L;
            }
        }
        this.field_5187 = handleForge != 0L ? handleForge : GLFW.glfwCreateWindow((int)this.field_5182, (int)this.field_5197, (CharSequence)titleIn, (long)(this.field_5191 && monitor != null ? monitor.method_1622() : 0L), (long)0L);
        if (monitor != null) {
            class_319 videomode = monitor.method_1614(this.field_5191 ? this.field_5193 : Optional.empty());
            this.field_5175 = this.field_5183 = monitor.method_1616() + videomode.method_1668() / 2 - this.field_5182 / 2;
            this.field_5185 = this.field_5198 = monitor.method_1618() + videomode.method_1669() / 2 - this.field_5197 / 2;
        } else {
            int[] aint1 = new int[1];
            int[] aint = new int[1];
            GLFW.glfwGetWindowPos((long)this.field_5187, (int[])aint1, (int[])aint);
            this.field_5175 = this.field_5183 = aint1[0];
            this.field_5185 = this.field_5198 = aint[0];
        }
        GLFW.glfwMakeContextCurrent((long)this.field_5187);
        GL.createCapabilities();
        this.method_4479();
        this.method_4483();
        GLFW.glfwSetFramebufferSizeCallback((long)this.field_5187, this::method_4504);
        GLFW.glfwSetWindowPosCallback((long)this.field_5187, this::method_4478);
        GLFW.glfwSetWindowSizeCallback((long)this.field_5187, this::method_4488);
        GLFW.glfwSetWindowFocusCallback((long)this.field_5187, this::method_4494);
        GLFW.glfwSetCursorEnterCallback((long)this.field_5187, this::method_30132);
    }

    public int method_22092() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GLX._getRefreshRate(this);
    }

    public boolean method_22093() {
        return GLX._shouldClose(this);
    }

    public static void method_4492(BiConsumer<Integer, String> errorHandlerIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            PointerBuffer pointerbuffer = memorystack.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerbuffer);
            if (i != 0) {
                long j = pointerbuffer.get();
                String s = j == 0L ? "" : MemoryUtil.memUTF8((long)j);
                errorHandlerIn.accept(i, s);
            }
        }
    }

    public void method_4491(InputStream stream16, InputStream stream32) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            if (stream16 == null) {
                throw new FileNotFoundException("icons/icon_16x16.png");
            }
            if (stream32 == null) {
                throw new FileNotFoundException("icons/icon_32x32.png");
            }
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)2, (MemoryStack)memorystack);
            ByteBuffer bytebuffer = this.method_4510(stream16, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(0);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer);
            ByteBuffer bytebuffer1 = this.method_4510(stream32, intbuffer, intbuffer1, intbuffer2);
            if (bytebuffer1 == null) {
                throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
            }
            buffer.position(1);
            buffer.width(intbuffer.get(0));
            buffer.height(intbuffer1.get(0));
            buffer.pixels(bytebuffer1);
            buffer.position(0);
            GLFW.glfwSetWindowIcon((long)this.field_5187, (GLFWImage.Buffer)buffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            STBImage.stbi_image_free((ByteBuffer)bytebuffer1);
        }
        catch (IOException ioexception) {
            field_5178.error("Couldn't set icon", (Throwable)ioexception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuffer method_4510(InputStream streamIn, IntBuffer bufferX, IntBuffer bufferY, IntBuffer bufferChannels) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource(streamIn);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)bufferX, (IntBuffer)bufferY, (IntBuffer)bufferChannels, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }

    public void method_4474(String renderPhaseIn) {
        this.field_5192 = renderPhaseIn;
        if (renderPhaseIn.equals("Startup")) {
            TextureUtils.registerTickableTextures();
        }
    }

    private void method_4481() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLFW.glfwSetErrorCallback(class_1041::method_4501);
    }

    private static void method_4501(int error, long description) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        String s = "GLFW error " + error + ": " + MemoryUtil.memUTF8((long)description);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)(s + ".\n\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions)."), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        throw new class_4716(s);
    }

    public void method_4482(int error, long description) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        String s = MemoryUtil.memUTF8((long)description);
        field_5178.error("########## GL ERROR ##########");
        field_5178.error("@ {}", (Object)this.field_5192);
        field_5178.error("{}: {}", (Object)error, (Object)s);
    }

    public void method_4513() {
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.field_5190);
        if (glfwerrorcallback != null) {
            glfwerrorcallback.free();
        }
        TextureUtils.registerResourceListener();
    }

    public void method_4497(boolean vsyncEnabled) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.field_16517 = vsyncEnabled;
        GLFW.glfwSwapInterval((int)(vsyncEnabled ? 1 : 0));
    }

    @Override
    public void close() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        this.closed = true;
        Callbacks.glfwFreeCallbacks((long)this.field_5187);
        this.field_5190.close();
        GLFW.glfwDestroyWindow((long)this.field_5187);
        GLFW.glfwTerminate();
    }

    private void method_4478(long windowPointer, int windowXIn, int windowYIn) {
        this.field_5183 = windowXIn;
        this.field_5198 = windowYIn;
    }

    private void method_4504(long windowPointer, int framebufferWidth, int framebufferHeight) {
        if (windowPointer == this.field_5187) {
            int i = this.method_4489();
            int j = this.method_4506();
            if (framebufferWidth != 0 && framebufferHeight != 0) {
                this.field_5181 = framebufferWidth;
                this.field_5196 = framebufferHeight;
                if (this.method_4489() != i || this.method_4506() != j) {
                    this.field_5176.method_15993();
                }
            }
        }
    }

    private void method_4483() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        int[] aint = new int[1];
        int[] aint1 = new int[1];
        GLFW.glfwGetFramebufferSize((long)this.field_5187, (int[])aint, (int[])aint1);
        this.field_5181 = aint[0] > 0 ? aint[0] : 1;
        int n = this.field_5196 = aint1[0] > 0 ? aint1[0] : 1;
        if (this.field_5196 == 0 || this.field_5181 == 0) {
            EarlyProgressVisualization.INSTANCE.updateFBSize(w -> {
                this.field_5181 = w;
            }, h -> {
                this.field_5196 = h;
            });
        }
    }

    private void method_4488(long windowPointer, int windowWidthIn, int windowHeightIn) {
        this.field_5182 = windowWidthIn;
        this.field_5197 = windowHeightIn;
    }

    private void method_4494(long windowPointer, boolean hasFocus) {
        if (windowPointer == this.field_5187) {
            this.field_5176.method_15995(hasFocus);
        }
    }

    private void method_30132(long windowPointer, boolean enterIn) {
        if (enterIn) {
            this.field_5176.method_30133();
        }
    }

    public void method_15999(int limitIn) {
        this.field_16238 = limitIn;
    }

    public int method_16000() {
        return this.field_16238;
    }

    public void method_15998() {
        RenderSystem.flipFrame(this.field_5187);
        if (this.field_5191 != this.field_5177) {
            this.field_5177 = this.field_5191;
            this.method_4485(this.field_16517);
        }
    }

    public Optional<class_319> method_4511() {
        return this.field_5193;
    }

    public void method_4505(Optional<class_319> fullscreenModeIn) {
        boolean flag = !fullscreenModeIn.equals(this.field_5193);
        this.field_5193 = fullscreenModeIn;
        if (flag) {
            this.field_5186 = true;
        }
    }

    public void method_4475() {
        if (this.field_5191 && this.field_5186) {
            this.field_5186 = false;
            this.method_4479();
            this.field_5176.method_15993();
        }
    }

    private void method_4479() {
        boolean flag;
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        boolean bl = flag = GLFW.glfwGetWindowMonitor((long)this.field_5187) != 0L;
        if (this.field_5191) {
            class_313 monitor = this.field_5195.method_1681(this);
            if (monitor == null) {
                field_5178.warn("Failed to find suitable monitor for fullscreen mode");
                this.field_5191 = false;
            } else {
                if (class_310.field_1703) {
                    class_6417.method_37461(this.field_5187);
                }
                class_319 videomode = monitor.method_1614(this.field_5193);
                if (!flag) {
                    this.field_5175 = this.field_5183;
                    this.field_5185 = this.field_5198;
                    this.field_5174 = this.field_5182;
                    this.field_5184 = this.field_5197;
                }
                this.field_5183 = 0;
                this.field_5198 = 0;
                this.field_5182 = videomode.method_1668();
                this.field_5197 = videomode.method_1669();
                GLFW.glfwSetWindowMonitor((long)this.field_5187, (long)monitor.method_1622(), (int)this.field_5183, (int)this.field_5198, (int)this.field_5182, (int)this.field_5197, (int)videomode.method_1671());
            }
        } else {
            this.field_5183 = this.field_5175;
            this.field_5198 = this.field_5185;
            this.field_5182 = this.field_5174;
            this.field_5197 = this.field_5184;
            GLFW.glfwSetWindowMonitor((long)this.field_5187, (long)0L, (int)this.field_5183, (int)this.field_5198, (int)this.field_5182, (int)this.field_5197, (int)-1);
        }
    }

    public void method_4500() {
        this.field_5191 = !this.field_5191;
    }

    public void method_36813(int widthIn, int heightIn) {
        this.field_5174 = widthIn;
        this.field_5184 = heightIn;
        this.field_5191 = false;
        this.method_4479();
    }

    private void method_4485(boolean vsyncEnabled) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        try {
            this.method_4479();
            this.field_5176.method_15993();
            this.method_4497(vsyncEnabled);
            this.method_15998();
        }
        catch (Exception exception) {
            field_5178.error("Couldn't toggle fullscreen", (Throwable)exception);
        }
    }

    public int method_4476(int guiScaleIn, boolean forceUnicode) {
        int i;
        for (i = 1; i != guiScaleIn && i < this.field_5181 && i < this.field_5196 && this.field_5181 / (i + 1) >= 320 && this.field_5196 / (i + 1) >= 240; ++i) {
        }
        if (forceUnicode && i % 2 != 0) {
            ++i;
        }
        return i;
    }

    public void method_15997(double scaleFactor) {
        this.field_5179 = scaleFactor;
        int i = (int)((double)this.field_5181 / scaleFactor);
        this.field_5180 = (double)this.field_5181 / scaleFactor > (double)i ? i + 1 : i;
        int j = (int)((double)this.field_5196 / scaleFactor);
        this.field_5194 = (double)this.field_5196 / scaleFactor > (double)j ? j + 1 : j;
    }

    public void method_24286(String titleIn) {
        GLFW.glfwSetWindowTitle((long)this.field_5187, (CharSequence)titleIn);
    }

    public long method_4490() {
        return this.field_5187;
    }

    public boolean method_4498() {
        return this.field_5191;
    }

    public int method_4489() {
        return this.field_5181;
    }

    public int method_4506() {
        return this.field_5196;
    }

    public void method_35642(int widthIn) {
        this.field_5181 = widthIn;
    }

    public void method_35643(int heightIn) {
        this.field_5196 = heightIn;
    }

    public int method_4480() {
        return this.field_5182;
    }

    public int method_4507() {
        return this.field_5197;
    }

    public int method_4486() {
        return this.field_5180;
    }

    public int method_4502() {
        return this.field_5194;
    }

    public int method_4499() {
        return this.field_5183;
    }

    public int method_4477() {
        return this.field_5198;
    }

    public double method_4495() {
        return this.field_5179;
    }

    @Nullable
    public class_313 method_20831() {
        return this.field_5195.method_1681(this);
    }

    public void method_21668(boolean valueIn) {
        class_3675.method_21736(this.field_5187, valueIn);
    }

    public void resizeFramebuffer(int width, int height) {
        this.method_4504(this.field_5187, width, height);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static class class_4716
    extends class_4718 {
        class_4716(String messageIn) {
            super(messageIn);
        }
    }
}

