/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.util.MemoryReserve;
import net.optifine.CrashReporter;
import net.optifine.reflect.Reflector;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashReport {
    private static final Logger f_127499_ = LogManager.getLogger();
    private final String f_127500_;
    private final Throwable f_127501_;
    private final List<CrashReportCategory> f_127503_ = Lists.newArrayList();
    private File f_127504_;
    private boolean f_127505_ = true;
    private StackTraceElement[] f_127506_ = new StackTraceElement[0];
    private final SystemReport f_319128_ = new SystemReport();
    private boolean reported = false;

    public CrashReport(String descriptionIn, Throwable causeThrowable) {
        this.f_127500_ = descriptionIn;
        this.f_127501_ = causeThrowable;
    }

    public String m_127511_() {
        return this.f_127500_;
    }

    public Throwable m_127524_() {
        return this.f_127501_;
    }

    public String m_319129_() {
        StringBuilder stringbuilder = new StringBuilder();
        this.m_127519_(stringbuilder);
        return stringbuilder.toString();
    }

    public void m_127519_(StringBuilder builder) {
        if (!(this.f_127506_ != null && this.f_127506_.length > 0 || this.f_127503_.isEmpty())) {
            this.f_127506_ = (StackTraceElement[])ArrayUtils.subarray((Object[])this.f_127503_.get(0).m_128143_(), (int)0, (int)1);
        }
        if (this.f_127506_ != null && this.f_127506_.length > 0) {
            builder.append("-- Head --\n");
            builder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            if (Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.exists()) {
                builder.append("Stacktrace:");
                builder.append(Reflector.CrashReportExtender_generateEnhancedStackTraceSTE.callString1(this.f_127506_));
            } else {
                builder.append("Stacktrace:\n");
                for (StackTraceElement stacktraceelement : this.f_127506_) {
                    builder.append("\t").append("at ").append(stacktraceelement);
                    builder.append("\n");
                }
                builder.append("\n");
            }
        }
        for (CrashReportCategory crashreportcategory : this.f_127503_) {
            crashreportcategory.m_128168_(builder);
            builder.append("\n\n");
        }
        Reflector.CrashReportExtender_extendSystemReport.call((Object)this.f_319128_);
        this.f_319128_.m_300468_(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String m_127525_() {
        String s;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable throwable = this.f_127501_;
        if (throwable.getMessage() == null) {
            if (throwable instanceof NullPointerException) {
                throwable = new NullPointerException(this.f_127500_);
            } else if (throwable instanceof StackOverflowError) {
                throwable = new StackOverflowError(this.f_127500_);
            } else if (throwable instanceof OutOfMemoryError) {
                throwable = new OutOfMemoryError(this.f_127500_);
            }
            throwable.setStackTrace(this.f_127501_.getStackTrace());
        }
        try {
            if (Reflector.CrashReportExtender_generateEnhancedStackTraceT.exists()) {
                return Reflector.CrashReportExtender_generateEnhancedStackTraceT.callString(throwable);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            throwable.printStackTrace(printwriter);
            s = stringwriter.toString();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable2;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s;
    }

    public String m_127526_() {
        if (!this.reported) {
            this.reported = true;
            CrashReporter.onCrashReport((CrashReport)this, (SystemReport)this.f_319128_);
        }
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Crash Report ----\n");
        if (Reflector.CrashReportExtender_addCrashReportHeader != null && Reflector.CrashReportExtender_addCrashReportHeader.exists()) {
            Reflector.CrashReportExtender_addCrashReportHeader.call(stringbuilder, this);
        }
        stringbuilder.append("// ");
        stringbuilder.append(CrashReport.m_127531_());
        stringbuilder.append("\n\n");
        stringbuilder.append("Time: ");
        stringbuilder.append(new SimpleDateFormat().format(new Date()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.f_127500_);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.m_127525_());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.m_127519_(stringbuilder);
        return stringbuilder.toString();
    }

    public File m_127527_() {
        return this.f_127504_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_127512_(File toFile) {
        boolean bl;
        if (this.f_127504_ != null) {
            return false;
        }
        if (toFile.getParentFile() != null) {
            toFile.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), StandardCharsets.UTF_8);
            writer.write(this.m_127526_());
            this.f_127504_ = toFile;
            bl = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                f_127499_.error("Could not save crash report to {}", (Object)toFile, (Object)throwable);
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return flag;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    public SystemReport m_319130_() {
        return this.f_319128_;
    }

    public CrashReportCategory m_127514_(String name) {
        return this.m_127516_(name, 1);
    }

    public CrashReportCategory m_127516_(String categoryName, int stacktraceLength) {
        CrashReportCategory crashreportcategory = new CrashReportCategory(categoryName);
        try {
            if (this.f_127505_) {
                int i = crashreportcategory.m_128148_(stacktraceLength);
                StackTraceElement[] astacktraceelement = this.f_127501_.getStackTrace();
                StackTraceElement stacktraceelement = null;
                StackTraceElement stacktraceelement1 = null;
                int j = astacktraceelement.length - i;
                if (j < 0) {
                    System.out.println("Negative index in crash report handler (" + astacktraceelement.length + "/" + i + ")");
                }
                if (astacktraceelement != null && 0 <= j && j < astacktraceelement.length) {
                    stacktraceelement = astacktraceelement[j];
                    if (astacktraceelement.length + 1 - i < astacktraceelement.length) {
                        stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - i];
                    }
                }
                this.f_127505_ = crashreportcategory.m_128156_(stacktraceelement, stacktraceelement1);
                if (i > 0 && !this.f_127503_.isEmpty()) {
                    CrashReportCategory crashreportcategory1 = this.f_127503_.get(this.f_127503_.size() - 1);
                    crashreportcategory1.m_128174_(i);
                } else if (astacktraceelement != null && astacktraceelement.length >= i && 0 <= j && j < astacktraceelement.length) {
                    this.f_127506_ = new StackTraceElement[j];
                    System.arraycopy(astacktraceelement, 0, this.f_127506_, 0, this.f_127506_.length);
                } else {
                    this.f_127505_ = false;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.f_127503_.add(crashreportcategory);
        return crashreportcategory;
    }

    private static String m_127531_() {
        String[] astring = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return astring[(int)(Util.m_137569_() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport m_127521_(Throwable causeIn, String descriptionIn) {
        while (causeIn instanceof CompletionException && causeIn.getCause() != null) {
            causeIn = causeIn.getCause();
        }
        CrashReport crashreport = causeIn instanceof ReportedException ? ((ReportedException)causeIn).m_134761_() : new CrashReport(descriptionIn, causeIn);
        return crashreport;
    }

    public static void m_127529_() {
        MemoryReserve.m_320811_();
        new CrashReport("Don't panic!", new Throwable()).m_127526_();
    }
}

