/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Collectors;

public class VertexFormat {
    private ImmutableList<VertexFormatElement> f_86012_;
    private ImmutableMap<String, VertexFormatElement> f_268651_;
    private IntList f_86013_ = new IntArrayList();
    private int f_86014_;
    private int f_268652_;
    private int f_268653_;
    private int f_268654_;
    private String name;
    private int positionElementOffset = -1;
    private int normalElementOffset = -1;
    private int colorElementOffset = -1;
    private Int2IntMap uvOffsetsById = new Int2IntArrayMap();

    public VertexFormat(ImmutableMap<String, VertexFormatElement> p_i268655_1_) {
        this.f_268651_ = p_i268655_1_;
        this.f_86012_ = p_i268655_1_.values().asList();
        int i = 0;
        for (VertexFormatElement vertexformatelement : p_i268655_1_.values()) {
            this.f_86013_.add(i);
            VertexFormatElement.Usage usage = vertexformatelement.m_86048_();
            if (usage == VertexFormatElement.Usage.POSITION) {
                this.positionElementOffset = i;
            } else if (usage == VertexFormatElement.Usage.NORMAL) {
                this.normalElementOffset = i;
            } else if (usage == VertexFormatElement.Usage.COLOR) {
                this.colorElementOffset = i;
            } else if (usage == VertexFormatElement.Usage.UV) {
                this.uvOffsetsById.put(vertexformatelement.m_86049_(), i);
            }
            i += vertexformatelement.m_86050_();
        }
        this.f_86014_ = i;
    }

    public String toString() {
        return "format: " + this.name + " " + this.f_268651_.size() + " elements: " + this.f_268651_.entrySet().stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public int m_86017_() {
        return this.m_86020_() / 4;
    }

    public int m_86020_() {
        return this.f_86014_;
    }

    public ImmutableList<VertexFormatElement> m_86023_() {
        return this.f_86012_;
    }

    public ImmutableList<String> m_268657_() {
        return this.f_268651_.keySet().asList();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormat vertexformat = (VertexFormat)p_equals_1_;
            return this.f_86014_ != vertexformat.f_86014_ ? false : this.f_268651_.equals(vertexformat.f_268651_);
        }
        return false;
    }

    public int hashCode() {
        return this.f_268651_.hashCode();
    }

    public void m_268658_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(this::m_268663_);
        } else {
            this.m_268663_();
        }
    }

    private void m_268663_() {
        int i = this.m_86020_();
        ImmutableList<VertexFormatElement> list = this.m_86023_();
        for (int j = 0; j < list.size(); ++j) {
            VertexFormatElement vfe = (VertexFormatElement)list.get(j);
            int attributeIndex = vfe.getAttributeIndex(j);
            if (attributeIndex < 0) continue;
            vfe.m_268686_(attributeIndex, this.f_86013_.getInt(j), i);
        }
    }

    public void m_86024_() {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(this::m_268664_);
        } else {
            this.m_268664_();
        }
    }

    private void m_268664_() {
        ImmutableList<VertexFormatElement> immutablelist = this.m_86023_();
        for (int i = 0; i < immutablelist.size(); ++i) {
            VertexFormatElement vertexformatelement = (VertexFormatElement)immutablelist.get(i);
            int attributeIndex = vertexformatelement.getAttributeIndex(i);
            if (attributeIndex < 0) continue;
            vertexformatelement.m_268684_(attributeIndex);
        }
    }

    public int m_268660_() {
        if (this.f_268652_ == 0) {
            this.f_268652_ = GlStateManager.m_267881_();
        }
        return this.f_268652_;
    }

    public int m_268661_() {
        if (this.f_268653_ == 0) {
            this.f_268653_ = GlStateManager.m_84537_();
        }
        return this.f_268653_;
    }

    public int m_268662_() {
        if (this.f_268654_ == 0) {
            this.f_268654_ = GlStateManager.m_84537_();
        }
        return this.f_268654_;
    }

    public int getOffset(int index) {
        return this.f_86013_.getInt(index);
    }

    public boolean hasPosition() {
        return this.positionElementOffset >= 0;
    }

    public int getPositionOffset() {
        return this.positionElementOffset;
    }

    public boolean hasNormal() {
        return this.normalElementOffset >= 0;
    }

    public int getNormalOffset() {
        return this.normalElementOffset;
    }

    public boolean hasColor() {
        return this.colorElementOffset >= 0;
    }

    public int getColorOffset() {
        return this.colorElementOffset;
    }

    public boolean hasUV(int id) {
        return this.uvOffsetsById.containsKey(id);
    }

    public int getUvOffsetById(int id) {
        return this.uvOffsetsById.get(id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void copyFrom(VertexFormat vf) {
        this.f_86012_ = vf.f_86012_;
        this.f_268651_ = vf.f_268651_;
        this.f_86013_ = vf.f_86013_;
        this.f_86014_ = vf.f_86014_;
        this.f_268652_ = vf.f_268652_;
        this.f_268653_ = vf.f_268653_;
        this.f_268654_ = vf.f_268654_;
        this.name = vf.name;
        this.positionElementOffset = vf.positionElementOffset;
        this.normalElementOffset = vf.normalElementOffset;
        this.colorElementOffset = vf.colorElementOffset;
        this.uvOffsetsById = vf.uvOffsetsById;
    }

    public VertexFormat duplicate() {
        VertexFormat vf = new VertexFormat((ImmutableMap<String, VertexFormatElement>)ImmutableMap.of());
        vf.copyFrom(this);
        return vf;
    }

    public ImmutableMap<String, VertexFormatElement> getElementMapping() {
        return this.f_268651_;
    }

    public static enum Mode {
        LINES(4, 2, 2),
        LINE_STRIP(5, 2, 1),
        DEBUG_LINES(1, 2, 2),
        DEBUG_LINE_STRIP(3, 2, 1),
        TRIANGLES(4, 3, 3),
        TRIANGLE_STRIP(5, 3, 1),
        TRIANGLE_FAN(6, 3, 1),
        QUADS(4, 4, 4);

        public final int f_190732_;
        public final int f_190733_;
        public final int f_190734_;

        private Mode(int glModeIn, int lengthIn, int strideIn) {
            this.f_190732_ = glModeIn;
            this.f_190733_ = lengthIn;
            this.f_190734_ = strideIn;
        }

        public int m_190743_(int vertexCountIn) {
            int i;
            switch (this) {
                case LINE_STRIP: 
                case DEBUG_LINES: 
                case DEBUG_LINE_STRIP: 
                case TRIANGLES: 
                case TRIANGLE_STRIP: 
                case TRIANGLE_FAN: {
                    i = vertexCountIn;
                    break;
                }
                case LINES: 
                case QUADS: {
                    i = vertexCountIn / 4 * 6;
                    break;
                }
                default: {
                    i = 0;
                }
            }
            return i;
        }
    }

    public static enum IndexType {
        BYTE(5121, 1),
        SHORT(5123, 2),
        INT(5125, 4);

        public final int f_190712_;
        public final int f_190713_;

        private IndexType(int glTypeIn, int sizeBytesIn) {
            this.f_190712_ = glTypeIn;
            this.f_190713_ = sizeBytesIn;
        }

        public static IndexType m_190721_(int indexCountIn) {
            if ((indexCountIn & 0xFFFF0000) != 0) {
                return INT;
            }
            return (indexCountIn & 0xFF00) != 0 ? SHORT : BYTE;
        }
    }
}

