/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.optifine.Config;
import net.optifine.render.MultiTextureData;
import net.optifine.render.MultiTextureRenderer;
import net.optifine.render.VboRange;
import net.optifine.render.VboRegion;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;

public class VertexBuffer
implements AutoCloseable {
    private int f_268552_;
    private int f_190618_;
    private VertexFormat.IndexType f_190619_;
    private int f_268553_;
    private int f_190620_;
    private VertexFormat.Mode f_190621_;
    private boolean f_190622_;
    private VertexFormat f_268554_;
    private VboRegion vboRegion;
    private VboRange vboRange;
    private MultiTextureData multiTextureData;

    public VertexBuffer() {
        RenderSystem.m_69531_(idIn -> {
            this.f_268552_ = idIn;
        });
        RenderSystem.m_255975_(idIn -> {
            this.f_268553_ = idIn;
        });
        RenderSystem.m_69531_(idIn -> {
            this.f_190618_ = idIn;
        });
    }

    public void m_85921_() {
        GlStateManager.m_84480_((int)34962, (int)this.f_268552_);
        if (this.f_190622_) {
            RenderSystem.AutoStorageIndexBuffer rendersystem$autostorageindexbuffer = RenderSystem.m_177433_((VertexFormat.Mode)this.f_190621_, (int)this.f_190620_);
            this.f_190619_ = rendersystem$autostorageindexbuffer.m_177828_();
            GlStateManager.m_84480_((int)34963, (int)rendersystem$autostorageindexbuffer.m_177817_());
        } else {
            GlStateManager.m_84480_((int)34963, (int)this.f_190618_);
        }
    }

    public void m_85925_(BufferBuilder bufferIn) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_85935_(bufferIn));
        } else {
            this.m_85935_(bufferIn);
        }
    }

    public CompletableFuture<Void> m_85932_(BufferBuilder bufferIn) {
        if (!RenderSystem.m_69586_()) {
            return CompletableFuture.runAsync(() -> this.m_85935_(bufferIn), runnableIn -> RenderSystem.m_69879_(runnableIn::run));
        }
        this.m_85935_(bufferIn);
        return CompletableFuture.completedFuture(null);
    }

    private void m_85935_(BufferBuilder bufferIn) {
        Pair<BufferBuilder.DrawState, ByteBuffer> pair = bufferIn.m_85728_();
        BufferBuilder.DrawState drawState = (BufferBuilder.DrawState)pair.getFirst();
        if (this.vboRegion != null) {
            ByteBuffer data = (ByteBuffer)pair.getSecond();
            data.position(0);
            data.limit(drawState.m_190503_());
            this.vboRegion.bufferData(data, this.vboRange);
            data.position(0);
            data.limit(drawState.m_190504_());
            return;
        }
        this.multiTextureData = drawState.getMultiTextureData();
        if (this.f_268552_ != 0) {
            BufferUploader.m_268466_();
            BufferBuilder.DrawState bufferbuilder$drawstate = (BufferBuilder.DrawState)pair.getFirst();
            ByteBuffer bytebuffer = (ByteBuffer)pair.getSecond();
            int i = bufferbuilder$drawstate.m_190503_();
            this.f_190620_ = bufferbuilder$drawstate.m_190500_();
            this.f_190619_ = bufferbuilder$drawstate.m_190502_();
            this.f_268554_ = bufferbuilder$drawstate.m_85745_();
            this.f_190621_ = bufferbuilder$drawstate.m_190501_();
            this.f_190622_ = bufferbuilder$drawstate.m_190506_();
            this.m_268583_();
            this.m_85921_();
            if (!bufferbuilder$drawstate.m_190505_()) {
                bytebuffer.limit(i);
                RenderSystem.m_69525_((int)34962, (ByteBuffer)bytebuffer, (int)35044);
                bytebuffer.position(i);
            }
            if (!this.f_190622_) {
                bytebuffer.limit(bufferbuilder$drawstate.m_190504_());
                RenderSystem.m_69525_((int)34963, (ByteBuffer)bytebuffer, (int)35044);
                bytebuffer.position(0);
            } else {
                bytebuffer.limit(bufferbuilder$drawstate.m_190504_());
                bytebuffer.position(0);
            }
            VertexBuffer.m_85931_();
            VertexBuffer.m_268564_();
        }
    }

    private void m_268583_() {
        GlStateManager.m_267882_((int)this.f_268553_);
    }

    public static void m_268564_() {
        GlStateManager.m_267882_((int)0);
    }

    public void m_313172_() {
        if (this.vboRegion != null) {
            this.vboRegion.drawArrays(VertexFormat.Mode.QUADS, this.vboRange);
        } else if (this.multiTextureData != null) {
            MultiTextureRenderer.draw((VertexFormat.Mode)this.f_190621_, (int)this.f_190619_.f_190712_, (MultiTextureData)this.multiTextureData);
        } else if (this.f_190620_ != 0) {
            RenderSystem.m_177412_((int)this.f_190621_.f_190732_, (int)this.f_190620_, (int)this.f_190619_.f_190712_);
        }
    }

    public void m_268555_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_(() -> this.m_268565_(matrixIn.m_27658_(), projectionIn.m_27658_(), shaderIn));
        } else {
            this.m_268565_(matrixIn, projectionIn, shaderIn);
        }
    }

    public void m_268565_(Matrix4f matrixIn, Matrix4f projectionIn, ShaderInstance shaderIn) {
        if (this.f_190620_ != 0) {
            RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
            BufferUploader.m_268466_();
            for (int i = 0; i < 12; ++i) {
                int j = RenderSystem.m_255956_((int)i);
                shaderIn.setSampler(i, j);
            }
            if (shaderIn.f_283095_ != null) {
                shaderIn.f_283095_.m_5679_(matrixIn);
            }
            if (shaderIn.f_283096_ != null) {
                shaderIn.f_283096_.m_5679_(projectionIn);
            }
            if (shaderIn.f_283099_ != null) {
                shaderIn.f_283099_.m_5941_(RenderSystem.m_255950_());
            }
            if (shaderIn.f_283102_ != null) {
                shaderIn.f_283102_.m_5985_(RenderSystem.m_255953_());
            }
            if (shaderIn.f_283103_ != null) {
                shaderIn.f_283103_.m_5985_(RenderSystem.m_255952_());
            }
            if (shaderIn.f_283104_ != null) {
                shaderIn.f_283104_.m_5941_(RenderSystem.m_255951_());
            }
            if (shaderIn.f_283097_ != null) {
                shaderIn.f_283097_.m_5679_(RenderSystem.m_255962_());
            }
            if (shaderIn.f_283106_ != null) {
                shaderIn.f_283106_.m_5985_(RenderSystem.m_255954_());
            }
            if (shaderIn.f_283098_ != null) {
                Window window = Minecraft.m_91087_().m_91268_();
                shaderIn.f_283098_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
            }
            if (shaderIn.f_283105_ != null && (this.f_190621_ == VertexFormat.Mode.LINES || this.f_190621_ == VertexFormat.Mode.LINE_STRIP)) {
                shaderIn.f_283105_.m_5985_(RenderSystem.m_255955_());
            }
            if (Config.isShaders()) {
                Shaders.setModelViewMatrix((Matrix4f)matrixIn);
                Shaders.setProjectionMatrix((Matrix4f)projectionIn);
                Shaders.setTextureMatrix((Matrix4f)RenderSystem.m_255962_());
                Shaders.setColorModulator(RenderSystem.m_255950_());
            }
            RenderSystem.m_256287_((ShaderInstance)shaderIn);
            this.m_268583_();
            this.m_85921_();
            this.m_268580_().m_268658_();
            shaderIn.m_283148_();
            if (Config.isShaders()) {
                ShadersRender.setupArrayPointersVbo();
            }
            this.m_313172_();
            shaderIn.m_283147_();
            this.m_268580_().m_86024_();
            VertexBuffer.m_85931_();
            VertexBuffer.m_268564_();
        }
    }

    public void m_268571_() {
        if (this.f_190620_ != 0) {
            RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
            this.m_268583_();
            this.m_85921_();
            this.f_268554_.m_268658_();
            if (Config.isShaders()) {
                ShadersRender.setupArrayPointersVbo();
            }
            this.m_313172_();
        }
    }

    public static void m_85931_() {
        GlStateManager.m_84480_((int)34962, (int)0);
        GlStateManager.m_84480_((int)34963, (int)0);
    }

    @Override
    public void close() {
        if (this.f_190618_ >= 0) {
            RenderSystem.m_69529_((int)this.f_190618_);
            this.f_190618_ = -1;
        }
        if (this.f_268552_ > 0) {
            RenderSystem.m_69529_((int)this.f_268552_);
            this.f_268552_ = 0;
        }
        if (this.f_268553_ > 0) {
            RenderSystem.m_255972_((int)this.f_268553_);
            this.f_268553_ = 0;
        }
    }

    public VertexFormat m_268580_() {
        return this.f_268554_;
    }

    public void setVboRegion(VboRegion vboRegion) {
        if (vboRegion == null) {
            return;
        }
        this.close();
        this.vboRegion = vboRegion;
        this.vboRange = new VboRange();
    }

    public VboRegion getVboRegion() {
        return this.vboRegion;
    }
}

