/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.systems;

import com.google.common.collect.Queues;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_286;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_4573;
import net.minecraft.class_4587;
import net.minecraft.class_5365;
import net.minecraft.class_5944;
import net.minecraft.class_6177;
import net.optifine.Config;
import net.optifine.shaders.Shaders;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;

@class_6177
public class RenderSystem {
    static final Logger LOGGER = LogManager.getLogger();
    private static final ConcurrentLinkedQueue<class_4573> recordingQueue = Queues.newConcurrentLinkedQueue();
    private static final class_289 RENDER_THREAD_TESSELATOR = new class_289();
    private static final int MINIMUM_ATLAS_TEXTURE_SIZE = 1024;
    private static boolean isReplayingQueue;
    @Nullable
    private static Thread gameThread;
    @Nullable
    private static Thread renderThread;
    private static int MAX_SUPPORTED_TEXTURE_SIZE;
    private static boolean isInInit;
    private static double lastDrawTime;
    private static final class_5590 sharedSequential;
    private static final class_5590 sharedSequentialQuad;
    private static final class_5590 sharedSequentialLines;
    private static class_1159 projectionMatrix;
    private static class_1159 savedProjectionMatrix;
    private static class_4587 modelViewStack;
    private static class_1159 modelViewMatrix;
    private static class_1159 textureMatrix;
    private static final int[] shaderTextures;
    private static final float[] shaderColor;
    private static float shaderFogStart;
    private static float shaderFogEnd;
    private static final float[] shaderFogColor;
    private static final class_1160[] shaderLightDirections;
    private static float shaderGameTime;
    private static float shaderLineWidth;
    @Nullable
    private static class_5944 shader;
    private static boolean fogAllowed;
    private static boolean colorToAttribute;

    public static void initRenderThread() {
        if (renderThread != null || gameThread == Thread.currentThread()) {
            throw new IllegalStateException("Could not initialize render thread");
        }
        renderThread = Thread.currentThread();
    }

    public static boolean isOnRenderThread() {
        return Thread.currentThread() == renderThread;
    }

    public static boolean isOnRenderThreadOrInit() {
        return isInInit || RenderSystem.isOnRenderThread();
    }

    public static void initGameThread(boolean onRenderThreadIn) {
        boolean flag;
        boolean bl = flag = renderThread == Thread.currentThread();
        if (gameThread != null || renderThread == null || flag == onRenderThreadIn) {
            throw new IllegalStateException("Could not initialize tick thread");
        }
        gameThread = Thread.currentThread();
    }

    public static boolean isOnGameThread() {
        return true;
    }

    public static boolean isOnGameThreadOrInit() {
        return isInInit || RenderSystem.isOnGameThread();
    }

    public static void assertThread(Supplier<Boolean> threadIn) {
        if (!threadIn.get().booleanValue()) {
            throw new IllegalStateException("Rendersystem called from wrong thread");
        }
    }

    public static boolean isInInitPhase() {
        return true;
    }

    public static void recordRenderCall(class_4573 renderCallIn) {
        recordingQueue.add(renderCallIn);
    }

    public static void flipFrame(long handleIn) {
        GLFW.glfwPollEvents();
        RenderSystem.replayQueue();
        class_289.method_1348().method_1349().method_1343();
        GLFW.glfwSwapBuffers((long)handleIn);
        GLFW.glfwPollEvents();
    }

    public static void replayQueue() {
        isReplayingQueue = true;
        while (!recordingQueue.isEmpty()) {
            class_4573 rendercall = recordingQueue.poll();
            rendercall.execute();
        }
        isReplayingQueue = false;
    }

    public static void limitDisplayFPS(int fpsLimitIn) {
        double d0 = lastDrawTime + 1.0 / (double)fpsLimitIn;
        double d1 = GLFW.glfwGetTime();
        while (d1 < d0) {
            GLFW.glfwWaitEventsTimeout((double)(d0 - d1));
            d1 = GLFW.glfwGetTime();
        }
        lastDrawTime = d1;
    }

    public static void disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableDepthTest();
    }

    public static void enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableDepthTest();
    }

    public static void enableScissor(int x, int y, int width, int height) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._enableScissorTest();
        GlStateManager._scissorBox(x, y, width, height);
    }

    public static void disableScissor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._disableScissorTest();
    }

    public static void depthFunc(int depthFunc) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthFunc(depthFunc);
    }

    public static void depthMask(boolean depthMask) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._depthMask(depthMask);
    }

    public static void enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableBlend();
    }

    public static void disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableBlend();
    }

    public static void blendFunc(GlStateManager.class_4535 srcFactor, GlStateManager.class_4534 dstFactor) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(srcFactor.value, dstFactor.value);
    }

    public static void blendFunc(int srcFactor, int dstFactor) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFunc(srcFactor, dstFactor);
    }

    public static void blendFuncSeparate(GlStateManager.class_4535 srcFactor, GlStateManager.class_4534 dstFactor, GlStateManager.class_4535 srcFactorAlpha, GlStateManager.class_4534 dstFactorAlpha) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(srcFactor.value, dstFactor.value, srcFactorAlpha.value, dstFactorAlpha.value);
    }

    public static void blendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendFuncSeparate(srcFactor, dstFactor, srcFactorAlpha, dstFactorAlpha);
    }

    public static void blendEquation(int blendEquation) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._blendEquation(blendEquation);
    }

    public static void enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableCull();
    }

    public static void disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableCull();
    }

    public static void polygonMode(int face, int mode) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonMode(face, mode);
    }

    public static void enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enablePolygonOffset();
    }

    public static void disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disablePolygonOffset();
    }

    public static void polygonOffset(float factor, float units) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._polygonOffset(factor, units);
    }

    public static void enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableColorLogicOp();
    }

    public static void disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableColorLogicOp();
    }

    public static void logicOp(GlStateManager.class_1030 logicOp) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._logicOp(logicOp.field_5108);
    }

    public static void activeTexture(int textureIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._activeTexture(textureIn);
    }

    public static void enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._enableTexture();
    }

    public static void disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._disableTexture();
    }

    public static void texParameter(int target, int parameterName, int parameter) {
        GlStateManager._texParameter(target, parameterName, parameter);
    }

    public static void deleteTexture(int textureIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._deleteTexture(textureIn);
    }

    public static void bindTextureForSetup(int textureIn) {
        RenderSystem.bindTexture(textureIn);
    }

    public static void bindTexture(int textureIn) {
        GlStateManager._bindTexture(textureIn);
    }

    public static void viewport(int x, int y, int width, int height) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._viewport(x, y, width, height);
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._colorMask(red, green, blue, alpha);
    }

    public static void stencilFunc(int func, int ref, int mask) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilFunc(func, ref, mask);
    }

    public static void stencilMask(int mask) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilMask(mask);
    }

    public static void stencilOp(int sfail, int dpfail, int dppass) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._stencilOp(sfail, dpfail, dppass);
    }

    public static void clearDepth(double depth) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearDepth(depth);
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clearColor(red, green, blue, alpha);
    }

    public static void clearStencil(int index) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._clearStencil(index);
    }

    public static void clear(int mask, boolean checkError) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._clear(mask, checkError);
    }

    public static void setShaderFogStart(float fogStartIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogStart(fogStartIn);
    }

    private static void _setShaderFogStart(float fogStartIn) {
        shaderFogStart = fogStartIn;
    }

    public static float getShaderFogStart() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogStart;
    }

    public static void setShaderFogEnd(float fogEndIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogEnd(fogEndIn);
    }

    private static void _setShaderFogEnd(float fogEndIn) {
        shaderFogEnd = fogEndIn;
    }

    public static float getShaderFogEnd() {
        if (!fogAllowed) {
            return Float.MAX_VALUE;
        }
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogEnd;
    }

    public static void setShaderFogColor(float red, float green, float blue, float alpha) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderFogColor(red, green, blue, alpha);
    }

    public static void setShaderFogColor(float red, float green, float blue) {
        RenderSystem.setShaderFogColor(red, green, blue, 1.0f);
    }

    private static void _setShaderFogColor(float red, float green, float blue, float alpha) {
        RenderSystem.shaderFogColor[0] = red;
        RenderSystem.shaderFogColor[1] = green;
        RenderSystem.shaderFogColor[2] = blue;
        RenderSystem.shaderFogColor[3] = alpha;
    }

    public static float[] getShaderFogColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderFogColor;
    }

    public static void setShaderLights(class_1160 dir1, class_1160 dir2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem._setShaderLights(dir1, dir2);
    }

    public static void _setShaderLights(class_1160 dir1, class_1160 dir2) {
        RenderSystem.shaderLightDirections[0] = dir1;
        RenderSystem.shaderLightDirections[1] = dir2;
    }

    public static void setupShaderLights(class_5944 shaderInstanceIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (shaderInstanceIn.field_29475 != null) {
            shaderInstanceIn.field_29475.method_34413(shaderLightDirections[0]);
        }
        if (shaderInstanceIn.field_29476 != null) {
            shaderInstanceIn.field_29476.method_34413(shaderLightDirections[1]);
        }
    }

    public static void setShaderColor(float red, float green, float blue, float alpha) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderColor(red, green, blue, alpha));
        } else {
            RenderSystem._setShaderColor(red, green, blue, alpha);
        }
    }

    private static void _setShaderColor(float red, float green, float blue, float alpha) {
        RenderSystem.shaderColor[0] = red;
        RenderSystem.shaderColor[1] = green;
        RenderSystem.shaderColor[2] = blue;
        RenderSystem.shaderColor[3] = alpha;
        if (colorToAttribute) {
            Shaders.setDefaultAttribColor(red, green, blue, alpha);
        }
    }

    public static float[] getShaderColor() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderColor;
    }

    public static void drawElements(int mode, int count, int type) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._drawElements(mode, count, type, 0L);
    }

    public static void lineWidth(float widthIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderLineWidth = widthIn;
            });
        } else {
            shaderLineWidth = widthIn;
        }
    }

    public static float getShaderLineWidth() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderLineWidth;
    }

    public static void pixelStore(int pname, int param) {
        RenderSystem.assertThread(RenderSystem::isOnGameThreadOrInit);
        GlStateManager._pixelStore(pname, param);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._readPixels(x, y, width, height, format, type, pixels);
    }

    public static void getString(int nameIn, Consumer<String> consumerIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        consumerIn.accept(GlStateManager._getString(nameIn));
    }

    public static String getBackendDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return String.format("LWJGL version %s", GLX._getLWJGLVersion());
    }

    public static String getApiDescription() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX.getOpenGLVersionString();
    }

    public static LongSupplier initBackendSystem() {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GLX._initGlfw();
    }

    public static void initRenderer(int debugVerbosityIn, boolean debugSyncIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._init(debugVerbosityIn, debugSyncIn);
    }

    public static void setErrorCallback(GLFWErrorCallbackI errorCallbackIn) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GLX._setGlfwErrorCallback(errorCallbackIn);
    }

    public static void renderCrosshair(int heightIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GLX._renderCrosshair(heightIn, true, true, true);
    }

    public static String getCapsString() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        return "Using framebuffer using OpenGL 3.2";
    }

    public static void setupDefaultState(int x, int y, int width, int height) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        GlStateManager._enableTexture();
        GlStateManager._clearDepth(1.0);
        GlStateManager._enableDepthTest();
        GlStateManager._depthFunc(515);
        projectionMatrix.method_22668();
        savedProjectionMatrix.method_22668();
        modelViewMatrix.method_22668();
        textureMatrix.method_22668();
        GlStateManager._viewport(x, y, width, height);
    }

    public static int maxSupportedTextureSize() {
        if (MAX_SUPPORTED_TEXTURE_SIZE == -1) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            int i = GlStateManager._getInteger(3379);
            for (int j = Math.max(32768, i); j >= 1024; j >>= 1) {
                GlStateManager._texImage2D(32868, 0, 6408, j, j, 0, 6408, 5121, null);
                int k = GlStateManager._getTexLevelParameter(32868, 0, 4096);
                if (k == 0) continue;
                MAX_SUPPORTED_TEXTURE_SIZE = j;
                return j;
            }
            MAX_SUPPORTED_TEXTURE_SIZE = Math.max(i, 1024);
            LOGGER.info("Failed to determine maximum texture size by probing, trying GL_MAX_TEXTURE_SIZE = {}", (Object)MAX_SUPPORTED_TEXTURE_SIZE);
        }
        return MAX_SUPPORTED_TEXTURE_SIZE;
    }

    public static void glBindBuffer(int target, IntSupplier buffer) {
        GlStateManager._glBindBuffer(target, buffer.getAsInt());
    }

    public static void glBindVertexArray(Supplier<Integer> arrayIn) {
        GlStateManager._glBindVertexArray(arrayIn.get());
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager._glBufferData(target, data, usage);
    }

    public static void glDeleteBuffers(int buffer) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteBuffers(buffer);
    }

    public static void glDeleteVertexArrays(int array) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glDeleteVertexArrays(array);
    }

    public static void glUniform1i(int location, int value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1i(location, value);
    }

    public static void glUniform1(int location, IntBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(location, value);
    }

    public static void glUniform2(int location, IntBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(location, value);
    }

    public static void glUniform3(int location, IntBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(location, value);
    }

    public static void glUniform4(int location, IntBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(location, value);
    }

    public static void glUniform1(int location, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform1(location, value);
    }

    public static void glUniform2(int location, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform2(location, value);
    }

    public static void glUniform3(int location, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform3(location, value);
    }

    public static void glUniform4(int location, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniform4(location, value);
    }

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix2(location, transpose, value);
    }

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix3(location, transpose, value);
    }

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager._glUniformMatrix4(location, transpose, value);
    }

    public static void setupOverlayColor(IntSupplier textureIn, int colorIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        int i = textureIn.getAsInt();
        RenderSystem.setShaderTexture(1, i);
    }

    public static void teardownOverlayColor() {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        RenderSystem.setShaderTexture(1, 0);
    }

    public static void setupLevelDiffuseLighting(class_1160 vec1, class_1160 vec2, class_1159 matrixIn) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupLevelDiffuseLighting(vec1, vec2, matrixIn);
    }

    public static void setupGuiFlatDiffuseLighting(class_1160 vec1, class_1160 vec2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGuiFlatDiffuseLighting(vec1, vec2);
    }

    public static void setupGui3DDiffuseLighting(class_1160 vec1, class_1160 vec2) {
        RenderSystem.assertThread(RenderSystem::isOnGameThread);
        GlStateManager.setupGui3DDiffuseLighting(vec1, vec2);
    }

    public static void beginInitialization() {
        isInInit = true;
    }

    public static void finishInitialization() {
        isInInit = false;
        if (!recordingQueue.isEmpty()) {
            RenderSystem.replayQueue();
        }
        if (!recordingQueue.isEmpty()) {
            throw new IllegalStateException("Recorded to render queue during initialization");
        }
    }

    public static void glGenBuffers(Consumer<Integer> consumerIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumerIn.accept(GlStateManager._glGenBuffers()));
        } else {
            consumerIn.accept(GlStateManager._glGenBuffers());
        }
    }

    public static void glGenVertexArrays(Consumer<Integer> consumerIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> consumerIn.accept(GlStateManager._glGenVertexArrays()));
        } else {
            consumerIn.accept(GlStateManager._glGenVertexArrays());
        }
    }

    public static class_289 renderThreadTesselator() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return RENDER_THREAD_TESSELATOR;
    }

    public static void defaultBlendFunc() {
        RenderSystem.blendFuncSeparate(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, GlStateManager.class_4535.ONE, GlStateManager.class_4534.ZERO);
    }

    @Deprecated
    public static void runAsFancy(Runnable runnableIn) {
        boolean flag = class_310.method_29611();
        if (!flag) {
            runnableIn.run();
        } else {
            class_315 options = class_310.method_1551().field_1690;
            class_5365 graphicsstatus = options.field_25444;
            options.field_25444 = class_5365.field_25428;
            runnableIn.run();
            options.field_25444 = graphicsstatus;
        }
    }

    public static void setShader(Supplier<class_5944> shaderIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shader = (class_5944)shaderIn.get();
            });
        } else {
            shader = shaderIn.get();
        }
    }

    @Nullable
    public static class_5944 getShader() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shader;
    }

    public static int getTextureId(int textureUnitIn) {
        return GlStateManager._getTextureId(textureUnitIn);
    }

    public static void setShaderTexture(int textureUnitIn, class_2960 locIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(textureUnitIn, locIn));
        } else {
            RenderSystem._setShaderTexture(textureUnitIn, locIn);
        }
    }

    public static void _setShaderTexture(int textureUnitIn, class_2960 locIn) {
        if (textureUnitIn >= 0 && textureUnitIn < shaderTextures.length) {
            class_1060 texturemanager = class_310.method_1551().method_1531();
            class_1044 abstracttexture = texturemanager.method_4619(locIn);
            RenderSystem.shaderTextures[textureUnitIn] = abstracttexture.method_4624();
        }
    }

    public static void setShaderTexture(int textureUnitIn, int textureIn) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._setShaderTexture(textureUnitIn, textureIn));
        } else {
            RenderSystem._setShaderTexture(textureUnitIn, textureIn);
        }
    }

    public static void _setShaderTexture(int textureUnitIn, int textureIn) {
        if (textureUnitIn >= 0 && textureUnitIn < shaderTextures.length) {
            RenderSystem.shaderTextures[textureUnitIn] = textureIn;
        }
    }

    public static int getShaderTexture(int textureUnitIn) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return textureUnitIn >= 0 && textureUnitIn < shaderTextures.length ? shaderTextures[textureUnitIn] : 0;
    }

    public static void setProjectionMatrix(class_1159 matrixIn) {
        class_1159 matrix4f = matrixIn.method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                projectionMatrix = matrix4f;
            });
        } else {
            projectionMatrix = matrix4f;
        }
    }

    public static void setTextureMatrix(class_1159 matrixIn) {
        class_1159 matrix4f = matrixIn.method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                textureMatrix = matrix4f;
            });
        } else {
            textureMatrix = matrix4f;
        }
    }

    public static void resetTextureMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> textureMatrix.method_22668());
        } else {
            textureMatrix.method_22668();
        }
    }

    public static void applyModelViewMatrix() {
        class_1159 matrix4f = modelViewStack.method_23760().method_23761().method_22673();
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                modelViewMatrix = matrix4f;
            });
        } else {
            modelViewMatrix = matrix4f;
        }
    }

    public static void backupProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._backupProjectionMatrix());
        } else {
            RenderSystem._backupProjectionMatrix();
        }
    }

    private static void _backupProjectionMatrix() {
        savedProjectionMatrix = projectionMatrix;
    }

    public static void restoreProjectionMatrix() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> RenderSystem._restoreProjectionMatrix());
        } else {
            RenderSystem._restoreProjectionMatrix();
        }
    }

    private static void _restoreProjectionMatrix() {
        projectionMatrix = savedProjectionMatrix;
    }

    public static class_1159 getProjectionMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return projectionMatrix;
    }

    public static class_1159 getModelViewMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return modelViewMatrix;
    }

    public static class_4587 getModelViewStack() {
        return modelViewStack;
    }

    public static class_1159 getTextureMatrix() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return textureMatrix;
    }

    public static class_5590 getSequentialBuffer(class_293.class_5596 modeIn, int indexCountIn) {
        class_5590 rendersystem$autostorageindexbuffer;
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (modeIn == class_293.class_5596.field_27382) {
            rendersystem$autostorageindexbuffer = sharedSequentialQuad;
            if (Config.isRenderRegions()) {
                rendersystem$autostorageindexbuffer.method_31920(65536);
            }
        } else {
            rendersystem$autostorageindexbuffer = modeIn == class_293.class_5596.field_27377 ? sharedSequentialLines : sharedSequential;
        }
        rendersystem$autostorageindexbuffer.method_31920(indexCountIn);
        return rendersystem$autostorageindexbuffer;
    }

    public static void setShaderGameTime(long gameTimeIn, float partialTicks) {
        float f = ((float)(gameTimeIn % 24000L) + partialTicks) / 24000.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                shaderGameTime = f;
            });
        } else {
            shaderGameTime = f;
        }
    }

    public static float getShaderGameTime() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return shaderGameTime;
    }

    public static void setFogAllowed(boolean fogAllowed) {
        RenderSystem.fogAllowed = fogAllowed;
        if (Config.isShaders()) {
            Shaders.setFogAllowed(fogAllowed);
        }
    }

    public static boolean isFogAllowed() {
        return fogAllowed;
    }

    public static void setColorToAttribute(boolean colorToAttribute) {
        if (!Config.isShaders()) {
            return;
        }
        if (RenderSystem.colorToAttribute == colorToAttribute) {
            return;
        }
        RenderSystem.colorToAttribute = colorToAttribute;
        if (colorToAttribute) {
            Shaders.setDefaultAttribColor(shaderColor[0], shaderColor[1], shaderColor[2], shaderColor[3]);
        } else {
            Shaders.setDefaultAttribColor();
        }
    }

    static {
        MAX_SUPPORTED_TEXTURE_SIZE = -1;
        lastDrawTime = Double.MIN_VALUE;
        sharedSequential = new class_5590(1, 1, java.util.function.IntConsumer::accept);
        sharedSequentialQuad = new class_5590(4, 6, (consumerIn, positionIn) -> {
            consumerIn.accept(positionIn + 0);
            consumerIn.accept(positionIn + 1);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 3);
            consumerIn.accept(positionIn + 0);
        });
        sharedSequentialLines = new class_5590(4, 6, (consumerIn, positionIn) -> {
            consumerIn.accept(positionIn + 0);
            consumerIn.accept(positionIn + 1);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 3);
            consumerIn.accept(positionIn + 2);
            consumerIn.accept(positionIn + 1);
        });
        projectionMatrix = new class_1159();
        savedProjectionMatrix = new class_1159();
        modelViewStack = new class_4587();
        modelViewMatrix = new class_1159();
        textureMatrix = new class_1159();
        shaderTextures = new int[12];
        shaderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        shaderFogEnd = 1.0f;
        shaderFogColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        shaderLightDirections = new class_1160[2];
        shaderLineWidth = 1.0f;
        fogAllowed = true;
        colorToAttribute = false;
        projectionMatrix.method_22668();
        savedProjectionMatrix.method_22668();
        modelViewMatrix.method_22668();
        textureMatrix.method_22668();
    }

    public static final class class_5590 {
        private final int field_27332;
        private final int field_27333;
        private final class_5591 field_27334;
        private int field_27335;
        private class_293.class_5595 field_27336 = class_293.class_5595.field_27371;
        private int field_27337;

        class_5590(int vertexStrideIn, int indexStrideIn, class_5591 generatorIn) {
            this.field_27332 = vertexStrideIn;
            this.field_27333 = indexStrideIn;
            this.field_27334 = generatorIn;
        }

        void method_31920(int indexCountIn) {
            if (indexCountIn > this.field_27337) {
                indexCountIn = class_3532.method_28139(indexCountIn * 2, this.field_27333);
                LOGGER.debug("Growing IndexBuffer: Old limit {}, new limit {}.", (Object)this.field_27337, (Object)indexCountIn);
                if (this.field_27335 == 0) {
                    this.field_27335 = GlStateManager._glGenBuffers();
                }
                class_293.class_5595 vertexformat$indextype = class_293.class_5595.method_31972(indexCountIn);
                int i = class_3532.method_28139(indexCountIn * vertexformat$indextype.field_27375, 4);
                GlStateManager._glBindBuffer(34963, this.field_27335);
                GlStateManager._glBufferData(34963, i, 35048);
                ByteBuffer bytebuffer = GlStateManager._glMapBuffer(34963, 35001);
                if (bytebuffer == null) {
                    throw new RuntimeException("Failed to map GL buffer");
                }
                this.field_27336 = vertexformat$indextype;
                IntConsumer intconsumer = this.method_31922(bytebuffer);
                for (int j = 0; j < indexCountIn; j += this.field_27333) {
                    this.field_27334.accept(intconsumer, j * this.field_27332 / this.field_27333);
                }
                GlStateManager._glUnmapBuffer(34963);
                GlStateManager._glBindBuffer(34963, 0);
                this.field_27337 = indexCountIn;
                class_286.method_34423();
            }
        }

        private IntConsumer method_31922(ByteBuffer byteBufferIn) {
            switch (this.field_27336) {
                case field_27371: {
                    return valueIn -> byteBufferIn.put((byte)valueIn);
                }
                case field_27372: {
                    return valueIn -> byteBufferIn.putShort((short)valueIn);
                }
            }
            return byteBufferIn::putInt;
        }

        public int method_31919() {
            return this.field_27335;
        }

        public class_293.class_5595 method_31924() {
            return this.field_27336;
        }

        static interface class_5591 {
            public void accept(IntConsumer var1, int var2);
        }
    }
}

