/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.shaders;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Program {
    private static final Logger f_313019_ = LogManager.getLogger();
    private static final int f_313020_ = 32768;
    private final Type f_85535_;
    private final String f_85536_;
    private int f_85537_;

    protected Program(Type type, int shaderId, String filename) {
        this.f_85535_ = type;
        this.f_85537_ = shaderId;
        this.f_85536_ = filename;
    }

    public void m_268326_(Shader shaderIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        GlStateManager.m_84423_((int)shaderIn.m_224063_(), (int)this.m_268334_());
    }

    public void m_85543_() {
        if (this.f_85537_ != -1) {
            RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
            GlStateManager.m_84421_((int)this.f_85537_);
            this.f_85537_ = -1;
            this.f_85535_.m_85570_().remove(this.f_85536_);
        }
    }

    public String m_85551_() {
        return this.f_85536_;
    }

    public static Program m_313026_(Type typeIn, String nameIn, InputStream inputStreamIn, String packNameIn, GlslPreprocessor preprocessorIn) throws IOException {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        int i = Program.m_313032_(typeIn, nameIn, inputStreamIn, packNameIn, preprocessorIn);
        Program program = new Program(typeIn, i, nameIn);
        typeIn.m_85570_().put(nameIn, program);
        return program;
    }

    protected static int m_313032_(Type typeIn, String nameIn, InputStream inputStreamIn, String packNameIn, GlslPreprocessor preprocessorIn) throws IOException {
        String s = TextureUtil.m_85311_((InputStream)inputStreamIn);
        if (typeIn == Type.VERTEX) {
            s = s.replace("texelFetch(Sampler2, UV2 / 16, 0)", "texture(Sampler2, (UV2 / 256.0) + (0.5 / 16.0))");
            s = s.replace("minecraft_sample_lightmap(Sampler2, UV2)", "texture(Sampler2, (UV2 / 256.0) + (0.5 / 16.0))");
        }
        if (typeIn == Type.FRAGMENT) {
            s = s.replace("(color.a < 0.5)", "(color.a < 0.1)");
        }
        if (s == null) {
            throw new IOException("Could not load program " + typeIn.m_85566_());
        }
        int i = GlStateManager.m_84447_((int)typeIn.m_85571_());
        GlStateManager.m_267791_((int)i, (List)preprocessorIn.m_312903_(s));
        GlStateManager.m_84465_((int)i);
        if (GlStateManager.m_84449_((int)i, (int)35713) == 0) {
            String s1 = StringUtils.trim((String)GlStateManager.m_84492_((int)i, (int)32768));
            throw new IOException("Couldn't compile " + typeIn.m_85566_() + " program (" + packNameIn + ", " + nameIn + ") : " + s1);
        }
        return i;
    }

    private static Program m_313022_(Type typeIn, String filename, int shaderId) {
        return new Program(typeIn, shaderId, filename);
    }

    protected int m_268334_() {
        return this.f_85537_;
    }

    public static enum Type {
        VERTEX("vertex", ".vsh", 35633),
        FRAGMENT("fragment", ".fsh", 35632);

        private final String f_85554_;
        private final String f_85555_;
        private final int f_85556_;
        private final Map<String, Program> f_85557_ = Maps.newHashMap();

        private Type(String shaderNameIn, String shaderExtensionIn, int shaderModeIn) {
            this.f_85554_ = shaderNameIn;
            this.f_85555_ = shaderExtensionIn;
            this.f_85556_ = shaderModeIn;
        }

        public String m_85566_() {
            return this.f_85554_;
        }

        public String m_85569_() {
            return this.f_85555_;
        }

        int m_85571_() {
            return this.f_85556_;
        }

        public Map<String, Program> m_85570_() {
            return this.f_85557_;
        }
    }
}

