/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class PngInfo {
    public final int f_85207_;
    public final int f_85208_;
    private static final Object STATIC_MONITOR = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PngInfo(String nameIn, InputStream inputStreamIn) throws IOException {
        Object object = STATIC_MONITOR;
        synchronized (object) {
            try (MemoryStack memorystack = MemoryStack.stackPush();
                 StbReader pnginfo$stbreader = PngInfo.m_85212_(inputStreamIn);
                 STBIReadCallback stbireadcallback = STBIReadCallback.create(pnginfo$stbreader::m_85223_);
                 STBISkipCallback stbiskipcallback = STBISkipCallback.create(pnginfo$stbreader::m_85220_);
                 STBIEOFCallback stbieofcallback = STBIEOFCallback.create(pnginfo$stbreader::m_6816_);){
                STBIIOCallbacks stbiiocallbacks = STBIIOCallbacks.mallocStack((MemoryStack)memorystack);
                stbiiocallbacks.read((STBIReadCallbackI)stbireadcallback);
                stbiiocallbacks.skip((STBISkipCallbackI)stbiskipcallback);
                stbiiocallbacks.eof((STBIEOFCallbackI)stbieofcallback);
                IntBuffer intbuffer = memorystack.mallocInt(1);
                IntBuffer intbuffer1 = memorystack.mallocInt(1);
                IntBuffer intbuffer2 = memorystack.mallocInt(1);
                if (!STBImage.stbi_info_from_callbacks((STBIIOCallbacks)stbiiocallbacks, (long)0L, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2)) {
                    throw new IOException("Could not read info from the PNG file " + nameIn + " " + STBImage.stbi_failure_reason());
                }
                this.f_85207_ = intbuffer.get(0);
                this.f_85208_ = intbuffer1.get(0);
            }
        }
    }

    public String toString() {
        return "" + this.f_85207_ + " x " + this.f_85208_;
    }

    private static StbReader m_85212_(InputStream inputStreamIn) {
        return inputStreamIn instanceof FileInputStream ? new StbReaderSeekableByteChannel(((FileInputStream)inputStreamIn).getChannel()) : new StbReaderBufferedChannel(Channels.newChannel(inputStreamIn));
    }

    static class StbReaderSeekableByteChannel
    extends StbReader {
        private final SeekableByteChannel f_85248_;

        StbReaderSeekableByteChannel(SeekableByteChannel channelIn) {
            this.f_85248_ = channelIn;
        }

        @Override
        public int m_5835_(long pointerIn, int lenIn) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)pointerIn, (int)lenIn);
            return this.f_85248_.read(bytebuffer);
        }

        @Override
        public void m_5666_(int lenIn) throws IOException {
            this.f_85248_.position(this.f_85248_.position() + (long)lenIn);
        }

        @Override
        public int m_6816_(long pointerIn) {
            return super.m_6816_(pointerIn) != 0 && this.f_85248_.isOpen() ? 1 : 0;
        }

        @Override
        public void close() throws IOException {
            this.f_85248_.close();
        }
    }

    static class StbReaderBufferedChannel
    extends StbReader {
        private static final int f_312885_ = 128;
        private final ReadableByteChannel f_85230_;
        private long f_85231_ = MemoryUtil.nmemAlloc((long)128L);
        private int f_85232_ = 128;
        private int f_85233_;
        private int f_85234_;

        StbReaderBufferedChannel(ReadableByteChannel channelIn) {
            this.f_85230_ = channelIn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void m_85242_(int lenIn) throws IOException {
            ByteBuffer bytebuffer = MemoryUtil.memByteBuffer((long)this.f_85231_, (int)this.f_85232_);
            if (lenIn + this.f_85234_ > this.f_85232_) {
                this.f_85232_ = lenIn + this.f_85234_;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)this.f_85232_);
                this.f_85231_ = MemoryUtil.memAddress((ByteBuffer)bytebuffer);
            }
            bytebuffer.position(this.f_85233_);
            while (lenIn + this.f_85234_ > this.f_85233_) {
                try {
                    int i = this.f_85230_.read(bytebuffer);
                    if (i != -1) continue;
                    break;
                }
                finally {
                    this.f_85233_ = bytebuffer.position();
                }
            }
        }

        @Override
        public int m_5835_(long pointerIn, int lenIn) throws IOException {
            this.m_85242_(lenIn);
            if (lenIn + this.f_85234_ > this.f_85233_) {
                lenIn = this.f_85233_ - this.f_85234_;
            }
            MemoryUtil.memCopy((long)(this.f_85231_ + (long)this.f_85234_), (long)pointerIn, (long)lenIn);
            this.f_85234_ += lenIn;
            return lenIn;
        }

        @Override
        public void m_5666_(int lenIn) throws IOException {
            if (lenIn > 0) {
                this.m_85242_(lenIn);
                if (lenIn + this.f_85234_ > this.f_85233_) {
                    throw new EOFException("Can't skip past the EOF.");
                }
            }
            if (this.f_85234_ + lenIn < 0) {
                throw new IOException("Can't seek before the beginning: " + (this.f_85234_ + lenIn));
            }
            this.f_85234_ += lenIn;
        }

        @Override
        public void close() throws IOException {
            MemoryUtil.nmemFree((long)this.f_85231_);
            this.f_85230_.close();
        }
    }

    static abstract class StbReader
    implements AutoCloseable {
        protected boolean f_85214_;

        StbReader() {
        }

        int m_85223_(long userIn, long pointerIn, int lenIn) {
            try {
                return this.m_5835_(pointerIn, lenIn);
            }
            catch (IOException ioexception) {
                this.f_85214_ = true;
                return 0;
            }
        }

        void m_85220_(long pointerIn, int lenIn) {
            try {
                this.m_5666_(lenIn);
            }
            catch (IOException ioexception) {
                this.f_85214_ = true;
            }
        }

        int m_6816_(long pointerIn) {
            return this.f_85214_ ? 1 : 0;
        }

        protected abstract int m_5835_(long var1, int var3) throws IOException;

        protected abstract void m_5666_(int var1) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }
}

