/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.optifine.Config;
import net.optifine.util.NativeMemory;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class NativeImage
implements AutoCloseable {
    private static final Logger f_84958_ = LogManager.getLogger();
    private static final int f_312838_ = 24;
    private static final int f_312839_ = 16;
    private static final int f_312840_ = 8;
    private static final int f_312841_ = 0;
    private static final Set<StandardOpenOption> f_84959_ = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final Format f_84960_;
    private final int f_84961_;
    private final int f_84962_;
    private final boolean f_84963_;
    private long f_84964_;
    private final long f_84965_;

    public NativeImage(int widthIn, int heightIn, boolean clear) {
        this(Format.RGBA, widthIn, heightIn, clear);
    }

    public NativeImage(Format pixelFormatIn, int widthIn, int heightIn, boolean initialize) {
        if (widthIn > 0 && heightIn > 0) {
            this.f_84960_ = pixelFormatIn;
            this.f_84961_ = widthIn;
            this.f_84962_ = heightIn;
            this.f_84965_ = (long)widthIn * (long)heightIn * (long)pixelFormatIn.m_85161_();
            this.f_84963_ = false;
            this.f_84964_ = initialize ? MemoryUtil.nmemCalloc((long)1L, (long)this.f_84965_) : MemoryUtil.nmemAlloc((long)this.f_84965_);
        } else {
            throw new IllegalArgumentException("Invalid texture size: " + widthIn + "x" + heightIn);
        }
        this.m_85124_();
        NativeMemory.imageAllocated((NativeImage)this);
    }

    private NativeImage(Format pixelFormatIn, int widthIn, int heightIn, boolean stbiPointerIn, long pointer) {
        if (widthIn <= 0 || heightIn <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + widthIn + "x" + heightIn);
        }
        this.f_84960_ = pixelFormatIn;
        this.f_84961_ = widthIn;
        this.f_84962_ = heightIn;
        this.f_84963_ = stbiPointerIn;
        this.f_84964_ = pointer;
        this.f_84965_ = (long)widthIn * (long)heightIn * (long)pixelFormatIn.m_85161_();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.f_84960_) + " " + this.f_84961_ + "x" + this.f_84962_ + "@" + this.f_84964_ + (this.f_84963_ ? "S" : "N") + "]";
    }

    private boolean m_312864_(int xIn, int yIn) {
        return xIn < 0 || xIn >= this.f_84961_ || yIn < 0 || yIn >= this.f_84962_;
    }

    public static NativeImage m_85058_(InputStream inputStreamIn) throws IOException {
        return NativeImage.m_85048_(Format.RGBA, inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage m_85048_(@Nullable Format pixelFormatIn, InputStream inputStreamIn) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.m_85303_((InputStream)inputStreamIn);
            bytebuffer.rewind();
            nativeimage = NativeImage.m_85051_(pixelFormatIn, bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
            IOUtils.closeQuietly((InputStream)inputStreamIn);
        }
        return nativeimage;
    }

    public static NativeImage m_85062_(ByteBuffer byteBufferIn) throws IOException {
        return NativeImage.m_85051_(Format.RGBA, byteBufferIn);
    }

    public static NativeImage m_85051_(@Nullable Format pixelFormatIn, ByteBuffer byteBufferIn) throws IOException {
        NativeImage nativeimage;
        if (pixelFormatIn != null && !pixelFormatIn.m_85175_()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pixelFormatIn));
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBufferIn) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            ByteBuffer bytebuffer = STBImage.stbi_load_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2, (int)(pixelFormatIn == null ? 0 : pixelFormatIn.f_85130_));
            if (bytebuffer == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            nativeimage = new NativeImage(pixelFormatIn == null ? Format.m_85167_(intbuffer2.get(0)) : pixelFormatIn, intbuffer.get(0), intbuffer1.get(0), true, MemoryUtil.memAddress((ByteBuffer)bytebuffer));
            NativeMemory.imageAllocated((NativeImage)nativeimage);
        }
        return nativeimage;
    }

    public static void m_85081_(boolean linear, boolean mipmap) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69587_(), ()Ljava/lang/Boolean;)());
        if (linear) {
            GlStateManager.m_84331_((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GlStateManager.m_84331_((int)3553, (int)10240, (int)9729);
        } else {
            int mipmapType = Config.getMipmapType();
            GlStateManager.m_84331_((int)3553, (int)10241, (int)(mipmap ? mipmapType : 9728));
            GlStateManager.m_84331_((int)3553, (int)10240, (int)9728);
        }
    }

    private void m_85124_() {
        if (this.f_84964_ == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.f_84964_ != 0L) {
            if (this.f_84963_) {
                STBImage.nstbi_image_free((long)this.f_84964_);
            } else {
                MemoryUtil.nmemFree((long)this.f_84964_);
            }
            NativeMemory.imageFreed((NativeImage)this);
        }
        this.f_84964_ = 0L;
    }

    public int m_84982_() {
        return this.f_84961_;
    }

    public int m_85084_() {
        return this.f_84962_;
    }

    public Format m_85102_() {
        return this.f_84960_;
    }

    public int m_84985_(int x, int y) {
        if (this.f_84960_ != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        this.m_85124_();
        long i = ((long)x + (long)y * (long)this.f_84961_) * 4L;
        return MemoryUtil.memGetInt((long)(this.f_84964_ + i));
    }

    public void m_84988_(int x, int y, int value) {
        if (this.f_84960_ != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        this.m_85124_();
        long i = ((long)x + (long)y * (long)this.f_84961_) * 4L;
        MemoryUtil.memPutInt((long)(this.f_84964_ + i), (int)value);
    }

    public void m_312844_(int x, int y, byte lum) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        if (!this.f_84960_.m_312870_()) {
            throw new IllegalArgumentException(String.format("setPixelLuminance only works on image with luminance; have %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        this.m_85124_();
        long i = ((long)x + (long)y * (long)this.f_84961_) * (long)this.f_84960_.m_85161_() + (long)(this.f_84960_.m_312874_() / 8);
        MemoryUtil.memPutByte((long)(this.f_84964_ + i), (byte)lum);
    }

    public byte m_312850_(int x, int y) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        if (!this.f_84960_.m_312875_()) {
            throw new IllegalArgumentException(String.format("no red or luminance in %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        int i = (x + y * this.f_84961_) * this.f_84960_.m_85161_() + this.f_84960_.m_312878_() / 8;
        return MemoryUtil.memGetByte((long)(this.f_84964_ + (long)i));
    }

    public byte m_312857_(int x, int y) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        if (!this.f_84960_.m_312876_()) {
            throw new IllegalArgumentException(String.format("no green or luminance in %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        int i = (x + y * this.f_84961_) * this.f_84960_.m_85161_() + this.f_84960_.m_312879_() / 8;
        return MemoryUtil.memGetByte((long)(this.f_84964_ + (long)i));
    }

    public byte m_312860_(int x, int y) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        if (!this.f_84960_.m_312877_()) {
            throw new IllegalArgumentException(String.format("no blue or luminance in %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        int i = (x + y * this.f_84961_) * this.f_84960_.m_85161_() + this.f_84960_.m_312880_() / 8;
        return MemoryUtil.memGetByte((long)(this.f_84964_ + (long)i));
    }

    public byte m_85087_(int x, int y) {
        if (!this.f_84960_.m_85173_()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.f_84960_}));
        }
        if (this.m_312864_(x, y)) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", x, y, this.f_84961_, this.f_84962_));
        }
        int i = (x + y * this.f_84961_) * this.f_84960_.m_85161_() + this.f_84960_.m_85174_() / 8;
        return MemoryUtil.memGetByte((long)(this.f_84964_ + (long)i));
    }

    public void m_312853_(int x, int y, int col) {
        if (this.f_84960_ != Format.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = this.m_84985_(x, y);
        float f = (float)NativeImage.m_84983_(col) / 255.0f;
        float f1 = (float)NativeImage.m_85119_(col) / 255.0f;
        float f2 = (float)NativeImage.m_85103_(col) / 255.0f;
        float f3 = (float)NativeImage.m_85085_(col) / 255.0f;
        float f4 = (float)NativeImage.m_84983_(i) / 255.0f;
        float f5 = (float)NativeImage.m_85119_(i) / 255.0f;
        float f6 = (float)NativeImage.m_85103_(i) / 255.0f;
        float f7 = (float)NativeImage.m_85085_(i) / 255.0f;
        float f8 = 1.0f - f;
        float f9 = f * f + f4 * f8;
        float f10 = f1 * f + f5 * f8;
        float f11 = f2 * f + f6 * f8;
        float f12 = f3 * f + f7 * f8;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        if (f10 > 1.0f) {
            f10 = 1.0f;
        }
        if (f11 > 1.0f) {
            f11 = 1.0f;
        }
        if (f12 > 1.0f) {
            f12 = 1.0f;
        }
        int j = (int)(f9 * 255.0f);
        int k = (int)(f10 * 255.0f);
        int l = (int)(f11 * 255.0f);
        int i1 = (int)(f12 * 255.0f);
        this.m_84988_(x, y, NativeImage.m_84992_(j, k, l, i1));
    }

    @Deprecated
    public int[] m_85118_() {
        if (this.f_84960_ != Format.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.m_85124_();
        int[] aint = new int[this.m_84982_() * this.m_85084_()];
        for (int i = 0; i < this.m_85084_(); ++i) {
            for (int j = 0; j < this.m_84982_(); ++j) {
                int l1;
                int k = this.m_84985_(j, i);
                int l = NativeImage.m_84983_(k);
                int i1 = NativeImage.m_85119_(k);
                int j1 = NativeImage.m_85103_(k);
                int k1 = NativeImage.m_85085_(k);
                aint[j + i * this.m_84982_()] = l1 = l << 24 | k1 << 16 | j1 << 8 | i1;
            }
        }
        return aint;
    }

    public void m_85040_(int level, int xOffset, int yOffset, boolean autoClose) {
        this.m_85003_(level, xOffset, yOffset, 0, 0, this.f_84961_, this.f_84962_, false, autoClose);
    }

    public void m_85003_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean mipmap, boolean autoClose) {
        this.m_85013_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, false, false, mipmap, autoClose);
    }

    public void m_85013_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        if (!RenderSystem.m_69587_()) {
            RenderSystem.m_69879_(() -> this.m_85090_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose));
        } else {
            this.m_85090_(level, xOffset, yOffset, unpackSkipPixels, unpackSkipRows, widthIn, heightIn, blur, clamp, mipmap, autoClose);
        }
    }

    private void m_85090_(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int widthIn, int heightIn, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69587_(), ()Ljava/lang/Boolean;)());
        this.m_85124_();
        NativeImage.m_85081_(blur, mipmap);
        if (widthIn == this.m_84982_()) {
            GlStateManager.m_84522_((int)3314, (int)0);
        } else {
            GlStateManager.m_84522_((int)3314, (int)this.m_84982_());
        }
        GlStateManager.m_84522_((int)3316, (int)unpackSkipPixels);
        GlStateManager.m_84522_((int)3315, (int)unpackSkipRows);
        this.f_84960_.m_85169_();
        GlStateManager.m_84199_((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)widthIn, (int)heightIn, (int)this.f_84960_.m_85170_(), (int)5121, (long)this.f_84964_);
        if (clamp) {
            GlStateManager.m_84331_((int)3553, (int)10242, (int)33071);
            GlStateManager.m_84331_((int)3553, (int)10243, (int)33071);
        }
        if (autoClose) {
            this.close();
        }
    }

    public void m_85045_(int level, boolean opaque) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        this.m_85124_();
        this.f_84960_.m_85166_();
        GlStateManager.m_84227_((int)3553, (int)level, (int)this.f_84960_.m_85170_(), (int)5121, (long)this.f_84964_);
        if (opaque && this.f_84960_.m_85171_()) {
            for (int i = 0; i < this.m_85084_(); ++i) {
                for (int j = 0; j < this.m_84982_(); ++j) {
                    this.m_84988_(j, i, this.m_84985_(j, i) | 255 << this.f_84960_.m_85172_());
                }
            }
        }
    }

    public void m_312842_(float val) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        if (this.f_84960_.m_85161_() != 1) {
            throw new IllegalStateException("Depth buffer must be stored in NativeImage with 1 component.");
        }
        this.m_85124_();
        this.f_84960_.m_85166_();
        GlStateManager.m_307538_((int)0, (int)0, (int)this.f_84961_, (int)this.f_84962_, (int)6402, (int)5121, (long)this.f_84964_);
    }

    public void m_312863_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
        this.f_84960_.m_85169_();
        GlStateManager.m_307522_((int)this.f_84961_, (int)this.f_84962_, (int)this.f_84960_.m_85170_(), (int)5121, (long)this.f_84964_);
    }

    public void m_312848_(String pathIn) throws IOException {
        this.m_85066_(FileSystems.getDefault().getPath(pathIn, new String[0]));
    }

    public void m_85056_(File fileIn) throws IOException {
        this.m_85066_(fileIn.toPath());
    }

    public void m_85068_(STBTTFontinfo info, int glyphIndex, int widthIn, int heightIn, float scaleX, float scaleY, float shiftX, float shiftY, int x, int y) {
        if (x >= 0 && x + widthIn <= this.m_84982_() && y >= 0 && y + heightIn <= this.m_85084_()) {
            if (this.f_84960_.m_85161_() != 1) {
                throw new IllegalArgumentException("Can only write fonts into 1-component images.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", x, y, widthIn, heightIn, this.m_84982_(), this.m_85084_()));
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)info.address(), (long)(this.f_84964_ + (long)x + (long)(y * this.m_84982_())), (int)widthIn, (int)heightIn, (int)this.m_84982_(), (float)scaleX, (float)scaleY, (float)shiftX, (float)shiftY, (int)glyphIndex);
    }

    public void m_85066_(Path pathIn) throws IOException {
        if (!this.f_84960_.m_85175_()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.f_84960_));
        }
        this.m_85124_();
        try (SeekableByteChannel writablebytechannel = Files.newByteChannel(pathIn, f_84959_, new FileAttribute[0]);){
            if (!this.m_85064_(writablebytechannel)) {
                throw new IOException("Could not write image to the PNG file \"" + pathIn.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
            }
        }
    }

    public byte[] m_85121_() throws IOException {
        byte[] abyte;
        try (ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
             WritableByteChannel writablebytechannel = Channels.newChannel(bytearrayoutputstream);){
            if (!this.m_85064_(writablebytechannel)) {
                throw new IOException("Could not write image to byte array: " + STBImage.stbi_failure_reason());
            }
            abyte = bytearrayoutputstream.toByteArray();
        }
        return abyte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean m_85064_(WritableByteChannel channelIn) throws IOException {
        boolean flag;
        WriteCallback nativeimage$writecallback = new WriteCallback(channelIn);
        try {
            int i = Math.min(this.m_85084_(), Integer.MAX_VALUE / this.m_84982_() / this.f_84960_.m_85161_());
            if (i < this.m_85084_()) {
                f_84958_.warn("Dropping image height from {} to {} to fit the size into 32-bit signed int", (Object)this.m_85084_(), (Object)i);
            }
            if (STBImageWrite.nstbi_write_png_to_func((long)nativeimage$writecallback.address(), (long)0L, (int)this.m_84982_(), (int)i, (int)this.f_84960_.m_85161_(), (long)this.f_84964_, (int)0) != 0) {
                nativeimage$writecallback.m_85202_();
                boolean bl = true;
                return bl;
            }
            flag = false;
        }
        finally {
            nativeimage$writecallback.free();
        }
        return flag;
    }

    public void m_85054_(NativeImage from) {
        if (from.m_85102_() != this.f_84960_) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int i = this.f_84960_.m_85161_();
        this.m_85124_();
        from.m_85124_();
        if (this.f_84961_ == from.f_84961_) {
            MemoryUtil.memCopy((long)from.f_84964_, (long)this.f_84964_, (long)Math.min(this.f_84965_, from.f_84965_));
        } else {
            int j = Math.min(this.m_84982_(), from.m_84982_());
            int k = Math.min(this.m_85084_(), from.m_85084_());
            for (int l = 0; l < k; ++l) {
                int i1 = l * from.m_84982_() * i;
                int j1 = l * this.m_84982_() * i;
                MemoryUtil.memCopy((long)(from.f_84964_ + (long)i1), (long)(this.f_84964_ + (long)j1), (long)((long)j * (long)i));
            }
        }
    }

    public void m_84997_(int x, int y, int widthIn, int heightIn, int value) {
        for (int i = y; i < y + heightIn; ++i) {
            for (int j = x; j < x + widthIn; ++j) {
                this.m_84988_(j, i, value);
            }
        }
    }

    public void m_85025_(int xFrom, int yFrom, int xToDelta, int yToDelta, int widthIn, int heightIn, boolean mirrorX, boolean mirrorY) {
        for (int i = 0; i < heightIn; ++i) {
            for (int j = 0; j < widthIn; ++j) {
                int k = mirrorX ? widthIn - 1 - j : j;
                int l = mirrorY ? heightIn - 1 - i : i;
                int i1 = this.m_84985_(xFrom + j, yFrom + i);
                this.m_84988_(xFrom + xToDelta + k, yFrom + yToDelta + l, i1);
            }
        }
    }

    public void m_85122_() {
        this.m_85124_();
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            int i = this.f_84960_.m_85161_();
            int j = this.m_84982_() * i;
            long k = memorystack.nmalloc(j);
            for (int l = 0; l < this.m_85084_() / 2; ++l) {
                int i1 = l * this.m_84982_() * i;
                int j1 = (this.m_85084_() - 1 - l) * this.m_84982_() * i;
                MemoryUtil.memCopy((long)(this.f_84964_ + (long)i1), (long)k, (long)j);
                MemoryUtil.memCopy((long)(this.f_84964_ + (long)j1), (long)(this.f_84964_ + (long)i1), (long)j);
                MemoryUtil.memCopy((long)k, (long)(this.f_84964_ + (long)j1), (long)j);
            }
        }
    }

    public void m_85034_(int xIn, int yIn, int widthIn, int heightIn, NativeImage imageIn) {
        this.m_85124_();
        if (imageIn.m_85102_() != this.f_84960_) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int i = this.f_84960_.m_85161_();
        STBImageResize.nstbir_resize_uint8((long)(this.f_84964_ + (long)((xIn + yIn * this.m_84982_()) * i)), (int)widthIn, (int)heightIn, (int)(this.m_84982_() * i), (long)imageIn.f_84964_, (int)imageIn.m_84982_(), (int)imageIn.m_85084_(), (int)0, (int)i);
    }

    public void m_85123_() {
        DebugMemoryUntracker.m_84001_((long)this.f_84964_);
    }

    public static NativeImage m_85060_(String stringIn) throws IOException {
        NativeImage nativeimage;
        byte[] abyte = Base64.getDecoder().decode(stringIn.replaceAll("\n", "").getBytes(Charsets.UTF_8));
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(abyte.length);
            bytebuffer.put(abyte);
            bytebuffer.rewind();
            nativeimage = NativeImage.m_85062_(bytebuffer);
        }
        return nativeimage;
    }

    public static int m_84983_(int col) {
        return col >> 24 & 0xFF;
    }

    public static int m_85085_(int col) {
        return col >> 0 & 0xFF;
    }

    public static int m_85103_(int col) {
        return col >> 8 & 0xFF;
    }

    public static int m_85119_(int col) {
        return col >> 16 & 0xFF;
    }

    public static int m_84992_(int alpha, int blue, int green, int red) {
        return (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | (red & 0xFF) << 0;
    }

    public IntBuffer getBufferRGBA() {
        if (this.f_84960_ != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.f_84960_}));
        }
        this.m_85124_();
        return MemoryUtil.memIntBuffer((long)this.f_84964_, (int)((int)this.f_84965_));
    }

    public void fillRGBA(int rgba) {
        if (this.f_84960_ != Format.RGBA) {
            throw new IllegalArgumentException(String.format("getBuffer only works on RGBA images; have %s", new Object[]{this.f_84960_}));
        }
        this.m_85124_();
        MemoryUtil.memSet((long)this.f_84964_, (int)rgba, (long)this.f_84965_);
    }

    public long getSize() {
        return this.f_84965_;
    }

    public void downloadFromFramebuffer(boolean opaque) {
        this.m_85124_();
        this.f_84960_.m_85166_();
    }

    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel f_85195_;
        @Nullable
        private IOException f_85196_;

        WriteCallback(WritableByteChannel byteChannelIn) {
            this.f_85195_ = byteChannelIn;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = WriteCallback.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.f_85195_.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.f_85196_ = ioexception;
            }
        }

        public void m_85202_() throws IOException {
            if (this.f_85196_ != null) {
                throw this.f_85196_;
            }
        }
    }

    public static enum InternalGlFormat {
        RGBA(6408),
        RGB(6407),
        RG(33319),
        RED(6403);

        private final int f_85184_;

        private InternalGlFormat(int glFormatIn) {
            this.f_85184_ = glFormatIn;
        }

        public int m_85191_() {
            return this.f_85184_;
        }
    }

    public static enum Format {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 33319, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6403, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        final int f_85130_;
        private final int f_85131_;
        private final boolean f_85132_;
        private final boolean f_85133_;
        private final boolean f_85134_;
        private final boolean f_85135_;
        private final boolean f_85136_;
        private final int f_85137_;
        private final int f_85138_;
        private final int f_85139_;
        private final int f_85140_;
        private final int f_85141_;
        private final boolean f_85142_;

        private Format(int channelsIn, int glFormatIn, boolean redIn, boolean greenIn, boolean blueIn, boolean luminanceIn, boolean alphaIn, int offsetRedIn, int offsetGreenIn, int offsetBlueIn, int offsetLuminanceIn, int offsetAlphaIn, boolean standardIn) {
            this.f_85130_ = channelsIn;
            this.f_85131_ = glFormatIn;
            this.f_85132_ = redIn;
            this.f_85133_ = greenIn;
            this.f_85134_ = blueIn;
            this.f_85135_ = luminanceIn;
            this.f_85136_ = alphaIn;
            this.f_85137_ = offsetRedIn;
            this.f_85138_ = offsetGreenIn;
            this.f_85139_ = offsetBlueIn;
            this.f_85140_ = offsetLuminanceIn;
            this.f_85141_ = offsetAlphaIn;
            this.f_85142_ = standardIn;
        }

        public int m_85161_() {
            return this.f_85130_;
        }

        public void m_85166_() {
            RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69586_(), ()Ljava/lang/Boolean;)());
            GlStateManager.m_84522_((int)3333, (int)this.m_85161_());
        }

        public void m_85169_() {
            RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69587_(), ()Ljava/lang/Boolean;)());
            GlStateManager.m_84522_((int)3317, (int)this.m_85161_());
        }

        public int m_85170_() {
            return this.f_85131_;
        }

        public boolean m_312867_() {
            return this.f_85132_;
        }

        public boolean m_312868_() {
            return this.f_85133_;
        }

        public boolean m_312869_() {
            return this.f_85134_;
        }

        public boolean m_312870_() {
            return this.f_85135_;
        }

        public boolean m_85171_() {
            return this.f_85136_;
        }

        public int m_312871_() {
            return this.f_85137_;
        }

        public int m_312872_() {
            return this.f_85138_;
        }

        public int m_312873_() {
            return this.f_85139_;
        }

        public int m_312874_() {
            return this.f_85140_;
        }

        public int m_85172_() {
            return this.f_85141_;
        }

        public boolean m_312875_() {
            return this.f_85135_ || this.f_85132_;
        }

        public boolean m_312876_() {
            return this.f_85135_ || this.f_85133_;
        }

        public boolean m_312877_() {
            return this.f_85135_ || this.f_85134_;
        }

        public boolean m_85173_() {
            return this.f_85135_ || this.f_85136_;
        }

        public int m_312878_() {
            return this.f_85135_ ? this.f_85140_ : this.f_85137_;
        }

        public int m_312879_() {
            return this.f_85135_ ? this.f_85140_ : this.f_85138_;
        }

        public int m_312880_() {
            return this.f_85135_ ? this.f_85140_ : this.f_85139_;
        }

        public int m_85174_() {
            return this.f_85135_ ? this.f_85140_ : this.f_85141_;
        }

        public boolean m_85175_() {
            return this.f_85142_;
        }

        static Format m_85167_(int channelsIn) {
            switch (channelsIn) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }
}

