/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.DebugMemoryUntracker;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.optifine.Config;
import net.optifine.GlErrors;
import net.optifine.util.ArrayUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;

public class GlDebug {
    private static final Logger f_84028_ = LogManager.getLogger();
    private static final int f_312661_ = 10;
    private static final Queue<LogEntry> f_312662_ = EvictingQueue.create((int)10);
    @Nullable
    private static volatile LogEntry f_312663_;
    private static final List<Integer> f_84032_;
    private static final List<Integer> f_84033_;
    private static boolean f_312664_;
    private static int[] ignoredErrors;

    private static int[] makeIgnoredErrors() {
        String prop = System.getProperty("gl.ignore.errors");
        if (prop == null) {
            return new int[0];
        }
        String[] parts = Config.tokenize(prop, ",");
        int[] ids = new int[]{};
        for (int i = 0; i < parts.length; ++i) {
            int id;
            String part = parts[i].trim();
            int n = id = part.startsWith("0x") ? Config.parseHexInt(part, -1) : Config.parseInt(part, -1);
            if (id < 0) {
                Config.warn("Invalid error id: " + part);
                continue;
            }
            Config.log("Ignore OpenGL error: " + id);
            ids = ArrayUtils.addIntToArray(ids, id);
        }
        return ids;
    }

    private static String m_84036_(int valueIn) {
        return "Unknown (0x" + Integer.toHexString(valueIn).toUpperCase() + ")";
    }

    public static String m_84055_(int sourceIn) {
        switch (sourceIn) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return GlDebug.m_84036_(sourceIn);
    }

    public static String m_84057_(int typeIn) {
        switch (typeIn) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return GlDebug.m_84036_(typeIn);
    }

    public static String m_84059_(int severityIn) {
        switch (severityIn) {
            case 33387: {
                return "NOTIFICATION";
            }
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return GlDebug.m_84036_(severityIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void m_84038_(int source, int type, int id, int severity, int messageLength, long message, long param) {
        if (type == 33385 || type == 33386) {
            return;
        }
        if (ArrayUtils.contains(ignoredErrors, id)) {
            return;
        }
        if (Config.isShaders() && source == 33352) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc != null && mc.m_91268_() != null && mc.m_91268_().isClosed()) {
            return;
        }
        if (!GlErrors.isEnabled(id)) {
            return;
        }
        String sourceStr = GlDebug.m_84055_(source);
        String typeStr = GlDebug.m_84057_(type);
        String severityStr = GlDebug.m_84059_(severity);
        String messageStr = GLDebugMessageCallback.getMessage((int)messageLength, (long)message);
        messageStr = StrUtils.trim(messageStr, " \n\r\t");
        String log = String.format("OpenGL %s %s: %s (%s)", sourceStr, typeStr, id, messageStr);
        Exception exc = new Exception("Stack trace");
        StackTraceElement[] stes = exc.getStackTrace();
        StackTraceElement[] stes2 = stes.length > 2 ? Arrays.copyOfRange(stes, 2, stes.length) : stes;
        exc.setStackTrace(stes2);
        if (type == 33356) {
            f_84028_.error(log, (Throwable)exc);
        } else {
            f_84028_.info(log, (Throwable)exc);
        }
        if (Config.isShowGlErrors() && TimedEvent.isActive("ShowGlErrorDebug", 10000L)) {
            String errorText = Config.getGlErrorString(id);
            if (id == 0 || Config.equals(errorText, "Unknown")) {
                errorText = messageStr;
            }
            String messageChat = I18n.m_118938_((String)"of.message.openglError", (Object[])new Object[]{id, errorText});
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TextComponent(messageChat));
        }
        String s = GLDebugMessageCallback.getMessage((int)messageLength, (long)message);
        Queue<LogEntry> queue = f_312662_;
        synchronized (queue) {
            LogEntry gldebug$logentry = f_312663_;
            if (gldebug$logentry != null && gldebug$logentry.m_312680_(source, type, id, severity, s)) {
                ++gldebug$logentry.f_312673_;
            } else {
                gldebug$logentry = new LogEntry(source, type, id, severity, s);
                f_312662_.add(gldebug$logentry);
                f_312663_ = gldebug$logentry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> m_312666_() {
        Queue<LogEntry> queue = f_312662_;
        synchronized (queue) {
            ArrayList list = Lists.newArrayListWithCapacity((int)f_312662_.size());
            for (LogEntry gldebug$logentry : f_312662_) {
                list.add(gldebug$logentry + " x " + gldebug$logentry.f_312673_);
            }
            return list;
        }
    }

    public static boolean m_312667_() {
        return f_312664_;
    }

    public static void m_84049_(int debugVerbosity, boolean synchronous) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69583_(), ()Ljava/lang/Boolean;)());
        if (debugVerbosity > 0) {
            GLCapabilities glcapabilities = GL.getCapabilities();
            if (glcapabilities.GL_KHR_debug) {
                f_312664_ = true;
                GL11.glEnable((int)37600);
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int i = 0; i < f_84032_.size(); ++i) {
                    boolean flag = i < debugVerbosity;
                    KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)f_84032_.get(i), (int[])null, (boolean)flag);
                }
                KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((GLDebugMessageCallbackI)GLX.m_69370_((Object)GLDebugMessageCallback.create(GlDebug::m_84038_), DebugMemoryUntracker::m_84003_)), (long)0L);
            } else if (glcapabilities.GL_ARB_debug_output) {
                f_312664_ = true;
                if (synchronous) {
                    GL11.glEnable((int)33346);
                }
                for (int j = 0; j < f_84033_.size(); ++j) {
                    boolean flag1 = j < debugVerbosity;
                    ARBDebugOutput.glDebugMessageControlARB((int)4352, (int)4352, (int)f_84033_.get(j), (int[])null, (boolean)flag1);
                }
                ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((GLDebugMessageARBCallbackI)GLX.m_69370_((Object)GLDebugMessageARBCallback.create(GlDebug::m_84038_), DebugMemoryUntracker::m_84003_)), (long)0L);
            }
        }
    }

    static {
        f_84032_ = ImmutableList.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
        f_84033_ = ImmutableList.of((Object)37190, (Object)37191, (Object)37192);
        ignoredErrors = GlDebug.makeIgnoredErrors();
    }

    static class LogEntry {
        private final int f_312668_;
        private final int f_312669_;
        private final int f_312670_;
        private final int f_312671_;
        private final String f_312672_;
        int f_312673_ = 1;

        LogEntry(int sourceIn, int typeIn, int idIn, int severityIn, String messageIn) {
            this.f_312668_ = idIn;
            this.f_312669_ = sourceIn;
            this.f_312670_ = typeIn;
            this.f_312671_ = severityIn;
            this.f_312672_ = messageIn;
        }

        boolean m_312680_(int sourceIn, int typeIn, int idIn, int severityIn, String messageIn) {
            return typeIn == this.f_312670_ && sourceIn == this.f_312669_ && idIn == this.f_312668_ && severityIn == this.f_312671_ && messageIn.equals(this.f_312672_);
        }

        public String toString() {
            return "id=" + this.f_312668_ + ", source=" + GlDebug.m_84055_(this.f_312669_) + ", type=" + GlDebug.m_84057_(this.f_312670_) + ", severity=" + GlDebug.m_84059_(this.f_312671_) + ", message='" + this.f_312672_ + "'";
        }
    }
}

