/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.fabric.impl.client.indigo.Indigo;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;

public abstract class CompatibilityHelper {
    private static boolean logCompatibilityWarning = true;

    private CompatibilityHelper() {
    }

    private static boolean isCompatible(int[] vertexData) {
        boolean result;
        boolean bl = result = vertexData.length == EncodingFormat.QUAD_STRIDE;
        if (!result && logCompatibilityWarning) {
            logCompatibilityWarning = false;
            Indigo.LOGGER.warn("[Indigo] Encountered baked quad with non-standard vertex format. Some blocks will not be rendered");
        }
        return result;
    }

    public static boolean canRender(int[] vertexData) {
        return !Indigo.ENSURE_VERTEX_FORMAT_COMPATIBILITY || CompatibilityHelper.isCompatible(vertexData);
    }
}

