/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1074;
import net.minecraft.class_2585;
import net.minecraft.class_316;
import net.minecraft.class_3532;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.settings.XaeroCyclingOption;
import xaero.map.settings.XaeroDoubleOption;

public class ModOptions {
    public static ModOptions DEBUG;
    public static ModOptions COLOURS;
    public static ModOptions LIGHTING;
    public static ModOptions UPDATE;
    public static ModOptions LOAD;
    public static ModOptions DEPTH;
    public static ModOptions SLOPES;
    public static ModOptions STEPS;
    public static ModOptions FLOWERS;
    public static ModOptions COMPRESSION;
    public static ModOptions COORDINATES;
    public static ModOptions BIOMES;
    public static ModOptions WAYPOINTS;
    public static ModOptions ARROW;
    public static ModOptions DISPLAY_ZOOM;
    public static ModOptions IGNORE_HEIGHTMAPS;
    public static ModOptions WAYPOINT_SCALE;
    public static ModOptions OPEN_ANIMATION;
    public static ModOptions RELOAD;
    public static ModOptions ZOOM_BUTTONS;
    public static ModOptions WAYPOINT_BACKGROUNDS;
    public static ModOptions PAUSE_REQUESTS;
    public static ModOptions EXTRA_DEBUG;
    public static ModOptions DETECT_AMBIGUOUS_Y;
    public static ModOptions UPDATE_NOTIFICATION;
    private final boolean enumDouble;
    final boolean enumBoolean;
    private final String enumString;
    private double valueMin;
    private double valueMax;
    private double valueStep;
    private class_316 mcOption;
    private CursorBox tooltip;
    private boolean ingameOnly;

    public static void init() {
        DEBUG = new ModOptions("gui.xaero_debug", false);
        COLOURS = new ModOptions("gui.xaero_block_colours", 2, false);
        LIGHTING = new ModOptions("gui.xaero_lighting", false);
        UPDATE = new ModOptions("gui.xaero_update_chunks", false);
        LOAD = new ModOptions("gui.xaero_load_chunks", false);
        DEPTH = new ModOptions("gui.xaero_terrain_depth", false);
        SLOPES = new ModOptions("gui.xaero_terrain_slopes", 4, false);
        STEPS = new ModOptions("gui.xaero_footsteps", false);
        FLOWERS = new ModOptions("gui.xaero_flowers", false);
        COMPRESSION = new ModOptions("gui.xaero_texture_compression", false);
        COORDINATES = new ModOptions("gui.xaero_wm_coordinates", false);
        BIOMES = new ModOptions("gui.xaero_biome_colors", false);
        WAYPOINTS = new ModOptions("gui.xaero_worldmap_waypoints", false);
        ARROW = new ModOptions("gui.xaero_render_arrow", false);
        DISPLAY_ZOOM = new ModOptions("gui.xaero_display_zoom", false);
        IGNORE_HEIGHTMAPS = new ModOptions("gui.xaero_wm_ignore_heightmaps", new CursorBox("gui.xaero_wm_box_ignore_heightmaps"), true);
        WAYPOINT_SCALE = new ModOptions("gui.xaero_wm_waypoint_scale", 0.5, 5.0, 0.5f, false);
        OPEN_ANIMATION = new ModOptions("gui.xaero_open_map_animation", false);
        RELOAD = new ModOptions("gui.xaero_reload_everything", false);
        ZOOM_BUTTONS = new ModOptions("gui.xaero_zoom_buttons", false);
        WAYPOINT_BACKGROUNDS = new ModOptions("gui.xaero_waypoint_backgrounds", false);
        PAUSE_REQUESTS = new ModOptions("pause_requests", false);
        EXTRA_DEBUG = new ModOptions("extra_debug", false);
        DETECT_AMBIGUOUS_Y = new ModOptions("gui.xaero_wm_detect_ambiguous_y", new CursorBox("gui.xaero_wm_box_detect_ambiguous_y"), false);
        UPDATE_NOTIFICATION = new ModOptions("gui.xaero_wm_update_notification", false);
    }

    private ModOptions(String par3Str, boolean ingameOnly) {
        this(par3Str, null, ingameOnly);
    }

    private ModOptions(String par3Str, CursorBox tooltip, boolean ingameOnly) {
        this(par3Str, true, () -> Lists.newArrayList((Object[])new Boolean[]{false, true}), tooltip, ingameOnly);
    }

    private ModOptions(String par3Str, int optionCount, boolean ingameOnly) {
        this(par3Str, optionCount, null, ingameOnly);
    }

    private ModOptions(String par3Str, int optionCount, CursorBox tooltip, boolean ingameOnly) {
        this(par3Str, false, () -> {
            List optionsList = IntStream.rangeClosed(0, optionCount - 1).boxed().collect(Collectors.toList());
            return optionsList;
        }, tooltip, ingameOnly);
    }

    private <T> ModOptions(String par3Str, boolean isBoolean, Supplier<List<T>> optionsListSupplier, CursorBox tooltip, boolean ingameOnly) {
        this.enumString = par3Str;
        this.enumBoolean = isBoolean;
        this.enumDouble = false;
        Supplier<Object> valueGetter = () -> WorldMap.settings.getOptionValue(this);
        Consumer<Object> valueSetter = v -> WorldMap.settings.setOptionValue(this, v);
        this.mcOption = new XaeroCyclingOption<Object>(this, optionsListSupplier.get(), valueGetter, valueSetter, () -> new class_2585(WorldMap.settings.getOptionValueName(this)));
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
    }

    private ModOptions(String p_i45004_3_, double p_i45004_6_, double p_i45004_7_, float p_i45004_8_, boolean ingameOnly) {
        this(p_i45004_3_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null, ingameOnly);
    }

    private ModOptions(String p_i45004_3_, double p_i45004_6_, double p_i45004_7_, float p_i45004_8_, CursorBox tooltip, boolean ingameOnly) {
        this.enumString = p_i45004_3_;
        this.enumBoolean = false;
        this.enumDouble = true;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
        this.mcOption = new XaeroDoubleOption(this, p_i45004_6_, p_i45004_7_, p_i45004_8_, gameSettings -> WorldMap.settings.getOptionDoubleValue(this), (gameSettings, option) -> WorldMap.settings.setOptionDoubleValue(this, (double)option), (gameSettings, option) -> new class_2585(WorldMap.settings.getSliderOptionText(this)));
        this.tooltip = tooltip;
        this.ingameOnly = ingameOnly;
    }

    public boolean getEnumDouble() {
        return this.enumDouble;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public double getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(float p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public double normalizeValue(double p_148266_1_) {
        return class_3532.method_15350((double)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * class_3532.method_15350((double)p_148262_1_, (double)0.0, (double)1.0));
    }

    public double snapToStepClamp(double p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return class_3532.method_15350((double)p_148268_1_, (double)this.valueMin, (double)this.valueMax);
    }

    protected double snapToStep(double p_148264_1_) {
        if (this.valueStep > 0.0) {
            p_148264_1_ = this.valueStep * (double)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return class_1074.method_4662((String)this.enumString, (Object[])new Object[0]);
    }

    public class_316 getMcOption() {
        return this.mcOption;
    }

    public CursorBox getTooltip() {
        return this.tooltip;
    }

    public boolean isIngameOnly() {
        return this.ingameOnly;
    }
}

