/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.class_1058;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2386;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.biome.BiomeKey;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class OverlayBuilder {
    private static final int MAX_OVERLAYS = 10;
    private Overlay[] overlayBuildingSet;
    private int currentOverlayIndex;
    private OverlayManager overlayManager;
    private class_1058 prevIcon;
    private BiomeKey overlayBiome;

    public OverlayBuilder(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
        this.overlayBuildingSet = new Overlay[10];
        for (int i = 0; i < this.overlayBuildingSet.length; ++i) {
            this.overlayBuildingSet[i] = new Overlay(class_2246.field_10124.method_9564(), 0, 0, 0.0f, 0, false);
        }
        this.currentOverlayIndex = -1;
    }

    public void startBuilding() {
        this.currentOverlayIndex = -1;
        this.setOverlayBiome(null);
    }

    public void build(class_2680 state, int[] biome, int opacity, byte light, class_1937 world, MapProcessor mapProcessor, class_2338 mutableBlockPos, BiomeKey biomeId, class_2378<class_1959> biomeRegistry, BlockStateColorTypeCache colorTypeCache, BiomeInfoSupplier biomeSupplier) {
        Overlay currentOverlay = null;
        if (this.currentOverlayIndex >= 0) {
            currentOverlay = this.overlayBuildingSet[this.currentOverlayIndex];
        }
        Overlay nextOverlay = null;
        if (this.currentOverlayIndex < this.overlayBuildingSet.length - 1) {
            nextOverlay = this.overlayBuildingSet[this.currentOverlayIndex + 1];
        }
        class_1058 icon = null;
        boolean changed = false;
        if (currentOverlay == null || currentOverlay.getState() != state) {
            icon = class_310.method_1551().method_1541().method_3351().method_3339(state);
            boolean bl = changed = icon != this.prevIcon;
        }
        if (nextOverlay != null && (currentOverlay == null || changed)) {
            float transparency = state.method_26204() instanceof class_2404 ? 0.66f : (state.method_26204() instanceof class_2386 ? 0.83f : 0.5f);
            boolean glowing = false;
            try {
                glowing = mapProcessor.getMapWriter().isGlowing(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (biomeSupplier != null) {
                biomeId = biomeSupplier.getBiomeInfo(colorTypeCache, world, state, mutableBlockPos, biome, biomeId, biomeRegistry);
            }
            if (this.getOverlayBiome() == null) {
                this.setOverlayBiome(biomeId);
            }
            nextOverlay.write(state, biome[0], biome[2], transparency, light, glowing);
            currentOverlay = nextOverlay;
            ++this.currentOverlayIndex;
        }
        currentOverlay.increaseOpacity(opacity);
        if (changed) {
            this.prevIcon = icon;
        }
    }

    public void finishBuilding(MapBlock block) {
        for (int i = 0; i <= this.currentOverlayIndex; ++i) {
            Overlay o = this.overlayBuildingSet[i];
            Overlay original = this.overlayManager.getOriginal(o);
            if (o == original) {
                this.overlayBuildingSet[i] = new Overlay(class_2246.field_10124.method_9564(), 0, 0, 0.0f, 0, false);
            }
            block.addOverlay(original);
        }
    }

    public BiomeKey getOverlayBiome() {
        return this.overlayBiome;
    }

    public void setOverlayBiome(BiomeKey overlayBiome) {
        this.overlayBiome = overlayBiome;
    }
}

