/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl.mixin;

import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_315.class})
public class MixinGameOptions {
    @Unique
    private static final String KEY_MODIFIERS_PREFIX = "key_modifiers_";
    @Shadow
    @Final
    public class_304[] field_1839;
    @Unique
    private File amecsOptionsFile;

    @Inject(method={"write"}, at={@At(value="RETURN")})
    public void write(CallbackInfo callbackInfo) {
        try (PrintWriter writer = new PrintWriter(new FileOutputStream(this.amecsOptionsFile));){
            for (class_304 binding : this.field_1839) {
                KeyModifiers modifiers = ((IKeyBinding)binding).amecs$getKeyModifiers();
                writer.println(KEY_MODIFIERS_PREFIX + binding.method_1431() + ":" + modifiers.serializeValue());
            }
        }
        catch (FileNotFoundException e) {
            AmecsAPI.log(Level.ERROR, "Failed to save Amecs API modifiers to options file:");
            e.printStackTrace();
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void load(CallbackInfo callbackInfo) {
        if (this.amecsOptionsFile == null) {
            this.amecsOptionsFile = new File(class_310.method_1551().field_1697, "options.amecsapi.txt");
        }
        if (!this.amecsOptionsFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.amecsOptionsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                try {
                    int colon = line.indexOf(58);
                    if (colon <= 0) {
                        AmecsAPI.log(Level.WARN, "Invalid line in Amecs API options file: " + line);
                        continue;
                    }
                    String id = line.substring(0, colon);
                    if (!id.startsWith(KEY_MODIFIERS_PREFIX)) {
                        AmecsAPI.log(Level.WARN, "Invalid entry in Amecs API options file: " + id);
                        continue;
                    }
                    id = id.substring(KEY_MODIFIERS_PREFIX.length());
                    class_304 keyBinding = KeyBindingUtils.getIdToKeyBindingMap().get(id);
                    if (keyBinding == null) {
                        AmecsAPI.log(Level.WARN, "Unknown keybinding identifier in Amecs API options file: " + id);
                        continue;
                    }
                    ((IKeyBinding)keyBinding).amecs$getKeyModifiers().setValue(KeyModifiers.deserializeValue(line.substring(colon + 1)));
                }
                catch (Throwable e) {
                    AmecsAPI.log(Level.ERROR, "Invalid line in Amecs API options file: " + line);
                }
            }
        }
        catch (IOException e) {
            AmecsAPI.log(Level.ERROR, "Failed to load Amecs API options file:");
            e.printStackTrace();
        }
    }
}

