/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.api;

import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public class KeyModifiers {
    private BitSet value;

    public KeyModifiers() {
        this(new BitSet(KeyModifier.getModifierCount()));
    }

    @Deprecated
    public KeyModifiers(BitSet value) {
        this.value = value;
    }

    public KeyModifiers(boolean alt, boolean control, boolean shift) {
        this();
        this.setAlt(alt);
        this.setControl(control);
        this.setShift(shift);
    }

    public boolean isPressed() {
        return this.equals(AmecsAPI.CURRENT_MODIFIERS);
    }

    @Deprecated
    public KeyModifiers setValue(BitSet value) {
        this.value = (BitSet)value.clone();
        return this;
    }

    @Deprecated
    public BitSet getValue() {
        return this.value;
    }

    public KeyModifiers setAlt(boolean value) {
        this.value.set(KeyModifier.ALT.id, value);
        return this;
    }

    public boolean getAlt() {
        return this.value.get(KeyModifier.ALT.id);
    }

    public KeyModifiers setControl(boolean value) {
        this.value.set(KeyModifier.CONTROL.id, value);
        return this;
    }

    public boolean getControl() {
        return this.value.get(KeyModifier.CONTROL.id);
    }

    public KeyModifiers setShift(boolean value) {
        this.value.set(KeyModifier.SHIFT.id, value);
        return this;
    }

    public boolean getShift() {
        return this.value.get(KeyModifier.SHIFT.id);
    }

    public void set(KeyModifier keyModifier, boolean value) {
        if (keyModifier != KeyModifier.NONE) {
            this.value.set(keyModifier.id, value);
        }
    }

    public boolean get(KeyModifier keyModifier) {
        if (keyModifier == KeyModifier.NONE) {
            return true;
        }
        return this.value.get(keyModifier.id);
    }

    public boolean isUnset() {
        return this.value.isEmpty();
    }

    public void unset() {
        this.value.clear();
    }

    public void cleanup(class_304 keyBinding) {
        int keyCode = ((IKeyBinding)keyBinding).amecs$getKeyCode().method_1444();
        this.set(KeyModifier.fromKeyCode(keyCode), false);
    }

    public boolean equals(KeyModifiers other) {
        return this.value.equals(other.value);
    }

    @Deprecated
    public String serializeValue() {
        return Arrays.stream(this.value.toLongArray()).mapToObj(Long::toHexString).collect(Collectors.joining(","));
    }

    @Deprecated
    public static BitSet deserializeValue(String value) {
        if (value.isEmpty()) {
            return new BitSet(KeyModifier.getModifierCount());
        }
        return BitSet.valueOf(Arrays.stream(value.split(",")).mapToLong(Long::valueOf).toArray());
    }
}

