/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.shadow.org.hjson;

import de.siphalor.tweed.shadow.org.hjson.DsfHex;
import de.siphalor.tweed.shadow.org.hjson.DsfMath;
import de.siphalor.tweed.shadow.org.hjson.IHjsonDsfProvider;
import de.siphalor.tweed.shadow.org.hjson.JsonString;
import de.siphalor.tweed.shadow.org.hjson.JsonValue;

public class HjsonDsf {
    private HjsonDsf() {
    }

    public static IHjsonDsfProvider math() {
        return new DsfMath();
    }

    public static IHjsonDsfProvider hex(boolean stringify) {
        return new DsfHex(stringify);
    }

    static boolean isInvalidDsfChar(char c) {
        return c == '{' || c == '}' || c == '[' || c == ']' || c == ',';
    }

    static JsonValue parse(IHjsonDsfProvider[] dsfProviders, String value) {
        for (IHjsonDsfProvider dsf : dsfProviders) {
            try {
                JsonValue res = dsf.parse(value);
                if (res == null) continue;
                return res;
            }
            catch (Exception exception) {
                throw new RuntimeException("DSF-" + dsf.getName() + " failed; " + exception.getMessage());
            }
        }
        return new JsonString(value);
    }

    static String stringify(IHjsonDsfProvider[] dsfProviders, JsonValue value) {
        for (IHjsonDsfProvider dsf : dsfProviders) {
            try {
                char[] textc;
                String text = dsf.stringify(value);
                if (text == null) continue;
                boolean isInvalid = false;
                for (char ch : textc = text.toCharArray()) {
                    if (!HjsonDsf.isInvalidDsfChar(ch)) continue;
                    isInvalid = true;
                    break;
                }
                if (isInvalid || text.length() == 0 || textc[0] == '\"') {
                    throw new Exception("value may not be empty, start with a quote or contain a punctuator character except colon: " + text);
                }
                return text;
            }
            catch (Exception exception) {
                throw new RuntimeException("DSF-" + dsf.getName() + " failed; " + exception.getMessage());
            }
        }
        return null;
    }
}

