/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.data.serializer;

import com.mojang.datafixers.util.Pair;
import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.data.DataList;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import de.siphalor.tweed.shadow.org.hjson.CommentStyle;
import de.siphalor.tweed.shadow.org.hjson.CommentType;
import de.siphalor.tweed.shadow.org.hjson.HjsonOptions;
import de.siphalor.tweed.shadow.org.hjson.JsonArray;
import de.siphalor.tweed.shadow.org.hjson.JsonObject;
import de.siphalor.tweed.shadow.org.hjson.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class HjsonSerializer
implements ConfigDataSerializer<JsonValue> {
    public static final HjsonSerializer INSTANCE = new HjsonSerializer();
    private final HjsonOptions hjsonOptions = new HjsonOptions().setAllowCondense(false).setBracesSameLine(true).setOutputComments(true).setSpace("\t");

    @Override
    public DataObject<JsonValue> newObject() {
        return new HjsonObject(new JsonObject());
    }

    @Override
    public DataObject<JsonValue> read(InputStream inputStream) {
        JsonValue json;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            json = JsonValue.readHjson(inputStreamReader);
            inputStreamReader.close();
        }
        catch (Exception e) {
            Tweed.LOGGER.error("Couldn't load hjson config file");
            e.printStackTrace();
            return null;
        }
        if (!json.isObject()) {
            Tweed.LOGGER.error("Config files should contain an hjson object!");
            return null;
        }
        return new HjsonObject(json.asObject());
    }

    @Override
    public void write(OutputStream outputStream, DataObject<JsonValue> dataObject) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            ((JsonValue)dataObject.getRaw()).writeTo((Writer)outputStreamWriter, this.hjsonOptions);
            outputStreamWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFileExtension() {
        return "hjson";
    }

    static class HjsonList
    extends HjsonValue
    implements DataList<JsonValue> {
        HjsonList(JsonValue jsonValue) {
            super(jsonValue);
        }

        @Override
        public int size() {
            return this.jsonValue.asArray().size();
        }

        @Override
        public DataValue<JsonValue> get(Integer index) {
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, byte value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, short value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, int value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, long value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, float value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, double value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, char value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, String.valueOf(value));
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, String value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, boolean value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value);
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataValue<JsonValue> set(Integer index, DataValue<JsonValue> value) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, value.getRaw());
            return new HjsonValue(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataObject<JsonValue> addObject(Integer index) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, new JsonObject());
            return new HjsonObject(this.jsonValue.asArray().get(index));
        }

        @Override
        public DataList<JsonValue> addList(Integer index) {
            this.adjustLength(index);
            this.jsonValue.asArray().set((int)index, new JsonArray());
            return new HjsonList(this.jsonValue.asArray().get(index));
        }

        private void adjustLength(int index) {
            int length;
            JsonArray jsonArray = this.jsonValue.asArray();
            for (int i = length = jsonArray.size(); i <= index; ++i) {
                jsonArray.add(JsonValue.valueOf(null));
            }
        }

        @Override
        public void remove(Integer index) {
            this.jsonValue.asArray().remove(index);
        }

        @Override
        @NotNull
        public Iterator<DataValue<JsonValue>> iterator() {
            return this.jsonValue.asArray().values().stream().map(json -> new HjsonValue((JsonValue)json)).iterator();
        }
    }

    static class HjsonObject
    extends HjsonValue
    implements DataObject<JsonValue> {
        HjsonObject(JsonValue jsonValue) {
            super(jsonValue);
        }

        @Override
        public boolean has(String key) {
            return this.jsonValue.asObject().has(key);
        }

        @Override
        public int size() {
            return this.jsonValue.asObject().size();
        }

        @Override
        public DataValue<JsonValue> get(String key) {
            if (!this.has(key)) {
                return null;
            }
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, int value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, short value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, byte value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, float value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, long value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, String value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, char value) {
            this.jsonValue.asObject().set(key, String.valueOf(value));
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, double value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, boolean value) {
            this.jsonValue.asObject().set(key, value);
            return new HjsonValue(this.jsonValue.asObject().get(key));
        }

        @Override
        public DataValue<JsonValue> set(String key, DataValue<JsonValue> value) {
            this.jsonValue.asObject().set(key, value.getRaw());
            return value;
        }

        @Override
        public DataObject<JsonValue> addObject(String key) {
            JsonObject jsonObject = new JsonObject();
            this.jsonValue.asObject().set(key, jsonObject);
            return new HjsonObject(jsonObject);
        }

        @Override
        public DataList<JsonValue> addList(String key) {
            JsonArray jsonArray = new JsonArray();
            this.jsonValue.asObject().set(key, jsonArray);
            return new HjsonList(jsonArray);
        }

        @Override
        public void remove(String key) {
            this.jsonValue.asObject().remove(key);
        }

        @Override
        @NotNull
        public Iterator<Pair<String, DataValue<JsonValue>>> iterator() {
            return this.jsonValue.asObject().names().stream().map(name -> new Pair(name, (Object)new HjsonValue(this.jsonValue.asObject().get((String)name)))).iterator();
        }
    }

    static class HjsonValue
    implements DataValue<JsonValue> {
        JsonValue jsonValue;

        HjsonValue(JsonValue jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public void setComment(String comment) {
            this.jsonValue.setComment(CommentType.BOL, CommentStyle.LINE, comment);
        }

        @Override
        public String getComment() {
            return this.jsonValue.getBOLComment();
        }

        @Override
        public boolean isNumber() {
            return this.jsonValue.isNumber();
        }

        @Override
        public boolean isCharacter() {
            return this.jsonValue.isString() && this.jsonValue.asString().length() == 1;
        }

        @Override
        public boolean isString() {
            return this.jsonValue.isString();
        }

        @Override
        public boolean isBoolean() {
            return this.jsonValue.isBoolean();
        }

        @Override
        public boolean isObject() {
            return this.jsonValue.isObject();
        }

        @Override
        public boolean isList() {
            return this.jsonValue.isArray();
        }

        @Override
        public byte asByte() {
            return (byte)this.jsonValue.asInt();
        }

        @Override
        public short asShort() {
            return (short)this.jsonValue.asInt();
        }

        @Override
        public int asInt() {
            return this.jsonValue.asInt();
        }

        @Override
        public long asLong() {
            return this.jsonValue.asLong();
        }

        @Override
        public float asFloat() {
            return this.jsonValue.asFloat();
        }

        @Override
        public double asDouble() {
            return this.jsonValue.asDouble();
        }

        @Override
        public char asCharacter() {
            return this.jsonValue.asString().charAt(0);
        }

        @Override
        public String asString() {
            return this.jsonValue.asString();
        }

        @Override
        public boolean asBoolean() {
            return this.jsonValue.asBoolean();
        }

        @Override
        public DataObject<JsonValue> asObject() {
            return new HjsonObject(this.jsonValue.asObject());
        }

        @Override
        public DataList<JsonValue> asList() {
            return new HjsonList(this.jsonValue.asArray());
        }

        @Override
        public JsonValue getRaw() {
            return this.jsonValue;
        }
    }
}

