/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.data.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Pair;
import de.siphalor.tweed.data.DataList;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import de.siphalor.tweed.data.serializer.ConfigDataSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

public class GsonSerializer
implements ConfigDataSerializer<JsonElement> {
    protected static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final GsonSerializer INSTANCE = new GsonSerializer();

    @Override
    public DataObject<JsonElement> newObject() {
        return new GsonObject((JsonElement)new JsonObject());
    }

    @Override
    public DataObject<JsonElement> read(InputStream inputStream) {
        GsonObject gsonObject;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            JsonObject jsonObject = class_3518.method_15255((Reader)inputStreamReader);
            gsonObject = new GsonObject((JsonElement)jsonObject);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        inputStreamReader.close();
        return gsonObject;
    }

    @Override
    public void write(OutputStream outputStream, DataObject<JsonElement> dataObject) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        try (JsonWriter jsonWriter = GSON.newJsonWriter((Writer)outputStreamWriter);){
            GSON.toJson((JsonElement)dataObject.getRaw(), jsonWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFileExtension() {
        return "json";
    }

    static class GsonList
    extends GsonValue
    implements DataList<JsonElement> {
        GsonList(JsonElement jsonElement) {
            super(jsonElement);
        }

        @Override
        public int size() {
            return this.jsonElement.getAsJsonArray().size();
        }

        @Override
        public DataValue<JsonElement> get(Integer index) {
            return new GsonValue(this.jsonElement.getAsJsonArray().get(index.intValue()));
        }

        @Override
        public DataValue<JsonElement> set(Integer index, byte value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, short value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, int value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, long value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, float value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)Float.valueOf(value));
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, double value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, char value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Character.valueOf(value));
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, String value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, boolean value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Boolean.valueOf(value));
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(Integer index, DataValue<JsonElement> value) {
            this.jsonElement.getAsJsonArray().set(index.intValue(), value.getRaw());
            return value;
        }

        @Override
        public DataList<JsonElement> addList(Integer index) {
            JsonArray jsonArray = new JsonArray();
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonArray);
            return new GsonList((JsonElement)jsonArray);
        }

        @Override
        public DataObject<JsonElement> addObject(Integer index) {
            JsonObject jsonObject = new JsonObject();
            this.jsonElement.getAsJsonArray().set(index.intValue(), (JsonElement)jsonObject);
            return new GsonObject((JsonElement)jsonObject);
        }

        @Override
        public void remove(Integer index) {
            this.jsonElement.getAsJsonArray().remove(index.intValue());
        }

        @Override
        @NotNull
        public Iterator<DataValue<JsonElement>> iterator() {
            return new Iterator<DataValue<JsonElement>>(){
                final Iterator<JsonElement> jsonElementIterator;
                {
                    this.jsonElementIterator = jsonElement.getAsJsonArray().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.jsonElementIterator.hasNext();
                }

                @Override
                public DataValue<JsonElement> next() {
                    return new GsonValue(this.jsonElementIterator.next());
                }
            };
        }
    }

    static class GsonObject
    extends GsonValue
    implements DataObject<JsonElement> {
        GsonObject(JsonElement jsonElement) {
            super(jsonElement);
        }

        @Override
        public boolean has(String key) {
            return this.jsonElement.getAsJsonObject().has(key);
        }

        @Override
        public int size() {
            return this.jsonElement.getAsJsonObject().size();
        }

        @Override
        public DataValue<JsonElement> set(String key, DataValue<JsonElement> value) {
            this.jsonElement.getAsJsonObject().add(key, value.getRaw());
            return value;
        }

        @Override
        public DataValue<JsonElement> set(String key, boolean value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Boolean.valueOf(value));
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, String value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(value);
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, char value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(Character.valueOf(value));
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, double value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, float value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)Float.valueOf(value));
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, long value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, int value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue((JsonElement)jsonPrimitive);
        }

        @Override
        public DataValue<JsonElement> set(String key, short value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue(this.jsonElement);
        }

        @Override
        public DataValue<JsonElement> set(String key, byte value) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive((Number)value);
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonPrimitive);
            return new GsonValue(this.jsonElement);
        }

        @Override
        public DataObject<JsonElement> addObject(String key) {
            JsonObject jsonObject = new JsonObject();
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonObject);
            return new GsonObject((JsonElement)jsonObject);
        }

        @Override
        public DataList<JsonElement> addList(String key) {
            JsonArray jsonArray = new JsonArray();
            this.jsonElement.getAsJsonObject().add(key, (JsonElement)jsonArray);
            return new GsonList((JsonElement)jsonArray);
        }

        @Override
        public DataValue<JsonElement> get(String key) {
            return new GsonValue(this.jsonElement.getAsJsonObject().get(key));
        }

        @Override
        public void remove(String key) {
            this.jsonElement.getAsJsonObject().remove(key);
        }

        @Override
        @NotNull
        public Iterator<Pair<String, DataValue<JsonElement>>> iterator() {
            return this.jsonElement.getAsJsonObject().entrySet().stream().map(entry -> new Pair((Object)((String)entry.getKey()), (Object)new GsonValue((JsonElement)entry.getValue()))).iterator();
        }
    }

    static class GsonValue
    implements DataValue<JsonElement> {
        final JsonElement jsonElement;

        GsonValue(JsonElement jsonElement) {
            this.jsonElement = jsonElement;
        }

        @Override
        public void setComment(String comment) {
        }

        @Override
        public String getComment() {
            return "";
        }

        @Override
        public boolean isNumber() {
            return class_3518.method_15275((JsonElement)this.jsonElement);
        }

        @Override
        public boolean isCharacter() {
            return this.isString() && this.asString().length() == 1;
        }

        @Override
        public boolean isString() {
            return this.jsonElement.isJsonPrimitive() && this.jsonElement.getAsJsonPrimitive().isString();
        }

        @Override
        public boolean isBoolean() {
            return this.jsonElement instanceof JsonPrimitive && ((JsonPrimitive)this.jsonElement).isBoolean();
        }

        @Override
        public boolean isObject() {
            return this.jsonElement.isJsonObject();
        }

        @Override
        public boolean isList() {
            return this.jsonElement.isJsonArray();
        }

        @Override
        public byte asByte() {
            return this.jsonElement.getAsByte();
        }

        @Override
        public short asShort() {
            return this.jsonElement.getAsShort();
        }

        @Override
        public int asInt() {
            return this.jsonElement.getAsInt();
        }

        @Override
        public long asLong() {
            return this.jsonElement.getAsLong();
        }

        @Override
        public float asFloat() {
            return this.jsonElement.getAsFloat();
        }

        @Override
        public double asDouble() {
            return this.jsonElement.getAsDouble();
        }

        @Override
        public char asCharacter() {
            return this.jsonElement.getAsCharacter();
        }

        @Override
        public String asString() {
            return this.jsonElement.getAsString();
        }

        @Override
        public boolean asBoolean() {
            return this.jsonElement.getAsBoolean();
        }

        @Override
        public DataObject<JsonElement> asObject() {
            return new GsonObject(this.jsonElement);
        }

        @Override
        public DataList<JsonElement> asList() {
            return new GsonList(this.jsonElement);
        }

        @Override
        public JsonElement getRaw() {
            return this.jsonElement;
        }
    }
}

