/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.fixers;

import de.siphalor.tweed.Tweed;
import de.siphalor.tweed.config.fixers.ConfigEntryFixer;
import de.siphalor.tweed.data.DataObject;
import de.siphalor.tweed.data.DataValue;
import org.apache.commons.lang3.StringUtils;

public class ConfigEntryLocationFixer
extends ConfigEntryFixer {
    private final String newName;
    private final String newLocation;

    public ConfigEntryLocationFixer(String newName) {
        this(newName, null);
    }

    public ConfigEntryLocationFixer(String newName, String newLocation) {
        this.newName = newName;
        this.newLocation = newLocation;
    }

    @Override
    public void fix(DataObject<?> dataObject, String propertyName, DataObject<?> mainCompound) {
        DataValue<?> dataValue = dataObject.get(propertyName);
        if (dataValue == null) {
            return;
        }
        dataObject.remove(propertyName);
        if (this.newLocation == null) {
            dataObject.set(this.newName, dataValue);
        } else {
            String[] parts;
            DataObject<?> location = mainCompound;
            for (String part : parts = StringUtils.split((String)this.newLocation, (char)'.')) {
                if (location.get(part) == null) {
                    location = location.addObject(part);
                    continue;
                }
                if (location.get(part).isObject()) {
                    location = location.get(part).asObject();
                    continue;
                }
                Tweed.LOGGER.error("Unable to fix Tweed config file");
                return;
            }
            location.set(this.newName, dataValue);
        }
    }
}

